/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.internal.support.Log;
import com.couchbase.litecore.C4Base;
import com.couchbase.litecore.C4Error;
import com.couchbase.litecore.LiteCoreException;

class CBLStatus {
    static final String[] kErrorDomains = new String[]{null, "CouchbaseLite", "POSIXErrorDomain", "CouchbaseLite.SQLite", "CouchbaseLite.Fleece", "CouchbaseLite", "CouchbaseLite"};

    CBLStatus() {
    }

    static CouchbaseLiteException convertException(int domainCode, int statusCode, String message, LiteCoreException e) {
        String domain = kErrorDomains[domainCode];
        int code = statusCode;
        if (domainCode == 5) {
            code += 5000;
        } else if (domainCode == 6) {
            code += 10000;
        }
        if (domain == null) {
            Log.w(LogDomain.DATABASE, "Unable to map C4Error(%d,%d) to an CouchbaseLiteException", domainCode, statusCode);
            domain = "CouchbaseLite";
            code = 10;
        }
        message = message != null ? message : (e != null ? e.getMessage() : null);
        return new CouchbaseLiteException(message, (Throwable)e, domain, code);
    }

    static CouchbaseLiteException convertException(LiteCoreException e) {
        return CBLStatus.convertException(e.domain, e.code, null, e);
    }

    static CouchbaseLiteException convertException(int domainCode, int statusCode, int _internalInfo) {
        if (domainCode != 0 && statusCode != 0) {
            String errMsg = C4Base.getMessage(domainCode, statusCode, _internalInfo);
            return CBLStatus.convertException(new LiteCoreException(domainCode, statusCode, errMsg));
        }
        return CBLStatus.convertException(domainCode, statusCode, null, null);
    }

    static CouchbaseLiteException convertError(C4Error c4err) {
        return CBLStatus.convertException(c4err.getDomain(), c4err.getCode(), c4err.getInternalInfo());
    }
}

