/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.Expression;
import java.util.Arrays;

abstract class AbstractFunction {
    AbstractFunction() {
    }

    @NonNull
    public static Expression avg(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("AVG()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression count(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("COUNT()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression min(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("MIN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression max(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("MAX()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression sum(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("SUM()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression abs(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ABS()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression acos(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ACOS()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression asin(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ASIN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression atan(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ATAN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression atan2(@NonNull Expression x, @NonNull Expression y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("x and y cannot be null.");
        }
        return new Expression.FunctionExpression("ATAN2()", Arrays.asList(x, y));
    }

    @NonNull
    public static Expression ceil(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("CEIL()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression cos(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("COS()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression degrees(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("DEGREES()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression e() {
        return new Expression.FunctionExpression("E()", Arrays.asList(new Expression[]{null}));
    }

    @NonNull
    public static Expression exp(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("EXP()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression floor(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("FLOOR()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression ln(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("LN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression log(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("LOG()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression pi() {
        return new Expression.FunctionExpression("PI()", Arrays.asList(new Expression[]{null}));
    }

    @NonNull
    public static Expression power(@NonNull Expression base, @NonNull Expression exponent) {
        if (base == null || exponent == null) {
            throw new IllegalArgumentException("base or exponent cannot be null.");
        }
        return new Expression.FunctionExpression("POWER()", Arrays.asList(base, exponent));
    }

    @NonNull
    public static Expression radians(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("RADIANS()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression round(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("ROUND()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression round(@NonNull Expression expression, @NonNull Expression digits) {
        if (expression == null || digits == null) {
            throw new IllegalArgumentException("expression and digits cannot be null.");
        }
        return new Expression.FunctionExpression("ROUND()", Arrays.asList(expression, digits));
    }

    @NonNull
    public static Expression sign(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("SIGN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression sin(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("SIN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression sqrt(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("SQRT()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression tan(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("TAN()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression trunc(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("TRUNC()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression trunc(@NonNull Expression expression, @NonNull Expression digits) {
        if (expression == null || digits == null) {
            throw new IllegalArgumentException("expression and digits cannot be null.");
        }
        return new Expression.FunctionExpression("TRUNC()", Arrays.asList(expression, digits));
    }

    @NonNull
    public static Expression contains(@NonNull Expression expression, @NonNull Expression substring) {
        if (expression == null || substring == null) {
            throw new IllegalArgumentException("expression and substring cannot be null.");
        }
        return new Expression.FunctionExpression("CONTAINS()", Arrays.asList(expression, substring));
    }

    @NonNull
    public static Expression length(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("LENGTH()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression lower(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("LOWER()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression ltrim(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("LTRIM()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression rtrim(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("RTRIM()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression trim(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("TRIM()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression upper(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("UPPER()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression millisToString(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("MILLIS_TO_STR()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression millisToUTC(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("MILLIS_TO_UTC()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression stringToMillis(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("STR_TO_MILLIS()", Arrays.asList(expression));
    }

    @NonNull
    public static Expression stringToUTC(@NonNull Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null.");
        }
        return new Expression.FunctionExpression("STR_TO_UTC()", Arrays.asList(expression));
    }
}

