/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import android.support.annotation.NonNull;
import com.couchbase.lite.AbstractIndex;
import com.couchbase.lite.CBLStatus;
import com.couchbase.lite.CBLVersion;
import com.couchbase.lite.ChangeListenerToken;
import com.couchbase.lite.ChangeNotifier;
import com.couchbase.lite.ConcurrencyControl;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DatabaseChange;
import com.couchbase.lite.DatabaseChangeListener;
import com.couchbase.lite.DatabaseConfiguration;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChangeListener;
import com.couchbase.lite.DocumentChangeNotifier;
import com.couchbase.lite.Index;
import com.couchbase.lite.ListenerToken;
import com.couchbase.lite.LiveQuery;
import com.couchbase.lite.Log;
import com.couchbase.lite.LogDomain;
import com.couchbase.lite.LogLevel;
import com.couchbase.lite.MutableDocument;
import com.couchbase.lite.NativeLibraryLoader;
import com.couchbase.lite.Replicator;
import com.couchbase.lite.internal.support.Run;
import com.couchbase.lite.internal.utils.ExecutorUtils;
import com.couchbase.lite.internal.utils.FileUtils;
import com.couchbase.lite.internal.utils.JsonUtils;
import com.couchbase.litecore.C4BlobStore;
import com.couchbase.litecore.C4Database;
import com.couchbase.litecore.C4DatabaseChange;
import com.couchbase.litecore.C4DatabaseObserver;
import com.couchbase.litecore.C4DatabaseObserverListener;
import com.couchbase.litecore.C4Document;
import com.couchbase.litecore.LiteCoreException;
import com.couchbase.litecore.SharedKeys;
import com.couchbase.litecore.fleece.FLSliceResult;
import com.couchbase.litecore.fleece.FLValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;

abstract class AbstractDatabase {
    protected static final LogDomain DOMAIN;
    protected static final String DB_EXTENSION = "cblite2";
    protected static final int MAX_CHANGES = 100;
    protected static final long kHousekeepingDelayAfterOpening = 3L;
    protected static final int DEFAULT_DATABASE_FLAGS = 21;
    protected String name;
    protected final DatabaseConfiguration config;
    protected final boolean shellMode;
    protected C4Database c4db;
    protected ScheduledExecutorService queryExecutor;
    protected ScheduledExecutorService postExecutor;
    protected ChangeNotifier<DatabaseChange> dbChangeNotifier;
    protected C4DatabaseObserver c4DBObserver;
    protected Map<String, DocumentChangeNotifier> docChangeNotifiers;
    protected final SharedKeys sharedKeys;
    protected Set<Replicator> activeReplications;
    protected Set<LiveQuery> activeLiveQueries;
    protected Timer purgeTimer;
    protected final Object lock = new Object();
    @NonNull
    public static final Log log;

    protected AbstractDatabase(@NonNull String name, @NonNull DatabaseConfiguration config) throws CouchbaseLiteException {
        Run.once("DATABASE_INIT_LOGGING", new Runnable(){

            @Override
            public void run() {
                com.couchbase.lite.internal.support.Log.info(DOMAIN, CBLVersion.getUserAgent());
                if (Database.log.getFile().getConfig() == null) {
                    com.couchbase.lite.internal.support.Log.w(DOMAIN, "Database.log.getFile().getConfig() is null, meaning file logging is disabled. Log files required for product support are not being generated.");
                }
            }
        });
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("id cannot be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("id cannot be null.");
        }
        this.name = name;
        this.config = config.readonlyCopy();
        this.shellMode = false;
        this.postExecutor = Executors.newSingleThreadScheduledExecutor();
        this.queryExecutor = Executors.newSingleThreadScheduledExecutor();
        this.activeReplications = Collections.synchronizedSet(new HashSet());
        this.activeLiveQueries = Collections.synchronizedSet(new HashSet());
        config.setTempDir();
        this.open();
        this.sharedKeys = new SharedKeys(this.c4db);
    }

    AbstractDatabase(C4Database c4db) {
        this.c4db = c4db;
        this.config = null;
        this.shellMode = true;
        this.sharedKeys = null;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4db != null ? this.getC4Database().getPath() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.c4db != null ? this.getC4Database().getDocumentCount() : 0L;
        }
    }

    @NonNull
    public DatabaseConfiguration getConfig() {
        return this.config.readonlyCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                return new Document((Database)this, id, false);
            }
            catch (CouchbaseLiteException ex) {
                return null;
            }
        }
    }

    public void save(@NonNull MutableDocument document) throws CouchbaseLiteException {
        this.save(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean save(@NonNull MutableDocument document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        if (document == null) {
            throw new IllegalArgumentException("document cannot be null.");
        }
        if (concurrencyControl == null) {
            throw new IllegalArgumentException("concurrencyControl cannot be null.");
        }
        return this.save((Document)document, false, concurrencyControl);
    }

    public void delete(@NonNull Document document) throws CouchbaseLiteException {
        this.delete(document, ConcurrencyControl.LAST_WRITE_WINS);
    }

    public boolean delete(@NonNull Document document, @NonNull ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        if (document == null) {
            throw new IllegalArgumentException("document cannot be null.");
        }
        if (concurrencyControl == null) {
            throw new IllegalArgumentException("concurrencyControl cannot be null.");
        }
        return this.save(document, true, concurrencyControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(@NonNull Document document) throws CouchbaseLiteException {
        if (document == null) {
            throw new IllegalArgumentException("document cannot be null.");
        }
        if (document.isNewDocument()) {
            throw new CouchbaseLiteException("Document doesn't exist in the database.", "CouchbaseLite", 7);
        }
        Object object = this.lock;
        synchronized (object) {
            this.prepareDocument(document);
            boolean commit = false;
            this.beginTransaction();
            try {
                if (document.getC4doc().purgeRevision(null) >= 0) {
                    document.getC4doc().save(0);
                    document.replaceC4Document(null);
                    commit = true;
                }
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge(@NonNull String id) throws CouchbaseLiteException {
        if (id == null) {
            throw new IllegalArgumentException("document id cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            boolean commit = false;
            this.beginTransaction();
            try {
                this.getC4Database().purgeDoc(id);
                commit = true;
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentExpiration(@NonNull String id, Date expiration) throws CouchbaseLiteException {
        if (id == null) {
            throw new IllegalArgumentException("document id cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (expiration == null) {
                    this.getC4Database().setExpiration(id, 0L);
                } else {
                    long timestamp = expiration.getTime();
                    this.getC4Database().setExpiration(id, timestamp);
                }
                this.scheduleDocumentExpiration(0L);
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    public Date getDocumentExpiration(@NonNull String id) throws CouchbaseLiteException {
        if (id == null) {
            throw new IllegalArgumentException("document id cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.getC4Database().get(id, true) == null) {
                    throw new CouchbaseLiteException("Document doesn't exist in the database.", "CouchbaseLite", 7);
                }
                long timestamp = this.getC4Database().getExpiration(id);
                if (timestamp == 0L) {
                    return null;
                }
                return new Date(timestamp);
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inBatch(@NonNull Runnable runnable) throws CouchbaseLiteException {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                boolean commit = false;
                this.getC4Database().beginTransaction();
                try {
                    try {
                        runnable.run();
                        commit = true;
                    }
                    catch (RuntimeException e) {
                        throw new CouchbaseLiteException(e);
                    }
                }
                finally {
                    this.getC4Database().endTransaction(commit);
                }
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
        this.postDatabaseChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                this.getC4Database().compact();
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    @NonNull
    public ListenerToken addChangeListener(@NonNull DatabaseChangeListener listener) {
        return this.addChangeListener(null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addChangeListener(Executor executor, @NonNull DatabaseChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            return this.addDatabaseChangeListener(executor, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(@NonNull ListenerToken token) {
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            if (token instanceof ChangeListenerToken && ((ChangeListenerToken)token).getKey() != null) {
                this.removeDocumentChangeListener((ChangeListenerToken)token);
            } else {
                this.removeDatabaseChangeListener(token);
            }
        }
    }

    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, @NonNull DocumentChangeListener listener) {
        return this.addDocumentChangeListener(id, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ListenerToken addDocumentChangeListener(@NonNull String id, Executor executor, @NonNull DocumentChangeListener listener) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            return this.addDocumentChangeListener(executor, listener, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            if (this.c4db == null) {
                return;
            }
            com.couchbase.lite.internal.support.Log.i(DOMAIN, "Closing %s at path %s", this, this.getC4Database().getPath());
            if (this.activeReplications.size() > 0) {
                throw new CouchbaseLiteException("Cannot close the database.  Please stop all of the replicators before closing the database.", "CouchbaseLite", 16);
            }
            if (this.activeLiveQueries.size() > 0) {
                throw new CouchbaseLiteException("Cannot close the database.  Please remove all of the query listeners before closing the database.", "CouchbaseLite", 16);
            }
            this.cancelPurgeTimer();
            this.closeC4DB();
            this.freeC4Observers();
            this.freeC4DB();
            this.shutdownExecutorService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            com.couchbase.lite.internal.support.Log.i(DOMAIN, "Deleting %s at path %s", this, this.getC4Database().getPath());
            if (this.activeReplications.size() > 0) {
                throw new CouchbaseLiteException("Cannot delete the database.  Please stop all of the replicators before closing the database.", "CouchbaseLite", 16);
            }
            if (this.activeLiveQueries.size() > 0) {
                throw new CouchbaseLiteException("Cannot delete the database.  Please remove all of the query listeners before closing the database.", "CouchbaseLite", 16);
            }
            this.cancelPurgeTimer();
            this.deleteC4DB();
            this.freeC4Observers();
            this.freeC4DB();
            this.shutdownExecutorService();
        }
    }

    @NonNull
    public List<String> getIndexes() throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                FLValue value = this.c4db.getIndexes();
                return (List)value.asObject();
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createIndex(@NonNull String name, @NonNull Index index) throws CouchbaseLiteException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (index == null) {
            throw new IllegalArgumentException("index cannot be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                AbstractIndex abstractIndex = (AbstractIndex)index;
                String json = JsonUtils.toJson(abstractIndex.items()).toString();
                this.getC4Database().createIndex(name, json, abstractIndex.type().getValue(), abstractIndex.language(), abstractIndex.ignoreAccents());
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
            catch (JSONException e) {
                throw new CouchbaseLiteException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(@NonNull String name) throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            try {
                this.c4db.deleteIndex(name);
            }
            catch (LiteCoreException e) {
                throw CBLStatus.convertException(e);
            }
        }
    }

    public static void delete(@NonNull String name, @NonNull File directory) throws CouchbaseLiteException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null.");
        }
        if (!AbstractDatabase.exists(name, directory)) {
            throw new CouchbaseLiteException("CouchbaseLite", 7);
        }
        File path = AbstractDatabase.getDatabasePath(directory, name);
        try {
            com.couchbase.lite.internal.support.Log.i(DOMAIN, "delete(): path=%s", path.toString());
            C4Database.deleteAtPath(path.getPath());
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    public static boolean exists(@NonNull String name, @NonNull File directory) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null.");
        }
        return AbstractDatabase.getDatabasePath(directory, name).exists();
    }

    public static void copy(@NonNull File path, @NonNull String name, @NonNull DatabaseConfiguration config) throws CouchbaseLiteException {
        String toPath;
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        if (config == null) {
            throw new IllegalArgumentException("config cannot be null.");
        }
        String fromPath = path.getPath();
        if (fromPath.charAt(fromPath.length() - 1) != File.separatorChar) {
            fromPath = fromPath + File.separator;
        }
        if ((toPath = AbstractDatabase.getDatabasePath(new File(config.getDirectory()), name).getPath()).charAt(toPath.length() - 1) != File.separatorChar) {
            toPath = toPath + File.separator;
        }
        int databaseFlags = 21;
        int encryptionAlgorithm = 0;
        byte[] encryptionKey = null;
        config.setTempDir();
        try {
            C4Database.copy(fromPath, toPath, databaseFlags, null, 0, encryptionAlgorithm, encryptionKey);
        }
        catch (LiteCoreException e) {
            FileUtils.deleteRecursive(toPath);
            throw CBLStatus.convertException(e);
        }
    }

    @Deprecated
    public static void setLogLevel(@NonNull LogDomain domain, @NonNull LogLevel level) {
        if (domain == null) {
            throw new IllegalArgumentException("domain cannot be null.");
        }
        if (level == null) {
            throw new IllegalArgumentException("level cannot be null.");
        }
        com.couchbase.lite.internal.support.Log.setLogLevel(domain, level);
    }

    @NonNull
    public String toString() {
        return "Database@" + Integer.toHexString(this.hashCode()) + "{name='" + this.name + '\'' + '}';
    }

    protected void finalize() throws Throwable {
        this.freeC4Observers();
        this.freeC4DB();
        super.finalize();
    }

    Object getLock() {
        return this.lock;
    }

    boolean equalsWithPath(Database other) {
        if (other == null) {
            return false;
        }
        File path = this.getFilePath();
        File otherPath = other.getFilePath();
        if (path == null && otherPath == null) {
            return true;
        }
        if (path == null && otherPath != null || path != null && otherPath == null) {
            return false;
        }
        return path.equals(otherPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C4BlobStore getBlobStore() throws LiteCoreException {
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            return this.c4db.getBlobStore();
        }
    }

    Database copy() throws CouchbaseLiteException {
        return new Database(this.name, this.config);
    }

    void mustBeOpen() {
        if (this.c4db == null) {
            throw new IllegalStateException("Attempt to perform an operation on a closed database");
        }
    }

    boolean isOpen() {
        return this.c4db != null;
    }

    C4Database getC4Database() {
        this.mustBeOpen();
        return this.c4db;
    }

    void beginTransaction() throws CouchbaseLiteException {
        try {
            this.getC4Database().beginTransaction();
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    void endTransaction(boolean commit) throws CouchbaseLiteException {
        try {
            this.getC4Database().endTransaction(commit);
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    SharedKeys getSharedKeys() {
        return this.sharedKeys;
    }

    Set<Replicator> getActiveReplications() {
        return this.activeReplications;
    }

    Set<LiveQuery> getActiveLiveQueries() {
        return this.activeLiveQueries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveConflictInDocument(String docID) throws CouchbaseLiteException {
        Object object = this.lock;
        synchronized (object) {
            boolean commit = false;
            this.beginTransaction();
            try {
                Document remoteDoc;
                Document localDoc;
                block11: {
                    localDoc = new Document((Database)this, docID, true);
                    remoteDoc = new Document((Database)this, docID, true);
                    try {
                        if (remoteDoc.selectConflictingRevision()) break block11;
                        com.couchbase.lite.internal.support.Log.w(DOMAIN, "Unable to select conflicting revision for '%s', skipping...", docID);
                    }
                    catch (LiteCoreException e) {
                        throw CBLStatus.convertException(e);
                    }
                    return;
                }
                com.couchbase.lite.internal.support.Log.v(DOMAIN, "Resolving doc '%s' (local=%s and remote=%s)", docID, localDoc.getRevID(), remoteDoc.getRevID());
                Document resolvedDoc = this.resolveConflict(localDoc, remoteDoc);
                try {
                    this.saveResolvedDocument(resolvedDoc, localDoc, remoteDoc);
                }
                catch (LiteCoreException e) {
                    throw CBLStatus.convertException(e);
                }
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
        }
    }

    File getFilePath() {
        String path = this.getPath();
        return path != null ? new File(path) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleOnPostNotificationExecutor(@NonNull Runnable runnable, long delay) {
        ScheduledExecutorService scheduledExecutorService = this.postExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.postExecutor.isShutdown() && !this.postExecutor.isTerminated()) {
                this.postExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleOnQueryExecutor(@NonNull Runnable runnable, long delay) {
        ScheduledExecutorService scheduledExecutorService = this.queryExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.queryExecutor.isShutdown() && !this.queryExecutor.isTerminated()) {
                this.queryExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
            }
        }
    }

    abstract int getEncryptionAlgorithm();

    abstract byte[] getEncryptionKey();

    private void open() throws CouchbaseLiteException {
        if (this.c4db != null) {
            return;
        }
        File dir = this.config.getDirectory() != null ? new File(this.config.getDirectory()) : this.getDefaultDirectory();
        this.setupDirectory(dir);
        File dbFile = AbstractDatabase.getDatabasePath(dir, this.name);
        int databaseFlags = this.getDatabaseFlags();
        com.couchbase.lite.internal.support.Log.i(DOMAIN, "Opening %s at path %s", this, dbFile.getPath());
        try {
            this.c4db = new C4Database(dbFile.getPath(), databaseFlags, null, 0, this.getEncryptionAlgorithm(), this.getEncryptionKey());
        }
        catch (LiteCoreException e) {
            if (e.code == 20) {
                throw new CouchbaseLiteException("The provided encryption key was incorrect.", (Throwable)e, "CouchbaseLite", e.code);
            }
            if (e.code == 11) {
                throw new CouchbaseLiteException("TUnable to create database directory.", (Throwable)e, "CouchbaseLite", e.code);
            }
            throw CBLStatus.convertException(e);
        }
        this.c4DBObserver = null;
        this.dbChangeNotifier = null;
        this.docChangeNotifiers = new HashMap<String, DocumentChangeNotifier>();
        this.scheduleDocumentExpiration(3L);
    }

    private int getDatabaseFlags() {
        int databaseFlags = 21;
        return databaseFlags;
    }

    private File getDefaultDirectory() {
        throw new UnsupportedOperationException("getDefaultDirectory() is not supported.");
    }

    private void setupDirectory(File dir) throws CouchbaseLiteException {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new CouchbaseLiteException(String.format(Locale.ENGLISH, "Unable to create directory for: %s.", dir));
        }
    }

    private static File getDatabasePath(File dir, String name) {
        name = name.replaceAll("/", ":");
        name = String.format(Locale.ENGLISH, "%s.%s", name, DB_EXTENSION);
        return new File(dir, name);
    }

    private void closeC4DB() throws CouchbaseLiteException {
        try {
            this.getC4Database().close();
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    private void deleteC4DB() throws CouchbaseLiteException {
        try {
            this.getC4Database().delete();
        }
        catch (LiteCoreException e) {
            throw CBLStatus.convertException(e);
        }
    }

    private void freeC4DB() {
        if (this.c4db != null && !this.shellMode) {
            this.getC4Database().free();
            this.c4db = null;
        }
    }

    private ListenerToken addDatabaseChangeListener(Executor executor, DatabaseChangeListener listener) {
        if (this.dbChangeNotifier == null) {
            this.dbChangeNotifier = new ChangeNotifier();
            this.registerC4DBObserver();
        }
        return this.dbChangeNotifier.addChangeListener(executor, listener);
    }

    private void removeDatabaseChangeListener(ListenerToken token) {
        if (this.dbChangeNotifier.removeChangeListener(token) == 0) {
            this.freeC4DBObserver();
            this.dbChangeNotifier = null;
        }
    }

    private ListenerToken addDocumentChangeListener(Executor executor, DocumentChangeListener listener, String docID) {
        DocumentChangeNotifier docNotifier = this.docChangeNotifiers.get(docID);
        if (docNotifier == null) {
            docNotifier = new DocumentChangeNotifier((Database)this, docID);
            this.docChangeNotifiers.put(docID, docNotifier);
        }
        ChangeListenerToken token = docNotifier.addChangeListener(executor, listener);
        token.setKey(docID);
        return token;
    }

    private void removeDocumentChangeListener(ChangeListenerToken token) {
        DocumentChangeNotifier notifier;
        String docID = (String)token.getKey();
        if (this.docChangeNotifiers.containsKey(docID) && (notifier = this.docChangeNotifiers.get(docID)) != null && notifier.removeChangeListener(token) == 0) {
            notifier.stop();
            this.docChangeNotifiers.remove(docID);
        }
    }

    private void registerC4DBObserver() {
        this.c4DBObserver = this.c4db.createDatabaseObserver(new C4DatabaseObserverListener(){

            @Override
            public void callback(C4DatabaseObserver observer, Object context) {
                AbstractDatabase.this.scheduleOnPostNotificationExecutor(new Runnable(){

                    @Override
                    public void run() {
                        AbstractDatabase.this.postDatabaseChanged();
                    }
                }, 0L);
            }
        }, this);
    }

    private void freeC4DBObserver() {
        if (this.c4DBObserver != null) {
            this.c4DBObserver.free();
            this.c4DBObserver = null;
        }
    }

    private void freeC4Observers() {
        this.freeC4DBObserver();
        if (this.docChangeNotifiers != null) {
            for (DocumentChangeNotifier notifier : this.docChangeNotifiers.values()) {
                notifier.stop();
            }
            this.docChangeNotifiers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postDatabaseChanged() {
        Object object = this.lock;
        synchronized (object) {
            int nChanges;
            if (this.c4DBObserver == null || this.c4db == null || this.getC4Database().isInTransaction()) {
                return;
            }
            boolean external = false;
            ArrayList<String> docIDs = new ArrayList<String>();
            do {
                C4DatabaseChange[] c4DBChanges;
                boolean newExternal;
                boolean bl = newExternal = (nChanges = (c4DBChanges = this.c4DBObserver.getChanges(100)).length) > 0 ? c4DBChanges[0].isExternal() : false;
                if ((c4DBChanges == null || c4DBChanges.length == 0 || external != newExternal || docIDs.size() > 1000) && docIDs.size() > 0) {
                    DatabaseChange change = new DatabaseChange((Database)this, docIDs);
                    this.dbChangeNotifier.postChange(change);
                    docIDs = new ArrayList();
                }
                external = newExternal;
                for (int i = 0; i < nChanges; ++i) {
                    docIDs.add(c4DBChanges[i].getDocID());
                }
            } while (nChanges > 0);
        }
    }

    private void prepareDocument(Document document) throws CouchbaseLiteException {
        this.mustBeOpen();
        if (document.getDatabase() == null) {
            document.setDatabase((Database)this);
        } else if (document.getDatabase() != this) {
            throw new CouchbaseLiteException("Cannot operate on a document from another database.", "CouchbaseLite", 9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean save(Document document, boolean deletion, ConcurrencyControl concurrencyControl) throws CouchbaseLiteException {
        if (deletion && !document.exists()) {
            throw new CouchbaseLiteException("Cannot delete a document that has not yet been saved.", "CouchbaseLite", 7);
        }
        C4Document curDoc = null;
        C4Document newDoc = null;
        Object object = this.lock;
        synchronized (object) {
            this.mustBeOpen();
            this.prepareDocument(document);
            boolean commit = false;
            this.beginTransaction();
            try {
                block33: {
                    try {
                        newDoc = this.save(document, null, deletion);
                        commit = true;
                    }
                    catch (LiteCoreException e) {
                        if (e.domain == 1 && e.code == 8) break block33;
                        throw CBLStatus.convertException(e);
                    }
                }
                if (newDoc == null) {
                    if (concurrencyControl.equals((Object)ConcurrencyControl.FAIL_ON_CONFLICT)) {
                        boolean e = false;
                        return e;
                    }
                    try {
                        curDoc = this.getC4Database().get(document.getId(), true);
                    }
                    catch (LiteCoreException e) {
                        if (deletion && e.domain == 1 && e.code == 7) {
                            boolean e2 = true;
                            if (curDoc != null) {
                                curDoc.retain();
                                curDoc.release();
                            }
                            try {
                                this.endTransaction(commit);
                            }
                            catch (CouchbaseLiteException e3) {
                                if (newDoc != null) {
                                    newDoc.release();
                                }
                                throw e3;
                            }
                            return e2;
                        }
                        throw CBLStatus.convertException(e);
                    }
                    if (deletion && curDoc.deleted()) {
                        document.replaceC4Document(curDoc);
                        curDoc = null;
                        boolean e = true;
                        return e;
                    }
                    try {
                        newDoc = this.save(document, curDoc, deletion);
                    }
                    catch (LiteCoreException e) {
                        throw CBLStatus.convertException(e);
                    }
                }
                document.replaceC4Document(newDoc);
                commit = true;
            }
            finally {
                if (curDoc != null) {
                    curDoc.retain();
                    curDoc.release();
                }
                try {
                    this.endTransaction(commit);
                }
                catch (CouchbaseLiteException e2) {
                    if (newDoc != null) {
                        newDoc.release();
                    }
                    throw e2;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C4Document save(Document document, C4Document base, boolean deletion) throws LiteCoreException {
        FLSliceResult body = null;
        try {
            C4Document c4Doc;
            int revFlags = 0;
            if (deletion) {
                revFlags = 1;
            }
            if (!deletion && !document.isEmpty()) {
                body = document.encode();
                if (body == null) {
                    C4Document c4Document = null;
                    return c4Document;
                }
                if (C4Document.dictContainsBlobs(body, this.sharedKeys.getFLSharedKeys())) {
                    revFlags |= 8;
                }
            }
            C4Document c4Document = c4Doc = base != null ? base : document.getC4doc();
            if (c4Doc != null) {
                C4Document c4Document2 = c4Doc.update(body, revFlags);
                return c4Document2;
            }
            C4Document c4Document3 = this.getC4Database().create(document.getId(), body, revFlags);
            return c4Document3;
        }
        finally {
            if (body != null) {
                body.free();
            }
        }
    }

    private Document resolveConflict(Document localDoc, Document remoteDoc) {
        if (remoteDoc.isDeleted()) {
            return remoteDoc;
        }
        if (localDoc.isDeleted()) {
            return localDoc;
        }
        if (localDoc.generation() > remoteDoc.generation()) {
            return localDoc;
        }
        if (localDoc.generation() < remoteDoc.generation()) {
            return remoteDoc;
        }
        if (localDoc.getRevID() != null && localDoc.getRevID().compareTo(remoteDoc.getRevID()) > 0) {
            return localDoc;
        }
        return remoteDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveResolvedDocument(Document resolvedDoc, Document localDoc, Document remoteDoc) throws CouchbaseLiteException, LiteCoreException {
        Object object = this.lock;
        synchronized (object) {
            boolean commit = false;
            this.beginTransaction();
            try {
                if (remoteDoc != localDoc) {
                    resolvedDoc.setDatabase((Database)this);
                }
                String winningRevID = remoteDoc.getRevID();
                String losingRevID = localDoc.getRevID();
                byte[] mergedBody = null;
                int mergedFlags = 0;
                if (resolvedDoc != remoteDoc) {
                    mergedBody = resolvedDoc.encode().getBuf();
                    if (mergedBody == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (resolvedDoc.isDeleted()) {
                        mergedFlags |= 1;
                    }
                }
                C4Document rawDoc = localDoc.getC4doc();
                rawDoc.resolveConflict(winningRevID, losingRevID, mergedBody, mergedFlags);
                rawDoc.save(0);
                com.couchbase.lite.internal.support.Log.i(DOMAIN, "Conflict resolved as doc '%s' rev %s", rawDoc.getDocID(), rawDoc.getRevID());
                commit = true;
            }
            finally {
                this.endTransaction(commit);
            }
            return commit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownExecutorService() {
        ScheduledExecutorService scheduledExecutorService = this.postExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.postExecutor.isShutdown() && !this.postExecutor.isTerminated()) {
                ExecutorUtils.shutdownAndAwaitTermination(this.postExecutor, 60);
            }
        }
        scheduledExecutorService = this.queryExecutor;
        synchronized (scheduledExecutorService) {
            if (!this.queryExecutor.isShutdown() && !this.queryExecutor.isTerminated()) {
                ExecutorUtils.shutdownAndAwaitTermination(this.queryExecutor, 60);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleDocumentExpiration(long minimumDelay) {
        long nextExpiration = this.getC4Database().nextDocExpiration();
        if (nextExpiration > 0L) {
            long expTime = nextExpiration - System.currentTimeMillis();
            long delay = Math.max(expTime, minimumDelay);
            com.couchbase.lite.internal.support.Log.v(DOMAIN, "Scheduling next doc expiration in %d sec", delay);
            Object object = this.lock;
            synchronized (object) {
                this.cancelPurgeTimer();
                this.purgeTimer = new Timer();
                this.purgeTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (AbstractDatabase.this.isOpen()) {
                            AbstractDatabase.this.purgeExpiredDocuments();
                        }
                    }
                }, delay);
            }
        } else {
            com.couchbase.lite.internal.support.Log.v(DOMAIN, "No pending doc expirations");
        }
    }

    private void purgeExpiredDocuments() {
        this.scheduleOnPostNotificationExecutor(new Runnable(){

            @Override
            public void run() {
                int nPurged = AbstractDatabase.this.getC4Database().purgeExpiredDocs();
                com.couchbase.lite.internal.support.Log.v(DOMAIN, "Purged %d expired documents", nPurged);
                AbstractDatabase.this.scheduleDocumentExpiration(1000L);
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPurgeTimer() {
        Object object = this.lock;
        synchronized (object) {
            if (this.purgeTimer != null) {
                this.purgeTimer.cancel();
                this.purgeTimer = null;
            }
        }
    }

    static {
        NativeLibraryLoader.load();
        log = new Log();
        com.couchbase.lite.internal.support.Log.setLogLevel(LogDomain.ALL, LogLevel.WARNING);
        DOMAIN = LogDomain.DATABASE;
    }
}

