//
// Message.java
//
// Copyright (c) 2018 Couchbase, Inc.  All rights reserved.
//
// Licensed under the Couchbase License Agreement (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// https://info.couchbase.com/rs/302-GJY-034/images/2017-10-30_License_Agreement.pdf
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
package com.couchbase.lite;

import android.support.annotation.NonNull;

/**
 * <b>ENTERPRISE EDITION API</b><br/></br>
 *
 * A message sent between message endpoint connections.
 */
public class Message {
    private byte[] data;

    Message(byte[] data) {
        this.data = data;
    }

    /**
     * Gets the message as data.
     * @return the data
     */
    @NonNull
    public byte[] toData() {
        return this.data;
    }

    /**
     * Creates a message object from data.
     *
     * @param data the data
     * @return the Message object
     */
    @NonNull
    public static Message fromData(@NonNull byte[] data) {
        if (data == null)
            throw new IllegalArgumentException("data cannot be null.");
        return new Message(data);
    }
}
