/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentracing;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.tracing.opentracing.OpenTracingInternalSpan;
import com.couchbase.client.tracing.opentracing.OpenTracingRequestSpan;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class OpenTracingRequestTracer
implements RequestTracer {
    private final Tracer tracer;

    public static OpenTracingRequestTracer wrap(Tracer tracer) {
        return new OpenTracingRequestTracer(tracer);
    }

    private OpenTracingRequestTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public OpenTracingInternalSpan internalSpan(String operationName, RequestSpan requestSpan) {
        Validators.notNullOrEmpty((String)operationName, (String)"OperationName");
        return new OpenTracingInternalSpan(this.tracer, this.castSpan(requestSpan), operationName);
    }

    private Span castSpan(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof OpenTracingRequestSpan) {
            return ((OpenTracingRequestSpan)requestSpan).span();
        }
        throw new IllegalArgumentException("RequestSpan must be of type OpenTracingRequestSpan");
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        Tracer.SpanBuilder builder = this.tracer.buildSpan(operationName);
        if (parent != null) {
            builder.asChildOf(this.castSpan(parent));
        }
        Span span = builder.start();
        this.tracer.activateSpan(span).close();
        return OpenTracingRequestSpan.wrap(this.tracer, span);
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

