/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6;

import com.couchbase.client.core.deps.io.grpc.ClientInterceptor;
import com.couchbase.client.core.deps.io.grpc.ServerInterceptor;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcRequest;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.GrpcTelemetryBuilder;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.TracingClientInterceptor;
import com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.TracingServerInterceptor;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;

public final class GrpcTelemetry {
    private final Instrumenter<GrpcRequest, Status> serverInstrumenter;
    private final Instrumenter<GrpcRequest, Status> clientInstrumenter;
    private final ContextPropagators propagators;
    private final boolean captureExperimentalSpanAttributes;

    public static GrpcTelemetry create(OpenTelemetry openTelemetry) {
        return GrpcTelemetry.builder(openTelemetry).build();
    }

    public static GrpcTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new GrpcTelemetryBuilder(openTelemetry);
    }

    GrpcTelemetry(Instrumenter<GrpcRequest, Status> serverInstrumenter, Instrumenter<GrpcRequest, Status> clientInstrumenter, ContextPropagators propagators, boolean captureExperimentalSpanAttributes) {
        this.serverInstrumenter = serverInstrumenter;
        this.clientInstrumenter = clientInstrumenter;
        this.propagators = propagators;
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
    }

    public ClientInterceptor newClientInterceptor() {
        return new TracingClientInterceptor(this.clientInstrumenter, this.propagators);
    }

    public ServerInterceptor newServerInterceptor() {
        return new TracingServerInterceptor(this.serverInstrumenter, this.captureExperimentalSpanAttributes);
    }
}

