/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.InternalSpan;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryRequestSpan;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;

public class OpenTelemetryInternalSpan
implements InternalSpan {
    private final Tracer tracer;
    private final Span span;
    private volatile RequestContext ctx;
    private volatile Span dispatchSpan;
    private volatile Span encodingSpan;

    OpenTelemetryInternalSpan(Tracer tracer, Span parent, String operationName) {
        this.tracer = tracer;
        Span.Builder spanBuilder = tracer.spanBuilder(operationName);
        if (parent != null) {
            spanBuilder.setParent(parent);
        } else {
            spanBuilder.setNoParent();
        }
        this.span = spanBuilder.startSpan();
        tracer.withSpan(this.span).close();
    }

    public void finish() {
        try (Scope scope = this.tracer.withSpan(this.span);){
            this.span.setAttribute("peer.service", this.mapServiceType(this.ctx.request().serviceType()));
            String operationId = this.ctx.request().operationId();
            if (operationId != null) {
                this.span.setAttribute("couchbase.operation_id", operationId);
            }
            if (this.ctx.request() instanceof BaseKeyValueRequest) {
                this.span.setAttribute("couchbase.document_id", new String(((BaseKeyValueRequest)this.ctx.request()).key(), CharsetUtil.UTF_8));
            }
            if (this.ctx.clientContext() != null) {
                this.ctx.clientContext().forEach((key, value) -> this.span.setAttribute("couchbase.client_context." + key, value.toString()));
            }
            this.span.end();
        }
    }

    private String mapServiceType(ServiceType serviceType) {
        switch (serviceType) {
            case KV: {
                return "kv";
            }
            case QUERY: {
                return "query";
            }
            case ANALYTICS: {
                return "analytics";
            }
            case VIEWS: {
                return "view";
            }
            case SEARCH: {
                return "search";
            }
        }
        return null;
    }

    public void requestContext(RequestContext ctx) {
        this.ctx = ctx;
    }

    public RequestContext requestContext() {
        return this.ctx;
    }

    public void startDispatch() {
        this.dispatchSpan = this.tracer.spanBuilder("dispatch_to_server").setParent(this.span).startSpan();
        this.tracer.withSpan(this.dispatchSpan).close();
    }

    public void stopDispatch() {
        try (Scope scope = this.tracer.withSpan(this.dispatchSpan);){
            long serverLatency = this.ctx.serverLatency();
            if (serverLatency > 0L) {
                this.dispatchSpan.setAttribute("peer.latency", serverLatency);
            }
            this.dispatchSpan.end();
        }
    }

    public void startPayloadEncoding() {
        this.encodingSpan = this.tracer.spanBuilder("request_encoding").setParent(this.span).startSpan();
        this.tracer.withSpan(this.encodingSpan).close();
    }

    public void stopPayloadEncoding() {
        try (Scope scope = this.tracer.withSpan(this.encodingSpan);){
            this.encodingSpan.end();
        }
    }

    public RequestSpan toRequestSpan() {
        return OpenTelemetryRequestSpan.wrap(this.tracer, this.span);
    }
}

