/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.util;

import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreQueryStatus;
import com.couchbase.client.core.api.search.result.CoreDateRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreNumericRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocations;
import com.couchbase.client.core.api.search.result.CoreTermSearchFacetResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.kv.Observe;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$ClientVerified$;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.durability.Durability$Majority$;
import com.couchbase.client.scala.durability.Durability$MajorityAndPersistToActive$;
import com.couchbase.client.scala.durability.Durability$PersistToMajority$;
import com.couchbase.client.scala.durability.PersistTo$;
import com.couchbase.client.scala.durability.ReplicateTo$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.CounterResult;
import com.couchbase.client.scala.kv.CounterResult$;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.ExistsResult$;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.GetResult$;
import com.couchbase.client.scala.kv.LookupInReplicaResult;
import com.couchbase.client.scala.kv.LookupInReplicaResult$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInResult$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.MutationResult$;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Insert$;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.StoreSemantics$Upsert$;
import com.couchbase.client.scala.query.QueryMetaData;
import com.couchbase.client.scala.query.QueryMetaData$;
import com.couchbase.client.scala.query.QueryMetrics;
import com.couchbase.client.scala.query.QueryMetrics$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.QueryResult$;
import com.couchbase.client.scala.query.QueryStatus;
import com.couchbase.client.scala.query.QueryStatus$Aborted$;
import com.couchbase.client.scala.query.QueryStatus$Closed$;
import com.couchbase.client.scala.query.QueryStatus$Completed$;
import com.couchbase.client.scala.query.QueryStatus$Errors$;
import com.couchbase.client.scala.query.QueryStatus$Fatal$;
import com.couchbase.client.scala.query.QueryStatus$Running$;
import com.couchbase.client.scala.query.QueryStatus$Stopped$;
import com.couchbase.client.scala.query.QueryStatus$Success$;
import com.couchbase.client.scala.query.QueryStatus$Timeout$;
import com.couchbase.client.scala.query.QueryStatus$Unknown$;
import com.couchbase.client.scala.query.QueryWarning;
import com.couchbase.client.scala.query.QueryWarning$;
import com.couchbase.client.scala.search.result.SearchFacetResult;
import com.couchbase.client.scala.search.result.SearchFacetResult$DateRangeSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchFacetResult$NumericRangeSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchFacetResult$TermSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchRowLocations;
import com.couchbase.client.scala.search.result.SearchRowLocations$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import reactor.util.annotation.Nullable;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Selectable$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters$RichOptional$;
import scala.language$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try;
import ujson.Arr$;
import ujson.Bool$;
import ujson.Num$;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str$;
import ujson.Value;

public final class CoreCommonConverters$
implements Serializable {
    public static final CoreCommonConverters$ MODULE$ = new CoreCommonConverters$();

    private CoreCommonConverters$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CoreCommonConverters$.class);
    }

    public <T> CoreCommonOptions convert(T options) {
        Duration duration = (Duration)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(options, language$.MODULE$.reflectiveCalls()).selectDynamic("timeout");
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        return CoreCommonOptions.of((java.time.Duration)(!(duration != null ? !duration.equals(infinite) : infinite != null) ? null : java.time.Duration.ofNanos(((Duration)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(options, language$.MODULE$.reflectiveCalls()).selectDynamic("timeout")).toNanos())), (RetryStrategy)((RetryStrategy)((Option)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(options, language$.MODULE$.reflectiveCalls()).selectDynamic("retryStrategy")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (RequestSpan)((RequestSpan)((Option)Selectable$.MODULE$.reflectiveSelectableFromLangReflectiveCalls(options, language$.MODULE$.reflectiveCalls()).selectDynamic("parentSpan")).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public CoreCommonOptions makeCommonOptions(Duration timeout, RetryStrategy retryStrategy, RequestSpan parentSpan) {
        Duration duration = timeout;
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        return CoreCommonOptions.of((java.time.Duration)(!(duration != null ? !duration.equals(infinite) : infinite != null) ? null : java.time.Duration.ofNanos(timeout.toNanos())), (RetryStrategy)retryStrategy, (RequestSpan)parentSpan);
    }

    public RetryStrategy makeCommonOptions$default$2() {
        return null;
    }

    public RequestSpan makeCommonOptions$default$3() {
        return null;
    }

    public GetResult convert(CoreGetResult in, ClusterEnvironment env, Option<Transcoder> transcoder) {
        return GetResult$.MODULE$.apply(in.key(), (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)in.content()), in.flags(), in.cas(), (Option<Instant>)Option$.MODULE$.apply((Object)in.expiry()), (Transcoder)transcoder.getOrElse(() -> CoreCommonConverters$.convert$$anonfun$1(env)));
    }

    public GetReplicaResult convertReplica(CoreGetResult in, ClusterEnvironment env, Option<Transcoder> transcoder) {
        return new GetReplicaResult(in.key(), (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)in.content()), in.flags(), in.cas(), (Option<Instant>)Option$.MODULE$.apply((Object)in.expiry()), in.replica(), (Transcoder)transcoder.getOrElse(() -> CoreCommonConverters$.convertReplica$$anonfun$1(env)));
    }

    public LookupInReplicaResult convertLookupInReplica(CoreSubdocGetResult in, ClusterEnvironment env) {
        return LookupInReplicaResult$.MODULE$.apply(in, (Option<Instant>)None$.MODULE$, in.replica());
    }

    public MutationResult convert(CoreMutationResult in) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(in.mutationToken());
        return MutationResult$.MODULE$.apply(in.cas(), (Option<MutationToken>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional).map((Function1 & Serializable)mt -> new MutationToken(mt.partitionID(), mt.partitionUUID(), mt.sequenceNumber(), mt.bucketName())));
    }

    public MutateInResult convert(CoreSubdocMutateResult in) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(in.mutationToken());
        return MutateInResult$.MODULE$.apply(in.key(), in, in.cas(), (Option<MutationToken>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional).map((Function1 & Serializable)mt -> new MutationToken(mt.partitionID(), mt.partitionUUID(), mt.sequenceNumber(), mt.bucketName())));
    }

    public ExistsResult convert(CoreExistsResult in) {
        return ExistsResult$.MODULE$.apply(in.exists(), in.cas());
    }

    public CounterResult convert(CoreCounterResult in) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(in.mutationToken());
        return CounterResult$.MODULE$.apply(in.cas(), (Option<MutationToken>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional), in.content());
    }

    public QueryResult convert(CoreQueryResult in) {
        return QueryResult$.MODULE$.apply((scala.collection.immutable.Seq<QueryChunkRow>)CollectionConverters$.MODULE$.ListHasAsScala(in.collectRows()).asScala().toSeq(), this.convert(in.metaData()));
    }

    public QueryMetaData convert(CoreQueryMetaData in) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(in.signature());
        Optional optional2 = OptionConverters$.MODULE$.RichOptional(in.metrics());
        Optional optional3 = OptionConverters$.MODULE$.RichOptional(in.profile());
        return QueryMetaData$.MODULE$.apply(in.requestId(), in.clientContextId(), (Option<byte[]>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional), (Option<QueryMetrics>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional2).map((Function1 & Serializable)v -> MODULE$.convert((CoreQueryMetrics)v)), (Seq<QueryWarning>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(in.warnings()).asScala().map((Function1 & Serializable)v -> QueryWarning$.MODULE$.apply(v.code(), v.message()))), this.convert(in.status()), (Option<byte[]>)OptionConverters$RichOptional$.MODULE$.asScala$extension(optional3));
    }

    public QueryMetrics convert(CoreQueryMetrics in) {
        return QueryMetrics$.MODULE$.apply(DurationConversions$.MODULE$.javaDurationToScala(in.elapsedTime()), DurationConversions$.MODULE$.javaDurationToScala(in.executionTime()), in.resultCount(), in.resultSize(), in.mutationCount(), in.sortCount(), in.errorCount(), in.warningCount());
    }

    public QueryStatus convert(CoreQueryStatus in) {
        Mirror.Singleton singleton;
        CoreQueryStatus coreQueryStatus = in;
        CoreQueryStatus coreQueryStatus2 = CoreQueryStatus.RUNNING;
        CoreQueryStatus coreQueryStatus3 = coreQueryStatus;
        if (!(coreQueryStatus2 != null ? !coreQueryStatus2.equals(coreQueryStatus3) : coreQueryStatus3 != null)) {
            singleton = QueryStatus$Running$.MODULE$;
        } else {
            CoreQueryStatus coreQueryStatus4 = CoreQueryStatus.SUCCESS;
            CoreQueryStatus coreQueryStatus5 = coreQueryStatus;
            if (!(coreQueryStatus4 != null ? !coreQueryStatus4.equals(coreQueryStatus5) : coreQueryStatus5 != null)) {
                singleton = QueryStatus$Success$.MODULE$;
            } else {
                CoreQueryStatus coreQueryStatus6 = CoreQueryStatus.ERRORS;
                CoreQueryStatus coreQueryStatus7 = coreQueryStatus;
                if (!(coreQueryStatus6 != null ? !coreQueryStatus6.equals(coreQueryStatus7) : coreQueryStatus7 != null)) {
                    singleton = QueryStatus$Errors$.MODULE$;
                } else {
                    CoreQueryStatus coreQueryStatus8 = CoreQueryStatus.COMPLETED;
                    CoreQueryStatus coreQueryStatus9 = coreQueryStatus;
                    if (!(coreQueryStatus8 != null ? !coreQueryStatus8.equals(coreQueryStatus9) : coreQueryStatus9 != null)) {
                        singleton = QueryStatus$Completed$.MODULE$;
                    } else {
                        CoreQueryStatus coreQueryStatus10 = CoreQueryStatus.STOPPED;
                        CoreQueryStatus coreQueryStatus11 = coreQueryStatus;
                        if (!(coreQueryStatus10 != null ? !coreQueryStatus10.equals(coreQueryStatus11) : coreQueryStatus11 != null)) {
                            singleton = QueryStatus$Stopped$.MODULE$;
                        } else {
                            CoreQueryStatus coreQueryStatus12 = CoreQueryStatus.TIMEOUT;
                            CoreQueryStatus coreQueryStatus13 = coreQueryStatus;
                            if (!(coreQueryStatus12 != null ? !coreQueryStatus12.equals(coreQueryStatus13) : coreQueryStatus13 != null)) {
                                singleton = QueryStatus$Timeout$.MODULE$;
                            } else {
                                CoreQueryStatus coreQueryStatus14 = CoreQueryStatus.CLOSED;
                                CoreQueryStatus coreQueryStatus15 = coreQueryStatus;
                                if (!(coreQueryStatus14 != null ? !coreQueryStatus14.equals(coreQueryStatus15) : coreQueryStatus15 != null)) {
                                    singleton = QueryStatus$Closed$.MODULE$;
                                } else {
                                    CoreQueryStatus coreQueryStatus16 = CoreQueryStatus.FATAL;
                                    CoreQueryStatus coreQueryStatus17 = coreQueryStatus;
                                    if (!(coreQueryStatus16 != null ? !coreQueryStatus16.equals(coreQueryStatus17) : coreQueryStatus17 != null)) {
                                        singleton = QueryStatus$Fatal$.MODULE$;
                                    } else {
                                        CoreQueryStatus coreQueryStatus18 = CoreQueryStatus.ABORTED;
                                        CoreQueryStatus coreQueryStatus19 = coreQueryStatus;
                                        if (!(coreQueryStatus18 != null ? !coreQueryStatus18.equals(coreQueryStatus19) : coreQueryStatus19 != null)) {
                                            singleton = QueryStatus$Aborted$.MODULE$;
                                        } else {
                                            CoreQueryStatus coreQueryStatus20 = CoreQueryStatus.UNKNOWN;
                                            CoreQueryStatus coreQueryStatus21 = coreQueryStatus;
                                            if (!(coreQueryStatus20 != null ? !coreQueryStatus20.equals(coreQueryStatus21) : coreQueryStatus21 != null)) {
                                                singleton = QueryStatus$Unknown$.MODULE$;
                                            } else {
                                                throw new MatchError((Object)coreQueryStatus);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return singleton;
    }

    public SearchRowLocations convert(CoreSearchRowLocations in) {
        return SearchRowLocations$.MODULE$.apply(in);
    }

    public SearchFacetResult convert(CoreSearchFacetResult in) {
        SearchFacetResult searchFacetResult;
        CoreSearchFacetResult coreSearchFacetResult = in;
        if (coreSearchFacetResult instanceof CoreTermSearchFacetResult) {
            CoreTermSearchFacetResult v = (CoreTermSearchFacetResult)coreSearchFacetResult;
            searchFacetResult = SearchFacetResult$TermSearchFacetResult$.MODULE$.apply(v);
        } else if (coreSearchFacetResult instanceof CoreDateRangeSearchFacetResult) {
            CoreDateRangeSearchFacetResult v = (CoreDateRangeSearchFacetResult)coreSearchFacetResult;
            searchFacetResult = SearchFacetResult$DateRangeSearchFacetResult$.MODULE$.apply(v);
        } else if (coreSearchFacetResult instanceof CoreNumericRangeSearchFacetResult) {
            CoreNumericRangeSearchFacetResult v = (CoreNumericRangeSearchFacetResult)coreSearchFacetResult;
            searchFacetResult = SearchFacetResult$NumericRangeSearchFacetResult$.MODULE$.apply(v);
        } else {
            throw new MatchError((Object)coreSearchFacetResult);
        }
        return searchFacetResult;
    }

    public Obj convert(scala.collection.immutable.Map<String, Object> in) {
        scala.collection.immutable.Map out = (scala.collection.immutable.Map)((MapOps)in.map((Function1 & Serializable)x -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(x._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.convertInternal$1(x._2()));
        })).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 x2;
                Tuple2 tuple2 = x;
                return tuple2 instanceof Tuple2 && ((Option)(x2 = tuple2)._2()).isDefined();
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 x2;
                Tuple2 tuple2 = x;
                if (tuple2 instanceof Tuple2 && ((Option)(x2 = tuple2)._2()).isDefined()) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc(x2._1());
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, ((Option)x2._2()).get());
                }
                return function1.apply((Object)x);
            }
        });
        return Obj$.MODULE$.from((IterableOnce)out);
    }

    public <T> Future<T> convert(Function0<CoreAsyncResponse<T>> in, ExecutionContext ec) {
        Future future;
        try {
            future = FutureConversions$.MODULE$.javaCFToScalaFutureMappingExceptions(((CoreAsyncResponse)in.apply()).toFuture(), ec);
        }
        catch (Throwable err) {
            future = Future$.MODULE$.failed(err);
        }
        return future;
    }

    public CoreDurability convert(Durability in) {
        Durability durability = in;
        if (Durability$Disabled$.MODULE$.equals(durability)) {
            return CoreDurability.NONE;
        }
        if (durability instanceof Durability.ClientVerified) {
            Observe.ObserveReplicateTo observeReplicateTo;
            Observe.ObservePersistTo observePersistTo;
            Enumeration.Value persistTo;
            Durability.ClientVerified clientVerified = Durability$ClientVerified$.MODULE$.unapply((Durability.ClientVerified)durability);
            Enumeration.Value value = clientVerified._1();
            Enumeration.Value value2 = clientVerified._2();
            Enumeration.Value replicateTo = value;
            Enumeration.Value value3 = persistTo = value2;
            Enumeration.Value value4 = PersistTo$.MODULE$.None();
            Enumeration.Value value5 = value3;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                observePersistTo = Observe.ObservePersistTo.NONE;
            } else {
                Enumeration.Value value6 = PersistTo$.MODULE$.One();
                Enumeration.Value value7 = value3;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    observePersistTo = Observe.ObservePersistTo.ONE;
                } else {
                    Enumeration.Value value8 = PersistTo$.MODULE$.Two();
                    Enumeration.Value value9 = value3;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        observePersistTo = Observe.ObservePersistTo.TWO;
                    } else {
                        Enumeration.Value value10 = PersistTo$.MODULE$.Three();
                        Enumeration.Value value11 = value3;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            observePersistTo = Observe.ObservePersistTo.THREE;
                        } else {
                            throw new MatchError((Object)value3);
                        }
                    }
                }
            }
            Enumeration.Value value12 = replicateTo;
            Enumeration.Value value13 = ReplicateTo$.MODULE$.None();
            Enumeration.Value value14 = value12;
            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                observeReplicateTo = Observe.ObserveReplicateTo.NONE;
            } else {
                Enumeration.Value value15 = ReplicateTo$.MODULE$.One();
                Enumeration.Value value16 = value12;
                if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                    observeReplicateTo = Observe.ObserveReplicateTo.ONE;
                } else {
                    Enumeration.Value value17 = ReplicateTo$.MODULE$.Two();
                    Enumeration.Value value18 = value12;
                    if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                        observeReplicateTo = Observe.ObserveReplicateTo.TWO;
                    } else {
                        Enumeration.Value value19 = ReplicateTo$.MODULE$.Three();
                        Enumeration.Value value20 = value12;
                        if (!(value19 != null ? !value19.equals(value20) : value20 != null)) {
                            observeReplicateTo = Observe.ObserveReplicateTo.THREE;
                        } else {
                            throw new MatchError((Object)value12);
                        }
                    }
                }
            }
            return CoreDurability.of((Observe.ObservePersistTo)observePersistTo, (Observe.ObserveReplicateTo)observeReplicateTo);
        }
        if (Durability$Majority$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.MAJORITY);
        }
        if (Durability$MajorityAndPersistToActive$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE);
        }
        if (Durability$PersistToMajority$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.PERSIST_TO_MAJORITY);
        }
        throw new MatchError((Object)durability);
    }

    public CoreExpiry convertExpiry(@Nullable Duration in) {
        if (in == null) {
            return CoreExpiry.NONE;
        }
        return CoreExpiry.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(in));
    }

    public java.time.Duration convert(Duration in) {
        return java.time.Duration.ofMillis(in.toMillis());
    }

    public CoreStoreSemantics convert(StoreSemantics in) {
        StoreSemantics storeSemantics = in;
        if (StoreSemantics$Replace$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.REPLACE;
        }
        if (StoreSemantics$Insert$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.INSERT;
        }
        if (StoreSemantics$Upsert$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.UPSERT;
        }
        throw new MatchError((Object)storeSemantics);
    }

    public <T> Supplier<CoreEncodedContent> encoder(Transcoder transcoder, JsonSerializer<T> serializer, T content) {
        return () -> {
            Try<EncodedValue> try_;
            Transcoder transcoder = transcoder;
            if (transcoder instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer x = (TranscoderWithSerializer)transcoder;
                try_ = x.encode(content, serializer);
            } else if (transcoder instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer x = (TranscoderWithoutSerializer)transcoder;
                try_ = x.encode(content);
            } else {
                throw new MatchError((Object)transcoder);
            }
            EncodedValue value = (EncodedValue)try_.get();
            return new CoreEncodedContent(value){
                private final EncodedValue value$1;
                {
                    this.value$1 = value$2;
                }

                public byte[] encoded() {
                    return this.value$1.encoded();
                }

                public int flags() {
                    return this.value$1.flags();
                }
            };
        };
    }

    private static final Transcoder convert$$anonfun$1(ClusterEnvironment env$1) {
        return env$1.transcoder();
    }

    private static final Transcoder convertReplica$$anonfun$1(ClusterEnvironment env$2) {
        return env$2.transcoder();
    }

    private final Option convertInternal$1(Object in) {
        Object object = in;
        if (object instanceof String) {
            String x = (String)object;
            return Some$.MODULE$.apply((Object)Str$.MODULE$.apply(x));
        }
        if (object instanceof Integer) {
            int x = BoxesRunTime.unboxToInt((Object)object);
            return Some$.MODULE$.apply((Object)Num$.MODULE$.apply(Int$.MODULE$.int2double(x)));
        }
        if (object instanceof Double) {
            double x = BoxesRunTime.unboxToDouble((Object)object);
            return Some$.MODULE$.apply((Object)Num$.MODULE$.apply(x));
        }
        if (object instanceof Boolean) {
            boolean x = BoxesRunTime.unboxToBoolean((Object)object);
            return Some$.MODULE$.apply((Object)Bool$.MODULE$.apply(x));
        }
        if (object instanceof LinkedHashMap) {
            LinkedHashMap x = (LinkedHashMap)object;
            return Some$.MODULE$.apply((Object)this.convert((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala((Map)x).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }
        if (object instanceof ArrayList) {
            ArrayList x = (ArrayList)object;
            ArrayBuffer ab = new ArrayBuffer();
            x.forEach(v -> {
                Option option = this.convertInternal$1(v);
                if (option instanceof Some) {
                    Value value = (Value)((Some)option).value();
                    ab.$plus$eq((Object)value);
                    return;
                }
            });
            return Some$.MODULE$.apply((Object)Arr$.MODULE$.apply(ab));
        }
        return None$.MODULE$;
    }
}

