/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.kv.AppendOptions;
import com.couchbase.client.scala.kv.AppendOptions$;
import com.couchbase.client.scala.kv.CounterResult;
import com.couchbase.client.scala.kv.DecrementOptions;
import com.couchbase.client.scala.kv.DecrementOptions$;
import com.couchbase.client.scala.kv.IncrementOptions;
import com.couchbase.client.scala.kv.IncrementOptions$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.PrependOptions;
import com.couchbase.client.scala.kv.PrependOptions$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.ExpiryUtil$;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.OptionConverters;
import scala.runtime.BoxesRunTime;

public class AsyncBinaryCollection {
    private final AsyncCollection async;
    private final ExecutionContext ec;
    private final ClusterEnvironment environment;
    private final Function1 kvTimeout;
    private final CoreKvBinaryOps kvBinaryOps;

    public AsyncBinaryCollection(AsyncCollection async) {
        this.async = async;
        this.ec = async.ec();
        this.environment = async.environment();
        this.kvTimeout = async.kvTimeout();
        this.kvBinaryOps = async.couchbaseOps().kvBinaryOps(async.keyspace());
    }

    public AsyncCollection async() {
        return this.async;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public Function1<Durability, Duration> kvTimeout() {
        return this.kvTimeout;
    }

    public CoreKvBinaryOps kvBinaryOps() {
        return this.kvBinaryOps;
    }

    public Future<MutationResult> append(String id, byte[] content, AppendOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.append$$anonfun$1(id, content, options), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public AppendOptions append$default$3() {
        return AppendOptions$.MODULE$.Default();
    }

    public Future<MutationResult> prepend(String id, byte[] content, PrependOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.prepend$$anonfun$1(id, content, options), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public PrependOptions prepend$default$3() {
        return PrependOptions$.MODULE$.Default();
    }

    public Future<CounterResult> increment(String id, long delta, IncrementOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.increment$$anonfun$1(id, options, delta), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreCounterResult)result), this.ec());
    }

    public IncrementOptions increment$default$3() {
        return IncrementOptions$.MODULE$.Default();
    }

    public Future<CounterResult> decrement(String id, long delta, DecrementOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.decrement$$anonfun$1(id, options, delta), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreCounterResult)result), this.ec());
    }

    public DecrementOptions decrement$default$3() {
        return DecrementOptions$.MODULE$.Default();
    }

    private final CoreAsyncResponse append$$anonfun$1(String id$1, byte[] content$1, AppendOptions options$1) {
        return this.kvBinaryOps().appendAsync(id$1, content$1, CoreCommonConverters$.MODULE$.convert(options$1), options$1.cas(), CoreCommonConverters$.MODULE$.convert(options$1.durability()));
    }

    private final CoreAsyncResponse prepend$$anonfun$1(String id$2, byte[] content$2, PrependOptions options$2) {
        return this.kvBinaryOps().prependAsync(id$2, content$2, CoreCommonConverters$.MODULE$.convert(options$2), options$2.cas(), CoreCommonConverters$.MODULE$.convert(options$2.durability()));
    }

    private static final /* synthetic */ Long increment$$anonfun$1$$anonfun$1(long v) {
        return BoxesRunTime.boxToLong((long)v);
    }

    private final CoreAsyncResponse increment$$anonfun$1(String id$3, IncrementOptions options$3, long delta$1) {
        Option option = OptionConverters$.MODULE$.RichOption(options$3.initial().map((Function1 & Serializable)v -> AsyncBinaryCollection.increment$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)v))));
        return this.kvBinaryOps().incrementAsync(id$3, CoreCommonConverters$.MODULE$.convert(options$3), ExpiryUtil$.MODULE$.expiryActual(options$3.expiry(), options$3.expiryTime()), delta$1, OptionConverters.RichOption$.MODULE$.asJava$extension(option), CoreCommonConverters$.MODULE$.convert(options$3.durability()));
    }

    private static final /* synthetic */ Long decrement$$anonfun$1$$anonfun$1(long v) {
        return BoxesRunTime.boxToLong((long)v);
    }

    private final CoreAsyncResponse decrement$$anonfun$1(String id$4, DecrementOptions options$4, long delta$2) {
        Option option = OptionConverters$.MODULE$.RichOption(options$4.initial().map((Function1 & Serializable)v -> AsyncBinaryCollection.decrement$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToLong((Object)v))));
        return this.kvBinaryOps().decrementAsync(id$4, CoreCommonConverters$.MODULE$.convert(options$4), ExpiryUtil$.MODULE$.expiryActual(options$4.expiry(), options$4.expiryTime()), delta$2, OptionConverters.RichOption$.MODULE$.asJava$extension(option), CoreCommonConverters$.MODULE$.convert(options$4.durability()));
    }
}

