/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionContext;
import com.couchbase.client.core.transaction.CoreTransactionResult;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarker;
import com.couchbase.client.core.transaction.threadlocal.TransactionMarkerOwner;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.transactions.AsyncTransactionAttemptContext;
import com.couchbase.client.scala.transactions.TransactionAttemptContext;
import com.couchbase.client.scala.transactions.TransactionResult;
import com.couchbase.client.scala.transactions.TransactionResult$;
import com.couchbase.client.scala.transactions.config.TransactionOptions;
import com.couchbase.client.scala.transactions.config.TransactionOptions$;
import com.couchbase.client.scala.transactions.internal.ErrorUtil$;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Transactions {
    private final CoreTransactionsReactive internal;
    private final ClusterEnvironment environment;

    public Transactions(CoreTransactionsReactive internal, ClusterEnvironment environment) {
        this.internal = internal;
        this.environment = environment;
    }

    private CoreTransactionsReactive internal() {
        return this.internal;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    public Try<TransactionResult> run(Function1<TransactionAttemptContext, Try<BoxedUnit>> transactionLogic, TransactionOptions options) {
        Scheduler scheduler = this.internal().core().context().environment().transactionsSchedulers().schedulerBlocking();
        Mono x = Mono.defer(() -> {
            CoreMergedTransactionConfig merged = new CoreMergedTransactionConfig(this.internal().config(), Optional.of(options.toCore()));
            CoreTransactionContext overall = new CoreTransactionContext(this.internal().core().context(), UUID.randomUUID().toString(), merged, this.internal().core().transactionsCleanup());
            Mono createAttempt = Mono.defer(() -> {
                String attemptId = UUID.randomUUID().toString();
                CoreTransactionAttemptContext ctx = this.internal().createAttemptContext(overall, merged, attemptId);
                return Mono.just((Object)ctx);
            });
            Function<CoreTransactionAttemptContext, Mono> newTransactionLogic = ctx -> Mono.defer(() -> {
                AsyncTransactionAttemptContext async = new AsyncTransactionAttemptContext((CoreTransactionAttemptContext)ctx, this.environment());
                TransactionAttemptContext ctxBlocking = new TransactionAttemptContext(async);
                return Mono.fromCallable(() -> {
                    Transactions.$anonfun$3$$anonfun$1$$anonfun$1(ctx, transactionLogic, ctxBlocking);
                    return BoxedUnit.UNIT;
                }).subscribeOn(scheduler).then();
            });
            return this.internal().executeTransaction(createAttempt, merged, overall, newTransactionLogic, false).onErrorResume(err -> ErrorUtil$.MODULE$.convertTransactionFailedInternal((Throwable)err));
        });
        return Try$.MODULE$.apply(() -> Transactions.run$$anonfun$1(x, scheduler));
    }

    public TransactionOptions run$default$2() {
        return TransactionOptions$.MODULE$.Default();
    }

    private static final Try $anonfun$4(Function1 transactionLogic$5, TransactionAttemptContext ctxBlocking$2) {
        return (Try)transactionLogic$5.apply((Object)ctxBlocking$2);
    }

    private static final /* synthetic */ void $anonfun$3$$anonfun$1$$anonfun$1(CoreTransactionAttemptContext ctx$2, Function1 transactionLogic$3, TransactionAttemptContext ctxBlocking$1) {
        Try try_;
        TransactionMarkerOwner.set((TransactionMarker)new TransactionMarker(ctx$2));
        Try out = Try$.MODULE$.apply(() -> Transactions.$anonfun$4(transactionLogic$3, ctxBlocking$1));
        TransactionMarkerOwner.clear();
        Try try_2 = out;
        if (try_2 instanceof Failure) {
            Throwable exception = ((Failure)try_2).exception();
            throw exception;
        }
        if (try_2 instanceof Success && (try_ = (Try)((Success)try_2).value()) instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            throw exception;
        }
    }

    private static final TransactionResult run$$anonfun$1(Mono x$1, Scheduler scheduler$4) {
        return (TransactionResult)x$1.map((Function)new Function<CoreTransactionResult, TransactionResult>(){

            public TransactionResult apply(CoreTransactionResult result) {
                return TransactionResult$.MODULE$.apply(result);
            }
        }).publishOn(scheduler$4).block();
    }
}

