/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.env.ConnectionStringPropertyLoader;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.PropertyLoader;
import com.couchbase.client.core.env.WanDevelopmentProfile;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.forwards.CoreTransactionsSupportedExtensions;
import com.couchbase.client.scala.codec.JsonTranscoder$;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.env.ClusterEnvironment$;
import com.couchbase.client.scala.env.ClusterEnvironment$Builder$;
import com.couchbase.client.scala.env.CompressionConfig;
import com.couchbase.client.scala.env.CoreEnvironment;
import com.couchbase.client.scala.env.CoreEnvironmentWrapper;
import com.couchbase.client.scala.env.IoConfig;
import com.couchbase.client.scala.env.IoEnvironment;
import com.couchbase.client.scala.env.LoggerConfig;
import com.couchbase.client.scala.env.LoggingMeterConfig;
import com.couchbase.client.scala.env.OrphanReporterConfig;
import com.couchbase.client.scala.env.SecurityConfig;
import com.couchbase.client.scala.env.ThresholdRequestTracerConfig;
import com.couchbase.client.scala.env.TimeoutConfig;
import com.couchbase.client.scala.env.TimeoutConfig$;
import com.couchbase.client.scala.transactions.config.TransactionsConfig;
import com.couchbase.client.scala.transactions.internal.TransactionsSupportedExtensionsUtil$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure$;
import scala.util.Try;
import scala.util.Try$;

public class ClusterEnvironment {
    private final Builder builder;
    private final boolean owned;
    private final ExecutorService threadPool;
    private final ExecutionContextExecutor ec;
    private final Scheduler defaultScheduler;
    private final CoreEnvironmentWrapper coreBuilder;
    private final CoreEnvironment coreEnv;

    public static String WanDevelopmentProfile() {
        return ClusterEnvironment$.MODULE$.WanDevelopmentProfile();
    }

    public static ClusterEnvironment create() {
        return ClusterEnvironment$.MODULE$.create();
    }

    public ClusterEnvironment(Builder builder) {
        CoreEnvironmentWrapper coreEnvironmentWrapper;
        this.builder = builder;
        this.owned = builder.owned();
        this.threadPool = Executors.newCachedThreadPool(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName(new StringBuilder(9).append("cb-comps-").append(thread.getId()).toString());
                return thread;
            }
        });
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)this.threadPool());
        this.defaultScheduler = Schedulers.fromExecutorService((ExecutorService)this.threadPool());
        this.coreBuilder = new CoreEnvironmentWrapper();
        builder.connectionString().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.load((PropertyLoader)new ConnectionStringPropertyLoader(v)));
        builder.ioEnvironment().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.ioEnvironment(v.toCore()));
        builder.ioConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.ioConfig(v.toCore()));
        builder.compressionConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.compressionConfig(v.toCore()));
        builder.securityConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.securityConfig(v.toCore()));
        builder.timeoutConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.timeoutConfig(v.toCore()));
        builder.loggerConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.loggerConfig(v.toCore()));
        builder.orphanReporterConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.orphanReporterConfig(v.toCore()));
        builder.eventBus().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.eventBus((EventBus)v));
        builder.scheduler().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.scheduler((Scheduler)v));
        builder.retryStrategy().foreach((Function1 & Serializable)rs -> (CoreEnvironmentWrapper)this.coreBuilder.retryStrategy((RetryStrategy)rs));
        builder.requestTracer().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.requestTracer((RequestTracer)v));
        builder.meter().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.meter((Meter)v));
        builder.maxNumRequestsInRetry().foreach((Function1 & Serializable)v -> this.$init$$$anonfun$14(BoxesRunTime.unboxToInt((Object)v)));
        builder.propertyLoaders().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.load((PropertyLoader)v));
        builder.thresholdRequestTracerConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.thresholdRequestTracerConfig(v.toCore()));
        builder.loggingMeterConfig().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.loggingMeterConfig(v.toCore()));
        Option<TransactionsConfig> option = builder.transactionsConfig();
        if (option instanceof Some) {
            TransactionsConfig value = (TransactionsConfig)((Some)option).value();
            coreEnvironmentWrapper = (CoreEnvironmentWrapper)this.coreBuilder.transactionsConfig(value.toCore());
        } else if (None$.MODULE$.equals(option)) {
            coreEnvironmentWrapper = (CoreEnvironmentWrapper)this.coreBuilder.transactionsConfig(CoreTransactionsConfig.createDefault((CoreTransactionsSupportedExtensions)TransactionsSupportedExtensionsUtil$.MODULE$.Supported()));
        } else {
            throw new MatchError(option);
        }
        builder.preferredServerGroup().foreach((Function1 & Serializable)v -> (CoreEnvironmentWrapper)this.coreBuilder.preferredServerGroup((String)v));
        this.coreBuilder.loadSystemProperties();
        this.coreEnv = new CoreEnvironment(this.coreBuilder);
    }

    public Builder builder() {
        return this.builder;
    }

    public boolean owned() {
        return this.owned;
    }

    public com.couchbase.client.core.env.TimeoutConfig timeoutConfig() {
        return this.coreEnv().timeoutConfig();
    }

    public RetryStrategy retryStrategy() {
        return this.coreEnv().retryStrategy();
    }

    public Transcoder transcoder() {
        return (Transcoder)this.builder().transcoder().getOrElse(ClusterEnvironment::transcoder$$anonfun$1);
    }

    public Option<TransactionsConfig> transactionsConfig() {
        return this.builder().transactionsConfig();
    }

    public ExecutorService threadPool() {
        return this.threadPool;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Scheduler defaultScheduler() {
        return this.defaultScheduler;
    }

    public CoreEnvironment coreEnv() {
        return this.coreEnv;
    }

    public CoreEnvironment core() {
        return this.coreEnv();
    }

    public void shutdown(Duration timeout) {
        if (!this.threadPool().isShutdown()) {
            this.coreEnv().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout));
            this.threadPool().shutdownNow();
            this.threadPool().awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
            this.defaultScheduler().dispose();
            return;
        }
    }

    public Duration shutdown$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.coreEnv().timeoutConfig().disconnectTimeout());
    }

    private final /* synthetic */ CoreEnvironmentWrapper $init$$$anonfun$14(int v) {
        return (CoreEnvironmentWrapper)this.coreBuilder.maxNumRequestsInRetry(Int$.MODULE$.int2long(v));
    }

    private static final Transcoder transcoder$$anonfun$1() {
        return JsonTranscoder$.MODULE$.Instance();
    }

    public static class Builder
    implements Product,
    Serializable {
        private final boolean owned;
        private final Option connectionString;
        private final Option ioEnvironment;
        private final Option ioConfig;
        private final Option compressionConfig;
        private final Option securityConfig;
        private final Option timeoutConfig;
        private final Option loggerConfig;
        private final Option orphanReporterConfig;
        private final Option eventBus;
        private final Option scheduler;
        private final Option retryStrategy;
        private final Option requestTracer;
        private final Option meter;
        private final Option maxNumRequestsInRetry;
        private final Option transcoder;
        private final Seq propertyLoaders;
        private final Option thresholdRequestTracerConfig;
        private final Option loggingMeterConfig;
        private final Option transactionsConfig;
        private final Option error;
        private final Option preferredServerGroup;

        public static Builder apply(boolean bl, Option<String> option, Option<IoEnvironment> option2, Option<IoConfig> option3, Option<CompressionConfig> option4, Option<SecurityConfig> option5, Option<TimeoutConfig> option6, Option<LoggerConfig> option7, Option<OrphanReporterConfig> option8, Option<EventBus> option9, Option<Scheduler> option10, Option<RetryStrategy> option11, Option<RequestTracer> option12, Option<Meter> option13, Option<Object> option14, Option<Transcoder> option15, Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq, Option<ThresholdRequestTracerConfig> option16, Option<LoggingMeterConfig> option17, Option<TransactionsConfig> option18, Option<Throwable> option19, Option<String> option20) {
            return ClusterEnvironment$Builder$.MODULE$.apply(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, option16, option17, option18, option19, option20);
        }

        public static Builder fromProduct(Product product) {
            return ClusterEnvironment$Builder$.MODULE$.fromProduct(product);
        }

        public static Builder unapply(Builder builder) {
            return ClusterEnvironment$Builder$.MODULE$.unapply(builder);
        }

        public static Option<String> $lessinit$greater$default$2() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<IoEnvironment> $lessinit$greater$default$3() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<IoConfig> $lessinit$greater$default$4() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<CompressionConfig> $lessinit$greater$default$5() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<SecurityConfig> $lessinit$greater$default$6() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<TimeoutConfig> $lessinit$greater$default$7() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$7();
        }

        public static Option<LoggerConfig> $lessinit$greater$default$8() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$8();
        }

        public static Option<OrphanReporterConfig> $lessinit$greater$default$9() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$9();
        }

        public static Option<EventBus> $lessinit$greater$default$10() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$10();
        }

        public static Option<Scheduler> $lessinit$greater$default$11() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$11();
        }

        public static Option<RetryStrategy> $lessinit$greater$default$12() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$12();
        }

        public static Option<RequestTracer> $lessinit$greater$default$13() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$13();
        }

        public static Option<Meter> $lessinit$greater$default$14() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$14();
        }

        public static Option<Object> $lessinit$greater$default$15() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$15();
        }

        public static Option<Transcoder> $lessinit$greater$default$16() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$16();
        }

        public static Seq<PropertyLoader<CoreEnvironment.Builder<?>>> $lessinit$greater$default$17() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$17();
        }

        public static Option<ThresholdRequestTracerConfig> $lessinit$greater$default$18() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$18();
        }

        public static Option<LoggingMeterConfig> $lessinit$greater$default$19() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$19();
        }

        public static Option<TransactionsConfig> $lessinit$greater$default$20() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$20();
        }

        public static Option<Throwable> $lessinit$greater$default$21() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$21();
        }

        public static Option<String> $lessinit$greater$default$22() {
            return ClusterEnvironment$Builder$.MODULE$.$lessinit$greater$default$22();
        }

        public Builder(boolean owned, Option<String> connectionString, Option<IoEnvironment> ioEnvironment, Option<IoConfig> ioConfig, Option<CompressionConfig> compressionConfig, Option<SecurityConfig> securityConfig, Option<TimeoutConfig> timeoutConfig, Option<LoggerConfig> loggerConfig, Option<OrphanReporterConfig> orphanReporterConfig, Option<EventBus> eventBus, Option<Scheduler> scheduler, Option<RetryStrategy> retryStrategy, Option<RequestTracer> requestTracer, Option<Meter> meter, Option<Object> maxNumRequestsInRetry, Option<Transcoder> transcoder, Seq<PropertyLoader<CoreEnvironment.Builder<?>>> propertyLoaders, Option<ThresholdRequestTracerConfig> thresholdRequestTracerConfig, Option<LoggingMeterConfig> loggingMeterConfig, Option<TransactionsConfig> transactionsConfig, Option<Throwable> error, Option<String> preferredServerGroup) {
            this.owned = owned;
            this.connectionString = connectionString;
            this.ioEnvironment = ioEnvironment;
            this.ioConfig = ioConfig;
            this.compressionConfig = compressionConfig;
            this.securityConfig = securityConfig;
            this.timeoutConfig = timeoutConfig;
            this.loggerConfig = loggerConfig;
            this.orphanReporterConfig = orphanReporterConfig;
            this.eventBus = eventBus;
            this.scheduler = scheduler;
            this.retryStrategy = retryStrategy;
            this.requestTracer = requestTracer;
            this.meter = meter;
            this.maxNumRequestsInRetry = maxNumRequestsInRetry;
            this.transcoder = transcoder;
            this.propertyLoaders = propertyLoaders;
            this.thresholdRequestTracerConfig = thresholdRequestTracerConfig;
            this.loggingMeterConfig = loggingMeterConfig;
            this.transactionsConfig = transactionsConfig;
            this.error = error;
            this.preferredServerGroup = preferredServerGroup;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.owned() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.connectionString()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.ioEnvironment()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.ioConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.compressionConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.securityConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.timeoutConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.loggerConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.orphanReporterConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.eventBus()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.scheduler()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.retryStrategy()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.requestTracer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.meter()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.maxNumRequestsInRetry()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.transcoder()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.propertyLoaders()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.thresholdRequestTracerConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.loggingMeterConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.transactionsConfig()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.error()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.preferredServerGroup()));
            return Statics.finalizeHash((int)n, (int)22);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Builder)) return false;
            Builder builder = (Builder)object;
            if (this.owned() != builder.owned()) return false;
            Option<String> option = this.connectionString();
            Option<String> option2 = builder.connectionString();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<IoEnvironment> option3 = this.ioEnvironment();
            Option<IoEnvironment> option4 = builder.ioEnvironment();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<IoConfig> option5 = this.ioConfig();
            Option<IoConfig> option6 = builder.ioConfig();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<CompressionConfig> option7 = this.compressionConfig();
            Option<CompressionConfig> option8 = builder.compressionConfig();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<SecurityConfig> option9 = this.securityConfig();
            Option<SecurityConfig> option10 = builder.securityConfig();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            Option<TimeoutConfig> option11 = this.timeoutConfig();
            Option<TimeoutConfig> option12 = builder.timeoutConfig();
            if (option11 == null) {
                if (option12 != null) {
                    return false;
                }
            } else if (!option11.equals(option12)) return false;
            Option<LoggerConfig> option13 = this.loggerConfig();
            Option<LoggerConfig> option14 = builder.loggerConfig();
            if (option13 == null) {
                if (option14 != null) {
                    return false;
                }
            } else if (!option13.equals(option14)) return false;
            Option<OrphanReporterConfig> option15 = this.orphanReporterConfig();
            Option<OrphanReporterConfig> option16 = builder.orphanReporterConfig();
            if (option15 == null) {
                if (option16 != null) {
                    return false;
                }
            } else if (!option15.equals(option16)) return false;
            Option<EventBus> option17 = this.eventBus();
            Option<EventBus> option18 = builder.eventBus();
            if (option17 == null) {
                if (option18 != null) {
                    return false;
                }
            } else if (!option17.equals(option18)) return false;
            Option<Scheduler> option19 = this.scheduler();
            Option<Scheduler> option20 = builder.scheduler();
            if (option19 == null) {
                if (option20 != null) {
                    return false;
                }
            } else if (!option19.equals(option20)) return false;
            Option<RetryStrategy> option21 = this.retryStrategy();
            Option<RetryStrategy> option22 = builder.retryStrategy();
            if (option21 == null) {
                if (option22 != null) {
                    return false;
                }
            } else if (!option21.equals(option22)) return false;
            Option<RequestTracer> option23 = this.requestTracer();
            Option<RequestTracer> option24 = builder.requestTracer();
            if (option23 == null) {
                if (option24 != null) {
                    return false;
                }
            } else if (!option23.equals(option24)) return false;
            Option<Meter> option25 = this.meter();
            Option<Meter> option26 = builder.meter();
            if (option25 == null) {
                if (option26 != null) {
                    return false;
                }
            } else if (!option25.equals(option26)) return false;
            Option<Object> option27 = this.maxNumRequestsInRetry();
            Option<Object> option28 = builder.maxNumRequestsInRetry();
            if (option27 == null) {
                if (option28 != null) {
                    return false;
                }
            } else if (!option27.equals(option28)) return false;
            Option<Transcoder> option29 = this.transcoder();
            Option<Transcoder> option30 = builder.transcoder();
            if (option29 == null) {
                if (option30 != null) {
                    return false;
                }
            } else if (!option29.equals(option30)) return false;
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.propertyLoaders();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq2 = builder.propertyLoaders();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Option<ThresholdRequestTracerConfig> option31 = this.thresholdRequestTracerConfig();
            Option<ThresholdRequestTracerConfig> option32 = builder.thresholdRequestTracerConfig();
            if (option31 == null) {
                if (option32 != null) {
                    return false;
                }
            } else if (!option31.equals(option32)) return false;
            Option<LoggingMeterConfig> option33 = this.loggingMeterConfig();
            Option<LoggingMeterConfig> option34 = builder.loggingMeterConfig();
            if (option33 == null) {
                if (option34 != null) {
                    return false;
                }
            } else if (!option33.equals(option34)) return false;
            Option<TransactionsConfig> option35 = this.transactionsConfig();
            Option<TransactionsConfig> option36 = builder.transactionsConfig();
            if (option35 == null) {
                if (option36 != null) {
                    return false;
                }
            } else if (!option35.equals(option36)) return false;
            Option<Throwable> option37 = this.error();
            Option<Throwable> option38 = builder.error();
            if (option37 == null) {
                if (option38 != null) {
                    return false;
                }
            } else if (!option37.equals(option38)) return false;
            Option<String> option39 = this.preferredServerGroup();
            Option<String> option40 = builder.preferredServerGroup();
            if (option39 == null) {
                if (option40 != null) {
                    return false;
                }
            } else if (!option39.equals(option40)) return false;
            if (!builder.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Builder;
        }

        public int productArity() {
            return 22;
        }

        public String productPrefix() {
            return "Builder";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean((boolean)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return this._12();
                }
                case 12: {
                    return this._13();
                }
                case 13: {
                    return this._14();
                }
                case 14: {
                    return this._15();
                }
                case 15: {
                    return this._16();
                }
                case 16: {
                    return this._17();
                }
                case 17: {
                    return this._18();
                }
                case 18: {
                    return this._19();
                }
                case 19: {
                    return this._20();
                }
                case 20: {
                    return this._21();
                }
                case 21: {
                    return this._22();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "owned";
                }
                case 1: {
                    return "connectionString";
                }
                case 2: {
                    return "ioEnvironment";
                }
                case 3: {
                    return "ioConfig";
                }
                case 4: {
                    return "compressionConfig";
                }
                case 5: {
                    return "securityConfig";
                }
                case 6: {
                    return "timeoutConfig";
                }
                case 7: {
                    return "loggerConfig";
                }
                case 8: {
                    return "orphanReporterConfig";
                }
                case 9: {
                    return "eventBus";
                }
                case 10: {
                    return "scheduler";
                }
                case 11: {
                    return "retryStrategy";
                }
                case 12: {
                    return "requestTracer";
                }
                case 13: {
                    return "meter";
                }
                case 14: {
                    return "maxNumRequestsInRetry";
                }
                case 15: {
                    return "transcoder";
                }
                case 16: {
                    return "propertyLoaders";
                }
                case 17: {
                    return "thresholdRequestTracerConfig";
                }
                case 18: {
                    return "loggingMeterConfig";
                }
                case 19: {
                    return "transactionsConfig";
                }
                case 20: {
                    return "error";
                }
                case 21: {
                    return "preferredServerGroup";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public boolean owned() {
            return this.owned;
        }

        public Option<String> connectionString() {
            return this.connectionString;
        }

        public Option<IoEnvironment> ioEnvironment() {
            return this.ioEnvironment;
        }

        public Option<IoConfig> ioConfig() {
            return this.ioConfig;
        }

        public Option<CompressionConfig> compressionConfig() {
            return this.compressionConfig;
        }

        public Option<SecurityConfig> securityConfig() {
            return this.securityConfig;
        }

        public Option<TimeoutConfig> timeoutConfig() {
            return this.timeoutConfig;
        }

        public Option<LoggerConfig> loggerConfig() {
            return this.loggerConfig;
        }

        public Option<OrphanReporterConfig> orphanReporterConfig() {
            return this.orphanReporterConfig;
        }

        public Option<EventBus> eventBus() {
            return this.eventBus;
        }

        public Option<Scheduler> scheduler() {
            return this.scheduler;
        }

        public Option<RetryStrategy> retryStrategy() {
            return this.retryStrategy;
        }

        public Option<RequestTracer> requestTracer() {
            return this.requestTracer;
        }

        public Option<Meter> meter() {
            return this.meter;
        }

        public Option<Object> maxNumRequestsInRetry() {
            return this.maxNumRequestsInRetry;
        }

        public Option<Transcoder> transcoder() {
            return this.transcoder;
        }

        public Seq<PropertyLoader<CoreEnvironment.Builder<?>>> propertyLoaders() {
            return this.propertyLoaders;
        }

        public Option<ThresholdRequestTracerConfig> thresholdRequestTracerConfig() {
            return this.thresholdRequestTracerConfig;
        }

        public Option<LoggingMeterConfig> loggingMeterConfig() {
            return this.loggingMeterConfig;
        }

        public Option<TransactionsConfig> transactionsConfig() {
            return this.transactionsConfig;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public Option<String> preferredServerGroup() {
            return this.preferredServerGroup;
        }

        public Try<ClusterEnvironment> build() {
            Option<Throwable> option = this.error();
            if (option instanceof Some) {
                Throwable err = (Throwable)((Some)option).value();
                return Failure$.MODULE$.apply(err);
            }
            return Try$.MODULE$.apply(this::build$$anonfun$1);
        }

        public Builder connectionString(String value) {
            Some some = Some$.MODULE$.apply((Object)value);
            boolean bl = this.copy$default$1();
            Option<IoEnvironment> option = this.copy$default$3();
            Option<IoConfig> option2 = this.copy$default$4();
            Option<CompressionConfig> option3 = this.copy$default$5();
            Option<SecurityConfig> option4 = this.copy$default$6();
            Option<TimeoutConfig> option5 = this.copy$default$7();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, (Option<String>)some, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder ioEnvironment(IoEnvironment config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoConfig> option2 = this.copy$default$4();
            Option<CompressionConfig> option3 = this.copy$default$5();
            Option<SecurityConfig> option4 = this.copy$default$6();
            Option<TimeoutConfig> option5 = this.copy$default$7();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, (Option<IoEnvironment>)some, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder ioConfig(IoConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<CompressionConfig> option3 = this.copy$default$5();
            Option<SecurityConfig> option4 = this.copy$default$6();
            Option<TimeoutConfig> option5 = this.copy$default$7();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, (Option<IoConfig>)some, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder compressionConfig(CompressionConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<SecurityConfig> option4 = this.copy$default$6();
            Option<TimeoutConfig> option5 = this.copy$default$7();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, (Option<CompressionConfig>)some, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder securityConfig(SecurityConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<TimeoutConfig> option5 = this.copy$default$7();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, (Option<SecurityConfig>)some, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder timeoutConfig(TimeoutConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<LoggerConfig> option6 = this.copy$default$8();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, (Option<TimeoutConfig>)some, option6, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder loggerConfig(LoggerConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<OrphanReporterConfig> option7 = this.copy$default$9();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, (Option<LoggerConfig>)some, option7, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder orphanReporterConfig(OrphanReporterConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<EventBus> option8 = this.copy$default$10();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, (Option<OrphanReporterConfig>)some, option8, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        @Stability.Uncommitted
        public Builder eventBus(EventBus eventBus) {
            Some some = Some$.MODULE$.apply((Object)eventBus);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<Scheduler> option9 = this.copy$default$11();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, (Option<EventBus>)some, option9, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        @Stability.Uncommitted
        public Builder scheduler(Scheduler scheduler) {
            Some some = Some$.MODULE$.apply((Object)scheduler);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<RetryStrategy> option10 = this.copy$default$12();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, (Option<Scheduler>)some, option10, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder retryStrategy(RetryStrategy value) {
            Some some = Some$.MODULE$.apply((Object)value);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RequestTracer> option11 = this.copy$default$13();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, (Option<RetryStrategy>)some, option11, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        @Stability.Volatile
        public Builder requestTracer(RequestTracer requestTracer) {
            Some some = Some$.MODULE$.apply((Object)requestTracer);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<Meter> option12 = this.copy$default$14();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, (Option<RequestTracer>)some, option12, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        @Stability.Volatile
        public Builder meter(Meter meter) {
            Some some = Some$.MODULE$.apply((Object)meter);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Object> option13 = this.copy$default$15();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, (Option<Meter>)some, option13, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder maxNumRequestsInRetry(int value) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)value));
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Transcoder> option14 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, (Option<Object>)some, option14, seq, option15, option16, option17, option18, option19);
        }

        public Builder transcoder(Transcoder transcoder) {
            Some some = Some$.MODULE$.apply((Object)transcoder);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option15 = this.copy$default$18();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, (Option<Transcoder>)some, seq, option15, option16, option17, option18, option19);
        }

        public Builder loaders(Seq<PropertyLoader<CoreEnvironment.Builder<?>>> propertyLoaders) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), propertyLoaders, this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22());
        }

        public Builder thresholdRequestTracerConfig(ThresholdRequestTracerConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Option<Transcoder> option15 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<LoggingMeterConfig> option16 = this.copy$default$19();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, (Option<ThresholdRequestTracerConfig>)some, option16, option17, option18, option19);
        }

        public Builder loggingMeterConfig(LoggingMeterConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Option<Transcoder> option15 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option16 = this.copy$default$18();
            Option<TransactionsConfig> option17 = this.copy$default$20();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, option16, (Option<LoggingMeterConfig>)some, option17, option18, option19);
        }

        public Builder transactionsConfig(TransactionsConfig config) {
            Some some = Some$.MODULE$.apply((Object)config);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Option<Transcoder> option15 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option16 = this.copy$default$18();
            Option<LoggingMeterConfig> option17 = this.copy$default$19();
            Option<Throwable> option18 = this.copy$default$21();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, option16, option17, (Option<TransactionsConfig>)some, option18, option19);
        }

        @Stability.Volatile
        public Builder applyProfile(String profileName) {
            String string = profileName;
            String string2 = ClusterEnvironment$.MODULE$.WanDevelopmentProfile();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                java.time.Duration connectTimeout = WanDevelopmentProfile.CONNECT_TIMEOUT;
                java.time.Duration kvTimeout = WanDevelopmentProfile.KV_TIMEOUT;
                java.time.Duration serviceTimeout = WanDevelopmentProfile.SERVICE_TIMEOUT;
                return this.timeoutConfig(TimeoutConfig$.MODULE$.apply(TimeoutConfig$.MODULE$.$lessinit$greater$default$1(), TimeoutConfig$.MODULE$.$lessinit$greater$default$2(), TimeoutConfig$.MODULE$.$lessinit$greater$default$3(), TimeoutConfig$.MODULE$.$lessinit$greater$default$4(), TimeoutConfig$.MODULE$.$lessinit$greater$default$5(), TimeoutConfig$.MODULE$.$lessinit$greater$default$6(), TimeoutConfig$.MODULE$.$lessinit$greater$default$7(), TimeoutConfig$.MODULE$.$lessinit$greater$default$8(), TimeoutConfig$.MODULE$.$lessinit$greater$default$9(), TimeoutConfig$.MODULE$.$lessinit$greater$default$10()).connectTimeout(DurationConversions$.MODULE$.javaDurationToScala(connectTimeout)).kvTimeout(DurationConversions$.MODULE$.javaDurationToScala(kvTimeout)).kvDurableTimeout(DurationConversions$.MODULE$.javaDurationToScala(kvTimeout)).viewTimeout(DurationConversions$.MODULE$.javaDurationToScala(serviceTimeout)).queryTimeout(DurationConversions$.MODULE$.javaDurationToScala(serviceTimeout)).analyticsTimeout(DurationConversions$.MODULE$.javaDurationToScala(serviceTimeout)).searchTimeout(DurationConversions$.MODULE$.javaDurationToScala(serviceTimeout)).managementTimeout(DurationConversions$.MODULE$.javaDurationToScala(serviceTimeout)));
            }
            Some some = Some$.MODULE$.apply((Object)new IllegalArgumentException(new StringBuilder(21).append("Unknown profile name ").append(profileName).toString()));
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Option<Transcoder> option15 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option16 = this.copy$default$18();
            Option<LoggingMeterConfig> option17 = this.copy$default$19();
            Option<TransactionsConfig> option18 = this.copy$default$20();
            Option<String> option19 = this.copy$default$22();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, option16, option17, option18, (Option<Throwable>)some, option19);
        }

        public Builder preferredServerGroup(String value) {
            Some some = Some$.MODULE$.apply((Object)value);
            boolean bl = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<IoEnvironment> option2 = this.copy$default$3();
            Option<IoConfig> option3 = this.copy$default$4();
            Option<CompressionConfig> option4 = this.copy$default$5();
            Option<SecurityConfig> option5 = this.copy$default$6();
            Option<TimeoutConfig> option6 = this.copy$default$7();
            Option<LoggerConfig> option7 = this.copy$default$8();
            Option<OrphanReporterConfig> option8 = this.copy$default$9();
            Option<EventBus> option9 = this.copy$default$10();
            Option<Scheduler> option10 = this.copy$default$11();
            Option<RetryStrategy> option11 = this.copy$default$12();
            Option<RequestTracer> option12 = this.copy$default$13();
            Option<Meter> option13 = this.copy$default$14();
            Option<Object> option14 = this.copy$default$15();
            Option<Transcoder> option15 = this.copy$default$16();
            Seq<PropertyLoader<CoreEnvironment.Builder<?>>> seq = this.copy$default$17();
            Option<ThresholdRequestTracerConfig> option16 = this.copy$default$18();
            Option<LoggingMeterConfig> option17 = this.copy$default$19();
            Option<TransactionsConfig> option18 = this.copy$default$20();
            Option<Throwable> option19 = this.copy$default$21();
            return this.copy(bl, option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12, option13, option14, option15, seq, option16, option17, option18, option19, (Option<String>)some);
        }

        public Builder copy(boolean owned, Option<String> connectionString, Option<IoEnvironment> ioEnvironment, Option<IoConfig> ioConfig, Option<CompressionConfig> compressionConfig, Option<SecurityConfig> securityConfig, Option<TimeoutConfig> timeoutConfig, Option<LoggerConfig> loggerConfig, Option<OrphanReporterConfig> orphanReporterConfig, Option<EventBus> eventBus, Option<Scheduler> scheduler, Option<RetryStrategy> retryStrategy, Option<RequestTracer> requestTracer, Option<Meter> meter, Option<Object> maxNumRequestsInRetry, Option<Transcoder> transcoder, Seq<PropertyLoader<CoreEnvironment.Builder<?>>> propertyLoaders, Option<ThresholdRequestTracerConfig> thresholdRequestTracerConfig, Option<LoggingMeterConfig> loggingMeterConfig, Option<TransactionsConfig> transactionsConfig, Option<Throwable> error, Option<String> preferredServerGroup) {
            return new Builder(owned, connectionString, ioEnvironment, ioConfig, compressionConfig, securityConfig, timeoutConfig, loggerConfig, orphanReporterConfig, eventBus, scheduler, retryStrategy, requestTracer, meter, maxNumRequestsInRetry, transcoder, propertyLoaders, thresholdRequestTracerConfig, loggingMeterConfig, transactionsConfig, error, preferredServerGroup);
        }

        public boolean copy$default$1() {
            return this.owned();
        }

        public Option<String> copy$default$2() {
            return this.connectionString();
        }

        public Option<IoEnvironment> copy$default$3() {
            return this.ioEnvironment();
        }

        public Option<IoConfig> copy$default$4() {
            return this.ioConfig();
        }

        public Option<CompressionConfig> copy$default$5() {
            return this.compressionConfig();
        }

        public Option<SecurityConfig> copy$default$6() {
            return this.securityConfig();
        }

        public Option<TimeoutConfig> copy$default$7() {
            return this.timeoutConfig();
        }

        public Option<LoggerConfig> copy$default$8() {
            return this.loggerConfig();
        }

        public Option<OrphanReporterConfig> copy$default$9() {
            return this.orphanReporterConfig();
        }

        public Option<EventBus> copy$default$10() {
            return this.eventBus();
        }

        public Option<Scheduler> copy$default$11() {
            return this.scheduler();
        }

        public Option<RetryStrategy> copy$default$12() {
            return this.retryStrategy();
        }

        public Option<RequestTracer> copy$default$13() {
            return this.requestTracer();
        }

        public Option<Meter> copy$default$14() {
            return this.meter();
        }

        public Option<Object> copy$default$15() {
            return this.maxNumRequestsInRetry();
        }

        public Option<Transcoder> copy$default$16() {
            return this.transcoder();
        }

        public Seq<PropertyLoader<CoreEnvironment.Builder<?>>> copy$default$17() {
            return this.propertyLoaders();
        }

        public Option<ThresholdRequestTracerConfig> copy$default$18() {
            return this.thresholdRequestTracerConfig();
        }

        public Option<LoggingMeterConfig> copy$default$19() {
            return this.loggingMeterConfig();
        }

        public Option<TransactionsConfig> copy$default$20() {
            return this.transactionsConfig();
        }

        public Option<Throwable> copy$default$21() {
            return this.error();
        }

        public Option<String> copy$default$22() {
            return this.preferredServerGroup();
        }

        public boolean _1() {
            return this.owned();
        }

        public Option<String> _2() {
            return this.connectionString();
        }

        public Option<IoEnvironment> _3() {
            return this.ioEnvironment();
        }

        public Option<IoConfig> _4() {
            return this.ioConfig();
        }

        public Option<CompressionConfig> _5() {
            return this.compressionConfig();
        }

        public Option<SecurityConfig> _6() {
            return this.securityConfig();
        }

        public Option<TimeoutConfig> _7() {
            return this.timeoutConfig();
        }

        public Option<LoggerConfig> _8() {
            return this.loggerConfig();
        }

        public Option<OrphanReporterConfig> _9() {
            return this.orphanReporterConfig();
        }

        public Option<EventBus> _10() {
            return this.eventBus();
        }

        public Option<Scheduler> _11() {
            return this.scheduler();
        }

        public Option<RetryStrategy> _12() {
            return this.retryStrategy();
        }

        public Option<RequestTracer> _13() {
            return this.requestTracer();
        }

        public Option<Meter> _14() {
            return this.meter();
        }

        public Option<Object> _15() {
            return this.maxNumRequestsInRetry();
        }

        public Option<Transcoder> _16() {
            return this.transcoder();
        }

        public Seq<PropertyLoader<CoreEnvironment.Builder<?>>> _17() {
            return this.propertyLoaders();
        }

        public Option<ThresholdRequestTracerConfig> _18() {
            return this.thresholdRequestTracerConfig();
        }

        public Option<LoggingMeterConfig> _19() {
            return this.loggingMeterConfig();
        }

        public Option<TransactionsConfig> _20() {
            return this.transactionsConfig();
        }

        public Option<Throwable> _21() {
            return this.error();
        }

        public Option<String> _22() {
            return this.preferredServerGroup();
        }

        private final ClusterEnvironment build$$anonfun$1() {
            return new ClusterEnvironment(this);
        }
    }
}

