/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.CoreTransactionOptionalGetMultiResult;
import com.couchbase.client.core.transaction.components.CoreTransactionGetMultiSpec;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.AsyncScope;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.transactions.TransactionGetResult;
import com.couchbase.client.scala.transactions.TransactionGetResult$;
import com.couchbase.client.scala.transactions.TransactionQueryOptions;
import com.couchbase.client.scala.transactions.TransactionQueryResult;
import com.couchbase.client.scala.transactions.TransactionQueryResult$;
import com.couchbase.client.scala.transactions.config.TransactionGetOptions;
import com.couchbase.client.scala.transactions.config.TransactionGetOptions$;
import com.couchbase.client.scala.transactions.config.TransactionGetReplicaFromPreferredServerGroupOptions;
import com.couchbase.client.scala.transactions.config.TransactionGetReplicaFromPreferredServerGroupOptions$;
import com.couchbase.client.scala.transactions.config.TransactionInsertOptions;
import com.couchbase.client.scala.transactions.config.TransactionInsertOptions$;
import com.couchbase.client.scala.transactions.config.TransactionReplaceOptions;
import com.couchbase.client.scala.transactions.config.TransactionReplaceOptions$;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiOptions;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiOptions$;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupOptions;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupOptions$;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupResult;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiReplicasFromPreferredServerGroupSpec;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiResult;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiSpec;
import com.couchbase.client.scala.transactions.getmulti.TransactionGetMultiUtil$;
import com.couchbase.client.scala.transactions.internal.EncodingUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.List;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class AsyncTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final ClusterEnvironment environment;
    private final ExecutionContext executionContext;

    public AsyncTransactionAttemptContext(CoreTransactionAttemptContext internal, ClusterEnvironment environment) {
        this.internal = internal;
        this.environment = environment;
        this.executionContext = environment.ec();
    }

    public CoreTransactionAttemptContext internal() {
        return this.internal;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public Future<TransactionGetResult> get(AsyncCollection collection, String id, TransactionGetOptions options) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().get(collection.collectionIdentifier(), id)).map((Function1 & Serializable)result -> TransactionGetResult$.MODULE$.apply((CoreTransactionGetResult)result, options.transcoder()), this.executionContext());
    }

    public TransactionGetOptions get$default$3() {
        return TransactionGetOptions$.MODULE$.Default();
    }

    public Future<TransactionGetResult> getReplicaFromPreferredServerGroup(AsyncCollection collection, String id, TransactionGetReplicaFromPreferredServerGroupOptions options) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().getReplicaFromPreferredServerGroup(collection.collectionIdentifier(), id)).map((Function1 & Serializable)result -> TransactionGetResult$.MODULE$.apply((CoreTransactionGetResult)result, options.transcoder()), this.executionContext());
    }

    public TransactionGetReplicaFromPreferredServerGroupOptions getReplicaFromPreferredServerGroup$default$3() {
        return TransactionGetReplicaFromPreferredServerGroupOptions$.MODULE$.Default();
    }

    public Future<TransactionGetMultiResult> getMulti(Seq<TransactionGetMultiSpec> specs, TransactionGetMultiOptions options) {
        List<CoreTransactionGetMultiSpec> coreSpecs = TransactionGetMultiUtil$.MODULE$.convert(specs);
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().getMultiAlgo(coreSpecs, options.toCore(), false)).map((Function1 & Serializable)res -> TransactionGetMultiUtil$.MODULE$.convert((List<CoreTransactionOptionalGetMultiResult>)res, specs), this.executionContext());
    }

    public TransactionGetMultiOptions getMulti$default$2() {
        return TransactionGetMultiOptions$.MODULE$.Default();
    }

    public Future<TransactionGetMultiReplicasFromPreferredServerGroupResult> getMultiReplicasFromPreferredServerGroup(Seq<TransactionGetMultiReplicasFromPreferredServerGroupSpec> specs, TransactionGetMultiReplicasFromPreferredServerGroupOptions options) {
        List<CoreTransactionGetMultiSpec> coreSpecs = TransactionGetMultiUtil$.MODULE$.convertReplica(specs);
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().getMultiAlgo(coreSpecs, options.toCore(), true)).map((Function1 & Serializable)res -> TransactionGetMultiUtil$.MODULE$.convertReplica((List<CoreTransactionOptionalGetMultiResult>)res, specs), this.executionContext());
    }

    public TransactionGetMultiReplicasFromPreferredServerGroupOptions getMultiReplicasFromPreferredServerGroup$default$2() {
        return TransactionGetMultiReplicasFromPreferredServerGroupOptions$.MODULE$.Default();
    }

    public <T> Future<TransactionGetResult> insert(AsyncCollection collection, String id, T content, TransactionInsertOptions options, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_insert", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Try<EncodedValue> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, options.transcoder(), this.internal().core().context());
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            EncodedValue encoded = (EncodedValue)((Success)try_).value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().insert(collection.collectionIdentifier(), id, encoded.encoded(), encoded.flags(), new SpanWrapper(span))).map((Function1 & Serializable)result -> TransactionGetResult$.MODULE$.apply((CoreTransactionGetResult)result, options.transcoder()), this.executionContext()));
        }
        throw new MatchError(try_);
    }

    public <T> TransactionInsertOptions insert$default$4() {
        return TransactionInsertOptions$.MODULE$.Default();
    }

    public <T> Future<TransactionGetResult> replace(TransactionGetResult doc, T content, TransactionReplaceOptions options, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_replace", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Try<EncodedValue> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, options.transcoder(), this.internal().core().context());
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            EncodedValue encoded = (EncodedValue)((Success)try_).value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().replace(doc.internal(), encoded.encoded(), encoded.flags(), new SpanWrapper(span))).map((Function1 & Serializable)result -> TransactionGetResult$.MODULE$.apply((CoreTransactionGetResult)result, options.transcoder()), this.executionContext()));
        }
        throw new MatchError(try_);
    }

    public <T> TransactionReplaceOptions replace$default$3() {
        return TransactionReplaceOptions$.MODULE$.Default();
    }

    private <T> Future<TransactionGetResult> closeSpan(RequestSpan span, Future<TransactionGetResult> future) {
        future.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                span.status(RequestSpan.StatusCode.ERROR);
                span.end();
                return;
            }
            if (try_ instanceof Success) {
                span.end();
                return;
            }
            throw new MatchError((Object)try_);
        }, this.executionContext());
        return future;
    }

    public Future<BoxedUnit> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_remove", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        Future out = FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().remove(doc.internal(), new SpanWrapper(span))).map((Function1)(JProcedure1 & Serializable)_$1 -> {}, this.executionContext());
        out.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                span.status(RequestSpan.StatusCode.ERROR);
                span.end();
                return;
            }
            if (try_ instanceof Success) {
                span.end();
                return;
            }
            throw new MatchError((Object)try_);
        }, this.executionContext());
        return out;
    }

    public Future<TransactionQueryResult> query(String statement) {
        return this.query(null, statement, null);
    }

    public Future<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement, TransactionQueryOptions options) {
        CoreQueryOptions opts = (CoreQueryOptions)Option$.MODULE$.apply((Object)options).map((Function1 & Serializable)v -> v.toCore()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), opts, false)).map((Function1 & Serializable)internal -> TransactionQueryResult$.MODULE$.apply((CoreQueryResult)internal), this.executionContext());
    }
}

