/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.Cluster$;
import com.couchbase.client.scala.ClusterBase;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions$;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.vector.SearchRequest;
import com.couchbase.client.scala.transactions.Transactions;
import com.couchbase.client.scala.util.AsyncUtils$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Try;
import scala.util.Try$;

public class Cluster
implements ClusterBase {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Cluster.class.getDeclaredField("transactions$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Cluster.class.getDeclaredField("environment$lzy1"));
    private ExecutionContext ec;
    private AsyncCluster async;
    private volatile Object transactions$lzy1;
    private Function0<ClusterEnvironment> _env;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private volatile Object environment$lzy1;

    public static Try<Cluster> connect(String string, ClusterOptions clusterOptions) {
        return Cluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<Cluster> connect(String string, String string2, String string3) {
        return Cluster$.MODULE$.connect(string, string2, string3);
    }

    public Cluster(Function0<ClusterEnvironment> _env, Authenticator authenticator, ConnectionString connectionString) {
        this._env = _env;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        ClusterBase.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public AsyncCluster async() {
        return this.async;
    }

    @Override
    public Transactions transactions() {
        Object object = this.transactions$lzy1;
        if (object instanceof Transactions) {
            return (Transactions)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Transactions)this.transactions$lzyINIT1();
    }

    private Object transactions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.transactions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Transactions transactions = null;
                    try {
                        transactions = ClusterBase.transactions$(this);
                        object2 = transactions == null ? LazyVals.NullValue$.MODULE$ : transactions;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.transactions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return transactions;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void com$couchbase$client$scala$ClusterBase$_setter_$ec_$eq(ExecutionContext x$0) {
        this.ec = x$0;
    }

    @Override
    public void com$couchbase$client$scala$ClusterBase$_setter_$async_$eq(AsyncCluster x$0) {
        this.async = x$0;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ClusterEnvironment environment() {
        Object object = this.environment$lzy1;
        if (object instanceof ClusterEnvironment) {
            return (ClusterEnvironment)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterEnvironment)this.environment$lzyINIT1();
    }

    private Object environment$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.environment$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterEnvironment clusterEnvironment = null;
                    try {
                        clusterEnvironment = (ClusterEnvironment)this._env.apply();
                        object2 = clusterEnvironment == null ? LazyVals.NullValue$.MODULE$ : clusterEnvironment;
                        this._env = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.environment$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterEnvironment;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Try<QueryResult> query(String statement, QueryOptions options) {
        return Try$.MODULE$.apply(() -> this.query$$anonfun$1(statement, options)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result));
    }

    public QueryOptions query$default$2() {
        return QueryOptions$.MODULE$.Default();
    }

    public Try<SearchResult> search(String indexName, SearchRequest request, SearchOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().search(indexName, request, options));
    }

    public SearchOptions search$default$3() {
        return SearchOptions$.MODULE$.Default();
    }

    public void disconnect(Duration timeout) {
        AsyncUtils$.MODULE$.block(this.async().disconnect(timeout));
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Try<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().diagnostics(options));
    }

    public DiagnosticsOptions diagnostics$default$1() {
        return DiagnosticsOptions$.MODULE$.Default();
    }

    public Try<PingResult> ping(PingOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().ping(options));
    }

    public PingOptions ping$default$1() {
        return PingOptions$.MODULE$.Default();
    }

    public Try<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().waitUntilReady(timeout, options));
    }

    public WaitUntilReadyOptions waitUntilReady$default$2() {
        return WaitUntilReadyOptions$.MODULE$.Default();
    }

    private final CoreQueryResult query$$anonfun$1(String statement$1, QueryOptions options$1) {
        return this.async().queryOps().queryBlocking(statement$1, options$1.toCore(), null, null, null);
    }
}

