/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreSubdocGetCommand;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.kv.CoreRangeScan;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.CoreSamplingScan;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.kv.CoreScanTerm;
import com.couchbase.client.core.kv.CoreScanType;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBinaryCollection;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.AsyncCollectionBase$;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInResult$;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutationState;
import com.couchbase.client.scala.kv.ScanOptions;
import com.couchbase.client.scala.kv.ScanResult;
import com.couchbase.client.scala.kv.ScanResult$;
import com.couchbase.client.scala.kv.ScanTerm;
import com.couchbase.client.scala.kv.ScanType;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.TimeoutUtil$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

public interface AsyncCollectionBase {
    public static ArrayList<String> EmptyList() {
        return AsyncCollectionBase$.MODULE$.EmptyList();
    }

    public static void $init$(AsyncCollectionBase $this) {
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$ec_$eq((ExecutionContext)((AsyncCollection)$this).environment().ec());
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvTimeout_$eq((Function1 & Serializable)durability -> TimeoutUtil$.MODULE$.kvTimeout(((AsyncCollection)this).environment(), (Durability)durability));
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvReadTimeout_$eq(DurationConversions$.MODULE$.javaDurationToScala(((AsyncCollection)$this).environment().timeoutConfig().kvTimeout()));
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$collectionIdentifier_$eq(new CollectionIdentifier(((AsyncCollection)$this).bucketName(), Optional.of(((AsyncCollection)$this).scopeName()), Optional.of(((AsyncCollection)$this).name())));
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$keyspace_$eq(CoreKeyspace.from((CollectionIdentifier)$this.collectionIdentifier()));
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvOps_$eq(((AsyncCollection)$this).couchbaseOps().kvOps($this.keyspace()));
        $this.com$couchbase$client$scala$AsyncCollectionBase$_setter_$binary_$eq(new AsyncBinaryCollection((AsyncCollection)$this));
    }

    public ExecutionContext ec();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$ec_$eq(ExecutionContext var1);

    public Function1<Durability, Duration> kvTimeout();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvTimeout_$eq(Function1 var1);

    public Duration kvReadTimeout();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvReadTimeout_$eq(Duration var1);

    public CollectionIdentifier collectionIdentifier();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$collectionIdentifier_$eq(CollectionIdentifier var1);

    public CoreKeyspace keyspace();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$keyspace_$eq(CoreKeyspace var1);

    public CoreKvOps kvOps();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvOps_$eq(CoreKvOps var1);

    public static Core core$(AsyncCollectionBase $this) {
        return $this.core();
    }

    default public Core core() {
        CoreCouchbaseOps coreCouchbaseOps = ((AsyncCollection)this).couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return core;
        }
        throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
    }

    public AsyncBinaryCollection binary();

    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$binary_$eq(AsyncBinaryCollection var1);

    public static Future getSubDoc$(AsyncCollectionBase $this, String id, Seq spec, boolean withExpiry, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, Option parentSpan, Option accessDeleted) {
        return $this.getSubDoc(id, (Seq<LookupInSpec>)spec, withExpiry, timeout, retryStrategy, transcoder, (Option<RequestSpan>)parentSpan, (Option<Object>)accessDeleted);
    }

    default public Future<LookupInResult> getSubDoc(String id, Seq<LookupInSpec> spec, boolean withExpiry, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, Option<RequestSpan> parentSpan, Option<Object> accessDeleted) {
        ObjectRef commands = ObjectRef.create(LookupInSpec$.MODULE$.map(spec));
        if (withExpiry) {
            commands.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)commands.elem).$colon$plus((Object)new CoreSubdocGetCommand(SubdocCommandType.GET, "$document.exptime", true));
        }
        return CoreCommonConverters$.MODULE$.convert(() -> this.getSubDoc$$anonfun$1(timeout, retryStrategy, parentSpan, id, commands, accessDeleted), this.ec()).flatMap((Function1 & Serializable)result -> {
            Tuple2 tuple2;
            if (withExpiry) {
                Buffer fields = CollectionConverters$.MODULE$.ListHasAsScala(result.fields()).asScala();
                SubDocumentField expField = (SubDocumentField)fields.last();
                String expTime = new String(expField.value(), StandardCharsets.UTF_8);
                List fieldsWithout = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)fields.dropRight(1)).asJava();
                tuple2 = Tuple2$.MODULE$.apply((Object)fieldsWithout, (Object)Some$.MODULE$.apply((Object)Instant.ofEpochSecond(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(expTime)))));
            } else {
                tuple2 = Tuple2$.MODULE$.apply((Object)result.fields(), (Object)None$.MODULE$);
            }
            Tuple2 tuple22 = tuple2;
            List fieldsWithoutExp = (List)tuple22._1();
            Option expTime = (Option)tuple22._2();
            CoreSubdocGetResult modified = new CoreSubdocGetResult(result.keyspace(), result.key(), result.meta(), fieldsWithoutExp, result.cas(), result.tombstone());
            return Future$.MODULE$.successful((Object)LookupInResult$.MODULE$.apply(modified, (Option<Instant>)expTime, transcoder));
        }, this.ec());
    }

    public static Flux scanRequest$(AsyncCollectionBase $this, ScanType scanType, ScanOptions opts) {
        return $this.scanRequest(scanType, opts);
    }

    default public Flux<ScanResult> scanRequest(ScanType scanType, ScanOptions opts) {
        Object object;
        Duration duration = opts.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        java.time.Duration timeoutActual = !(duration != null ? !duration.equals(infinite) : infinite != null) ? ((AsyncCollection)this).environment().timeoutConfig().kvScanTimeout() : DurationConversions$.MODULE$.scalaDurationToJava(opts.timeout());
        LinkedList consistencyTokens = new LinkedList();
        Option<MutationState> option = opts.consistentWith();
        if (option instanceof Some) {
            MutationState cw = (MutationState)((Some)option).value();
            cw.tokens().foreach((Function1 & Serializable)t -> consistencyTokens.add(t));
        }
        boolean _idsOnly = BoxesRunTime.unboxToBoolean((Object)opts.idsOnly().getOrElse(AsyncCollectionBase::$anonfun$1));
        CoreScanOptions options = new CoreScanOptions(timeoutActual, opts, _idsOnly, consistencyTokens){
            private final java.time.Duration timeoutActual$1;
            private final ScanOptions opts$1;
            private final boolean _idsOnly$1;
            private final LinkedList consistencyTokens$2;
            {
                this.timeoutActual$1 = timeoutActual$2;
                this.opts$1 = opts$3;
                this._idsOnly$1 = _idsOnly$2;
                this.consistencyTokens$2 = consistencyTokens$3;
            }

            public CoreCommonOptions commonOptions() {
                return CoreCommonOptions.of((java.time.Duration)this.timeoutActual$1, (RetryStrategy)((RetryStrategy)this.opts$1.retryStrategy().getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$1)), (RequestSpan)((RequestSpan)this.opts$1.parentSpan().getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$2)));
            }

            public boolean idsOnly() {
                return this._idsOnly$1;
            }

            public CoreMutationState consistentWith() {
                return new CoreMutationState((Iterable)this.consistencyTokens$2);
            }

            public int batchItemLimit() {
                return BoxesRunTime.unboxToInt((Object)this.opts$1.batchItemLimit().getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchItemLimit$$anonfun$1));
            }

            public int batchByteLimit() {
                return BoxesRunTime.unboxToInt((Object)this.opts$1.batchByteLimit().getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchByteLimit$$anonfun$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$1(), com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$2(), com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchItemLimit$$anonfun$1(), com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchByteLimit$$anonfun$1()}, serializedLambda);
            }
        };
        ScanType scanType2 = scanType;
        if (scanType2 instanceof ScanType.RangeScan) {
            ScanType.RangeScan scan = (ScanType.RangeScan)scanType2;
            object = new CoreRangeScan(scan){
                private final ScanType.RangeScan scan$1;
                {
                    this.scan$1 = scan$3;
                }

                public CoreScanTerm from() {
                    return (CoreScanTerm)this.scan$1.from().map(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$1).getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$2);
                }

                public CoreScanTerm to() {
                    return (CoreScanTerm)this.scan$1.to().map(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$1).getOrElse(AsyncCollectionBase::com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$2);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$1(com.couchbase.client.scala.kv.ScanTerm ), com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$2(), com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$1(com.couchbase.client.scala.kv.ScanTerm ), com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$2()}, serializedLambda);
                }
            };
        } else if (scanType2 instanceof ScanType.PrefixScan) {
            ScanType.PrefixScan scan = (ScanType.PrefixScan)scanType2;
            object = CoreRangeScan.forPrefix((String)scan.prefix());
        } else if (scanType2 instanceof ScanType.SamplingScan) {
            ScanType.SamplingScan scan = (ScanType.SamplingScan)scanType2;
            object = new CoreSamplingScan(scan){
                private final ScanType.SamplingScan scan$2;
                {
                    this.scan$2 = scan$4;
                }

                public long limit() {
                    return this.scan$2.limit();
                }

                public Optional seed() {
                    return Optional.ofNullable(Predef$.MODULE$.long2Long(this.scan$2.seed()));
                }
            };
        } else {
            throw new MatchError((Object)scanType2);
        }
        CoreRangeScan rangeScan = object;
        return Flux.from((Publisher)this.kvOps().scanRequestReactive((CoreScanType)rangeScan, options)).map(item -> ScanResult$.MODULE$.apply((CoreRangeScanItem)item, (Transcoder)opts.transcoder().getOrElse(this::scanRequest$$anonfun$2$$anonfun$1)));
    }

    private static boolean getSubDoc$$anonfun$1$$anonfun$1() {
        return false;
    }

    private CoreAsyncResponse getSubDoc$$anonfun$1(Duration timeout$1, RetryStrategy retryStrategy$1, Option parentSpan$1, String id$1, ObjectRef commands$1, Option accessDeleted$1) {
        return this.kvOps().subdocGetAsync(CoreCommonConverters$.MODULE$.makeCommonOptions(timeout$1, retryStrategy$1, (RequestSpan)parentSpan$1.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), id$1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((scala.collection.immutable.Seq)commands$1.elem)).asJava(), BoxesRunTime.unboxToBoolean((Object)accessDeleted$1.getOrElse(AsyncCollectionBase::getSubDoc$$anonfun$1$$anonfun$1)));
    }

    private static boolean $anonfun$1() {
        return false;
    }

    public static RetryStrategy com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$1() {
        return null;
    }

    public static RequestSpan com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$commonOptions$$anonfun$2() {
        return null;
    }

    public static int com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchItemLimit$$anonfun$1() {
        return 50;
    }

    public static int com$couchbase$client$scala$AsyncCollectionBase$$anon$1$$_$batchByteLimit$$anonfun$1() {
        return 15000;
    }

    public static /* synthetic */ CoreScanTerm com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$1(ScanTerm _$1) {
        return _$1.toCore();
    }

    public static CoreScanTerm com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$from$$anonfun$2() {
        return CoreScanTerm.MIN;
    }

    public static /* synthetic */ CoreScanTerm com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$1(ScanTerm _$2) {
        return _$2.toCore();
    }

    public static CoreScanTerm com$couchbase$client$scala$AsyncCollectionBase$$anon$2$$_$to$$anonfun$2() {
        return CoreScanTerm.MAX;
    }

    private Transcoder scanRequest$$anonfun$2$$anonfun$1() {
        return ((AsyncCollection)this).environment().transcoder();
    }
}

