/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.DelegatingAuthenticator;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.AsyncClusterBase;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions$;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchResult$;
import com.couchbase.client.scala.search.vector.SearchRequest;
import com.couchbase.client.scala.transactions.AsyncTransactions;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters$RichOption$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class AsyncCluster
implements AsyncClusterBase {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(AsyncCluster.class.getDeclaredField("transactions$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AsyncCluster.class.getDeclaredField("ec$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AsyncCluster.class.getDeclaredField("environment$lzy1"));
    private volatile Object ec$lzy1;
    private DelegatingAuthenticator delegatingAuthenticator;
    private ClusterEnvironment env;
    private CoreCouchbaseOps couchbaseOps;
    private Duration searchTimeout;
    private Duration analyticsTimeout;
    private RetryStrategy retryStrategy;
    private CoreSearchOps searchOps;
    private CoreQueryOps queryOps;
    private volatile Object transactions$lzy1;
    private Function0<ClusterEnvironment> _env;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private volatile Object environment$lzy1;

    public static Try<ClusterEnvironment> extractClusterEnvironment(ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.extractClusterEnvironment(clusterOptions);
    }

    public static Try<ClusterEnvironment> extractClusterEnvironment(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.extractClusterEnvironment(string, clusterOptions);
    }

    public AsyncCluster(Function0<ClusterEnvironment> _env, Authenticator authenticator, ConnectionString connectionString) {
        this._env = _env;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        AsyncClusterBase.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public ExecutionContext ec() {
        Object object = this.ec$lzy1;
        if (object instanceof ExecutionContext) {
            return (ExecutionContext)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ExecutionContext)this.ec$lzyINIT1();
    }

    private Object ec$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.ec$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ExecutionContext executionContext = null;
                    try {
                        executionContext = AsyncClusterBase.ec$(this);
                        object2 = executionContext == null ? LazyVals.NullValue$.MODULE$ : executionContext;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.ec$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return executionContext;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public DelegatingAuthenticator delegatingAuthenticator() {
        return this.delegatingAuthenticator;
    }

    @Override
    public ClusterEnvironment env() {
        return this.env;
    }

    @Override
    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    @Override
    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    @Override
    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    @Override
    public AsyncTransactions transactions() {
        Object object = this.transactions$lzy1;
        if (object instanceof AsyncTransactions) {
            return (AsyncTransactions)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (AsyncTransactions)this.transactions$lzyINIT1();
    }

    private Object transactions$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.transactions$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    AsyncTransactions asyncTransactions = null;
                    try {
                        asyncTransactions = AsyncClusterBase.transactions$(this);
                        object2 = asyncTransactions == null ? LazyVals.NullValue$.MODULE$ : asyncTransactions;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.transactions$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return asyncTransactions;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$delegatingAuthenticator_$eq(DelegatingAuthenticator x$0) {
        this.delegatingAuthenticator = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$env_$eq(ClusterEnvironment x$0) {
        this.env = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$couchbaseOps_$eq(CoreCouchbaseOps x$0) {
        this.couchbaseOps = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$searchTimeout_$eq(Duration x$0) {
        this.searchTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$analyticsTimeout_$eq(Duration x$0) {
        this.analyticsTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$retryStrategy_$eq(RetryStrategy x$0) {
        this.retryStrategy = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$searchOps_$eq(CoreSearchOps x$0) {
        this.searchOps = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$queryOps_$eq(CoreQueryOps x$0) {
        this.queryOps = x$0;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ClusterEnvironment environment() {
        Object object = this.environment$lzy1;
        if (object instanceof ClusterEnvironment) {
            return (ClusterEnvironment)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ClusterEnvironment)this.environment$lzyINIT1();
    }

    private Object environment$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.environment$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ClusterEnvironment clusterEnvironment = null;
                    try {
                        clusterEnvironment = (ClusterEnvironment)this._env.apply();
                        object2 = clusterEnvironment == null ? LazyVals.NullValue$.MODULE$ : clusterEnvironment;
                        this._env = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.environment$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clusterEnvironment;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.query$$anonfun$1(statement, options), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryOptions query$default$2() {
        return QueryOptions$.MODULE$.Default();
    }

    public Future<SearchResult> search(String indexName, SearchRequest request, SearchOptions options) {
        Try<CoreSearchRequest> try_ = request.toCore();
        if (try_ instanceof Failure) {
            Throwable err = ((Failure)try_).exception();
            return Future$.MODULE$.failed(err);
        }
        if (try_ instanceof Success) {
            CoreSearchRequest req = (CoreSearchRequest)((Success)try_).value();
            return CoreCommonConverters$.MODULE$.convert(() -> this.search$$anonfun$1(indexName, req, options), this.ec()).map((Function1 & Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
        }
        throw new MatchError(try_);
    }

    public SearchOptions search$default$3() {
        return SearchOptions$.MODULE$.Default();
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.couchbaseOps().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).map((Function1)(JProcedure1 & Serializable)_$1 -> {
            if (this.env().owned()) {
                this.env().shutdown(timeout);
                return;
            }
        }, this.ec());
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return Future$.MODULE$.apply(() -> AsyncCluster.diagnostics$$anonfun$1(core, options), this.ec());
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public DiagnosticsOptions diagnostics$default$1() {
        return DiagnosticsOptions$.MODULE$.Default();
    }

    public Future<PingResult> ping(PingOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            Option option = OptionConverters$.MODULE$.RichOption(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)));
            Option option2 = OptionConverters$.MODULE$.RichOption(options.reportId());
            CompletableFuture future = HealthPinger.ping((Core)core, (Optional)OptionConverters$RichOption$.MODULE$.asJava$extension(option), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse(this::$anonfun$2)), (Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), (Optional)OptionConverters$RichOption$.MODULE$.asJava$extension(option2), Optional.empty()).toFuture();
            return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public PingOptions ping$default$1() {
        return PingOptions$.MODULE$.Default();
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.couchbaseOps().waitUntilReady(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1)(JProcedure1 & Serializable)_$2 -> {}, this.ec());
    }

    public WaitUntilReadyOptions waitUntilReady$default$2() {
        return WaitUntilReadyOptions$.MODULE$.Default();
    }

    private final CoreAsyncResponse query$$anonfun$1(String statement$1, QueryOptions options$1) {
        return this.queryOps().queryAsync(statement$1, options$1.toCore(), null, null, null);
    }

    private final CoreAsyncResponse search$$anonfun$1(String indexName$1, CoreSearchRequest req$1, SearchOptions options$2) {
        return this.searchOps().searchAsync(indexName$1, req$1, options$2.toCore());
    }

    private static final String diagnostics$$anonfun$1$$anonfun$2() {
        return UUID.randomUUID().toString();
    }

    private static final DiagnosticsResult diagnostics$$anonfun$1(Core core$1, DiagnosticsOptions options$3) {
        return new DiagnosticsResult(core$1.diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), core$1.context().environment().userAgent().formattedShort(), (String)options$3.reportId().getOrElse(AsyncCluster::diagnostics$$anonfun$1$$anonfun$2));
    }

    private final RetryStrategy $anonfun$2() {
        return this.env().retryStrategy();
    }
}

