/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.AsyncClusterBase;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.handlers.AnalyticsHandler;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.search.vector.SearchRequest;
import com.couchbase.client.scala.transactions.AsyncTransactions;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r-b\u0001\u0002\u00192\u0001iB\u0001\u0002\u0012\u0001\u0003\u0002\u0013\u0006I!\u0012\u0005\n\u001d\u0002\u0011)\u0019!C\u0001c=C\u0001b\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\n1\u0002\u0011)\u0019!C\u0001ceC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\nO\u0002A)\u0019!C\u0001c!D\u0011\"\u001b\u0001\t\u0006\u0004%\t!\r6\t\u0011M\u0004\u0001R1A\u0005\u0002QD\u0011\u0002\u001f\u0001\t\u0006\u0004%\t!M=\t\u0015\u0005\u0005\u0001\u0001#b\u0001\n\u0003\t\u0019\u0001\u0003\u0006\u0002\f\u0001A)\u0019!C\u0001\u0003\u001bA!\"a\u0007\u0001\u0011\u000b\u0007I\u0011AA\u000f\u0011)\tY\u0003\u0001EC\u0002\u0013\u0005\u0011Q\u0006\u0005\u000b\u0003w\u0001\u0001R1A\u0005\u0002\u0005u\u0002bBA\u0013\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003K\u0001A\u0011AAO\u0011%\t)\rAI\u0001\n\u0003\t9\rC\u0005\u0002\\\u0002\t\n\u0011\"\u0001\u0002^\"I\u0011\u0011\u001d\u0001\u0012\u0002\u0013\u0005\u00111\u001d\u0005\b\u0003O\u0004A\u0011AAu\u0011\u001d\t9\u000f\u0001C\u0001\u0005\u0003A\u0011Ba\u0004\u0001#\u0003%\tA!\u0005\t\u0013\tU\u0001!%A\u0005\u0002\u0005u\u0007bBA\u001b\u0001\u0011\u0005!q\u0003\u0005\b\u0003k\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001fBqA!\u0014\u0001\t\u0003\u0011\u0019\u0007C\u0005\u0003l\u0001\t\n\u0011\"\u0001\u0002^\"9!Q\u000e\u0001\u0005\u0002\t=\u0004\"\u0003B>\u0001E\u0005I\u0011AAo\u0011\u001d\u0011i\b\u0001C\u0001\u0005\u007fB\u0011B!%\u0001#\u0003%\tAa%\t\u000f\tu\u0004\u0001\"\u0001\u0003\u0018\"9!Q\u0015\u0001\u0005\u0002\t\u001d\u0006\"\u0003B]\u0001E\u0005I\u0011\u0001B^\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005\u007fCqA!3\u0001\t\u0003\u0011Y\rC\u0004\u0003J\u0002!\tAa4\b\u000f\tm\u0017\u0007#\u0001\u0003^\u001a1\u0001'\rE\u0001\u0005?Da!Y\u0015\u0005\u0002\t\u0005\bb\u0002BrS\u0011\u0005!Q\u001d\u0005\b\u0005GLC\u0011\u0001B~\u0011\u001d\u0011\u0019/\u000bC\u0001\u0007\u000fA\u0001ba\u0007*\t\u0003\u00194Q\u0004\u0005\t\u00077IC\u0011A\u001a\u0004(\ta\u0011i]=oG\u000ecWo\u001d;fe*\u0011!gM\u0001\u0006g\u000e\fG.\u0019\u0006\u0003iU\naa\u00197jK:$(B\u0001\u001c8\u0003%\u0019w.^2iE\u0006\u001cXMC\u00019\u0003\r\u0019w.\\\u0002\u0001'\r\u00011\b\u0011\t\u0003yyj\u0011!\u0010\u0006\u0002e%\u0011q(\u0010\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0005\u0013U\"A\u0019\n\u0005\r\u000b$\u0001E!ts:\u001c7\t\\;ti\u0016\u0014()Y:f\u0003\u0011yVM\u001c<\u0011\u0007q2\u0005*\u0003\u0002H{\tAAHY=oC6,g\b\u0005\u0002J\u00196\t!J\u0003\u0002Lc\u0005\u0019QM\u001c<\n\u00055S%AE\"mkN$XM]#om&\u0014xN\\7f]R\fQ\"Y;uQ\u0016tG/[2bi>\u0014X#\u0001)\u0011\u0005E+V\"\u0001*\u000b\u0005-\u001b&B\u0001+4\u0003\u0011\u0019wN]3\n\u0005Y\u0013&!D!vi\",g\u000e^5dCR|'/\u0001\bbkRDWM\u001c;jG\u0006$xN\u001d\u0011\u0002!\r|gN\\3di&|gn\u0015;sS:<W#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u\u001b\u0016\u0001B;uS2L!a\u0018/\u0003!\r{gN\\3di&|gn\u0015;sS:<\u0017!E2p]:,7\r^5p]N#(/\u001b8hA\u00051A(\u001b8jiz\"Ba\u00193fMB\u0011\u0011\t\u0001\u0005\u0007\t\u001a!\t\u0019A#\t\u000b93\u0001\u0019\u0001)\t\u000ba3\u0001\u0019\u0001.\u0002\u0017\u0015tg/\u001b:p]6,g\u000e^\u000b\u0002\u0011\u0006i\"/Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/F\u0001l!\ta\u0017/D\u0001n\u0015\tqw.A\u0005b]\u0006d\u0017\u0010^5dg*\u0011\u0001/M\u0001\b[\u0006t\u0017mZ3s\u0013\t\u0011XNA\u000fSK\u0006\u001cG/\u001b<f\u0003:\fG.\u001f;jGNLe\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003A\tg.\u00197zi&\u001c7/\u00138eKb,7/F\u0001v!\tag/\u0003\u0002x[\nQ\u0012i]=oG\u0006s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\u0006)\"/Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014X#\u0001>\u0011\u0005mtX\"\u0001?\u000b\u0005u|\u0017A\u00022vG.,G/\u0003\u0002\u0000y\n)\"+Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014\u0018a\u00022vG.,Go]\u000b\u0003\u0003\u000b\u00012a_A\u0004\u0013\r\tI\u0001 \u0002\u0013\u0003NLhn\u0019\"vG.,G/T1oC\u001e,'/A\u0003vg\u0016\u00148/\u0006\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016=\fA!^:fe&!\u0011\u0011DA\n\u0005A\t5/\u001f8d+N,'/T1oC\u001e,'/\u0001\u0007rk\u0016\u0014\u00180\u00138eKb,7/\u0006\u0002\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&=\fQ!];fefLA!!\u000b\u0002$\t1\u0012i]=oGF+XM]=J]\u0012,\u00070T1oC\u001e,'/A\u0007tK\u0006\u00148\r[%oI\u0016DXm]\u000b\u0003\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003ky\u0017AB:fCJ\u001c\u0007.\u0003\u0003\u0002:\u0005M\"aF!ts:\u001c7+Z1sG\"Le\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003E)g/\u001a8uS:<g)\u001e8di&|gn]\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bz\u0017\u0001C3wK:$\u0018N\\4\n\t\u0005%\u00131\t\u0002\u001d\u0003NLhnY#wK:$\u0018N\\4Gk:\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\ry\u0011Q\n\t\u0005\u0003\u001f\nYF\u0004\u0003\u0002R\u0005]SBAA*\u0015\r\t)fU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA-\u0003'\n\u0011b\u0015;bE&d\u0017\u000e^=\n\t\u0005u\u0013q\f\u0002\f+:\u001cw.\\7jiR,GM\u0003\u0003\u0002Z\u0005MCCBA2\u0003s\n\u0019\n\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b>\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003[\n9G\u0001\u0004GkR,(/\u001a\t\u0005\u0003c\n)(\u0004\u0002\u0002t)\u0019\u0011QE\u0019\n\t\u0005]\u00141\u000f\u0002\f#V,'/\u001f*fgVdG\u000fC\u0004\u0002|A\u0001\r!! \u0002\u0013M$\u0018\r^3nK:$\b\u0003BA@\u0003\u001bsA!!!\u0002\nB\u0019\u00111Q\u001f\u000e\u0005\u0005\u0015%bAADs\u00051AH]8pizJ1!a#>\u0003\u0019\u0001&/\u001a3fM&!\u0011qRAI\u0005\u0019\u0019FO]5oO*\u0019\u00111R\u001f\t\u000f\u0005U\u0005\u00031\u0001\u0002\u0018\u00069q\u000e\u001d;j_:\u001c\b\u0003BA9\u00033KA!a'\u0002t\ta\u0011+^3ss>\u0003H/[8ogRQ\u00111MAP\u0003C\u000bY+a/\t\u000f\u0005m\u0014\u00031\u0001\u0002~!I\u00111U\t\u0011\u0002\u0003\u0007\u0011QU\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003BA9\u0003OKA!!+\u0002t\ty\u0011+^3ssB\u000b'/Y7fi\u0016\u00148\u000fC\u0005\u0002.F\u0001\n\u00111\u0001\u00020\u00069A/[7f_V$\b\u0003BAY\u0003ok!!a-\u000b\t\u0005U\u0016qM\u0001\tIV\u0014\u0018\r^5p]&!\u0011\u0011XAZ\u0005!!UO]1uS>t\u0007\"CA_#A\u0005\t\u0019AA`\u0003\u0015\tG\r[8d!\ra\u0014\u0011Y\u0005\u0004\u0003\u0007l$a\u0002\"p_2,\u0017M\\\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001a\u0016\u0005\u0003K\u000bYm\u000b\u0002\u0002NB!\u0011qZAl\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017!C;oG\",7m[3e\u0015\r\t)&P\u0005\u0005\u00033\f\tNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"];fef$C-\u001a4bk2$HeM\u000b\u0003\u0003?TC!a,\u0002L\u0006y\u0011/^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u0002f*\"\u0011qXAf\u00039\tg.\u00197zi&\u001c7/U;fef$b!a;\u0002x\u0006e\bCBA3\u0003W\ni\u000f\u0005\u0003\u0002p\u0006MXBAAy\u0015\tq\u0017'\u0003\u0003\u0002v\u0006E(aD!oC2LH/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\u0005mT\u00031\u0001\u0002~!9\u0011QS\u000bA\u0002\u0005m\b\u0003BAx\u0003{LA!a@\u0002r\n\u0001\u0012I\\1msRL7m](qi&|gn\u001d\u000b\t\u0003W\u0014\u0019A!\u0002\u0003\u000e!9\u00111\u0010\fA\u0002\u0005u\u0004\"CAR-A\u0005\t\u0019\u0001B\u0004!\u0011\tyO!\u0003\n\t\t-\u0011\u0011\u001f\u0002\u0014\u0003:\fG.\u001f;jGN\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0003[3\u0002\u0013!a\u0001\u0003_\u000b\u0001$\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019B\u000b\u0003\u0003\b\u0005-\u0017\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gQ1!\u0011\u0004B\u0015\u0005[\u0001b!!\u001a\u0002l\tm\u0001\u0003\u0002B\u000f\u0005Ki!Aa\b\u000b\t\t\u0005\"1E\u0001\u0007e\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005U\u0012'\u0003\u0003\u0003(\t}!\u0001D*fCJ\u001c\u0007NU3tk2$\bb\u0002B\u00163\u0001\u0007\u0011QP\u0001\nS:$W\r\u001f(b[\u0016DqAa\f\u001a\u0001\u0004\u0011\t$A\u0004sKF,Xm\u001d;\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQAAa\u000e\u0003$\u00051a/Z2u_JLAAa\u000f\u00036\ti1+Z1sG\"\u0014V-];fgR$\u0002B!\u0007\u0003@\t\u0005#1\t\u0005\b\u0005WQ\u0002\u0019AA?\u0011\u001d\u0011yC\u0007a\u0001\u0005cAq!!&\u001b\u0001\u0004\u0011)\u0005\u0005\u0003\u0003H\t%SB\u0001B\u0012\u0013\u0011\u0011YEa\t\u0003\u001bM+\u0017M]2i\u001fB$\u0018n\u001c8t\u0003-\u0019X-\u0019:dQF+XM]=\u0015\u0011\te!\u0011\u000bB*\u0005CBqAa\u000b\u001c\u0001\u0004\ti\bC\u0004\u0002&m\u0001\rA!\u0016\u0011\t\t]#QL\u0007\u0003\u00053RAAa\u0017\u0003$\u00059\u0011/^3sS\u0016\u001c\u0018\u0002\u0002B0\u00053\u00121bU3be\u000eD\u0017+^3ss\"9\u0011QS\u000eA\u0002\t\u0015C\u0003\u0003B\r\u0005K\u00129G!\u001b\t\u000f\t-B\u00041\u0001\u0002~!9\u0011Q\u0005\u000fA\u0002\tU\u0003\"CAW9A\u0005\t\u0019AAX\u0003U\u0019X-\u0019:dQF+XM]=%I\u00164\u0017-\u001e7uIM\n!\u0002Z5tG>tg.Z2u)\u0011\u0011\tH!\u001f\u0011\r\u0005\u0015\u00141\u000eB:!\ra$QO\u0005\u0004\u0005oj$\u0001B+oSRD\u0011\"!,\u001f!\u0003\u0005\r!a,\u0002)\u0011L7oY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003-!\u0017.Y4o_N$\u0018nY:\u0015\t\t\u0005%Q\u0012\t\u0007\u0003K\nYGa!\u0011\t\t\u0015%\u0011R\u0007\u0003\u0005\u000fS1A! T\u0013\u0011\u0011YIa\"\u0003#\u0011K\u0017m\u001a8pgRL7m\u001d*fgVdG\u000fC\u0005\u0003\u0010\u0002\u0002\n\u00111\u0001\u0002~\u0005A!/\u001a9peRLE-A\u000beS\u0006<gn\\:uS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tU%\u0006BA?\u0003\u0017$BA!!\u0003\u001a\"9\u0011Q\u0013\u0012A\u0002\tm\u0005\u0003\u0002BO\u0005Ck!Aa(\u000b\u0007\tu\u0014'\u0003\u0003\u0003$\n}%A\u0005#jC\u001etwn\u001d;jGN|\u0005\u000f^5p]N\fA\u0001]5oOR!!\u0011\u0016BY!\u0019\t)'a\u001b\u0003,B!!Q\u0011BW\u0013\u0011\u0011yKa\"\u0003\u0015AKgn\u001a*fgVdG\u000fC\u0005\u0002.\u000e\u0002\n\u00111\u0001\u00034B)AH!.\u00020&\u0019!qW\u001f\u0003\r=\u0003H/[8o\u00039\u0001\u0018N\\4%I\u00164\u0017-\u001e7uIE*\"A!0+\t\tM\u00161\u001a\u000b\u0005\u0005S\u0013\t\rC\u0004\u0002\u0016\u0016\u0002\rAa1\u0011\t\tu%QY\u0005\u0005\u0005\u000f\u0014yJA\u0006QS:<w\n\u001d;j_:\u001c\u0018AD<bSR,f\u000e^5m%\u0016\fG-\u001f\u000b\u0005\u0005c\u0012i\rC\u0004\u0002.\u001a\u0002\r!a,\u0015\r\tE$\u0011\u001bBj\u0011\u001d\tik\na\u0001\u0003_Cq!!&(\u0001\u0004\u0011)\u000e\u0005\u0003\u0003\u001e\n]\u0017\u0002\u0002Bm\u0005?\u0013QcV1jiVsG/\u001b7SK\u0006$\u0017p\u00149uS>t7/\u0001\u0007Bgft7m\u00117vgR,'\u000f\u0005\u0002BSM\u0011\u0011f\u000f\u000b\u0003\u0005;\fqaY8o]\u0016\u001cG\u000f\u0006\u0005\u0003h\nE(1\u001fB|!\u0015\u0011IO!<d\u001b\t\u0011YO\u0003\u0002^{%!!q\u001eBv\u0005\r!&/\u001f\u0005\u00071.\u0002\r!! \t\u000f\tU8\u00061\u0001\u0002~\u0005AQo]3s]\u0006lW\rC\u0004\u0003z.\u0002\r!! \u0002\u0011A\f7o]<pe\u0012$bAa:\u0003~\n}\bB\u0002--\u0001\u0004\ti\bC\u0004\u0002\u00162\u0002\ra!\u0001\u0011\u0007\u0005\u001b\u0019!C\u0002\u0004\u0006E\u0012ab\u00117vgR,'o\u00149uS>t7\u000f\u0006\u0004\u0003h\u000e%1\u0011\u0004\u0005\b\u0007\u0017i\u0003\u0019AB\u0007\u0003%\u0019X-\u001a3O_\u0012,7\u000f\u0005\u0004\u0002\u0000\r=11C\u0005\u0005\u0007#\t\tJA\u0002TKR\u00042!SB\u000b\u0013\r\u00199B\u0013\u0002\t'\u0016,GMT8eK\"9\u0011QS\u0017A\u0002\r\u0005\u0011!G3yiJ\f7\r^\"mkN$XM]#om&\u0014xN\\7f]R$baa\b\u0004\"\r\r\u0002#\u0002Bu\u0005[D\u0005B\u0002-/\u0001\u0004\ti\bC\u0004\u0004&9\u0002\ra!\u0001\u0002\t=\u0004Ho\u001d\u000b\u0005\u0007?\u0019I\u0003C\u0004\u0004&=\u0002\ra!\u0001")
public class AsyncCluster
implements AsyncClusterBase {
    private ClusterEnvironment environment;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    private ReactiveBucketManager reactiveBucketManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private Function0<ClusterEnvironment> _env;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private ExecutionContext ec;
    private final ClusterEnvironment env;
    private final CoreCouchbaseOps couchbaseOps;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final CoreSearchOps searchOps;
    private final CoreQueryOps queryOps;
    private AsyncTransactions transactions;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    @Override
    public Core core() {
        return AsyncClusterBase.core$(this);
    }

    @Override
    public AsyncBucket bucket(String bucketName) {
        return AsyncClusterBase.bucket$(this, bucketName);
    }

    @Override
    public void performGlobalConnect() {
        AsyncClusterBase.performGlobalConnect$(this);
    }

    private ExecutionContext ec$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.ec = AsyncClusterBase.ec$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.ec;
    }

    @Override
    public ExecutionContext ec() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.ec$lzycompute();
        }
        return this.ec;
    }

    @Override
    public ClusterEnvironment env() {
        return this.env;
    }

    @Override
    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    @Override
    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    @Override
    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    @Override
    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    @Override
    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    @Override
    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncTransactions transactions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.transactions = AsyncClusterBase.transactions$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.transactions;
    }

    @Override
    public AsyncTransactions transactions() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.transactions$lzycompute();
        }
        return this.transactions;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$env_$eq(ClusterEnvironment x$1) {
        this.env = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$couchbaseOps_$eq(CoreCouchbaseOps x$1) {
        this.couchbaseOps = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$searchTimeout_$eq(Duration x$1) {
        this.searchTimeout = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$analyticsTimeout_$eq(Duration x$1) {
        this.analyticsTimeout = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$retryStrategy_$eq(RetryStrategy x$1) {
        this.retryStrategy = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$searchOps_$eq(CoreSearchOps x$1) {
        this.searchOps = x$1;
    }

    @Override
    public void com$couchbase$client$scala$AsyncClusterBase$_setter_$queryOps_$eq(CoreQueryOps x$1) {
        this.queryOps = x$1;
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    private ClusterEnvironment environment$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.environment = (ClusterEnvironment)this._env.apply();
                this.bitmap$0 |= 1;
            }
        }
        this._env = null;
        return this.environment;
    }

    public ClusterEnvironment environment() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.environment$lzycompute();
        }
        return this.environment;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 4;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.couchbaseOps());
                this.bitmap$0 |= 8;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.buckets = new AsyncBucketManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.users = new AsyncUserManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            HandlerBasicParams hp = new HandlerBasicParams(core);
            AnalyticsHandler analyticsHandler = new AnalyticsHandler(hp);
            Try<AnalyticsRequest> try_ = analyticsHandler.request(statement, options, core, this.environment(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                AnalyticsRequest request = (AnalyticsRequest)success.value();
                return analyticsHandler.queryAsync(request, this.ec());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            throw new MatchError(try_);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9(), AnalyticsOptions$.MODULE$.apply$default$10()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> search(String indexName, SearchRequest request) {
        return this.search(indexName, request, new SearchOptions(SearchOptions$.MODULE$.apply$default$1(), SearchOptions$.MODULE$.apply$default$2(), SearchOptions$.MODULE$.apply$default$3(), SearchOptions$.MODULE$.apply$default$4(), SearchOptions$.MODULE$.apply$default$5(), SearchOptions$.MODULE$.apply$default$6(), SearchOptions$.MODULE$.apply$default$7(), SearchOptions$.MODULE$.apply$default$8(), SearchOptions$.MODULE$.apply$default$9(), SearchOptions$.MODULE$.apply$default$10(), SearchOptions$.MODULE$.apply$default$11(), SearchOptions$.MODULE$.apply$default$12(), SearchOptions$.MODULE$.apply$default$13(), SearchOptions$.MODULE$.apply$default$14(), SearchOptions$.MODULE$.apply$default$15(), SearchOptions$.MODULE$.apply$default$16(), SearchOptions$.MODULE$.apply$default$17(), SearchOptions$.MODULE$.apply$default$18()));
    }

    public Future<SearchResult> search(String indexName, SearchRequest request, SearchOptions options) {
        Try<CoreSearchRequest> try_ = request.toCore();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CoreSearchRequest req = (CoreSearchRequest)success.value();
            return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchAsync(indexName, req, options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> new SearchResult((CoreSearchResult)result), this.ec());
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchQueryAsync(indexName, query.toCore(), options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> new SearchResult((CoreSearchResult)result), this.ec());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.environment().timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.couchbaseOps().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncCluster.$anonfun$disconnect$1(this, timeout, x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(core.diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), core.context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            CompletableFuture future = HealthPinger.ping((Core)core, (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), (Optional)OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(options.reportId())), Optional.empty()).toFuture();
            return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.couchbaseOps().waitUntilReady(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public static final /* synthetic */ void $anonfun$disconnect$1(AsyncCluster $this, Duration timeout$2, Void x$1) {
        if ($this.env().owned()) {
            $this.env().shutdown(timeout$2);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> _env, Authenticator authenticator, ConnectionString connectionString) {
        this._env = _env;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        AsyncClusterBase.$init$(this);
    }
}

