/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.user.AsyncUserManager$;
import com.couchbase.client.scala.manager.user.AuthDomain;
import com.couchbase.client.scala.manager.user.AuthDomain$Local$;
import com.couchbase.client.scala.manager.user.Group;
import com.couchbase.client.scala.manager.user.Group$;
import com.couchbase.client.scala.manager.user.RoleAndDescription;
import com.couchbase.client.scala.manager.user.RoleAndDescription$;
import com.couchbase.client.scala.manager.user.User;
import com.couchbase.client.scala.manager.user.UserAndMetadata;
import com.couchbase.client.scala.manager.user.UserAndMetadata$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;

@ScalaSignature(bytes="\u0006\u0001\t]h\u0001\u0002\u001f>\u0001)C\u0001\u0002\u0015\u0001\u0003\u0006\u0004%I!\u0015\u0005\t5\u0002\u0011\t\u0011)A\u0005%\"A1\f\u0001BC\u0002\u0013\rA\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003^\u0011\u0015!\u0007\u0001\"\u0001f\u0011!Y\u0007A1A\u0005\u0002\u0005c\u0007BB;\u0001A\u0003%Q\u000e\u0003\u0005w\u0001\t\u0007I\u0011A!x\u0011\u0019q\b\u0001)A\u0005q\"1q\u0010\u0001C\u0005\u0003\u0003Aq!a\u0004\u0001\t\u0013\t\t\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005]\u0002\u0001\"\u0003\u0002\u0002!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002bBA!\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011%\tY\u0006\u0001b\u0001\n\u0013\ti\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA0\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!a\u001d\u0001\t\u0013\tY\fC\u0004\u0002T\u0002!\t!!6\t\u0013\u0005\u001d\b!%A\u0005\u0002\u0005%\b\"CA\u0000\u0001E\u0005I\u0011\u0001B\u0001\u0011%\u0011)\u0001AI\u0001\n\u0003\u00119\u0001C\u0004\u0003\f\u0001!\tB!\u0004\t\u000f\t}\u0001\u0001\"\u0001\u0003\"!I!Q\b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003A\u0011B!\u0011\u0001#\u0003%\tAa\u0002\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!I!q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\u0017\u0001#\u0003%\tAa\u0002\t\u000f\tu\u0003\u0001\"\u0001\u0003`!I!\u0011\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0005W\u0002\u0011\u0013!C\u0001\u0005\u0003A\u0011B!\u001c\u0001#\u0003%\tAa\u0002\t\u000f\t=\u0004\u0001\"\u0001\u0003r!I!1\u0010\u0001\u0012\u0002\u0013\u0005!\u0011\u0001\u0005\n\u0005{\u0002\u0011\u0013!C\u0001\u0005\u000fAqAa \u0001\t\u0003\u0011\t\tC\u0005\u0003\u0012\u0002\t\n\u0011\"\u0001\u0003\u0002!I!1\u0013\u0001\u0012\u0002\u0013\u0005!q\u0001\u0005\b\u0005+\u0003A\u0011\u0001BL\u0011%\u0011I\u000bAI\u0001\n\u0003\u0011\t\u0001C\u0005\u0003,\u0002\t\n\u0011\"\u0001\u0003\b!9!Q\u0016\u0001\u0005\u0002\t=\u0006\"\u0003B]\u0001E\u0005I\u0011\u0001B\u0001\u0011%\u0011Y\fAI\u0001\n\u0003\u00119\u0001C\u0004\u0003>\u0002!\tAa0\t\u0013\t%\u0007!%A\u0005\u0002\t\u0005\u0001\"\u0003Bf\u0001E\u0005I\u0011\u0001B\u0004\u0011\u001d\u0011i\r\u0001C\u0001\u0005\u001fD\u0011Ba6\u0001#\u0003%\tA!\u0001\t\u0013\te\u0007!%A\u0005\u0002\t\u001dqa\u0002Bn{!\u0005!Q\u001c\u0004\u0007yuB\tAa8\t\r\u0011LD\u0011\u0001Bq\u0011\u001d\u0011\u0019/\u000fC\u0001\u0005K\u0014\u0001#Q:z]\u000e,6/\u001a:NC:\fw-\u001a:\u000b\u0005yz\u0014\u0001B;tKJT!\u0001Q!\u0002\u000f5\fg.Y4fe*\u0011!iQ\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\t\u0016\u000baa\u00197jK:$(B\u0001$H\u0003%\u0019w.^2iE\u0006\u001cXMC\u0001I\u0003\r\u0019w.\\\u0002\u0001'\t\u00011\n\u0005\u0002M\u001d6\tQJC\u0001C\u0013\tyUJ\u0001\u0004B]f\u0014VMZ\u0001\rG>,8\r\u001b2bg\u0016|\u0005o]\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0004CBL'BA,D\u0003\u0011\u0019wN]3\n\u0005e#&\u0001E\"pe\u0016\u001cu.^2iE\u0006\u001cXm\u00149t\u00035\u0019w.^2iE\u0006\u001cXm\u00149tA\u0005\u0011QmY\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001-T\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00012`\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\na\u0001P5oSRtDC\u00014k)\t9\u0017\u000e\u0005\u0002i\u00015\tQ\bC\u0003\\\u000b\u0001\u000fQ\fC\u0003Q\u000b\u0001\u0007!+A\u000beK\u001a\fW\u000f\u001c;NC:\fw-\u001a:US6,w.\u001e;\u0016\u00035\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\tQLW.\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\t!xN\u0001\u0005EkJ\fG/[8o\u0003Y!WMZ1vYRl\u0015M\\1hKJ$\u0016.\\3pkR\u0004\u0013\u0001\u00063fM\u0006,H\u000e\u001e*fiJL8\u000b\u001e:bi\u0016<\u00170F\u0001y!\tIH0D\u0001{\u0015\tYh+A\u0003sKR\u0014\u00180\u0003\u0002~u\ni!+\u001a;ssN#(/\u0019;fOf\fQ\u0003Z3gCVdGOU3uef\u001cFO]1uK\u001eL\b%\u0001\u0007qCRDgi\u001c:Vg\u0016\u00148/\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nE\fA\u0001\\1oO&!\u0011QBA\u0004\u0005\u0019\u0019FO]5oO\u0006a\u0001/\u0019;i\r>\u0014(k\u001c7fg\u0006Y\u0001/\u0019;i\r>\u0014Xk]3s)\u0019\t\u0019!!\u0006\u0002 !9\u0011q\u0003\u0007A\u0002\u0005e\u0011A\u00023p[\u0006Lg\u000eE\u0002i\u00037I1!!\b>\u0005)\tU\u000f\u001e5E_6\f\u0017N\u001c\u0005\b\u0003Ca\u0001\u0019AA\u0012\u0003!)8/\u001a:oC6,\u0007\u0003BA\u0013\u0003gqA!a\n\u00020A\u0019\u0011\u0011F'\u000e\u0005\u0005-\"bAA\u0017\u0013\u00061AH]8pizJ1!!\rN\u0003\u0019\u0001&/\u001a3fM&!\u0011QBA\u001b\u0015\r\t\t$T\u0001\u000ea\u0006$\bNR8s\u000fJ|W\u000f]:\u0002\u0019A\fG\u000f\u001b$pe\u001e\u0013x.\u001e9\u0015\t\u0005\r\u0011Q\b\u0005\b\u0003\u007fq\u0001\u0019AA\u0012\u0003\u0011q\u0017-\\3\u0002\u001fA\fG\u000f\u001b$peB\u000b7o]<pe\u0012\fqaY8sKR\u0013\u00180\u0006\u0002\u0002HA1\u0011\u0011JA(\u0003'j!!a\u0013\u000b\u0007\u00055S*\u0001\u0003vi&d\u0017\u0002BA)\u0003\u0017\u00121\u0001\u0016:z!\u0011\t)&a\u0016\u000e\u0003YK1!!\u0017W\u0005\u0011\u0019uN]3\u0002\u0015!$H\u000f]\"mS\u0016tG/\u0006\u0002\u0002`A1\u0011\u0011JA(\u0003C\u0002B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'\u0001\u0003iiR\u0004(bAA6-\u0006AQM\u001c3q_&tG/\u0003\u0003\u0002p\u0005\u0015$AD\"pe\u0016DE\u000f\u001e9DY&,g\u000e^\u0001\fQR$\bo\u00117jK:$\b%A\u0006tK:$'+Z9vKN$HCCA<\u0003\u0007\u000b)+!+\u00028B)a,!\u001f\u0002~%\u0019\u00111P0\u0003\r\u0019+H/\u001e:f!\u0011\t\u0019'a \n\t\u0005\u0005\u0015Q\r\u0002\u0011\u0007>\u0014X\r\u0013;uaJ+7\u000f]8og\u0016Dq!!\"\u0014\u0001\u0004\t9)\u0001\u0004nKRDw\u000e\u001a\t\u0005\u0003\u0013\u000b\t+\u0004\u0002\u0002\f*!\u0011qMAG\u0015\u0011\ty)!%\u0002\u000b\r|G-Z2\u000b\t\u0005M\u0015QS\u0001\bQ\u0006tG\r\\3s\u0015\u0011\t9*!'\u0002\u000b9,G\u000f^=\u000b\t\u0005m\u0015QT\u0001\u0003S>T1!a(W\u0003\u0011!W\r]:\n\t\u0005\r\u00161\u0012\u0002\u000b\u0011R$\b/T3uQ>$\u0007bBAT'\u0001\u0007\u00111E\u0001\u0005a\u0006$\b\u000eC\u0004\u0002,N\u0001\r!!,\u0002\u000fQLW.Z8viB!\u0011qVA[\u001b\t\t\tLC\u0002\u00024~\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0004i\u0006E\u0006BBA]'\u0001\u0007\u00010A\u0007sKR\u0014\u0018p\u0015;sCR,w-\u001f\u000b\r\u0003o\ni,a0\u0002B\u0006=\u0017\u0011\u001b\u0005\b\u0003\u000b#\u0002\u0019AAD\u0011\u001d\t9\u000b\u0006a\u0001\u0003GAq!a1\u0015\u0001\u0004\t)-\u0001\u0003c_\u0012L\b\u0003BAd\u0003\u0017l!!!3\u000b\u0007\u00055c+\u0003\u0003\u0002N\u0006%'!F+sYF+XM]=TiJLgn\u001a\"vS2$WM\u001d\u0005\b\u0003W#\u0002\u0019AAW\u0011\u0019\tI\f\u0006a\u0001q\u00069q-\u001a;Vg\u0016\u0014HCCAl\u0003?\f\t/a9\u0002fB)a,!\u001f\u0002ZB\u0019\u0001.a7\n\u0007\u0005uWHA\bVg\u0016\u0014\u0018I\u001c3NKR\fG-\u0019;b\u0011\u001d\t\t#\u0006a\u0001\u0003GA\u0011\"a\u0006\u0016!\u0003\u0005\r!!\u0007\t\u0013\u0005-V\u0003%AA\u0002\u00055\u0006\u0002CA]+A\u0005\t\u0019\u0001=\u0002#\u001d,G/V:fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002l*\"\u0011\u0011DAwW\t\ty\u000f\u0005\u0003\u0002r\u0006mXBAAz\u0015\u0011\t)0a>\u0002\u0013Ut7\r[3dW\u0016$'bAA}\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00181\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E4fiV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u0001\u0016\u0005\u0003[\u000bi/A\thKR,6/\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!\u0003+\u0007a\fi/A\u0006dQ\u0016\u001c7n\u0015;biV\u001cHC\u0002B\b\u0005/\u0011Y\u0002\u0005\u0004\u0002J\u0005=#\u0011\u0003\t\u0004\u0019\nM\u0011b\u0001B\u000b\u001b\n!QK\\5u\u0011\u001d\u0011I\"\u0007a\u0001\u0003{\n\u0001B]3ta>t7/\u001a\u0005\b\u0005;I\u0002\u0019AA\u0012\u0003\u0019\t7\r^5p]\u0006Yq-\u001a;BY2,6/\u001a:t)!\u0011\u0019Ca\u000e\u0003:\tm\u0002#\u00020\u0002z\t\u0015\u0002C\u0002B\u0014\u0005c\tIN\u0004\u0003\u0003*\t5b\u0002BA\u0015\u0005WI\u0011AQ\u0005\u0004\u0005_i\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005g\u0011)DA\u0002TKFT1Aa\fN\u0011%\t9B\u0007I\u0001\u0002\u0004\tI\u0002C\u0005\u0002,j\u0001\n\u00111\u0001\u0002.\"A\u0011\u0011\u0018\u000e\u0011\u0002\u0003\u0007\u00010A\u000bhKR\fE\u000e\\+tKJ\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002+\u001d,G/\u00117m+N,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005)r-\u001a;BY2,6/\u001a:tI\u0011,g-Y;mi\u0012\u001a\u0014AC;qg\u0016\u0014H/V:feRQ!q\tB%\u0005#\u0012\u0019F!\u0016\u0011\u000by\u000bIH!\u0005\t\ryr\u0002\u0019\u0001B&!\rA'QJ\u0005\u0004\u0005\u001fj$\u0001B+tKJD\u0011\"a\u0006\u001f!\u0003\u0005\r!!\u0007\t\u0013\u0005-f\u0004%AA\u0002\u00055\u0006\u0002CA]=A\u0005\t\u0019\u0001=\u0002)U\u00048/\u001a:u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003Q)\bo]3siV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005!R\u000f]:feR,6/\u001a:%I\u00164\u0017-\u001e7uIQ\n\u0001\u0002\u001a:paV\u001bXM\u001d\u000b\u000b\u0005\u000f\u0012\tGa\u0019\u0003f\t\u001d\u0004bBA\u0011E\u0001\u0007\u00111\u0005\u0005\n\u0003/\u0011\u0003\u0013!a\u0001\u00033A\u0011\"a+#!\u0003\u0005\r!!,\t\u0011\u0005e&\u0005%AA\u0002a\f!\u0003\u001a:paV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0011BM]8q+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003I!'o\u001c9Vg\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\rD\u0017M\\4f!\u0006\u001c8o^8sIRA!q\tB:\u0005o\u0012I\bC\u0004\u0003v\u0019\u0002\r!a\t\u0002\u00179,w\u000fU1tg^|'\u000f\u001a\u0005\n\u0003W3\u0003\u0013!a\u0001\u0003[C\u0001\"!/'!\u0003\u0005\r\u0001_\u0001\u0019G\"\fgnZ3QCN\u001cxo\u001c:eI\u0011,g-Y;mi\u0012\u0012\u0014\u0001G2iC:<W\rU1tg^|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005q\u0011M^1jY\u0006\u0014G.\u001a*pY\u0016\u001cHC\u0002BB\u0005\u001b\u0013y\tE\u0003_\u0003s\u0012)\t\u0005\u0004\u0003(\tE\"q\u0011\t\u0004Q\n%\u0015b\u0001BF{\t\u0011\"k\u001c7f\u0003:$G)Z:de&\u0004H/[8o\u0011%\tY+\u000bI\u0001\u0002\u0004\ti\u000b\u0003\u0005\u0002:&\u0002\n\u00111\u0001y\u0003a\tg/Y5mC\ndWMU8mKN$C-\u001a4bk2$H%M\u0001\u0019CZ\f\u0017\u000e\\1cY\u0016\u0014v\u000e\\3tI\u0011,g-Y;mi\u0012\u0012\u0014\u0001C4fi\u001e\u0013x.\u001e9\u0015\u0011\te%\u0011\u0015BS\u0005O\u0003RAXA=\u00057\u00032\u0001\u001bBO\u0013\r\u0011y*\u0010\u0002\u0006\u000fJ|W\u000f\u001d\u0005\b\u0005Gc\u0003\u0019AA\u0012\u0003%9'o\\;q\u001d\u0006lW\rC\u0005\u0002,2\u0002\n\u00111\u0001\u0002.\"A\u0011\u0011\u0018\u0017\u0011\u0002\u0003\u0007\u00010\u0001\nhKR<%o\\;qI\u0011,g-Y;mi\u0012\u0012\u0014AE4fi\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIM\nAbZ3u\u00032dwI]8vaN$bA!-\u00036\n]\u0006#\u00020\u0002z\tM\u0006C\u0002B\u0014\u0005c\u0011Y\nC\u0005\u0002,>\u0002\n\u00111\u0001\u0002.\"A\u0011\u0011X\u0018\u0011\u0002\u0003\u0007\u00010\u0001\fhKR\fE\u000e\\$s_V\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003Y9W\r^!mY\u001e\u0013x.\u001e9tI\u0011,g-Y;mi\u0012\u0012\u0014aC;qg\u0016\u0014Ho\u0012:pkB$\u0002Ba\u0012\u0003B\n\u0015'q\u0019\u0005\b\u0005\u0007\u0014\u0004\u0019\u0001BN\u0003\u00159'o\\;q\u0011%\tYK\rI\u0001\u0002\u0004\ti\u000b\u0003\u0005\u0002:J\u0002\n\u00111\u0001y\u0003U)\bo]3si\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uII\nQ#\u001e9tKJ$xI]8va\u0012\"WMZ1vYR$3'A\u0005ee>\u0004xI]8vaRA!q\tBi\u0005'\u0014)\u000eC\u0004\u0003$V\u0002\r!a\t\t\u0013\u0005-V\u0007%AA\u0002\u00055\u0006\u0002CA]kA\u0005\t\u0019\u0001=\u0002'\u0011\u0014x\u000e]$s_V\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002'\u0011\u0014x\u000e]$s_V\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0002!\u0005\u001b\u0018P\\2Vg\u0016\u0014X*\u00198bO\u0016\u0014\bC\u00015:'\tI4\n\u0006\u0002\u0003^\u0006a1m\u001c8wKJ$(k\u001c7fgR!!q\u001dBz!\u0015a%\u0011\u001eBw\u0013\r\u0011Y/\u0014\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0019\n=\u0018b\u0001By\u001b\n!!)\u001f;f\u0011\u001d\u0011)p\u000fa\u0001\u0005O\f!!\u001b8")
public class AsyncUserManager {
    private final CoreCouchbaseOps couchbaseOps;
    private final ExecutionContext ec;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;
    private final Try<CoreHttpClient> httpClient;

    public static byte[] convertRoles(byte[] byArray) {
        return AsyncUserManager$.MODULE$.convertRoles(byArray);
    }

    private CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForUsers() {
        return "/settings/rbac/users";
    }

    private String pathForRoles() {
        return "/settings/rbac/roles";
    }

    private String pathForUser(AuthDomain domain, String username) {
        return new StringBuilder(2).append(this.pathForUsers()).append("/").append(UrlQueryStringBuilder.urlEncode((String)domain.alias())).append("/").append(UrlQueryStringBuilder.urlEncode((String)username)).toString();
    }

    private String pathForGroups() {
        return "/settings/rbac/groups";
    }

    private String pathForGroup(String name) {
        return new StringBuilder(1).append(this.pathForGroups()).append("/").append(UrlQueryStringBuilder.urlEncode((String)name)).toString();
    }

    private String pathForPassword() {
        return "/controller/changePassword";
    }

    private Try<Core> coreTry() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return new Success((Object)core);
        }
        return new Failure((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    private Try<CoreHttpClient> httpClient() {
        return this.httpClient;
    }

    private Future<CoreHttpResponse> sendRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        Try attempt = this.coreTry().flatMap((Function1 & Serializable & scala.Serializable)core -> this.httpClient().flatMap((Function1 & Serializable & scala.Serializable)client -> {
            Object object;
            HttpMethod httpMethod = method;
            HttpMethod httpMethod2 = HttpMethod.GET;
            HttpMethod httpMethod3 = httpMethod;
            if (!(httpMethod2 != null ? !httpMethod2.equals(httpMethod3) : httpMethod3 != null)) {
                object = new Success((Object)client.get(CoreHttpPath.path((String)path), CoreCommonConverters$.MODULE$.makeCommonOptions(timeout, retryStrategy, CoreCommonConverters$.MODULE$.makeCommonOptions$default$3())));
            } else {
                HttpMethod httpMethod4 = HttpMethod.DELETE;
                HttpMethod httpMethod5 = httpMethod;
                object = !(httpMethod4 != null ? !httpMethod4.equals(httpMethod5) : httpMethod5 != null) ? new Success((Object)client.delete(CoreHttpPath.path((String)path), CoreCommonConverters$.MODULE$.makeCommonOptions(timeout, retryStrategy, CoreCommonConverters$.MODULE$.makeCommonOptions$default$3()))) : new Failure((Throwable)new CouchbaseException(new StringBuilder(44).append("Internal bug, please report: unknown method ").append(method).toString()));
            }
            return object.map((Function1 & Serializable & scala.Serializable)builder -> FutureConversions$.MODULE$.javaCFToScalaFuture(builder.exec(core)));
        }));
        return (Future)attempt.fold((Function1 & Serializable & scala.Serializable)exception -> Future$.MODULE$.failed(exception), (Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x));
    }

    private Future<CoreHttpResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retryStrategy) {
        Try attempt = this.coreTry().flatMap((Function1 & Serializable & scala.Serializable)core -> this.httpClient().flatMap((Function1 & Serializable & scala.Serializable)client -> {
            Object object;
            HttpMethod httpMethod = method;
            HttpMethod httpMethod2 = HttpMethod.PUT;
            HttpMethod httpMethod3 = httpMethod;
            if (!(httpMethod2 != null ? !httpMethod2.equals(httpMethod3) : httpMethod3 != null)) {
                object = new Success((Object)client.put(CoreHttpPath.path((String)path), CoreCommonConverters$.MODULE$.makeCommonOptions(timeout, retryStrategy, CoreCommonConverters$.MODULE$.makeCommonOptions$default$3())));
            } else {
                HttpMethod httpMethod4 = HttpMethod.POST;
                HttpMethod httpMethod5 = httpMethod;
                object = !(httpMethod4 != null ? !httpMethod4.equals(httpMethod5) : httpMethod5 != null) ? new Success((Object)client.post(CoreHttpPath.path((String)path), CoreCommonConverters$.MODULE$.makeCommonOptions(timeout, retryStrategy, CoreCommonConverters$.MODULE$.makeCommonOptions$default$3()))) : new Failure((Throwable)new CouchbaseException(new StringBuilder(44).append("Internal bug, please report: unknown method ").append(method).toString()));
            }
            return object.map((Function1 & Serializable & scala.Serializable)builder -> FutureConversions$.MODULE$.javaCFToScalaFuture(builder.exec(core)));
        }));
        return (Future)attempt.fold((Function1 & Serializable & scala.Serializable)exception -> Future$.MODULE$.failed(exception), (Function1 & Serializable & scala.Serializable)x -> (Future)Predef$.MODULE$.identity(x));
    }

    public Future<UserAndMetadata> getUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return Future$.MODULE$.failed((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(12).append("get ").append(domain).append(" user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            UserAndMetadata value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), UserAndMetadata$.MODULE$.rw());
            return Future$.MODULE$.successful((Object)value);
        }, this.ec());
    }

    public AuthDomain getUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public Try<BoxedUnit> checkStatus(CoreHttpResponse response, String action) {
        ResponseStatus responseStatus = response.status();
        ResponseStatus responseStatus2 = ResponseStatus.SUCCESS;
        if (responseStatus == null ? responseStatus2 != null : !responseStatus.equals(responseStatus2)) {
            return new Failure((Throwable)new CouchbaseException(new StringBuilder(44).append("Failed to ").append(action).append("; response status=").append(response.status()).append("; response ").append("body=").append(new String(response.content(), StandardCharsets.UTF_8)).toString()));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public Future<Seq<UserAndMetadata>> getAllUsers(AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUsers(), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, "get all users");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            Seq value = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(UserAndMetadata$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return Future$.MODULE$.successful((Object)value);
        }, this.ec());
    }

    public AuthDomain getAllUsers$default$1() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getAllUsers$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllUsers$default$3() {
        return this.defaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertUser(User user, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("name", user.displayName()).add("roles", ((TraversableOnce)user.roles().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.format(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        Object object = user.groups().nonEmpty() ? params.add("groups", user.groups().mkString(",")) : BoxedUnit.UNIT;
        user.password().foreach((Function1 & Serializable & scala.Serializable)pwd -> params.add("password", pwd));
        return this.sendRequest(HttpMethod.PUT, this.pathForUser(domain, user.username()), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(14).append("create user [").append(RedactableArgument.redactUser((Object)user.username())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }, this.ec());
    }

    public AuthDomain upsertUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration upsertUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public Future<BoxedUnit> dropUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return Future$.MODULE$.failed((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(12).append("drop user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }, this.ec());
    }

    public AuthDomain dropUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration dropUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public Future<BoxedUnit> changePassword(String newPassword, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("password", newPassword);
        return this.sendRequest(HttpMethod.POST, this.pathForPassword(), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, "change user password");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }, this.ec());
    }

    public Duration changePassword$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy changePassword$default$3() {
        return this.defaultRetryStrategy();
    }

    public Future<Seq<RoleAndDescription>> availableRoles(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForRoles(), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, "get all roles");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            byte[] converted = AsyncUserManager$.MODULE$.convertRoles(response.content());
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(converted), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(RoleAndDescription$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return Future$.MODULE$.successful((Object)values);
        }, this.ec());
    }

    public Duration availableRoles$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy availableRoles$default$2() {
        return this.defaultRetryStrategy();
    }

    public Future<Group> getGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return Future$.MODULE$.failed((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(12).append("get group [").append(RedactableArgument.redactMeta((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            Group value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), Group$.MODULE$.rw());
            return Future$.MODULE$.successful((Object)value);
        }, this.ec());
    }

    public Duration getGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public Future<Seq<Group>> getAllGroups(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroups(), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, "get all groups");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(Group$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return Future$.MODULE$.successful((Object)values);
        }, this.ec());
    }

    public Duration getAllGroups$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllGroups$default$2() {
        return this.defaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertGroup(Group group, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("description", group.description()).add("roles", ((TraversableOnce)group.roles().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.format(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        group.ldapGroupReference().foreach((Function1 & Serializable & scala.Serializable)lgr -> params.add("ldap_group_ref", lgr));
        return this.sendRequest(HttpMethod.PUT, this.pathForGroup(group.name()), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(15).append("create group [").append(RedactableArgument.redactSystem((Object)group.name())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }, this.ec());
    }

    public Duration upsertGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public Future<BoxedUnit> dropGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return Future$.MODULE$.failed((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((CoreHttpResponse)response, new StringBuilder(13).append("drop group [").append(RedactableArgument.redactUser((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }, this.ec());
    }

    public Duration dropGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public AsyncUserManager(CoreCouchbaseOps couchbaseOps, ExecutionContext ec) {
        this.couchbaseOps = couchbaseOps;
        this.ec = ec;
        this.defaultManagerTimeout = couchbaseOps.environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = couchbaseOps.environment().retryStrategy();
        this.httpClient = this.coreTry().map((Function1 & Serializable & scala.Serializable)core -> new CoreHttpClient(core, RequestTarget.manager()));
    }
}

