/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchResult$;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.search.vector.SearchRequest;
import com.couchbase.client.scala.transactions.AsyncTransactions;
import com.couchbase.client.scala.transactions.config.TransactionsConfig;
import com.couchbase.client.scala.transactions.config.TransactionsConfig$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r5g\u0001B\"E\u00015C\u0001b\u0015\u0001\u0003\u0002\u0013\u0006I\u0001\u0016\u0005\n;\u0002\u0011)\u0019!C\u0001\tzC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\nO\u0002\u0011)\u0019!C\u0001\t\"D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\to\u0002\u0011\r\u0011b\u0001Eq\"1q\u0010\u0001Q\u0001\neD\u0001B\u0017\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003X\u0011)\t)\u0001\u0001b\u0001\n\u0003!\u0015q\u0001\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\n!91\r\u0001C\u0001\u0011\u0006]\u0001BCA\u0011\u0001\t\u0007I\u0011\u0001#\u0002$!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0003\u0003\u0006\u00024\u0001\u0011\r\u0011\"\u0001E\u0003GA\u0001\"!\u000e\u0001A\u0003%\u0011Q\u0005\u0005\u000b\u0003o\u0001!\u0019!C\u0001\t\u0006e\u0002\u0002CA$\u0001\u0001\u0006I!a\u000f\t\u0015\u0005%\u0003A1A\u0005\u0002\u0011\u000bY\u0005\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA'\u0011-\tY\u0006\u0001EC\u0002\u0013\u0005A)!\u0018\t\u0017\u0005=\u0004\u0001#b\u0001\n\u0003!\u0015\u0011\u000f\u0005\u000b\u0003\u007f\u0002!\u0019!C\u0001\t\u0006\u0005\u0005\u0002CAH\u0001\u0001\u0006I!a!\t\u0015\u0005E\u0005\u0001#b\u0001\n\u0003\t\u0019\n\u0003\u0006\u0002\u001c\u0002A)\u0019!C\u0001\u0003;C!\"a+\u0001\u0011\u000b\u0007I\u0011AAW\u0011)\tI\f\u0001EC\u0002\u0013\u0005\u00111\u0018\u0005\u000b\u0003\u000f\u0004\u0001R1A\u0005\u0002\u0005%\u0007BCAi\u0001!\u0015\r\u0011\"\u0001\u0002T\"Q\u0011q\u001f\u0001\t\u0006\u0004%\t!!?\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0003\u0006!9\u0011\u0011\u0012\u0001\u0005\u0002\t\u001d\u0002bBAE\u0001\u0011\u0005!q\t\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005KB\u0011B!\u001f\u0001#\u0003%\tAa\u001f\t\u0013\t}\u0004!%A\u0005\u0002\t\u0005\u0005b\u0002BC\u0001\u0011\u0005!q\u0011\u0005\b\u0005\u000b\u0003A\u0011\u0001BP\u0011%\u0011i\u000bAI\u0001\n\u0003\u0011y\u000bC\u0005\u00034\u0002\t\n\u0011\"\u0001\u0003|!9\u00111\u000b\u0001\u0005\u0002\tU\u0006bBA*\u0001\u0011\u0005!1\u001c\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0007\u0003A\u0011b!\u0003\u0001#\u0003%\tAa\u001f\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e!I1\u0011\u0004\u0001\u0012\u0002\u0013\u0005!1\u0010\u0005\b\u00077\u0001A\u0011AB\u000f\u0011%\u0019y\u0003AI\u0001\n\u0003\u0019\t\u0004C\u0004\u0004\u001c\u0001!\ta!\u000e\t\u000f\r\r\u0003\u0001\"\u0001\u0004F!I1q\u000b\u0001\u0012\u0002\u0013\u00051\u0011\f\u0005\b\u0007\u0007\u0002A\u0011AB/\u0011\u001d\u00199\u0007\u0001C\u0001\u0007SBqaa\u001a\u0001\t\u0003\u0019i\u0007\u0003\u0005\u0004z\u0001!\t\u0001RB>\u000f\u001d\u0019i\b\u0012E\u0001\u0007\u007f2aa\u0011#\t\u0002\r\u0005\u0005B\u00029=\t\u0003\u0019\u0019\tC\u0004\u0004\u0006r\"\taa\"\t\u000f\r\u0015E\b\"\u0001\u0004\u001e\"91Q\u0011\u001f\u0005\u0002\r%\u0006\u0002CB_y\u0011\u0005aia0\t\u0011\ruF\b\"\u0001G\u0007\u0013\u0014A\"Q:z]\u000e\u001cE.^:uKJT!!\u0012$\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dC\u0015AB2mS\u0016tGO\u0003\u0002J\u0015\u0006I1m\\;dQ\n\f7/\u001a\u0006\u0002\u0017\u0006\u00191m\\7\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fFk\u0011\u0001\u0015\u0006\u0002\u000b&\u0011!\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0004\u001fV;\u0016B\u0001,Q\u0005!a$-\u001f8b[\u0016t\u0004C\u0001-\\\u001b\u0005I&B\u0001.E\u0003\r)gN^\u0005\u00039f\u0013!c\u00117vgR,'/\u00128wSJ|g.\\3oi\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012a\u0018\t\u0003A\u0012l\u0011!\u0019\u0006\u00035\nT!a\u0019$\u0002\t\r|'/Z\u0005\u0003K\u0006\u0014Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001e,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\n\fA!\u001e;jY&\u0011an\u001b\u0002\u0011\u0007>tg.Z2uS>t7\u000b\u001e:j]\u001e\f\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4!\u0003\u0019a\u0014N\\5u}Q!!\u000f^;w!\t\u0019\b!D\u0001E\u0011\u0019\u0019f\u0001\"a\u0001)\")QL\u0002a\u0001?\")qM\u0002a\u0001S\u0006\u0011QmY\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011A\u0010U\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001@|\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002*\u0012aV\u0001\u0005K:4\b%\u0001\u0007d_V\u001c\u0007NY1tK>\u00038/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\t\f1!\u00199j\u0013\u0011\t\u0019\"!\u0004\u0003!\r{'/Z\"pk\u000eD'-Y:f\u001fB\u001c\u0018!D2pk\u000eD'-Y:f\u001fB\u001c\b%\u0006\u0002\u0002\u001aA!\u00111DA\u000f\u001b\u0005\u0011\u0017bAA\u0010E\n!1i\u001c:f\u00035\u0019X-\u0019:dQRKW.Z8viV\u0011\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F>\u0002\u0011\u0011,(/\u0019;j_:LA!a\f\u0002*\tAA)\u001e:bi&|g.\u0001\btK\u0006\u00148\r\u001b+j[\u0016|W\u000f\u001e\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001cH+[7f_V$\u0018!E1oC2LH/[2t)&lWm\\;uA\u0005i!/\u001a;ssN#(/\u0019;fOf,\"!a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011c\u0003\u0015\u0011X\r\u001e:z\u0013\u0011\t)%a\u0010\u0003\u001bI+GO]=TiJ\fG/Z4z\u00039\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0002\n\u0011b]3be\u000eDw\n]:\u0016\u0005\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\t\u0005M\u0013QB\u0001\u0007g\u0016\f'o\u00195\n\t\u0005]\u0013\u0011\u000b\u0002\u000e\u0007>\u0014XmU3be\u000eDw\n]:\u0002\u0015M,\u0017M]2i\u001fB\u001c\b%A\u000bsK\u0006\u001cG/\u001b<f\u0005V\u001c7.\u001a;NC:\fw-\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0007EV\u001c7.\u001a;\u000b\u0007\u0005%D)A\u0004nC:\fw-\u001a:\n\t\u00055\u00141\r\u0002\u0016%\u0016\f7\r^5wK\n+8m[3u\u001b\u0006t\u0017mZ3s\u0003u\u0011X-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014XCAA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA=\u0003O\n\u0011\"\u00198bYf$\u0018nY:\n\t\u0005u\u0014q\u000f\u0002\u001e%\u0016\f7\r^5wK\u0006s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\u0006A\u0011/^3ss>\u00038/\u0006\u0002\u0002\u0004B!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u00065\u0011!B9vKJL\u0018\u0002BAG\u0003\u000f\u0013AbQ8sKF+XM]=PaN\f\u0011\"];fef|\u0005o\u001d\u0011\u0002\u000f\t,8m[3ugV\u0011\u0011Q\u0013\t\u0005\u0003C\n9*\u0003\u0003\u0002\u001a\u0006\r$AE!ts:\u001c')^2lKRl\u0015M\\1hKJ\fQ!^:feN,\"!a(\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002h\u0005!Qo]3s\u0013\u0011\tI+a)\u0003!\u0005\u001b\u0018P\\2Vg\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001D9vKJL\u0018J\u001c3fq\u0016\u001cXCAAX!\u0011\t\t,!.\u000e\u0005\u0005M&\u0002BAE\u0003OJA!a.\u00024\n1\u0012i]=oGF+XM]=J]\u0012,\u00070T1oC\u001e,'/A\u0007tK\u0006\u00148\r[%oI\u0016DXm]\u000b\u0003\u0003{\u0003B!a0\u0002D6\u0011\u0011\u0011\u0019\u0006\u0005\u0003'\n9'\u0003\u0003\u0002F\u0006\u0005'aF!ts:\u001c7+Z1sG\"Le\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003A\tg.\u00197zi&\u001c7/\u00138eKb,7/\u0006\u0002\u0002LB!\u0011QOAg\u0013\u0011\ty-a\u001e\u00035\u0005\u001b\u0018P\\2B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0002#\u00154XM\u001c;j]\u001e4UO\\2uS>t7/\u0006\u0002\u0002VB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006\u001d\u0014\u0001C3wK:$\u0018N\\4\n\t\u0005}\u0017\u0011\u001c\u0002\u001d\u0003NLhnY#wK:$\u0018N\\4Gk:\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\ry\u00121\u001d\t\u0005\u0003K\f\tP\u0004\u0003\u0002h\u00065XBAAu\u0015\r\tYOY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAx\u0003S\f\u0011b\u0015;bE&d\u0017\u000e^=\n\t\u0005M\u0018Q\u001f\u0002\f+:\u001cw.\\7jiR,GM\u0003\u0003\u0002p\u0006%\u0018\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001cXCAA~!\u0011\tiP!\u0001\u000e\u0005\u0005}(bAA|\t&!!1AA\u0000\u0005E\t5/\u001f8d)J\fgn]1di&|gn\u001d\u000b\u0005\u0005\u000f\u0011i\u0001E\u0002t\u0005\u0013I1Aa\u0003E\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\t\u000f\t=\u0011\u00051\u0001\u0003\u0012\u0005Q!-^2lKRt\u0015-\\3\u0011\t\tM!\u0011\u0005\b\u0005\u0005+\u0011i\u0002E\u0002\u0003\u0018Ak!A!\u0007\u000b\u0007\tmA*\u0001\u0004=e>|GOP\u0005\u0004\u0005?\u0001\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003$\t\u0015\"AB*ue&twMC\u0002\u0003 A#bA!\u000b\u0003:\tu\u0002#\u0002>\u0003,\t=\u0012b\u0001B\u0017w\n1a)\u001e;ve\u0016\u0004BA!\r\u000365\u0011!1\u0007\u0006\u0004\u0003\u0013#\u0015\u0002\u0002B\u001c\u0005g\u00111\"U;fef\u0014Vm];mi\"9!1\b\u0012A\u0002\tE\u0011!C:uCR,W.\u001a8u\u0011\u001d\u0011yD\ta\u0001\u0005\u0003\nqa\u001c9uS>t7\u000f\u0005\u0003\u00032\t\r\u0013\u0002\u0002B#\u0005g\u0011A\"U;fef|\u0005\u000f^5p]N$\"B!\u000b\u0003J\t-#Q\u000bB-\u0011\u001d\u0011Yd\ta\u0001\u0005#A\u0011B!\u0014$!\u0003\u0005\rAa\u0014\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u00032\tE\u0013\u0002\u0002B*\u0005g\u0011q\"U;fef\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0005/\u001a\u0003\u0013!a\u0001\u0003K\tq\u0001^5nK>,H\u000fC\u0005\u0003\\\r\u0002\n\u00111\u0001\u0003^\u0005)\u0011\r\u001a5pGB\u0019qJa\u0018\n\u0007\t\u0005\u0004KA\u0004C_>dW-\u00198\u0002\u001fE,XM]=%I\u00164\u0017-\u001e7uII*\"Aa\u001a+\t\t=#\u0011N\u0016\u0003\u0005W\u0002BA!\u001c\u0003v5\u0011!q\u000e\u0006\u0005\u0005c\u0012\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u00111\u001e)\n\t\t]$q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD9vKJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu$\u0006BA\u0013\u0005S\nq\"];fef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005\u0007SCA!\u0018\u0003j\u0005q\u0011M\\1msRL7m])vKJLHC\u0002BE\u0005+\u00139\nE\u0003{\u0005W\u0011Y\t\u0005\u0003\u0003\u000e\nEUB\u0001BH\u0015\r\tI\bR\u0005\u0005\u0005'\u0013yIA\bB]\u0006d\u0017\u0010^5dgJ+7/\u001e7u\u0011\u001d\u0011Yd\na\u0001\u0005#AqAa\u0010(\u0001\u0004\u0011I\n\u0005\u0003\u0003\u000e\nm\u0015\u0002\u0002BO\u0005\u001f\u0013\u0001#\u00118bYf$\u0018nY:PaRLwN\\:\u0015\u0011\t%%\u0011\u0015BR\u0005WCqAa\u000f)\u0001\u0004\u0011\t\u0002C\u0005\u0003N!\u0002\n\u00111\u0001\u0003&B!!Q\u0012BT\u0013\u0011\u0011IKa$\u0003'\u0005s\u0017\r\\=uS\u000e\u001c\b+\u0019:b[\u0016$XM]:\t\u0013\t]\u0003\u0006%AA\u0002\u0005\u0015\u0012\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0017\u0016\u0005\u0005K\u0013I'\u0001\rb]\u0006d\u0017\u0010^5dgF+XM]=%I\u00164\u0017-\u001e7uIM\"bAa.\u0003H\n-\u0007#\u0002>\u0003,\te\u0006\u0003\u0002B^\u0005\u0007l!A!0\u000b\t\t}&\u0011Y\u0001\u0007e\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005MC)\u0003\u0003\u0003F\nu&\u0001D*fCJ\u001c\u0007NU3tk2$\bb\u0002BeW\u0001\u0007!\u0011C\u0001\nS:$W\r\u001f(b[\u0016DqA!4,\u0001\u0004\u0011y-A\u0004sKF,Xm\u001d;\u0011\t\tE'q[\u0007\u0003\u0005'TAA!6\u0003B\u00061a/Z2u_JLAA!7\u0003T\ni1+Z1sG\"\u0014V-];fgR$\u0002Ba.\u0003^\n}'\u0011\u001d\u0005\b\u0005\u0013d\u0003\u0019\u0001B\t\u0011\u001d\u0011i\r\fa\u0001\u0005\u001fDqAa\u0010-\u0001\u0004\u0011\u0019\u000f\u0005\u0003\u0003f\n\u001dXB\u0001Ba\u0013\u0011\u0011IO!1\u0003\u001bM+\u0017M]2i\u001fB$\u0018n\u001c8t\u0003-\u0019X-\u0019:dQF+XM]=\u0015\u0011\t]&q\u001eBy\u0005\u007fDqA!3.\u0001\u0004\u0011\t\u0002C\u0004\u0002\n6\u0002\rAa=\u0011\t\tU(1`\u0007\u0003\u0005oTAA!?\u0003B\u00069\u0011/^3sS\u0016\u001c\u0018\u0002\u0002B\u007f\u0005o\u00141bU3be\u000eD\u0017+^3ss\"9!qH\u0017A\u0002\t\rH\u0003\u0003B\\\u0007\u0007\u0019)aa\u0002\t\u000f\t%g\u00061\u0001\u0003\u0012!9\u0011\u0011\u0012\u0018A\u0002\tM\b\"\u0003B,]A\u0005\t\u0019AA\u0013\u0003U\u0019X-\u0019:dQF+XM]=%I\u00164\u0017-\u001e7uIM\n!\u0002Z5tG>tg.Z2u)\u0011\u0019yaa\u0006\u0011\u000bi\u0014Yc!\u0005\u0011\u0007=\u001b\u0019\"C\u0002\u0004\u0016A\u0013A!\u00168ji\"I!q\u000b\u0019\u0011\u0002\u0003\u0007\u0011QE\u0001\u0015I&\u001c8m\u001c8oK\u000e$H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u000b\u0005\u0007?\u0019Y\u0003E\u0003{\u0005W\u0019\t\u0003\u0005\u0003\u0004$\r\u001dRBAB\u0013\u0015\r\u0019YBY\u0005\u0005\u0007S\u0019)CA\tES\u0006<gn\\:uS\u000e\u001c(+Z:vYRD\u0011b!\f3!\u0003\u0005\rA!\u0005\u0002\u0011I,\u0007o\u001c:u\u0013\u0012\fQ\u0003Z5bO:|7\u000f^5dg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00044)\"!\u0011\u0003B5)\u0011\u0019yba\u000e\t\u000f\t}B\u00071\u0001\u0004:A!11HB \u001b\t\u0019iDC\u0002\u0004\u001c\u0011KAa!\u0011\u0004>\t\u0011B)[1h]>\u001cH/[2t\u001fB$\u0018n\u001c8t\u0003\u0011\u0001\u0018N\\4\u0015\t\r\u001d3q\n\t\u0006u\n-2\u0011\n\t\u0005\u0007G\u0019Y%\u0003\u0003\u0004N\r\u0015\"A\u0003)j]\u001e\u0014Vm];mi\"I!qK\u001b\u0011\u0002\u0003\u00071\u0011\u000b\t\u0006\u001f\u000eM\u0013QE\u0005\u0004\u0007+\u0002&AB(qi&|g.\u0001\bqS:<G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rm#\u0006BB)\u0005S\"Baa\u0012\u0004`!9!qH\u001cA\u0002\r\u0005\u0004\u0003BB\u001e\u0007GJAa!\u001a\u0004>\tY\u0001+\u001b8h\u001fB$\u0018n\u001c8t\u000399\u0018-\u001b;V]RLGNU3bIf$Baa\u0004\u0004l!9!q\u000b\u001dA\u0002\u0005\u0015BCBB\b\u0007_\u001a\t\bC\u0004\u0003Xe\u0002\r!!\n\t\u000f\t}\u0012\b1\u0001\u0004tA!11HB;\u0013\u0011\u00199h!\u0010\u0003+]\u000b\u0017\u000e^+oi&d'+Z1es>\u0003H/[8og\u0006!\u0002/\u001a:g_Jlw\t\\8cC2\u001cuN\u001c8fGR$\"a!\u0005\u0002\u0019\u0005\u001b\u0018P\\2DYV\u001cH/\u001a:\u0011\u0005Md4C\u0001\u001fO)\t\u0019y(A\u0004d_:tWm\u0019;\u0015\u0011\r%51SBK\u00073\u0003Raa#\u0004\u0010Jl!a!$\u000b\u00051\u0004\u0016\u0002BBI\u0007\u001b\u00131\u0001\u0016:z\u0011\u00199g\b1\u0001\u0003\u0012!91q\u0013 A\u0002\tE\u0011\u0001C;tKJt\u0017-\\3\t\u000f\rme\b1\u0001\u0003\u0012\u0005A\u0001/Y:to>\u0014H\r\u0006\u0004\u0004\n\u000e}5\u0011\u0015\u0005\u0007O~\u0002\rA!\u0005\t\u000f\t}r\b1\u0001\u0004$B\u00191o!*\n\u0007\r\u001dFI\u0001\bDYV\u001cH/\u001a:PaRLwN\\:\u0015\r\r%51VB^\u0011\u001d\u0019i\u000b\u0011a\u0001\u0007_\u000b\u0011b]3fI:{G-Z:\u0011\r\tM1\u0011WB[\u0013\u0011\u0019\u0019L!\n\u0003\u0007M+G\u000fE\u0002Y\u0007oK1a!/Z\u0005!\u0019V-\u001a3O_\u0012,\u0007b\u0002B \u0001\u0002\u000711U\u0001\u001aKb$(/Y2u\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0004\u0004B\u000e\r7Q\u0019\t\u0006\u0007\u0017\u001byi\u0016\u0005\u0007O\u0006\u0003\rA!\u0005\t\u000f\r\u001d\u0017\t1\u0001\u0004$\u0006!q\u000e\u001d;t)\u0011\u0019\tma3\t\u000f\r\u001d'\t1\u0001\u0004$\u0002")
public class AsyncCluster {
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private AsyncTransactions transactions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final CoreCouchbaseOps couchbaseOps;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final CoreSearchOps searchOps;
    private final CoreQueryOps queryOps;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public Core core() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return core;
        }
        throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.couchbaseOps());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 4;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.users = new AsyncUserManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    private AsyncTransactions transactions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.transactions = new AsyncTransactions(new CoreTransactionsReactive(this.core(), (CoreTransactionsConfig)this.env().transactionsConfig().map((Function1 & Serializable & scala.Serializable)v -> v.toCore()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new TransactionsConfig(TransactionsConfig$.MODULE$.apply$default$1(), TransactionsConfig$.MODULE$.apply$default$2(), TransactionsConfig$.MODULE$.apply$default$3(), TransactionsConfig$.MODULE$.apply$default$4(), TransactionsConfig$.MODULE$.apply$default$5(), TransactionsConfig$.MODULE$.apply$default$6(), TransactionsConfig$.MODULE$.apply$default$7(), TransactionsConfig$.MODULE$.apply$default$8()).toCore())), this.env());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.transactions;
    }

    public AsyncTransactions transactions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.transactions$lzycompute();
        }
        return this.transactions;
    }

    public AsyncBucket bucket(String bucketName) {
        block0: {
            CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
            if (!(coreCouchbaseOps instanceof Core)) break block0;
            Core core = (Core)coreCouchbaseOps;
            core.openBucket(bucketName);
        }
        return new AsyncBucket(bucketName, this.couchbaseOps(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            HandlerBasicParams hp = new HandlerBasicParams(core);
            AnalyticsHandler analyticsHandler = new AnalyticsHandler(hp);
            Try<AnalyticsRequest> try_ = analyticsHandler.request(statement, options, core, (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                AnalyticsRequest request = (AnalyticsRequest)success.value();
                return analyticsHandler.queryAsync(request, this.ec());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            throw new MatchError(try_);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9(), AnalyticsOptions$.MODULE$.apply$default$10()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> search(String indexName, SearchRequest request) {
        return this.search(indexName, request, new SearchOptions(SearchOptions$.MODULE$.apply$default$1(), SearchOptions$.MODULE$.apply$default$2(), SearchOptions$.MODULE$.apply$default$3(), SearchOptions$.MODULE$.apply$default$4(), SearchOptions$.MODULE$.apply$default$5(), SearchOptions$.MODULE$.apply$default$6(), SearchOptions$.MODULE$.apply$default$7(), SearchOptions$.MODULE$.apply$default$8(), SearchOptions$.MODULE$.apply$default$9(), SearchOptions$.MODULE$.apply$default$10(), SearchOptions$.MODULE$.apply$default$11(), SearchOptions$.MODULE$.apply$default$12(), SearchOptions$.MODULE$.apply$default$13(), SearchOptions$.MODULE$.apply$default$14(), SearchOptions$.MODULE$.apply$default$15(), SearchOptions$.MODULE$.apply$default$16(), SearchOptions$.MODULE$.apply$default$17(), SearchOptions$.MODULE$.apply$default$18()));
    }

    public Future<SearchResult> search(String indexName, SearchRequest request, SearchOptions options) {
        Try<CoreSearchRequest> try_ = request.toCore();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CoreSearchRequest req = (CoreSearchRequest)success.value();
            return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchAsync(indexName, req, options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchQueryAsync(indexName, query.toCore(), options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.couchbaseOps().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(core.diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), core.context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            CompletableFuture future = HealthPinger.ping((Core)core, OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
            return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.couchbaseOps().waitUntilReady(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            core.initGlobalConfig();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$1) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.searchOps = this.couchbaseOps().searchOps(null);
        this.queryOps = this.couchbaseOps().queryOps();
    }
}

