/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsMetaData;
import com.couchbase.client.scala.analytics.AnalyticsMetrics$;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.analytics.AnalyticsStatus$;
import com.couchbase.client.scala.analytics.AnalyticsWarning;
import com.couchbase.client.scala.analytics.ReactiveAnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!\u0002\u0004\b\u0001-\u0019\u0002\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\t\u000b}\u0001A\u0011\u0001\u0011\t\u000b\u0011\u0002A\u0011A\u0013\t\u000b!\u0004A\u0011A5\t\u000bi\u0004A\u0011A>\u0003!\u0005s\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014(B\u0001\u0005\n\u0003!A\u0017M\u001c3mKJ\u001c(B\u0001\u0006\f\u0003\u0015\tX/\u001a:z\u0015\taQ\"A\u0003tG\u0006d\u0017M\u0003\u0002\u000f\u001f\u000511\r\\5f]RT!\u0001E\t\u0002\u0013\r|Wo\u00195cCN,'\"\u0001\n\u0002\u0007\r|Wn\u0005\u0002\u0001)A\u0011QcF\u0007\u0002-)\tA\"\u0003\u0002\u0019-\t1\u0011I\\=SK\u001a\f!\u0001\u001b9\u0004\u0001A\u0011A$H\u0007\u0002\u0017%\u0011ad\u0003\u0002\u0013\u0011\u0006tG\r\\3s\u0005\u0006\u001c\u0018n\u0019)be\u0006l7/\u0001\u0004=S:LGO\u0010\u000b\u0003C\r\u0002\"A\t\u0001\u000e\u0003\u001dAQ!\u0007\u0002A\u0002m\tqA]3rk\u0016\u001cH/\u0006\u0002'?R9qe\u000e#L!bk\u0006c\u0001\u0015,[5\t\u0011F\u0003\u0002+-\u0005!Q\u000f^5m\u0013\ta\u0013FA\u0002Uef\u0004\"AL\u001b\u000e\u0003=R!\u0001M\u0019\u0002\u0013\u0005t\u0017\r\\=uS\u000e\u001c(B\u0001\u001a4\u0003\ri7o\u001a\u0006\u0003i5\tAaY8sK&\u0011ag\f\u0002\u0011\u0003:\fG.\u001f;jGN\u0014V-];fgRDQ\u0001O\u0002A\u0002e\n\u0011b\u001d;bi\u0016lWM\u001c;\u0011\u0005i\neBA\u001e@!\tad#D\u0001>\u0015\tq$$\u0001\u0004=e>|GOP\u0005\u0003\u0001Z\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001I\u0006\u0005\u0006\u000b\u000e\u0001\rAR\u0001\b_B$\u0018n\u001c8t!\t9\u0015*D\u0001I\u0015\t\u00014\"\u0003\u0002K\u0011\n\u0001\u0012I\\1msRL7m](qi&|gn\u001d\u0005\u0006i\r\u0001\r\u0001\u0014\t\u0003\u001b:k\u0011aM\u0005\u0003\u001fN\u0012AaQ8sK\")\u0011k\u0001a\u0001%\u0006YQM\u001c<je>tW.\u001a8u!\t\u0019f+D\u0001U\u0015\t)6\"A\u0002f]ZL!a\u0016+\u0003%\rcWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\u00063\u000e\u0001\rAW\u0001\u0007EV\u001c7.\u001a;\u0011\u0007UY\u0016(\u0003\u0002]-\t1q\n\u001d;j_:DQAX\u0002A\u0002i\u000bQa]2pa\u0016$Q\u0001Y\u0002C\u0002\u0005\u0014\u0011\u0001V\t\u0003E\u0016\u0004\"!F2\n\u0005\u00114\"a\u0002(pi\"Lgn\u001a\t\u0003+\u0019L!a\u001a\f\u0003\u0007\u0005s\u00170\u0001\u0006rk\u0016\u0014\u00180Q:z]\u000e$\"A[=\u0015\u0005-$\bc\u00017pc6\tQN\u0003\u0002o-\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005Al'A\u0002$viV\u0014X\r\u0005\u0002He&\u00111\u000f\u0013\u0002\u0010\u0003:\fG.\u001f;jGN\u0014Vm];mi\")Q\u000f\u0002a\u0002m\u0006\u0011Qm\u0019\t\u0003Y^L!\u0001_7\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"\u0002\u0013\u0005\u0001\u0004i\u0013!D9vKJL(+Z1di&4X\rF\u0002}\u0003'\u0001R!`A\u0005\u0003\u001bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!\u00039vE2L7\u000f[3s\u0015\ra\u00111\u0001\u0006\u0004i\u0005\u0015!BAA\u0004\u0003\u001d\u0011X-Y2u_JL1!a\u0003\u007f\u0005\u0015\u0019Vj\u001c8p!\r9\u0015qB\u0005\u0004\u0003#A%a\u0006*fC\u000e$\u0018N^3B]\u0006d\u0017\u0010^5dgJ+7/\u001e7u\u0011\u0015!S\u00011\u0001.\u0001")
public class AnalyticsHandler {
    private final HandlerBasicParams hp;

    public <T> Try<AnalyticsRequest> request(String statement, AnalyticsOptions options, Core core, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.priority()), "priority").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))))));
        if (validations.isFailure()) {
            return validations;
        }
        JsonObject params = options.encode();
        params.put("statement", statement);
        Object object = bucket.isDefined() && scope.isDefined() ? params.put("query_context", AnalyticsRequest.queryContext((String)((String)bucket.get()), (String)((String)scope.get()))) : BoxedUnit.UNIT;
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable & scala.Serializable)queryStr -> {
            byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
            Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().analyticsTimeout()));
            RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> environment.retryStrategy());
            return new AnalyticsRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, core.context().authenticator(), queryBytes, options.priority() ? -1 : 0, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), params.str("client_context_id"), statement, $this.hp.tracer().requestSpan("analytics", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())), (String)bucket.orNull(Predef$.MODULE$.$conforms()), (String)scope.orNull(Predef$.MODULE$.$conforms()), true, options._endpointIdx());
        });
    }

    public Future<AnalyticsResult> queryAsync(AnalyticsRequest request, ExecutionContext ec) {
        this.hp.core().send((Request)request);
        Future ret = FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)response -> FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows()).collectSeq().flatMap((Function1 & Serializable & scala.Serializable)rows -> FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)trailer -> {
            Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(trailer.warnings())).map((Function1 & Serializable & scala.Serializable)warnings -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala()).map((Function1 & Serializable & scala.Serializable)codeAndMessage -> new AnalyticsWarning((ErrorCodeAndMessage)codeAndMessage), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            return new AnalyticsResult((Seq<AnalyticsChunkRow>)rows, new AnalyticsMetaData(response.header().requestId(), response.header().clientContextId().orElse(""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), AnalyticsMetrics$.MODULE$.fromBytes(trailer.metrics()), (Seq<AnalyticsWarning>)warnings2, AnalyticsStatus$.MODULE$.from(trailer.status())));
        }))).toFuture();
        ret.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                return request.context().logicallyComplete();
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return request.context().logicallyComplete(err);
            }
            throw new MatchError((Object)try_);
        }, ec);
        return ret;
    }

    public SMono<ReactiveAnalyticsResult> queryReactive(AnalyticsRequest request) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            $this.hp.core().send((Request)request);
            return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), false).map((Function1 & Serializable & scala.Serializable)response -> {
                SMono meta = FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)trailer -> {
                    Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(trailer.warnings())).map((Function1 & Serializable & scala.Serializable)warnings -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala()).map((Function1 & Serializable & scala.Serializable)codeAndMessage -> new AnalyticsWarning((ErrorCodeAndMessage)codeAndMessage), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
                    return new AnalyticsMetaData(response.header().requestId(), response.header().clientContextId().orElse(""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), AnalyticsMetrics$.MODULE$.fromBytes(trailer.metrics()), (Seq<AnalyticsWarning>)warnings2, AnalyticsStatus$.MODULE$.from(trailer.status()));
                }).doOnNext((Function1 & Serializable & scala.Serializable)x$1 -> {
                    AnalyticsHandler.$anonfun$queryReactive$7(request, x$1);
                    return BoxedUnit.UNIT;
                }).doOnError((Function1 & Serializable & scala.Serializable)err -> {
                    AnalyticsHandler.$anonfun$queryReactive$8(request, err);
                    return BoxedUnit.UNIT;
                });
                SFlux rows = FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows());
                return new ReactiveAnalyticsResult(rows, (SMono<AnalyticsMetaData>)meta);
            });
        });
    }

    public static final /* synthetic */ void $anonfun$queryReactive$7(AnalyticsRequest request$2, AnalyticsMetaData x$1) {
        request$2.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$queryReactive$8(AnalyticsRequest request$2, Throwable err) {
        request$2.context().logicallyComplete(err);
    }

    public AnalyticsHandler(HandlerBasicParams hp) {
        this.hp = hp;
    }
}

