/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.user.AuthDomain;
import com.couchbase.client.scala.manager.user.AuthDomain$Local$;
import com.couchbase.client.scala.manager.user.Group;
import com.couchbase.client.scala.manager.user.Group$;
import com.couchbase.client.scala.manager.user.ReactiveUserManager$;
import com.couchbase.client.scala.manager.user.RoleAndDescription;
import com.couchbase.client.scala.manager.user.RoleAndDescription$;
import com.couchbase.client.scala.manager.user.User;
import com.couchbase.client.scala.manager.user.UserAndMetadata;
import com.couchbase.client.scala.manager.user.UserAndMetadata$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;

@ScalaSignature(bytes="\u0006\u0001\t-w!\u0002\u001d:\u0011\u00031e!\u0002%:\u0011\u0003I\u0005\"B(\u0002\t\u0003\u0001\u0006\"B)\u0002\t\u0003\u0011f\u0001\u0002%:\u0001mC\u0001\u0002\u0018\u0003\u0003\u0006\u0004%I!\u0018\u0005\tM\u0012\u0011\t\u0011)A\u0005=\")q\n\u0002C\u0001O\"A!\u000e\u0002b\u0001\n\u0003i4\u000e\u0003\u0004u\t\u0001\u0006I\u0001\u001c\u0005\tk\u0012\u0011\r\u0011\"\u0001>m\"1Q\u0010\u0002Q\u0001\n]DQA \u0003\u0005\n}Da!!\u0004\u0005\t\u0013y\bbBA\b\t\u0011%\u0011\u0011\u0003\u0005\u0007\u0003k!A\u0011B@\t\u000f\u0005]B\u0001\"\u0003\u0002:!1\u0011q\b\u0003\u0005\n}Dq!!\u0011\u0005\t\u0013\t\u0019\u0005C\u0004\u0002b\u0011!I!a\u0019\t\u000f\u0005\u0005D\u0001\"\u0003\u00024\"9\u0011Q\u001a\u0003\u0005\u0012\u0005=\u0007bBAu\t\u0011\u0005\u00111\u001e\u0005\n\u0003{$\u0011\u0013!C\u0001\u0003\u007fD\u0011B!\u0006\u0005#\u0003%\tAa\u0006\t\u0013\tmA!%A\u0005\u0002\tu\u0001b\u0002B\u0011\t\u0011\u0005!1\u0005\u0005\n\u0005c!\u0011\u0013!C\u0001\u0003\u007fD\u0011Ba\r\u0005#\u0003%\tAa\u0006\t\u0013\tUB!%A\u0005\u0002\tu\u0001b\u0002B\u001c\t\u0011\u0005!\u0011\b\u0005\n\u0005\u0017\"\u0011\u0013!C\u0001\u0003\u007fD\u0011B!\u0014\u0005#\u0003%\tAa\u0006\t\u0013\t=C!%A\u0005\u0002\tu\u0001b\u0002B)\t\u0011\u0005!1\u000b\u0005\n\u0005;\"\u0011\u0013!C\u0001\u0003\u007fD\u0011Ba\u0018\u0005#\u0003%\tAa\u0006\t\u0013\t\u0005D!%A\u0005\u0002\tu\u0001b\u0002B2\t\u0011\u0005!Q\r\u0005\n\u0005_\"\u0011\u0013!C\u0001\u0005/A\u0011B!\u001d\u0005#\u0003%\tA!\b\t\u000f\tMD\u0001\"\u0001\u0003v!I!1\u0011\u0003\u0012\u0002\u0013\u0005!q\u0003\u0005\n\u0005\u000b#\u0011\u0013!C\u0001\u0005;AqAa\"\u0005\t\u0003\u0011I\tC\u0005\u0003\u001c\u0012\t\n\u0011\"\u0001\u0003\u0018!I!Q\u0014\u0003\u0012\u0002\u0013\u0005!Q\u0004\u0005\b\u0005?#A\u0011\u0001BQ\u0011%\u0011I\u000bBI\u0001\n\u0003\u00119\u0002C\u0005\u0003,\u0012\t\n\u0011\"\u0001\u0003\u001e!9!Q\u0016\u0003\u0005\u0002\t=\u0006\"\u0003B]\tE\u0005I\u0011\u0001B\f\u0011%\u0011Y\fBI\u0001\n\u0003\u0011i\u0002C\u0004\u0003>\u0012!\tAa0\t\u0013\t\u001dG!%A\u0005\u0002\t]\u0001\"\u0003Be\tE\u0005I\u0011\u0001B\u000f\u0003M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0015\tQ4(\u0001\u0003vg\u0016\u0014(B\u0001\u001f>\u0003\u001di\u0017M\\1hKJT!AP \u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u0001\u000b\u0015AB2mS\u0016tGO\u0003\u0002C\u0007\u0006I1m\\;dQ\n\f7/\u001a\u0006\u0002\t\u0006\u00191m\\7\u0004\u0001A\u0011q)A\u0007\u0002s\t\u0019\"+Z1di&4X-V:fe6\u000bg.Y4feN\u0011\u0011A\u0013\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0002}%\u0011a\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0015\u0001D2p]Z,'\u000f\u001e*pY\u0016\u001cHCA*Z!\rYEKV\u0005\u0003+2\u0013Q!\u0011:sCf\u0004\"aS,\n\u0005ac%\u0001\u0002\"zi\u0016DQAW\u0002A\u0002M\u000b!!\u001b8\u0014\u0005\u0011Q\u0015\u0001D2pk\u000eD'-Y:f\u001fB\u001cX#\u00010\u0011\u0005}#W\"\u00011\u000b\u0005\u0005\u0014\u0017aA1qS*\u00111mP\u0001\u0005G>\u0014X-\u0003\u0002fA\n\u00012i\u001c:f\u0007>,8\r\u001b2bg\u0016|\u0005o]\u0001\u000eG>,8\r\u001b2bg\u0016|\u0005o\u001d\u0011\u0015\u0005!L\u0007CA$\u0005\u0011\u0015av\u00011\u0001_\u0003U!WMZ1vYRl\u0015M\\1hKJ$\u0016.\\3pkR,\u0012\u0001\u001c\t\u0003[Jl\u0011A\u001c\u0006\u0003_B\fA\u0001^5nK*\t\u0011/\u0001\u0003kCZ\f\u0017BA:o\u0005!!UO]1uS>t\u0017A\u00063fM\u0006,H\u000e^'b]\u0006<WM\u001d+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011,g-Y;miJ+GO]=TiJ\fG/Z4z+\u00059\bC\u0001=|\u001b\u0005I(B\u0001>c\u0003\u0015\u0011X\r\u001e:z\u0013\ta\u0018PA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016I\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u00031\u0001\u0018\r\u001e5G_J,6/\u001a:t+\t\t\t\u0001\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0005\u0015!AB*ue&tw-\u0001\u0007qCRDgi\u001c:S_2,7/A\u0006qCRDgi\u001c:Vg\u0016\u0014HCBA\u0001\u0003'\ti\u0002C\u0004\u0002\u00169\u0001\r!a\u0006\u0002\r\u0011|W.Y5o!\r9\u0015\u0011D\u0005\u0004\u00037I$AC!vi\"$u.\\1j]\"9\u0011q\u0004\bA\u0002\u0005\u0005\u0012\u0001C;tKJt\u0017-\\3\u0011\t\u0005\r\u0012\u0011\u0007\b\u0005\u0003K\ti\u0003E\u0002\u0002(1k!!!\u000b\u000b\u0007\u0005-R)\u0001\u0004=e>|GOP\u0005\u0004\u0003_a\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u0005M\"bAA\u0018\u0019\u0006i\u0001/\u0019;i\r>\u0014xI]8vaN\fA\u0002]1uQ\u001a{'o\u0012:pkB$B!!\u0001\u0002<!9\u0011Q\b\tA\u0002\u0005\u0005\u0012\u0001\u00028b[\u0016\fq\u0002]1uQ\u001a{'\u000fU1tg^|'\u000fZ\u0001\bG>\u0014X\r\u0016:z+\t\t)\u0005\u0005\u0004\u0002H\u0005U\u0013\u0011L\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0004}\u0005=#bA2\u0002R)\u0011\u00111K\u0001\be\u0016\f7\r^8s\u0013\u0011\t9&!\u0013\u0003\u000bMkuN\\8\u0011\t\u0005m\u0013QL\u0007\u0002E&\u0019\u0011q\f2\u0003\t\r{'/Z\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0006\u0002f\u0005U\u0014\u0011TAO\u0003_\u0003b!a\u0012\u0002V\u0005\u001d\u0004\u0003BA5\u0003cj!!a\u001b\u000b\u0007q\niGC\u0002\u0002p\t\f1!\\:h\u0013\u0011\t\u0019(a\u001b\u0003-\u001d+g.\u001a:jG6\u000bg.Y4feJ+7\u000f]8og\u0016Dq!a\u001e\u0014\u0001\u0004\tI(\u0001\u0004nKRDw\u000e\u001a\t\u0005\u0003w\n)*\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0011AG\u000f\u001e9\u000b\t\u0005\r\u0015QQ\u0001\u0006G>$Wm\u0019\u0006\u0005\u0003\u000f\u000bI)A\u0004iC:$G.\u001a:\u000b\t\u0005-\u0015QR\u0001\u0006]\u0016$H/\u001f\u0006\u0005\u0003\u001f\u000b\t*\u0001\u0002j_*\u0019\u00111\u00132\u0002\t\u0011,\u0007o]\u0005\u0005\u0003/\u000biH\u0001\u0006IiR\u0004X*\u001a;i_\u0012Dq!a'\u0014\u0001\u0004\t\t#\u0001\u0003qCRD\u0007bBAP'\u0001\u0007\u0011\u0011U\u0001\bi&lWm\\;u!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003Wc\u0015AC2p]\u000e,(O]3oi&\u00191/!*\t\r\u0005E6\u00031\u0001x\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hsRa\u0011QMA[\u0003o\u000bI,!3\u0002L\"9\u0011q\u000f\u000bA\u0002\u0005e\u0004bBAN)\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003w#\u0002\u0019AA_\u0003\u0011\u0011w\u000eZ=\u0011\t\u0005}\u0016QY\u0007\u0003\u0003\u0003T1!a1c\u0003\u0011)H/\u001b7\n\t\u0005\u001d\u0017\u0011\u0019\u0002\u0016+Jd\u0017+^3ssN#(/\u001b8h\u0005VLG\u000eZ3s\u0011\u001d\ty\n\u0006a\u0001\u0003CCa!!-\u0015\u0001\u00049\u0018aC2iK\u000e\\7\u000b^1ukN$b!!5\u0002b\u0006\u0015\bCBAj\u0003/\fY.\u0004\u0002\u0002V*\u0019\u00111\u0019'\n\t\u0005e\u0017Q\u001b\u0002\u0004)JL\bcA&\u0002^&\u0019\u0011q\u001c'\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003G,\u0002\u0019AA4\u0003!\u0011Xm\u001d9p]N,\u0007bBAt+\u0001\u0007\u0011\u0011E\u0001\u0007C\u000e$\u0018n\u001c8\u0002\u000f\u001d,G/V:feRQ\u0011Q^A{\u0003o\fI0a?\u0011\r\u0005\u001d\u0013QKAx!\r9\u0015\u0011_\u0005\u0004\u0003gL$aD+tKJ\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\u0005}a\u00031\u0001\u0002\"!I\u0011Q\u0003\f\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\n\u0003?3\u0002\u0013!a\u0001\u0003CC\u0001\"!-\u0017!\u0003\u0005\ra^\u0001\u0012O\u0016$Xk]3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0001U\u0011\t9Ba\u0001,\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0004M\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0011IAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011cZ3u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IB\u000b\u0003\u0002\"\n\r\u0011!E4fiV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!q\u0004\u0016\u0004o\n\r\u0011aC4fi\u0006cG.V:feN$\u0002B!\n\u0003,\t5\"q\u0006\t\u0007\u0003\u000f\u00129#a<\n\t\t%\u0012\u0011\n\u0002\u0006'\u001acW\u000f\u001f\u0005\n\u0003+Q\u0002\u0013!a\u0001\u0003/A\u0011\"a(\u001b!\u0003\u0005\r!!)\t\u0011\u0005E&\u0004%AA\u0002]\fQcZ3u\u00032dWk]3sg\u0012\"WMZ1vYR$\u0013'A\u000bhKR\fE\u000e\\+tKJ\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002+\u001d,G/\u00117m+N,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005QQ\u000f]:feR,6/\u001a:\u0015\u0015\tm\"Q\bB#\u0005\u000f\u0012I\u0005\u0005\u0004\u0002H\u0005U\u00131\u001c\u0005\u0007uy\u0001\rAa\u0010\u0011\u0007\u001d\u0013\t%C\u0002\u0003De\u0012A!V:fe\"I\u0011Q\u0003\u0010\u0011\u0002\u0003\u0007\u0011q\u0003\u0005\n\u0003?s\u0002\u0013!a\u0001\u0003CC\u0001\"!-\u001f!\u0003\u0005\ra^\u0001\u0015kB\u001cXM\u001d;Vg\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002)U\u00048/\u001a:u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003Q)\bo]3siV\u001bXM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005AAM]8q+N,'\u000f\u0006\u0006\u0003<\tU#q\u000bB-\u00057Bq!a\b#\u0001\u0004\t\t\u0003C\u0005\u0002\u0016\t\u0002\n\u00111\u0001\u0002\u0018!I\u0011q\u0014\u0012\u0011\u0002\u0003\u0007\u0011\u0011\u0015\u0005\t\u0003c\u0013\u0003\u0013!a\u0001o\u0006\u0011BM]8q+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003I!'o\u001c9Vg\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002%\u0011\u0014x\u000e]+tKJ$C-\u001a4bk2$H\u0005N\u0001\u000fG\"\fgnZ3QCN\u001cxo\u001c:e)!\u0011YDa\u001a\u0003l\t5\u0004b\u0002B5M\u0001\u0007\u0011\u0011E\u0001\f]\u0016<\b+Y:to>\u0014H\rC\u0005\u0002 \u001a\u0002\n\u00111\u0001\u0002\"\"A\u0011\u0011\u0017\u0014\u0011\u0002\u0003\u0007q/\u0001\rdQ\u0006tw-\u001a)bgN<xN\u001d3%I\u00164\u0017-\u001e7uII\n\u0001d\u00195b]\u001e,\u0007+Y:to>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134\u00039\tg/Y5mC\ndWMU8mKN$bAa\u001e\u0003\u0000\t\u0005\u0005CBA$\u0005O\u0011I\bE\u0002H\u0005wJ1A! :\u0005I\u0011v\u000e\\3B]\u0012$Um]2sSB$\u0018n\u001c8\t\u0013\u0005}\u0015\u0006%AA\u0002\u0005\u0005\u0006\u0002CAYSA\u0005\t\u0019A<\u00021\u00054\u0018-\u001b7bE2,'k\u001c7fg\u0012\"WMZ1vYR$\u0013'\u0001\rbm\u0006LG.\u00192mKJ{G.Z:%I\u00164\u0017-\u001e7uII\n\u0001bZ3u\u000fJ|W\u000f\u001d\u000b\t\u0005\u0017\u0013\u0019Ja&\u0003\u001aB1\u0011qIA+\u0005\u001b\u00032a\u0012BH\u0013\r\u0011\t*\u000f\u0002\u0006\u000fJ|W\u000f\u001d\u0005\b\u0005+c\u0003\u0019AA\u0011\u0003%9'o\\;q\u001d\u0006lW\rC\u0005\u0002 2\u0002\n\u00111\u0001\u0002\"\"A\u0011\u0011\u0017\u0017\u0011\u0002\u0003\u0007q/\u0001\nhKR<%o\\;qI\u0011,g-Y;mi\u0012\u0012\u0014AE4fi\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIM\nAbZ3u\u00032dwI]8vaN$bAa)\u0003&\n\u001d\u0006CBA$\u0005O\u0011i\tC\u0005\u0002 >\u0002\n\u00111\u0001\u0002\"\"A\u0011\u0011W\u0018\u0011\u0002\u0003\u0007q/\u0001\fhKR\fE\u000e\\$s_V\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003Y9W\r^!mY\u001e\u0013x.\u001e9tI\u0011,g-Y;mi\u0012\u0012\u0014aC;qg\u0016\u0014Ho\u0012:pkB$\u0002Ba\u000f\u00032\nU&q\u0017\u0005\b\u0005g\u0013\u0004\u0019\u0001BG\u0003\u00159'o\\;q\u0011%\tyJ\rI\u0001\u0002\u0004\t\t\u000b\u0003\u0005\u00022J\u0002\n\u00111\u0001x\u0003U)\bo]3si\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uII\nQ#\u001e9tKJ$xI]8va\u0012\"WMZ1vYR$3'A\u0005ee>\u0004xI]8vaRA!1\bBa\u0005\u0007\u0014)\rC\u0004\u0003\u0016V\u0002\r!!\t\t\u0013\u0005}U\u0007%AA\u0002\u0005\u0005\u0006\u0002CAYkA\u0005\t\u0019A<\u0002'\u0011\u0014x\u000e]$s_V\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002'\u0011\u0014x\u000e]$s_V\u0004H\u0005Z3gCVdG\u000fJ\u001a")
public class ReactiveUserManager {
    private final CoreCouchbaseOps couchbaseOps;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public static byte[] convertRoles(byte[] byArray) {
        return ReactiveUserManager$.MODULE$.convertRoles(byArray);
    }

    private CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForUsers() {
        return "/settings/rbac/users";
    }

    private String pathForRoles() {
        return "/settings/rbac/roles";
    }

    private String pathForUser(AuthDomain domain, String username) {
        return new StringBuilder(2).append(this.pathForUsers()).append("/").append(UrlQueryStringBuilder.urlEncode((String)domain.alias())).append("/").append(UrlQueryStringBuilder.urlEncode((String)username)).toString();
    }

    private String pathForGroups() {
        return "/settings/rbac/groups";
    }

    private String pathForGroup(String name) {
        return new StringBuilder(1).append(this.pathForGroups()).append("/").append(UrlQueryStringBuilder.urlEncode((String)name)).toString();
    }

    private String pathForPassword() {
        return "/controller/changePassword";
    }

    private SMono<Core> coreTry() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return SMono$.MODULE$.just((Object)core);
        }
        return SMono$.MODULE$.error((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        return this.coreTry().flatMap((Function1 & Serializable & scala.Serializable)core -> ManagerUtil$.MODULE$.sendRequest((Core)core, method, path, timeout, retryStrategy));
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retryStrategy) {
        return this.coreTry().flatMap((Function1 & Serializable & scala.Serializable)core -> ManagerUtil$.MODULE$.sendRequest((Core)core, method, path, body, timeout, retryStrategy));
    }

    public Try<BoxedUnit> checkStatus(GenericManagerResponse response, String action) {
        return ManagerUtil$.MODULE$.checkStatus(response, action);
    }

    public SMono<UserAndMetadata> getUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get ").append(domain).append(" user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            UserAndMetadata value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), UserAndMetadata$.MODULE$.rw());
            return SMono$.MODULE$.just((Object)value);
        });
    }

    public AuthDomain getUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SFlux<UserAndMetadata> getAllUsers(AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUsers(), timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all users");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            Seq value = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(UserAndMetadata$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return SFlux$.MODULE$.fromIterable((Iterable)value);
        });
    }

    public AuthDomain getAllUsers$default$1() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getAllUsers$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllUsers$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertUser(User user, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("name", user.displayName()).add("roles", ((TraversableOnce)user.roles().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.format(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        Object object = user.groups().nonEmpty() ? params.add("groups", user.groups().mkString(",")) : BoxedUnit.UNIT;
        user.password().foreach((Function1 & Serializable & scala.Serializable)pwd -> params.add("password", pwd));
        return this.sendRequest(HttpMethod.PUT, this.pathForUser(domain, user.username()), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(14).append("create user [").append(RedactableArgument.redactUser((Object)user.username())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public AuthDomain upsertUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration upsertUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("drop user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public AuthDomain dropUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration dropUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> changePassword(String newPassword, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("password", newPassword);
        return this.sendRequest(HttpMethod.POST, this.pathForPassword(), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "change user password");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration changePassword$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy changePassword$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<RoleAndDescription> availableRoles(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForRoles(), timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all roles");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            byte[] converted = ReactiveUserManager$.MODULE$.convertRoles(response.content());
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(converted), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(RoleAndDescription$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return SFlux$.MODULE$.fromIterable((Iterable)values);
        });
    }

    public Duration availableRoles$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy availableRoles$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<Group> getGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get group [").append(RedactableArgument.redactMeta((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            Group value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), Group$.MODULE$.rw());
            return SMono$.MODULE$.just((Object)value);
        });
    }

    public Duration getGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<Group> getAllGroups(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroups(), timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all groups");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(Group$.MODULE$.rw(), Predef$.MODULE$.fallbackStringCanBuildFrom()));
            return SFlux$.MODULE$.fromIterable((Iterable)values);
        });
    }

    public Duration getAllGroups$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllGroups$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertGroup(Group group, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("description", group.description()).add("roles", ((TraversableOnce)group.roles().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.format(), Seq$.MODULE$.canBuildFrom())).mkString(","));
        group.ldapGroupReference().foreach((Function1 & Serializable & scala.Serializable)lgr -> params.add("ldap_group_ref", lgr));
        return this.sendRequest(HttpMethod.PUT, this.pathForGroup(group.name()), params, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(15).append("create group [").append(RedactableArgument.redactSystem((Object)group.name())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration upsertGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(13).append("drop group [").append(RedactableArgument.redactUser((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration dropGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public ReactiveUserManager(CoreCouchbaseOps couchbaseOps) {
        this.couchbaseOps = couchbaseOps;
        this.defaultManagerTimeout = couchbaseOps.environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = couchbaseOps.environment().retryStrategy();
    }
}

