/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.AsyncScope;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.transactions.TransactionGetResult;
import com.couchbase.client.scala.transactions.TransactionGetResult$;
import com.couchbase.client.scala.transactions.TransactionQueryOptions;
import com.couchbase.client.scala.transactions.TransactionQueryResult;
import com.couchbase.client.scala.transactions.TransactionQueryResult$;
import com.couchbase.client.scala.transactions.internal.EncodingUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001B\t\u0013\u0001uA\u0001b\t\u0001\u0003\u0006\u0004%I\u0001\n\u0005\t[\u0001\u0011\t\u0011)A\u0005K!Aa\u0006\u0001BC\u0002\u0013%q\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00031\u0011\u00199\u0004\u0001\"\u0001\u0015q!9Q\b\u0001b\u0001\n\u0007q\u0004BB#\u0001A\u0003%q\bC\u0003G\u0001\u0011\u0005q\tC\u0003b\u0001\u0011\u0005!\rC\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u0002\u0010\u0001!I!!\u0005\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002bBA\u001d\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003s\u0001A\u0011AA,\u0011\u001d\tI\u0004\u0001C\u0001\u0003K\u0012a$Q:z]\u000e$&/\u00198tC\u000e$\u0018n\u001c8BiR,W\u000e\u001d;D_:$X\r\u001f;\u000b\u0005M!\u0012\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001c(BA\u000b\u0017\u0003\u0015\u00198-\u00197b\u0015\t9\u0002$\u0001\u0004dY&,g\u000e\u001e\u0006\u00033i\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003m\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\tS\"\u0001\u0011\u000b\u0003UI!A\t\u0011\u0003\r\u0005s\u0017PU3g\u0003!Ig\u000e^3s]\u0006dW#A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013a\u0003;sC:\u001c\u0018m\u0019;j_:T!A\u000b\f\u0002\t\r|'/Z\u0005\u0003Y\u001d\u0012QdQ8sKR\u0013\u0018M\\:bGRLwN\\!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\nS:$XM\u001d8bY\u0002\n1\"\u001a8wSJ|g.\\3oiV\t\u0001\u0007\u0005\u00022i5\t!G\u0003\u00024)\u0005\u0019QM\u001c<\n\u0005U\u0012$AE\"mkN$XM]#om&\u0014xN\\7f]R\fA\"\u001a8wSJ|g.\\3oi\u0002\na\u0001P5oSRtDcA\u001d<yA\u0011!\bA\u0007\u0002%!)1%\u0002a\u0001K!)a&\u0002a\u0001a\u0005\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tI\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001#B\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002\n1aZ3u)\rAe\n\u0016\t\u0004\u0001&[\u0015B\u0001&B\u0005\u00191U\u000f^;sKB\u0011!\bT\u0005\u0003\u001bJ\u0011A\u0003\u0016:b]N\f7\r^5p]\u001e+GOU3tk2$\b\"B(\t\u0001\u0004\u0001\u0016AC2pY2,7\r^5p]B\u0011\u0011KU\u0007\u0002)%\u00111\u000b\u0006\u0002\u0010\u0003NLhnY\"pY2,7\r^5p]\")Q\u000b\u0003a\u0001-\u0006\u0011\u0011\u000e\u001a\t\u0003/zs!\u0001\u0017/\u0011\u0005e\u0003S\"\u0001.\u000b\u0005mc\u0012A\u0002\u001fs_>$h(\u0003\u0002^A\u00051\u0001K]3eK\u001aL!a\u00181\u0003\rM#(/\u001b8h\u0015\ti\u0006%\u0001\u0004j]N,'\u000f^\u000b\u0003G>$B\u0001\u001a=zuR\u0011\u0001*\u001a\u0005\u0006M&\u0001\u001daZ\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bc\u00015l[6\t\u0011N\u0003\u0002k)\u0005)1m\u001c3fG&\u0011A.\u001b\u0002\u000f\u0015N|gnU3sS\u0006d\u0017N_3s!\tqw\u000e\u0004\u0001\u0005\u000bAL!\u0019A9\u0003\u0003Q\u000b\"A];\u0011\u0005}\u0019\u0018B\u0001;!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\b<\n\u0005]\u0004#aA!os\")q*\u0003a\u0001!\")Q+\u0003a\u0001-\")10\u0003a\u0001[\u000691m\u001c8uK:$\u0018a\u0002:fa2\f7-Z\u000b\u0004}\u0006\u001dA#B@\u0002\n\u00055Ac\u0001%\u0002\u0002!1aM\u0003a\u0002\u0003\u0007\u0001B\u0001[6\u0002\u0006A\u0019a.a\u0002\u0005\u000bAT!\u0019A9\t\r\u0005-!\u00021\u0001L\u0003\r!wn\u0019\u0005\u0007w*\u0001\r!!\u0002\u0002\u0013\rdwn]3Ta\u0006tW\u0003BA\n\u0003S!R\u0001SA\u000b\u0003KAq!a\u0006\f\u0001\u0004\tI\"\u0001\u0003ta\u0006t\u0007\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}\u0011&A\u0002d]\u000eLA!a\t\u0002\u001e\tY!+Z9vKN$8\u000b]1o\u0011\u0019\t9c\u0003a\u0001\u0011\u00061a-\u001e;ve\u0016$Q\u0001]\u0006C\u0002E\faA]3n_Z,G\u0003BA\u0018\u0003o\u0001B\u0001Q%\u00022A\u0019q$a\r\n\u0007\u0005U\u0002E\u0001\u0003V]&$\bBBA\u0006\u0019\u0001\u00071*A\u0003rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002>\u0005\u0015\u0003\u0003\u0002!J\u0003\u007f\u00012AOA!\u0013\r\t\u0019E\u0005\u0002\u0017)J\fgn]1di&|g.U;fef\u0014Vm];mi\"1\u0011qI\u0007A\u0002Y\u000b\u0011b\u001d;bi\u0016lWM\u001c;\u0015\r\u0005u\u00121JA'\u0011\u0019\t9E\u0004a\u0001-\"9\u0011q\n\bA\u0002\u0005E\u0013aB8qi&|gn\u001d\t\u0004u\u0005M\u0013bAA+%\t9BK]1og\u0006\u001cG/[8o#V,'/_(qi&|gn\u001d\u000b\u0007\u0003{\tI&a\u0019\t\u000f\u0005ms\u00021\u0001\u0002^\u0005)1oY8qKB\u0019\u0011+a\u0018\n\u0007\u0005\u0005DC\u0001\u0006Bgft7mU2pa\u0016Da!a\u0012\u0010\u0001\u00041F\u0003CA\u001f\u0003O\nI'a\u001b\t\u000f\u0005m\u0003\u00031\u0001\u0002^!1\u0011q\t\tA\u0002YCq!a\u0014\u0011\u0001\u0004\t\t\u0006")
public class AsyncTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final ClusterEnvironment environment;
    private final ExecutionContext executionContext;

    private CoreTransactionAttemptContext internal() {
        return this.internal;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public Future<TransactionGetResult> get(AsyncCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().get(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$, this.executionContext());
    }

    public <T> Future<TransactionGetResult> insert(AsyncCollection collection, String id, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_insert", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().insert(collection.collectionIdentifier(), id, encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$, this.executionContext()));
        }
        throw new MatchError(try_);
    }

    public <T> Future<TransactionGetResult> replace(TransactionGetResult doc, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_replace", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().replace(doc.internal(), encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$, this.executionContext()));
        }
        throw new MatchError(try_);
    }

    private <T> Future<TransactionGetResult> closeSpan(RequestSpan span, Future<TransactionGetResult> future) {
        future.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTransactionAttemptContext.$anonfun$closeSpan$1(span, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return future;
    }

    public Future<BoxedUnit> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_remove", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        Future out = FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().remove(doc.internal(), new SpanWrapper(span))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncTransactionAttemptContext.$anonfun$remove$1(x$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        out.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AsyncTransactionAttemptContext.$anonfun$remove$2(span, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return out;
    }

    public Future<TransactionQueryResult> query(String statement) {
        return this.query(null, statement, null);
    }

    public Future<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement, TransactionQueryOptions options) {
        CoreQueryOptions opts = (CoreQueryOptions)Option$.MODULE$.apply((Object)options).map((Function1 & Serializable & scala.Serializable)v -> v.toCore()).orNull(Predef$.MODULE$.$conforms());
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), opts, false)).map((Function1)TransactionQueryResult$.MODULE$, this.executionContext());
    }

    public static final /* synthetic */ void $anonfun$closeSpan$1(RequestSpan span$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            span$1.status(RequestSpan.StatusCode.ERROR);
            span$1.end();
            return;
        }
        if (try_ instanceof Success) {
            span$1.end();
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$remove$1(Void x$1) {
    }

    public static final /* synthetic */ void $anonfun$remove$2(RequestSpan span$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            span$2.status(RequestSpan.StatusCode.ERROR);
            span$2.end();
            return;
        }
        if (try_ instanceof Success) {
            span$2.end();
            return;
        }
        throw new MatchError((Object)try_);
    }

    public AsyncTransactionAttemptContext(CoreTransactionAttemptContext internal, ClusterEnvironment environment) {
        this.internal = internal;
        this.environment = environment;
        this.executionContext = environment.ec();
    }
}

