/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001U4AAC\u0006\u0001-!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!)\u0011\t\u0001C!\u0005\u001e)\u0011m\u0003E\u0001E\u001a)!b\u0003E\u0001G\")\u0001%\u0002C\u0001O\"9\u0001.\u0002b\u0001\n\u0003I\u0007B\u00026\u0006A\u0003%!\u0005C\u0004l\u000b\u0005\u0005I\u0011\u00027\u0003\u001d)\u001bxN\u001c+sC:\u001c8m\u001c3fe*\u0011A\"D\u0001\u0006G>$Wm\u0019\u0006\u0003\u001d=\tQa]2bY\u0006T!\u0001E\t\u0002\r\rd\u0017.\u001a8u\u0015\t\u00112#A\u0005d_V\u001c\u0007NY1tK*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/q\u0001\"\u0001\u0007\u000e\u000e\u0003eQ\u0011AD\u0005\u00037e\u0011a!\u00118z%\u00164\u0007CA\u000f\u001f\u001b\u0005Y\u0011BA\u0010\f\u0005a!&/\u00198tG>$WM],ji\"\u001cVM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"!\b\u0001\u0002\r\u0015t7m\u001c3f+\t)3\u0007F\u0002'_q\u00022a\n\u0016-\u001b\u0005A#BA\u0015\u001a\u0003\u0011)H/\u001b7\n\u0005-B#a\u0001+ssB\u0011Q$L\u0005\u0003]-\u0011A\"\u00128d_\u0012,GMV1mk\u0016DQ\u0001\r\u0002A\u0002E\nQA^1mk\u0016\u0004\"AM\u001a\r\u0001\u0011)AG\u0001b\u0001k\t\tA+\u0005\u00027sA\u0011\u0001dN\u0005\u0003qe\u0011qAT8uQ&tw\r\u0005\u0002\u0019u%\u00111(\u0007\u0002\u0004\u0003:L\b\"B\u001f\u0003\u0001\u0004q\u0014AC:fe&\fG.\u001b>feB\u0019QdP\u0019\n\u0005\u0001[!A\u0004&t_:\u001cVM]5bY&TXM]\u0001\u0007I\u0016\u001cw\u000eZ3\u0016\u0005\r;E\u0003\u0002#Q1v#\"!\u0012%\u0011\u0007\u001dRc\t\u0005\u00023\u000f\u0012)Ag\u0001b\u0001k!)\u0011j\u0001a\u0002\u0015\u0006\u0019A/Y4\u0011\u0007-se)D\u0001M\u0015\ti\u0015$A\u0004sK\u001adWm\u0019;\n\u0005=c%\u0001C\"mCN\u001cH+Y4\t\u000bE\u001b\u0001\u0019\u0001*\u0002\u000b%t\u0007/\u001e;\u0011\u0007a\u0019V+\u0003\u0002U3\t)\u0011I\u001d:bsB\u0011\u0001DV\u0005\u0003/f\u0011AAQ=uK\")\u0011l\u0001a\u00015\u0006)a\r\\1hgB\u0011\u0001dW\u0005\u00039f\u00111!\u00138u\u0011\u0015i4\u00011\u0001_!\rirLR\u0005\u0003A.\u0011\u0001CS:p]\u0012+7/\u001a:jC2L'0\u001a:\u0002\u001d)\u001bxN\u001c+sC:\u001c8m\u001c3feB\u0011Q$B\n\u0004\u000b]!\u0007C\u0001\rf\u0013\t1\u0017D\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001c\u0003!Ien\u001d;b]\u000e,W#\u0001\u0012\u0002\u0013%s7\u000f^1oG\u0016\u0004\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fA\u0001\\1oO*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0019y%M[3di\u0002")
public class JsonTranscoder
implements TranscoderWithSerializer {
    public static JsonTranscoder Instance() {
        return JsonTranscoder$.MODULE$.Instance();
    }

    public <T> Try<EncodedValue> encode(T value, JsonSerializer<T> serializer) {
        T t = value;
        if (t instanceof byte[]) {
            return new Failure((Throwable)new IllegalArgumentException("byte[] input is not supported for the JsonTranscoder! If you want to store already encoded JSON, use the RawJsonTranscoder, otherwise store it with the RawBinaryTranscoder!"));
        }
        return serializer.serialize(value).map((Function1 & java.io.Serializable & Serializable)bytes -> new EncodedValue((byte[])bytes, CodecFlags.JSON_COMPAT_FLAGS));
    }

    public <T> Try<T> decode(byte[] input, int flags, JsonDeserializer<T> serializer, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return new Failure((Throwable)new IllegalArgumentException("Array[Byte] input is not supported for the JsonTranscoder!. If you want to read already encoded JSON, use the RawJsonTranscoder, otherwise read it with the RawBinaryTranscoder!"));
        }
        return serializer.deserialize(input);
    }
}

