/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.transaction.CoreTransactionsReactive;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchResult$;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.search.vector.SearchRequest;
import com.couchbase.client.scala.transactions.AsyncTransactions;
import com.couchbase.client.scala.transactions.config.TransactionsConfig$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r=h\u0001B\"E\u00015C\u0001b\u0015\u0001\u0003\u0002\u0013\u0006I\u0001\u0016\u0005\n;\u0002\u0011)\u0019!C\u0001\tzC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\nO\u0002\u0011)\u0019!C\u0001\t\"D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\to\u0002\u0011\r\u0011b\u0001Eq\"1q\u0010\u0001Q\u0001\neD\u0001B\u0017\u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003X\u0011)\t)\u0001\u0001b\u0001\n\u0003!\u0015q\u0001\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\n!91\r\u0001C\u0001\u0011\u0006]\u0001BCA\u0011\u0001\t\u0007I\u0011\u0001#\u0002$!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0003\u0003\u0006\u00024\u0001\u0011\r\u0011\"\u0001E\u0003GA\u0001\"!\u000e\u0001A\u0003%\u0011Q\u0005\u0005\u000b\u0003o\u0001!\u0019!C\u0001\t\u0006e\u0002\u0002CA$\u0001\u0001\u0006I!a\u000f\t\u0015\u0005%\u0003A1A\u0005\u0002\u0011\u000bY\u0005\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA'\u0011-\tY\u0006\u0001EC\u0002\u0013\u0005A)!\u0018\t\u0017\u0005=\u0004\u0001#b\u0001\n\u0003!\u0015\u0011\u000f\u0005\u000b\u0003\u007f\u0002!\u0019!C\u0001\t\u0006\u0005\u0005\u0002CAH\u0001\u0001\u0006I!a!\t\u0015\u0005E\u0005\u0001#b\u0001\n\u0003\t\u0019\n\u0003\u0006\u0002\u001c\u0002A)\u0019!C\u0001\u0003;C!\"a+\u0001\u0011\u000b\u0007I\u0011AAW\u0011)\tI\f\u0001EC\u0002\u0013\u0005\u00111\u0018\u0005\u000b\u0003\u000f\u0004\u0001R1A\u0005\u0002\u0005%\u0007BCAi\u0001!\u0015\r\u0011\"\u0001\u0002T\"Q\u0011q\u001f\u0001\t\u0006\u0004%\t!!?\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0003\b!9\u0011\u0011\u0012\u0001\u0005\u0002\t%\u0002bBAE\u0001\u0011\u0005!\u0011\n\u0005\n\u0005K\u0002\u0011\u0013!C\u0001\u0005OB\u0011Ba\u001f\u0001#\u0003%\tA! \t\u0013\t\u0005\u0005!%A\u0005\u0002\t\r\u0005b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005\u000f\u0003A\u0011\u0001BQ\u0011%\u0011y\u000bAI\u0001\n\u0003\u0011\t\fC\u0005\u00036\u0002\t\n\u0011\"\u0001\u0003~!9\u00111\u000b\u0001\u0005\u0002\t]\u0006bBA*\u0001\u0011\u0005!1 \u0005\b\u0007\u001b\u0001A\u0011AB\b\u0011\u001d\u0019i\u0001\u0001C\u0001\u0007GA\u0011ba\u000b\u0001#\u0003%\tA! \t\u000f\r5\u0002\u0001\"\u0001\u00040!I11\b\u0001\u0012\u0002\u0013\u0005!Q\u0010\u0005\b\u0007{\u0001A\u0011AB \u0011%\u0019\t\u0006AI\u0001\n\u0003\u0019\u0019\u0006C\u0004\u0004>\u0001!\taa\u0016\t\u000f\r\u0015\u0004\u0001\"\u0001\u0004h!I1\u0011\u0010\u0001\u0012\u0002\u0013\u000511\u0010\u0005\b\u0007K\u0002A\u0011AB@\u0011\u001d\u0019I\t\u0001C\u0001\u0007\u0017Cqa!#\u0001\t\u0003\u0019y\t\u0003\u0005\u0004\u001c\u0002!\t\u0001RBO\u000f\u001d\u0019y\n\u0012E\u0001\u0007C3aa\u0011#\t\u0002\r\r\u0006B\u00029=\t\u0003\u0019)\u000bC\u0004\u0004(r\"\ta!+\t\u000f\r\u001dF\b\"\u0001\u0004@\"91q\u0015\u001f\u0005\u0002\r-\u0007\u0002CBpy\u0011\u0005ai!9\t\u0011\r}G\b\"\u0001G\u0007W\u0014A\"Q:z]\u000e\u001cE.^:uKJT!!\u0012$\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dC\u0015AB2mS\u0016tGO\u0003\u0002J\u0015\u0006I1m\\;dQ\n\f7/\u001a\u0006\u0002\u0017\u0006\u00191m\\7\u0004\u0001M\u0011\u0001A\u0014\t\u0003\u001fFk\u0011\u0001\u0015\u0006\u0002\u000b&\u0011!\u000b\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0004\u001fV;\u0016B\u0001,Q\u0005!a$-\u001f8b[\u0016t\u0004C\u0001-\\\u001b\u0005I&B\u0001.E\u0003\r)gN^\u0005\u00039f\u0013!c\u00117vgR,'/\u00128wSJ|g.\\3oi\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012a\u0018\t\u0003A\u0012l\u0011!\u0019\u0006\u00035\nT!a\u0019$\u0002\t\r|'/Z\u0005\u0003K\u0006\u0014Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001e,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\n\fA!\u001e;jY&\u0011an\u001b\u0002\u0011\u0007>tg.Z2uS>t7\u000b\u001e:j]\u001e\f\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4!\u0003\u0019a\u0014N\\5u}Q!!\u000f^;w!\t\u0019\b!D\u0001E\u0011\u0019\u0019f\u0001\"a\u0001)\")QL\u0002a\u0001?\")qM\u0002a\u0001S\u0006\u0011QmY\u000b\u0002sB\u0011!0`\u0007\u0002w*\u0011A\u0010U\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001@|\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002*\u0012aV\u0001\u0005K:4\b%\u0001\u0007d_V\u001c\u0007NY1tK>\u00038/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010\t\f1!\u00199j\u0013\u0011\t\u0019\"!\u0004\u0003!\r{'/Z\"pk\u000eD'-Y:f\u001fB\u001c\u0018!D2pk\u000eD'-Y:f\u001fB\u001c\b%\u0006\u0002\u0002\u001aA!\u00111DA\u000f\u001b\u0005\u0011\u0017bAA\u0010E\n!1i\u001c:f\u00035\u0019X-\u0019:dQRKW.Z8viV\u0011\u0011Q\u0005\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111F>\u0002\u0011\u0011,(/\u0019;j_:LA!a\f\u0002*\tAA)\u001e:bi&|g.\u0001\btK\u0006\u00148\r\u001b+j[\u0016|W\u000f\u001e\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001cH+[7f_V$\u0018!E1oC2LH/[2t)&lWm\\;uA\u0005i!/\u001a;ssN#(/\u0019;fOf,\"!a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011c\u0003\u0015\u0011X\r\u001e:z\u0013\u0011\t)%a\u0010\u0003\u001bI+GO]=TiJ\fG/Z4z\u00039\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0002\n\u0011b]3be\u000eDw\n]:\u0016\u0005\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\t\u0005M\u0013QB\u0001\u0007g\u0016\f'o\u00195\n\t\u0005]\u0013\u0011\u000b\u0002\u000e\u0007>\u0014XmU3be\u000eDw\n]:\u0002\u0015M,\u0017M]2i\u001fB\u001c\b%A\u000bsK\u0006\u001cG/\u001b<f\u0005V\u001c7.\u001a;NC:\fw-\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0007EV\u001c7.\u001a;\u000b\u0007\u0005%D)A\u0004nC:\fw-\u001a:\n\t\u00055\u00141\r\u0002\u0016%\u0016\f7\r^5wK\n+8m[3u\u001b\u0006t\u0017mZ3s\u0003u\u0011X-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014XCAA:!\u0011\t)(a\u001f\u000e\u0005\u0005]$\u0002BA=\u0003O\n\u0011\"\u00198bYf$\u0018nY:\n\t\u0005u\u0014q\u000f\u0002\u001e%\u0016\f7\r^5wK\u0006s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\u0006A\u0011/^3ss>\u00038/\u0006\u0002\u0002\u0004B!\u0011QQAF\u001b\t\t9I\u0003\u0003\u0002\n\u00065\u0011!B9vKJL\u0018\u0002BAG\u0003\u000f\u0013AbQ8sKF+XM]=PaN\f\u0011\"];fef|\u0005o\u001d\u0011\u0002\u000f\t,8m[3ugV\u0011\u0011Q\u0013\t\u0005\u0003C\n9*\u0003\u0003\u0002\u001a\u0006\r$AE!ts:\u001c')^2lKRl\u0015M\\1hKJ\fQ!^:feN,\"!a(\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GSA!!*\u0002h\u0005!Qo]3s\u0013\u0011\tI+a)\u0003!\u0005\u001b\u0018P\\2Vg\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001D9vKJL\u0018J\u001c3fq\u0016\u001cXCAAX!\u0011\t\t,!.\u000e\u0005\u0005M&\u0002BAE\u0003OJA!a.\u00024\n1\u0012i]=oGF+XM]=J]\u0012,\u00070T1oC\u001e,'/A\u0007tK\u0006\u00148\r[%oI\u0016DXm]\u000b\u0003\u0003{\u0003B!a0\u0002D6\u0011\u0011\u0011\u0019\u0006\u0005\u0003'\n9'\u0003\u0003\u0002F\u0006\u0005'aF!ts:\u001c7+Z1sG\"Le\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003A\tg.\u00197zi&\u001c7/\u00138eKb,7/\u0006\u0002\u0002LB!\u0011QOAg\u0013\u0011\ty-a\u001e\u00035\u0005\u001b\u0018P\\2B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0002#\u00154XM\u001c;j]\u001e4UO\\2uS>t7/\u0006\u0002\u0002VB!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006\u001d\u0014\u0001C3wK:$\u0018N\\4\n\t\u0005}\u0017\u0011\u001c\u0002\u001d\u0003NLhnY#wK:$\u0018N\\4Gk:\u001cG/[8o\u001b\u0006t\u0017mZ3sQ\ry\u00121\u001d\t\u0005\u0003K\f\tP\u0004\u0003\u0002h\u00065XBAAu\u0015\r\tYOY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAx\u0003S\f\u0011b\u0015;bE&d\u0017\u000e^=\n\t\u0005M\u0018Q\u001f\u0002\f+:\u001cw.\\7jiR,GM\u0003\u0003\u0002p\u0006%\u0018\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001cXCAA~!\u0011\tiP!\u0001\u000e\u0005\u0005}(bAA|\t&!!1AA\u0000\u0005E\t5/\u001f8d)J\fgn]1di&|gn\u001d\u0015\u0004A\u0005\rH\u0003\u0002B\u0005\u0005\u001f\u00012a\u001dB\u0006\u0013\r\u0011i\u0001\u0012\u0002\f\u0003NLhn\u0019\"vG.,G\u000fC\u0004\u0003\u0012\u0005\u0002\rAa\u0005\u0002\u0015\t,8m[3u\u001d\u0006lW\r\u0005\u0003\u0003\u0016\t\rb\u0002\u0002B\f\u0005?\u00012A!\u0007Q\u001b\t\u0011YBC\u0002\u0003\u001e1\u000ba\u0001\u0010:p_Rt\u0014b\u0001B\u0011!\u00061\u0001K]3eK\u001aLAA!\n\u0003(\t11\u000b\u001e:j]\u001eT1A!\tQ)\u0019\u0011YCa\u000f\u0003@A)!P!\f\u00032%\u0019!qF>\u0003\r\u0019+H/\u001e:f!\u0011\u0011\u0019Da\u000e\u000e\u0005\tU\"bAAE\t&!!\u0011\bB\u001b\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000f\tu\"\u00051\u0001\u0003\u0014\u0005I1\u000f^1uK6,g\u000e\u001e\u0005\b\u0005\u0003\u0012\u0003\u0019\u0001B\"\u0003\u001dy\u0007\u000f^5p]N\u0004BAa\r\u0003F%!!q\tB\u001b\u00051\tV/\u001a:z\u001fB$\u0018n\u001c8t))\u0011YCa\u0013\u0003N\t]#1\f\u0005\b\u0005{\u0019\u0003\u0019\u0001B\n\u0011%\u0011ye\tI\u0001\u0002\u0004\u0011\t&\u0001\u0006qCJ\fW.\u001a;feN\u0004BAa\r\u0003T%!!Q\u000bB\u001b\u0005=\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001c\b\"\u0003B-GA\u0005\t\u0019AA\u0013\u0003\u001d!\u0018.\\3pkRD\u0011B!\u0018$!\u0003\u0005\rAa\u0018\u0002\u000b\u0005$\u0007n\\2\u0011\u0007=\u0013\t'C\u0002\u0003dA\u0013qAQ8pY\u0016\fg.A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IG\u000b\u0003\u0003R\t-4F\u0001B7!\u0011\u0011yGa\u001e\u000e\u0005\tE$\u0002\u0002B:\u0005k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\b+\u0003\u0003\u0003z\tE$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011/^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0000)\"\u0011Q\u0005B6\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\"TC\u0001BCU\u0011\u0011yFa\u001b\u0002\u001d\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ssR1!1\u0012BL\u00053\u0003RA\u001fB\u0017\u0005\u001b\u0003BAa$\u0003\u00146\u0011!\u0011\u0013\u0006\u0004\u0003s\"\u0015\u0002\u0002BK\u0005#\u0013q\"\u00118bYf$\u0018nY:SKN,H\u000e\u001e\u0005\b\u0005{9\u0003\u0019\u0001B\n\u0011\u001d\u0011\te\na\u0001\u00057\u0003BAa$\u0003\u001e&!!q\u0014BI\u0005A\te.\u00197zi&\u001c7o\u00149uS>t7\u000f\u0006\u0005\u0003\f\n\r&Q\u0015BW\u0011\u001d\u0011i\u0004\u000ba\u0001\u0005'A\u0011Ba\u0014)!\u0003\u0005\rAa*\u0011\t\t=%\u0011V\u0005\u0005\u0005W\u0013\tJA\nB]\u0006d\u0017\u0010^5dgB\u000b'/Y7fi\u0016\u00148\u000fC\u0005\u0003Z!\u0002\n\u00111\u0001\u0002&\u0005A\u0012M\\1msRL7m])vKJLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM&\u0006\u0002BT\u0005W\n\u0001$\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134)\u0019\u0011IL!3\u0003NB)!P!\f\u0003<B!!Q\u0018Bc\u001b\t\u0011yL\u0003\u0003\u0003B\n\r\u0017A\u0002:fgVdGOC\u0002\u0002T\u0011KAAa2\u0003@\na1+Z1sG\"\u0014Vm];mi\"9!1Z\u0016A\u0002\tM\u0011!C5oI\u0016Dh*Y7f\u0011\u001d\u0011ym\u000ba\u0001\u0005#\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003T\neWB\u0001Bk\u0015\u0011\u00119Na1\u0002\rY,7\r^8s\u0013\u0011\u0011YN!6\u0003\u001bM+\u0017M]2i%\u0016\fX/Z:uQ\rY#q\u001c\t\u0005\u0005C\u00149P\u0004\u0003\u0003d\u00065h\u0002\u0002Bs\u0005ktAAa:\u0003t:!!\u0011\u001eBy\u001d\u0011\u0011YOa<\u000f\t\te!Q^\u0005\u0002\u0017&\u0011\u0011JS\u0005\u0003\u000f\"K!a\u0019$\n\u0007\u0005-(-\u0003\u0003\u0003z\u0006U(\u0001\u0003,pY\u0006$\u0018\u000e\\3\u0015\u0011\te&Q B\u0000\u0007\u0003AqAa3-\u0001\u0004\u0011\u0019\u0002C\u0004\u0003P2\u0002\rA!5\t\u000f\t\u0005C\u00061\u0001\u0004\u0004A!1QAB\u0004\u001b\t\u0011\u0019-\u0003\u0003\u0004\n\t\r'!D*fCJ\u001c\u0007n\u00149uS>t7\u000fK\u0002-\u0005?\f1b]3be\u000eD\u0017+^3ssRA!\u0011XB\t\u0007'\u0019\t\u0003C\u0004\u0003L6\u0002\rAa\u0005\t\u000f\u0005%U\u00061\u0001\u0004\u0016A!1qCB\u000f\u001b\t\u0019IB\u0003\u0003\u0004\u001c\t\r\u0017aB9vKJLWm]\u0005\u0005\u0007?\u0019IBA\u0006TK\u0006\u00148\r[)vKJL\bb\u0002B![\u0001\u000711\u0001\u000b\t\u0005s\u001b)ca\n\u0004*!9!1\u001a\u0018A\u0002\tM\u0001bBAE]\u0001\u00071Q\u0003\u0005\n\u00053r\u0003\u0013!a\u0001\u0003K\tQc]3be\u000eD\u0017+^3ss\u0012\"WMZ1vYR$3'\u0001\u0006eSN\u001cwN\u001c8fGR$Ba!\r\u0004:A)!P!\f\u00044A\u0019qj!\u000e\n\u0007\r]\u0002K\u0001\u0003V]&$\b\"\u0003B-aA\u0005\t\u0019AA\u0013\u0003Q!\u0017n]2p]:,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005YA-[1h]>\u001cH/[2t)\u0011\u0019\te!\u0014\u0011\u000bi\u0014ica\u0011\u0011\t\r\u00153\u0011J\u0007\u0003\u0007\u000fR1a!\u0010c\u0013\u0011\u0019Yea\u0012\u0003#\u0011K\u0017m\u001a8pgRL7m\u001d*fgVdG\u000fC\u0005\u0004PI\u0002\n\u00111\u0001\u0003\u0014\u0005A!/\u001a9peRLE-A\u000beS\u0006<gn\\:uS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\rU#\u0006\u0002B\n\u0005W\"Ba!\u0011\u0004Z!9!\u0011\t\u001bA\u0002\rm\u0003\u0003BB/\u0007Cj!aa\u0018\u000b\u0007\ruB)\u0003\u0003\u0004d\r}#A\u0005#jC\u001etwn\u001d;jGN|\u0005\u000f^5p]N\fA\u0001]5oOR!1\u0011NB9!\u0015Q(QFB6!\u0011\u0019)e!\u001c\n\t\r=4q\t\u0002\u000b!&twMU3tk2$\b\"\u0003B-kA\u0005\t\u0019AB:!\u0015y5QOA\u0013\u0013\r\u00199\b\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001dALgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111Q\u0010\u0016\u0005\u0007g\u0012Y\u0007\u0006\u0003\u0004j\r\u0005\u0005b\u0002B!o\u0001\u000711\u0011\t\u0005\u0007;\u001a))\u0003\u0003\u0004\b\u000e}#a\u0003)j]\u001e|\u0005\u000f^5p]N\fab^1jiVsG/\u001b7SK\u0006$\u0017\u0010\u0006\u0003\u00042\r5\u0005b\u0002B-q\u0001\u0007\u0011Q\u0005\u000b\u0007\u0007c\u0019\tja%\t\u000f\te\u0013\b1\u0001\u0002&!9!\u0011I\u001dA\u0002\rU\u0005\u0003BB/\u0007/KAa!'\u0004`\t)r+Y5u+:$\u0018\u000e\u001c*fC\u0012Lx\n\u001d;j_:\u001c\u0018\u0001\u00069fe\u001a|'/\\$m_\n\fGnQ8o]\u0016\u001cG\u000f\u0006\u0002\u00044\u0005a\u0011i]=oG\u000ecWo\u001d;feB\u00111\u000fP\n\u0003y9#\"a!)\u0002\u000f\r|gN\\3diRA11VB[\u0007o\u001bY\fE\u0003\u0004.\u000eE&/\u0004\u0002\u00040*\u0011A\u000eU\u0005\u0005\u0007g\u001byKA\u0002UefDaa\u001a A\u0002\tM\u0001bBB]}\u0001\u0007!1C\u0001\tkN,'O\\1nK\"91Q\u0018 A\u0002\tM\u0011\u0001\u00039bgN<xN\u001d3\u0015\r\r-6\u0011YBb\u0011\u00199w\b1\u0001\u0003\u0014!9!\u0011I A\u0002\r\u0015\u0007cA:\u0004H&\u00191\u0011\u001a#\u0003\u001d\rcWo\u001d;fe>\u0003H/[8ogR111VBg\u0007;Dqaa4A\u0001\u0004\u0019\t.A\u0005tK\u0016$gj\u001c3fgB1!QCBj\u0007/LAa!6\u0003(\t\u00191+\u001a;\u0011\u0007a\u001bI.C\u0002\u0004\\f\u0013\u0001bU3fI:{G-\u001a\u0005\b\u0005\u0003\u0002\u0005\u0019ABc\u0003e)\u0007\u0010\u001e:bGR\u001cE.^:uKJ,eN^5s_:lWM\u001c;\u0015\r\r\r8Q]Bt!\u0015\u0019ik!-X\u0011\u00199\u0017\t1\u0001\u0003\u0014!91\u0011^!A\u0002\r\u0015\u0017\u0001B8qiN$Baa9\u0004n\"91\u0011\u001e\"A\u0002\r\u0015\u0007")
public class AsyncCluster {
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    @Stability.Uncommitted
    private AsyncTransactions transactions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final CoreCouchbaseOps couchbaseOps;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final CoreSearchOps searchOps;
    private final CoreQueryOps queryOps;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public Core core() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return core;
        }
        throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.couchbaseOps());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 4;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.users = new AsyncUserManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    private AsyncTransactions transactions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.transactions = new AsyncTransactions(new CoreTransactionsReactive(this.core(), (CoreTransactionsConfig)this.env().transactionsConfig().map((Function1 & Serializable & scala.Serializable)v -> v.toCore()).getOrElse((Function0 & Serializable & scala.Serializable)() -> TransactionsConfig$.MODULE$.apply(TransactionsConfig$.MODULE$.apply$default$1(), TransactionsConfig$.MODULE$.apply$default$2(), TransactionsConfig$.MODULE$.apply$default$3(), TransactionsConfig$.MODULE$.apply$default$4(), TransactionsConfig$.MODULE$.apply$default$5(), TransactionsConfig$.MODULE$.apply$default$6(), TransactionsConfig$.MODULE$.apply$default$7(), TransactionsConfig$.MODULE$.apply$default$8()).toCore())), this.env());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.transactions;
    }

    public AsyncTransactions transactions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.transactions$lzycompute();
        }
        return this.transactions;
    }

    public AsyncBucket bucket(String bucketName) {
        block0: {
            CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
            if (!(coreCouchbaseOps instanceof Core)) break block0;
            Core core = (Core)coreCouchbaseOps;
            core.openBucket(bucketName);
        }
        return new AsyncBucket(bucketName, this.couchbaseOps(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            HandlerBasicParams hp = new HandlerBasicParams(core);
            AnalyticsHandler analyticsHandler = new AnalyticsHandler(hp);
            Try<AnalyticsRequest> try_ = analyticsHandler.request(statement, options, core, (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                AnalyticsRequest request = (AnalyticsRequest)success.value();
                return analyticsHandler.queryAsync(request, this.ec());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            throw new MatchError(try_);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    @Stability.Volatile
    public Future<SearchResult> search(String indexName, SearchRequest request) {
        return this.search(indexName, request, new SearchOptions(SearchOptions$.MODULE$.apply$default$1(), SearchOptions$.MODULE$.apply$default$2(), SearchOptions$.MODULE$.apply$default$3(), SearchOptions$.MODULE$.apply$default$4(), SearchOptions$.MODULE$.apply$default$5(), SearchOptions$.MODULE$.apply$default$6(), SearchOptions$.MODULE$.apply$default$7(), SearchOptions$.MODULE$.apply$default$8(), SearchOptions$.MODULE$.apply$default$9(), SearchOptions$.MODULE$.apply$default$10(), SearchOptions$.MODULE$.apply$default$11(), SearchOptions$.MODULE$.apply$default$12(), SearchOptions$.MODULE$.apply$default$13(), SearchOptions$.MODULE$.apply$default$14(), SearchOptions$.MODULE$.apply$default$15(), SearchOptions$.MODULE$.apply$default$16(), SearchOptions$.MODULE$.apply$default$17(), SearchOptions$.MODULE$.apply$default$18()));
    }

    @Stability.Volatile
    public Future<SearchResult> search(String indexName, SearchRequest request, SearchOptions options) {
        Try<CoreSearchRequest> try_ = request.toCore();
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CoreSearchRequest req = (CoreSearchRequest)success.value();
            return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchAsync(indexName, req, options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable & scala.Serializable)() -> this.searchOps().searchQueryAsync(indexName, query.toCore(), options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.couchbaseOps().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(core.diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), core.context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            CompletableFuture future = HealthPinger.ping((Core)core, OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
            return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.couchbaseOps().waitUntilReady(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            core.initGlobalConfig();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$1) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.searchOps = this.couchbaseOps().searchOps(null);
        this.queryOps = this.couchbaseOps().queryOps();
    }
}

