/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.scala.ReactiveCollection;
import com.couchbase.client.scala.ReactiveScope;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.transactions.TransactionGetResult;
import com.couchbase.client.scala.transactions.TransactionGetResult$;
import com.couchbase.client.scala.transactions.TransactionQueryOptions;
import com.couchbase.client.scala.transactions.TransactionQueryResult;
import com.couchbase.client.scala.transactions.TransactionQueryResult$;
import com.couchbase.client.scala.transactions.internal.EncodingUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001\u0002\u0007\u000e\u0001aA\u0011B\b\u0001\u0003\u0006\u0004%\t!E\u0010\t\u0011!\u0002!\u0011!Q\u0001\n\u0001Ba!\u000b\u0001\u0005\u0002=Q\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"\u0002)\u0001\t\u0003\t\u0006\"B6\u0001\t\u0003a\u0007\"\u0002<\u0001\t\u00039\b\"B?\u0001\t\u0003q\bBB?\u0001\t\u0003\tY\u0001\u0003\u0004~\u0001\u0011\u0005\u0011\u0011\u0004\u0005\u0007{\u0002!\t!a\n\u0003CI+\u0017m\u0019;jm\u0016$&/\u00198tC\u000e$\u0018n\u001c8BiR,W\u000e\u001d;D_:$X\r\u001f;\u000b\u00059y\u0011\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001c(B\u0001\t\u0012\u0003\u0015\u00198-\u00197b\u0015\t\u00112#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003)U\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003Y\t1aY8n\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iaR\"A\u000e\u000b\u0003AI!!H\u000e\u0003\r\u0005s\u0017PU3g\u0003!Ig\u000e^3s]\u0006dW#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013a\u0003;sC:\u001c\u0018m\u0019;j_:T!!J\t\u0002\t\r|'/Z\u0005\u0003O\t\u0012QdQ8sKR\u0013\u0018M\\:bGRLwN\\!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\nS:$XM\u001d8bY\u0002\na\u0001P5oSRtDCA\u0016.!\ta\u0003!D\u0001\u000e\u0011\u0015q2\u00011\u0001!\u0003\r9W\r\u001e\u000b\u0004au\u001a\u0005cA\u00199u5\t!G\u0003\u00024i\u0005I\u0001/\u001e2mSNDWM\u001d\u0006\u0003!UR!!\n\u001c\u000b\u0003]\nqA]3bGR|'/\u0003\u0002:e\t)1+T8o_B\u0011AfO\u0005\u0003y5\u0011A\u0003\u0016:b]N\f7\r^5p]\u001e+GOU3tk2$\b\"\u0002 \u0005\u0001\u0004y\u0014AC2pY2,7\r^5p]B\u0011\u0001)Q\u0007\u0002\u001f%\u0011!i\u0004\u0002\u0013%\u0016\f7\r^5wK\u000e{G\u000e\\3di&|g\u000eC\u0003E\t\u0001\u0007Q)\u0001\u0002jIB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001S\u000e\u000e\u0003%S!AS\f\u0002\rq\u0012xn\u001c;?\u0013\ta5$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'\u001c\u0003\u0019Ign]3siV\u0011!K\u0018\u000b\u0005'\u001eD\u0017\u000e\u0006\u00021)\")Q+\u0002a\u0002-\u0006Q1/\u001a:jC2L'0\u001a:\u0011\u0007]SF,D\u0001Y\u0015\tIv\"A\u0003d_\u0012,7-\u0003\u0002\\1\nq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA/_\u0019\u0001!QaX\u0003C\u0002\u0001\u0014\u0011\u0001V\t\u0003C\u0012\u0004\"A\u00072\n\u0005\r\\\"a\u0002(pi\"Lgn\u001a\t\u00035\u0015L!AZ\u000e\u0003\u0007\u0005s\u0017\u0010C\u0003?\u000b\u0001\u0007q\bC\u0003E\u000b\u0001\u0007Q\tC\u0003k\u000b\u0001\u0007A,A\u0004d_:$XM\u001c;\u0002\u000fI,\u0007\u000f\\1dKV\u0011QN\u001d\u000b\u0004]N,HC\u0001\u0019p\u0011\u0015)f\u0001q\u0001q!\r9&,\u001d\t\u0003;J$Qa\u0018\u0004C\u0002\u0001DQ\u0001\u001e\u0004A\u0002i\n1\u0001Z8d\u0011\u0015Qg\u00011\u0001r\u0003\u0019\u0011X-\\8wKR\u0011\u0001\u0010 \t\u0004caJ\bC\u0001\u000e{\u0013\tY8D\u0001\u0003V]&$\b\"\u0002;\b\u0001\u0004Q\u0014!B9vKJLHcA@\u0002\bA!\u0011\u0007OA\u0001!\ra\u00131A\u0005\u0004\u0003\u000bi!A\u0006+sC:\u001c\u0018m\u0019;j_:\fV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\r\u0005%\u0001\u00021\u0001F\u0003%\u0019H/\u0019;f[\u0016tG\u000fF\u0003\u0000\u0003\u001b\ty\u0001\u0003\u0004\u0002\n%\u0001\r!\u0012\u0005\b\u0003#I\u0001\u0019AA\n\u0003\u001dy\u0007\u000f^5p]N\u00042\u0001LA\u000b\u0013\r\t9\"\u0004\u0002\u0018)J\fgn]1di&|g.U;fef|\u0005\u000f^5p]N$Ra`A\u000e\u0003KAq!!\b\u000b\u0001\u0004\ty\"A\u0003tG>\u0004X\rE\u0002A\u0003CI1!a\t\u0010\u00055\u0011V-Y2uSZ,7kY8qK\"1\u0011\u0011\u0002\u0006A\u0002\u0015#ra`A\u0015\u0003W\ti\u0003C\u0004\u0002\u001e-\u0001\r!a\b\t\r\u0005%1\u00021\u0001F\u0011\u001d\t\tb\u0003a\u0001\u0003'\u0001")
public class ReactiveTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;

    public CoreTransactionAttemptContext internal() {
        return this.internal;
    }

    public SMono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().get(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$);
    }

    public <T> SMono<TransactionGetResult> insert(ReactiveCollection collection, String id, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_insert", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return SMono$.MODULE$.raiseError(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().insert(collection.collectionIdentifier(), id, encoded, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$).doOnError((Function1 & Serializable & scala.Serializable)x$1 -> {
                span.status(RequestSpan.StatusCode.ERROR);
                return BoxedUnit.UNIT;
            }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> span.end());
        }
        throw new MatchError(try_);
    }

    public <T> SMono<TransactionGetResult> replace(TransactionGetResult doc, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_replace", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return SMono$.MODULE$.raiseError(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().replace(doc.internal(), encoded, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$).doOnError((Function1 & Serializable & scala.Serializable)x$2 -> {
                span.status(RequestSpan.StatusCode.ERROR);
                return BoxedUnit.UNIT;
            }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> span.end());
        }
        throw new MatchError(try_);
    }

    public SMono<BoxedUnit> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_remove", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().remove(doc.internal(), new SpanWrapper(span))).doOnError((Function1 & Serializable & scala.Serializable)x$3 -> {
            span.status(RequestSpan.StatusCode.ERROR);
            return BoxedUnit.UNIT;
        }).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> span.end()).then();
    }

    public SMono<TransactionQueryResult> query(String statement) {
        return this.query(null, statement, null);
    }

    public SMono<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public SMono<TransactionQueryResult> query(ReactiveScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public SMono<TransactionQueryResult> query(ReactiveScope scope, String statement, TransactionQueryOptions options) {
        CoreQueryOptions opts = (CoreQueryOptions)Option$.MODULE$.apply((Object)options).map((Function1 & Serializable & scala.Serializable)v -> v.toCore()).orNull(Predef$.MODULE$.$conforms());
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.internal().queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), opts, false)).publishOn(this.internal().core().context().environment().transactionsSchedulers().schedulerBlocking()).map((Function1)TransactionQueryResult$.MODULE$);
    }

    public ReactiveTransactionAttemptContext(CoreTransactionAttemptContext internal) {
        this.internal = internal;
    }
}

