/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonDeserializer$IntConvert$;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonSerializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.datastructures.CouchbaseBuffer$;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions$;
import com.couchbase.client.scala.json.JsonArraySafe;
import com.couchbase.client.scala.json.JsonArraySafe$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.RemoveOptions$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0015+\u0001UB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\ty\u0001\u0011\t\u0011)A\u00051\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015a\u0003f\u0011!Y\u0007A!A!\u0002\u0017a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b1\u00029\t\u000bY\u0004A\u0011A<\t\u0013\u0005\u0005\u0001A1A\u0005\u0012\u0005\r\u0001bBA\u0003\u0001\u0001\u0006I\u0001\u0019\u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u00033\u0001!\u0019!C\u0005\u00037A\u0001\"a\t\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002j\u0001!I!a\u001b\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"9\u00111\u0014\u0001\u0005\u0002\u0005u\u0005bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!a0\u0001\t\u0003\n\t\rC\u0004\u0002T\u0002!\t%!6\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\"9\u0011\u0011\u001d\u0001\u0005B\u0005\r\bbBAu\u0001\u0011\u0005\u00131\u001e\u0005\b\u0003c\u0004A\u0011IAR\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!!?\u0001\t\u0003\nYpB\u0005\u0003\n)\n\t\u0011#\u0001\u0003\f\u0019A\u0011FKA\u0001\u0012\u0003\u0011i\u0001\u0003\u0004wM\u0011\u0005!Q\u0003\u0005\n\u0005/1\u0013\u0013!C\u0001\u00053\u0011qbQ8vG\"\u0014\u0017m]3Ck\u001a4WM\u001d\u0006\u0003W1\na\u0002Z1uCN$(/^2ukJ,7O\u0003\u0002.]\u0005)1oY1mC*\u0011q\u0006M\u0001\u0007G2LWM\u001c;\u000b\u0005E\u0012\u0014!C2pk\u000eD'-Y:f\u0015\u0005\u0019\u0014aA2p[\u000e\u0001QC\u0001\u001cC'\t\u0001q\u0007E\u00029}\u0001k\u0011!\u000f\u0006\u0003um\nq!\\;uC\ndWM\u0003\u0002={\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00035J!aP\u001d\u0003\u001d\u0005\u00137\u000f\u001e:bGR\u0014UO\u001a4feB\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019\u0005A1\u0001E\u0005\u0005!\u0016CA#J!\t1u)D\u0001>\u0013\tAUHA\u0004O_RD\u0017N\\4\u0011\u0005\u0019S\u0015BA&>\u0005\r\te._\u0001\u0003S\u0012\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)>\u001b\u0005\t&B\u0001*5\u0003\u0019a$o\\8u}%\u0011A+P\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U{A\u0011\u0011LW\u0007\u0002Y%\u00111\f\f\u0002\u000b\u0007>dG.Z2uS>t\u0017aB8qi&|gn\u001d\t\u0004\rz\u0003\u0017BA0>\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011MY\u0007\u0002U%\u00111M\u000b\u0002\u001b\u0007>,8\r\u001b2bg\u0016\u001cu\u000e\u001c7fGRLwN\\(qi&|gn]\u0001\u0007I\u0016\u001cw\u000eZ3\u0011\u0007\u0019L\u0007)D\u0001h\u0015\tAG&A\u0003d_\u0012,7-\u0003\u0002kO\n\u0001\"j]8o\t\u0016\u001cXM]5bY&TXM]\u0001\u0007K:\u001cw\u000eZ3\u0011\u0007\u0019l\u0007)\u0003\u0002oO\nq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018a\u0001;bOB\u0019\u0011\u000f\u001e!\u000e\u0003IT!a]\u001f\u0002\u000fI,g\r\\3di&\u0011QO\u001d\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"B\u0001_?\u007f\u007fR!\u0011P_>}!\r\t\u0007\u0001\u0011\u0005\u0006I\u001e\u0001\u001d!\u001a\u0005\u0006W\u001e\u0001\u001d\u0001\u001c\u0005\u0006_\u001e\u0001\u001d\u0001\u001d\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006y\u001d\u0001\r\u0001\u0017\u0005\b9\u001e\u0001\n\u00111\u0001^\u0003\u0011y\u0007\u000f^:\u0016\u0003\u0001\fQa\u001c9ug\u0002\nq\u0002\\8pWV\u0004\u0018J\\(qi&|gn]\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#a\u0013AA6w\u0013\u0011\t)\"a\u0004\u0003\u001f1{wn[;q\u0013:|\u0005\u000f^5p]N\f\u0001\u0003\\8pWV\u0004\u0018J\\(qi&|gn\u001d\u0011\u0002\u001f5,H/\u0019;f\u0013:|\u0005\u000f^5p]N,\"!!\b\u0011\t\u00055\u0011qD\u0005\u0005\u0003C\tyAA\bNkR\fG/Z%o\u001fB$\u0018n\u001c8t\u0003AiW\u000f^1uK&sw\n\u001d;j_:\u001c\b%\u0001\u0006hKR|\u0005\u000f^5p]N,\"!!\u000b\u0011\t\u00055\u00111F\u0005\u0005\u0003[\tyA\u0001\u0006HKR|\u0005\u000f^5p]N\f1bZ3u\u001fB$\u0018n\u001c8tA\u0005i\u0011N\\:feR|\u0005\u000f^5p]N,\"!!\u000e\u0011\t\u00055\u0011qG\u0005\u0005\u0003s\tyAA\u0007J]N,'\u000f^(qi&|gn]\u0001\u000fS:\u001cXM\u001d;PaRLwN\\:!\u00035\u0011X-\\8wK>\u0003H/[8ogV\u0011\u0011\u0011\t\t\u0005\u0003\u001b\t\u0019%\u0003\u0003\u0002F\u0005=!!\u0004*f[>4Xm\u00149uS>t7/\u0001\bsK6|g/Z(qi&|gn\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0001\u000bi\u0005C\u0004\u0002PQ\u0001\r!!\u0015\u0002\u000b%tG-\u001a=\u0011\u0007\u0019\u000b\u0019&C\u0002\u0002Vu\u00121!\u00138u\u0003!\u0011X-\\8wK\u0006#H\u0003BA.\u0003C\u00022ARA/\u0013\r\ty&\u0010\u0002\u0005+:LG\u000fC\u0004\u0002PU\u0001\r!!\u0015\u0002\rI,Wn\u001c<f)\r\u0001\u0015q\r\u0005\b\u0003\u001f2\u0002\u0019AA)\u0003Y\u0011X\r\u001e:z\u0013\u001a$un\u0019#pKNtu\u000e^#ySN$X\u0003BA7\u0003\u001b#B!a\u0017\u0002p!9\u0011\u0011O\fA\u0002\u0005M\u0014!\u00014\u0011\u000b\u0019\u000b)(!\u001f\n\u0007\u0005]THA\u0005Gk:\u001cG/[8oaA\"\u00111PAE!\u0019\ti(a!\u0002\b6\u0011\u0011q\u0010\u0006\u0004\u0003\u0003k\u0014\u0001B;uS2LA!!\"\u0002\u0000\t\u0019AK]=\u0011\u0007\u0005\u000bI\tB\u0006\u0002\f\u0006=\u0014\u0011!A\u0001\u0006\u0003!%aA0%c\u00111\u0011qR\fC\u0002\u0011\u0013\u0011aX\u0001\u0007CB\u0004XM\u001c3\u0015\t\u0005U\u0015qS\u0007\u0002\u0001!1\u0011\u0011\u0014\rA\u0002\u0001\u000bQA^1mk\u0016\fq\u0001\u001d:fa\u0016tG\r\u0006\u0003\u0002\u0016\u0006}\u0005BBAM3\u0001\u0007\u0001)\u0001\u0006j]&$\u0018.\u00197ju\u0016$\"!a\u0017\u0002\tML'0\u001a\u000b\u0003\u0003#\n1!\u00197m)\t\ti\u000bE\u0003\u00020\u0006e\u0006I\u0004\u0003\u00022\u0006Ufb\u0001)\u00024&\tQ&C\u0002\u00028v\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002<\u0006u&aA*fc*\u0019\u0011qW\u001f\u0002\u000f\u0019|'/Z1dQV!\u00111YAh)\u0011\tY&!2\t\u000f\u0005ET\u00041\u0001\u0002HB1a)!3A\u0003\u001bL1!a3>\u0005%1UO\\2uS>t\u0017\u0007E\u0002B\u0003\u001f$a!!5\u001e\u0005\u0004!%!A+\u0002\u0011%$XM]1u_J,\"!a6\u0011\u000b\u0005=\u0016\u0011\u001c!\n\t\u0005m\u0017Q\u0018\u0002\t\u0013R,'/\u0019;pe\u00061A.\u001a8hi\",\"!!\u0015\u0002\rU\u0004H-\u0019;f)\u0019\tY&!:\u0002h\"9\u0011q\n\u0011A\u0002\u0005E\u0003BBAMA\u0001\u0007\u0001)\u0001\u0005%a2,8\u000fJ3r)\u0011\t)*!<\t\r\u0005=\u0018\u00051\u0001A\u0003\u0011)G.Z7\u0002\u000b\rdW-\u0019:\u0002\u001d\u0011\u0002H.^:%KF$3m\u001c7p]R!\u0011QSA|\u0011\u0019\tyo\ta\u0001\u0001\u0006I\u0011N\\:feR\fE\u000e\u001c\u000b\u0007\u00037\ni0a@\t\u000f\u0005=C\u00051\u0001\u0002R!9!\u0011\u0001\u0013A\u0002\t\r\u0011A\u0002<bYV,7\u000fE\u0003\u00020\n\u0015\u0001)\u0003\u0003\u0003\b\u0005u&a\u0003+sCZ,'o]1cY\u0016\fqbQ8vG\"\u0014\u0017m]3Ck\u001a4WM\u001d\t\u0003C\u001a\u001a2A\nB\b!\r1%\u0011C\u0005\u0004\u0005'i$AB!osJ+g\r\u0006\u0002\u0003\f\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*BAa\u0007\u00032U\u0011!Q\u0004\u0016\u0004;\n}1F\u0001B\u0011!\u0011\u0011\u0019C!\f\u000e\u0005\t\u0015\"\u0002\u0002B\u0014\u0005S\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-R(\u0001\u0006b]:|G/\u0019;j_:LAAa\f\u0003&\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b\rC#\u0019\u0001#")
public class CouchbaseBuffer<T>
extends AbstractBuffer<T> {
    private final String id;
    private final Collection collection;
    private final JsonDeserializer<T> decode;
    private final JsonSerializer<T> encode;
    private final ClassTag<T> tag;
    private final CouchbaseCollectionOptions opts;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;
    private final GetOptions getOptions;
    private final InsertOptions insertOptions;
    private final RemoveOptions removeOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseBuffer$.MODULE$.$lessinit$greater$default$3();
    }

    public CouchbaseCollectionOptions opts() {
        return this.opts;
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    private GetOptions getOptions() {
        return this.getOptions;
    }

    private InsertOptions insertOptions() {
        return this.insertOptions;
    }

    private RemoveOptions removeOptions() {
        return this.removeOptions;
    }

    public T apply(int index) {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)((Seq)new .colon.colon((Object)LookupInSpec$.MODULE$.get(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$)), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable & scala.Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            return (T)value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            throw new IndexOutOfBoundsException(new StringBuilder(39).append("Index ").append(index).append(" out of bounds, with root cause: ").append(err.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public void removeAt(int index) {
        Throwable err;
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$)), this.mutateInOptions());
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err2 = failure.exception();
            if (err2 instanceof DocumentNotFoundException) {
                DocumentNotFoundException documentNotFoundException = (DocumentNotFoundException)err2;
                throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(documentNotFoundException.getMessage()).toString());
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            PathNotFoundException pathNotFoundException = (PathNotFoundException)err;
            throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(pathNotFoundException.getMessage()).toString());
        }
        if (bl) {
            Throwable err3 = failure.exception();
            throw err3;
        }
        throw new MatchError(try_);
    }

    public T remove(int index) {
        Throwable err;
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)((Seq)new .colon.colon((Object)LookupInSpec$.MODULE$.get(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$)), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable & scala.Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            Try<MutateInResult> mutateResult = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$)), this.mutateInOptions().cas(((LookupInResult)op.get()).cas()));
            boolean bl2 = false;
            Failure failure2 = null;
            Try<MutateInResult> try_2 = mutateResult;
            if (try_2 instanceof Success) {
                return (T)value;
            }
            if (try_2 instanceof Failure) {
                bl2 = true;
                failure2 = (Failure)try_2;
                Throwable err2 = failure2.exception();
                if (err2 instanceof CasMismatchException) {
                    return this.remove(index);
                }
            }
            if (bl2) {
                Throwable err3 = failure2.exception();
                throw new CouchbaseException(new StringBuilder(51).append("Found element at index ").append(index).append(" but was unable to remove it").toString(), err3);
            }
            throw new MatchError(try_2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err4 = failure.exception();
            if (err4 instanceof DocumentNotFoundException) {
                DocumentNotFoundException documentNotFoundException = (DocumentNotFoundException)err4;
                throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(documentNotFoundException.getMessage()).toString());
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            PathNotFoundException pathNotFoundException = (PathNotFoundException)err;
            throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(pathNotFoundException.getMessage()).toString());
        }
        if (bl) {
            Throwable err5 = failure.exception();
            throw err5;
        }
        throw new MatchError((Object)try_);
    }

    private <_> void retryIfDocDoesNotExist(Function0<Try<?>> f) {
        block2: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                Try result = (Try)f.apply();
                bl = false;
                failure = null;
                try_ = result;
                if (try_ instanceof Success) break block2;
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                if (!(failure.exception() instanceof DocumentNotFoundException)) break;
                this.initialize();
            }
            if (bl) {
                Throwable err = failure.exception();
                throw err;
            }
            throw new MatchError((Object)try_);
        }
    }

    public CouchbaseBuffer<T> append(T value) {
        Function0 & Serializable & scala.Serializable f = (Function0 & Serializable & scala.Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAppend("", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), $this.encode), (List)Nil$.MODULE$)), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    public CouchbaseBuffer<T> prepend(T value) {
        Function0 & Serializable & scala.Serializable f = (Function0 & Serializable & scala.Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayPrepend("", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), $this.encode), (List)Nil$.MODULE$)), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    private void initialize() {
        this.collection.insert(this.id, JsonArraySafe$.MODULE$.create(), this.insertOptions(), JsonSerializer$JsonArraySafeConvert$.MODULE$).get();
    }

    public int size() {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)((Seq)new .colon.colon((Object)LookupInSpec$.MODULE$.count(""), (List)Nil$.MODULE$)), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable & scala.Serializable)result -> result.contentAs(0, JsonDeserializer$IntConvert$.MODULE$, ClassTag$.MODULE$.Int()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            return count;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return 0;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    private Seq<T> all() {
        Success success;
        Seq values;
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable & scala.Serializable)array -> array.toSeq());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (Seq)(success = (Success)try_).value()) != null) {
            Seq seq = values;
            return seq;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return (Seq)Nil$.MODULE$;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public <U> void foreach(Function1<T, U> f) {
        this.all().foreach(f);
    }

    public Iterator<T> iterator() {
        return this.all().iterator();
    }

    public int length() {
        return this.size();
    }

    public void update(int index, T value) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.replace(new StringBuilder(2).append("[").append(index).append("]").toString(), value, this.encode), (List)Nil$.MODULE$)), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PathNotFoundException) {
                throw new IndexOutOfBoundsException();
            }
        }
        if (bl && failure.exception() instanceof DocumentNotFoundException) {
            this.initialize();
            this.update(index, value);
            return;
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public CouchbaseBuffer<T> $plus$eq(T elem) {
        return this.append(elem);
    }

    public void clear() {
        boolean bl = false;
        Failure failure = null;
        Try<MutationResult> try_ = this.collection.remove(this.id, this.removeOptions());
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
    }

    public CouchbaseBuffer<T> $plus$eq$colon(T elem) {
        return this.prepend(elem);
    }

    public void insertAll(int index, Traversable<T> values) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAppend(new StringBuilder(2).append("[").append(index).append("]").toString(), values.toSeq(), this.encode), (List)Nil$.MODULE$)), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                this.initialize();
                this.insertAll(index, values);
                return;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public CouchbaseBuffer(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode, ClassTag<T> tag) {
        CouchbaseCollectionOptions couchbaseCollectionOptions;
        this.id = id;
        this.collection = collection;
        this.decode = decode;
        this.encode = encode;
        this.tag = tag;
        Option<CouchbaseCollectionOptions> option = options;
        if (option instanceof Some) {
            CouchbaseCollectionOptions v;
            Some some = (Some)option;
            couchbaseCollectionOptions = v = (CouchbaseCollectionOptions)some.value();
        } else {
            couchbaseCollectionOptions = CouchbaseCollectionOptions$.MODULE$.apply(collection, CouchbaseCollectionOptions$.MODULE$.apply$default$2());
        }
        this.opts = couchbaseCollectionOptions;
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.getOptions = new GetOptions(GetOptions$.MODULE$.apply$default$1(), GetOptions$.MODULE$.apply$default$2(), GetOptions$.MODULE$.apply$default$3(), GetOptions$.MODULE$.apply$default$4(), GetOptions$.MODULE$.apply$default$5(), GetOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.insertOptions = new InsertOptions(InsertOptions$.MODULE$.apply$default$1(), InsertOptions$.MODULE$.apply$default$2(), InsertOptions$.MODULE$.apply$default$3(), InsertOptions$.MODULE$.apply$default$4(), InsertOptions$.MODULE$.apply$default$5(), InsertOptions$.MODULE$.apply$default$6(), InsertOptions$.MODULE$.apply$default$7()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.removeOptions = new RemoveOptions(RemoveOptions$.MODULE$.apply$default$1(), RemoveOptions$.MODULE$.apply$default$2(), RemoveOptions$.MODULE$.apply$default$3(), RemoveOptions$.MODULE$.apply$default$4(), RemoveOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

