/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchResult$;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rMg\u0001\u0002$H\u0001AC\u0001B\u0016\u0001\u0003\u0002\u0013\u0006Ia\u0016\u0005\nA\u0002\u0011)\u0019!C\u0001\u000f\u0006D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\nU\u0002\u0011)\u0019!C\u0001\u000f.D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\tu\u0002\u0011\r\u0011b\u0001Hw\"9\u0011Q\u0001\u0001!\u0002\u0013a\b\u0002C/\u0001\u0005\u0004%\t!a\u0002\t\u000f\u0005%\u0001\u0001)A\u00055\"Ia\r\u0001b\u0001\n\u0003Y\u00151\u0002\u0005\t\u0003+\u0001\u0001\u0015!\u0003\u0002\u000e!Q\u0011q\u0003\u0001C\u0002\u0013\u0005q)!\u0007\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u00037A!\"!\u000b\u0001\u0005\u0004%\taRA\u0016\u0011!\t\u0019\u0004\u0001Q\u0001\n\u00055\u0002BCA\u001b\u0001\t\u0007I\u0011A$\u00028!A\u0011Q\t\u0001!\u0002\u0013\tI\u0004\u0003\u0006\u0002H\u0001\u0011\r\u0011\"\u0001H\u0003oA\u0001\"!\u0013\u0001A\u0003%\u0011\u0011\b\u0005\u000b\u0003\u0017\u0002!\u0019!C\u0001\u000f\u00065\u0003\u0002CA.\u0001\u0001\u0006I!a\u0014\t\u0015\u0005u\u0003A1A\u0005\u0002\u001d\u000by\u0006\u0003\u0005\u0002r\u0001\u0001\u000b\u0011BA1\u0011)\t\u0019\b\u0001b\u0001\n\u00039\u0015Q\u000f\u0005\t\u0003\u0007\u0003\u0001\u0015!\u0003\u0002x!Y\u0011Q\u0011\u0001\t\u0006\u0004%\taRAD\u0011-\tI\n\u0001EC\u0002\u0013\u0005q)a'\t\u0017\u0005%\u0006\u0001#b\u0001\n\u00039\u00151\u0016\u0005\u000b\u0003s\u0003!\u0019!C\u0001\u000f\u0006m\u0006\u0002CAd\u0001\u0001\u0006I!!0\t\u0015\u0005%\u0007\u0001#b\u0001\n\u0003\tY\r\u0003\u0006\u0002T\u0002A)\u0019!C\u0001\u0003+D!\"!8\u0001\u0011\u000b\u0007I\u0011AAp\u0011)\tY\u000f\u0001EC\u0002\u0013\u0005\u0011Q\u001e\u0005\u000b\u0003s\u0004\u0001R1A\u0005\u0002\u0005m\bB\u0003B\u0002\u0001!\u0015\r\u0011\"\u0001\u0003\u0006!9\u00111\u0015\u0001\u0005\u0002\t%\u0002bBA6\u0001\u0011\u0005!1\n\u0005\b\u0003W\u0002A\u0011\u0001B5\u0011%\u0011)\tAI\u0001\n\u0003\u00119\tC\u0005\u0003\u001c\u0002\t\n\u0011\"\u0001\u0003\u001e\"I!\u0011\u0015\u0001\u0012\u0002\u0013\u0005!1\u0015\u0005\b\u0005O\u0003A\u0011\u0001BU\u0011\u001d\u00119\u000b\u0001C\u0001\u0005\u0003D\u0011Ba4\u0001#\u0003%\tA!5\t\u0013\tU\u0007!%A\u0005\u0002\tu\u0005b\u0002Bl\u0001\u0011\u0005!\u0011\u001c\u0005\b\u0005/\u0004A\u0011AB\u0004\u0011%\u0019y\u0001AI\u0001\n\u0003\u0011i\nC\u0004\u0004\u0012\u0001!\taa\u0005\t\u0013\r}\u0001!%A\u0005\u0002\tu\u0005bBB\u0011\u0001\u0011\u000511\u0005\u0005\n\u0007k\u0001\u0011\u0013!C\u0001\u0007oAqa!\t\u0001\t\u0003\u0019Y\u0004C\u0004\u0004J\u0001!\taa\u0013\t\u0013\ru\u0003!%A\u0005\u0002\r}\u0003bBB%\u0001\u0011\u000511\r\u0005\b\u0007[\u0002A\u0011AB8\u0011\u001d\u0019i\u0007\u0001C\u0001\u0007gB\u0001ba \u0001\t\u000395\u0011Q\u0004\b\u0007\u0007;\u0005\u0012ABC\r\u00191u\t#\u0001\u0004\b\"11o\u0010C\u0001\u0007\u0013Cqaa#@\t\u0003\u0019i\tC\u0004\u0004\f~\"\taa)\t\u000f\r-u\b\"\u0001\u00040\"A11Y \u0005\u0002%\u001b)\r\u0003\u0005\u0004D~\"\t!SBh\u00051\t5/\u001f8d\u00072,8\u000f^3s\u0015\tA\u0015*A\u0003tG\u0006d\u0017M\u0003\u0002K\u0017\u000611\r\\5f]RT!\u0001T'\u0002\u0013\r|Wo\u00195cCN,'\"\u0001(\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0006C\u0001*U\u001b\u0005\u0019&\"\u0001%\n\u0005U\u001b&AB!osJ+g-A\u0006f]ZL'o\u001c8nK:$\bc\u0001*Y5&\u0011\u0011l\u0015\u0002\ty\tLh.Y7f}A\u00111LX\u0007\u00029*\u0011QlR\u0001\u0004K:4\u0018BA0]\u0005I\u0019E.^:uKJ,eN^5s_:lWM\u001c;\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^8s+\u0005\u0011\u0007CA2h\u001b\u0005!'BA/f\u0015\t1\u0017*\u0001\u0003d_J,\u0017B\u00015e\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\u0006q\u0011-\u001e;iK:$\u0018nY1u_J\u0004\u0013\u0001E2p]:,7\r^5p]N#(/\u001b8h+\u0005a\u0007CA7q\u001b\u0005q'BA8f\u0003\u0011)H/\u001b7\n\u0005Et'\u0001E\"p]:,7\r^5p]N#(/\u001b8h\u0003E\u0019wN\u001c8fGRLwN\\*ue&tw\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tU<\b0\u001f\t\u0003m\u0002i\u0011a\u0012\u0005\u0007-\u001a!\t\u0019A,\t\u000b\u00014\u0001\u0019\u00012\t\u000b)4\u0001\u0019\u00017\u0002\u0005\u0015\u001cW#\u0001?\u0011\u0007u\f\t!D\u0001\u007f\u0015\ty8+\u0001\u0006d_:\u001cWO\u001d:f]RL1!a\u0001\u007f\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002*\u0012AW\u0001\u0005K:4\b%\u0006\u0002\u0002\u000eA!\u0011qBA\t\u001b\u0005)\u0017bAA\nK\n!1i\u001c:f\u0003\u0015\u0019wN]3!\u00031\u0019w.^2iE\u0006\u001cXm\u00149t+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t#Z\u0001\u0004CBL\u0017\u0002BA\u0013\u0003?\u0011\u0001cQ8sK\u000e{Wo\u00195cCN,w\n]:\u0002\u001b\r|Wo\u00195cCN,w\n]:!\u0003\tA\u0007/\u0006\u0002\u0002.A\u0019a/a\f\n\u0007\u0005ErI\u0001\nIC:$G.\u001a:CCNL7\rU1sC6\u001c\u0018a\u00015qA\u0005i1/Z1sG\"$\u0016.\\3pkR,\"!!\u000f\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u007f\u0003!!WO]1uS>t\u0017\u0002BA\"\u0003{\u0011\u0001\u0002R;sCRLwN\\\u0001\u000fg\u0016\f'o\u00195US6,w.\u001e;!\u0003A\tg.\u00197zi&\u001c7\u000fV5nK>,H/A\tb]\u0006d\u0017\u0010^5dgRKW.Z8vi\u0002\nQB]3uef\u001cFO]1uK\u001eLXCAA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+K\u0006)!/\u001a;ss&!\u0011\u0011LA*\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\u0006q!/\u001a;ssN#(/\u0019;fOf\u0004\u0013\u0001E1oC2LH/[2t\u0011\u0006tG\r\\3s+\t\t\t\u0007\u0005\u0003\u0002d\u00055TBAA3\u0015\u0011\t9'!\u001b\u0002\u0011!\fg\u000e\u001a7feNT1!a\u001bH\u0003\u0015\tX/\u001a:z\u0013\u0011\ty'!\u001a\u0003!\u0005s\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014\u0018!E1oC2LH/[2t\u0011\u0006tG\r\\3sA\u0005I1/Z1sG\"|\u0005o]\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0005\u0003{\ny\"\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0003\u0003\u000bYHA\u0007D_J,7+Z1sG\"|\u0005o]\u0001\u000bg\u0016\f'o\u00195PaN\u0004\u0013a\u0005:fC\u000e$\u0018N^3Vg\u0016\u0014X*\u00198bO\u0016\u0014XCAAE!\u0011\tY)!&\u000e\u0005\u00055%\u0002BAH\u0003#\u000bA!^:fe*\u0019\u00111S$\u0002\u000f5\fg.Y4fe&!\u0011qSAG\u0005M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0003U\u0011X-Y2uSZ,')^2lKRl\u0015M\\1hKJ,\"!!(\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CSA!a)\u0002\u0012\u00061!-^2lKRLA!a*\u0002\"\n)\"+Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014\u0018!\b:fC\u000e$\u0018N^3B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0016\u0005\u00055\u0006\u0003BAX\u0003kk!!!-\u000b\t\u0005M\u0016\u0011S\u0001\nC:\fG.\u001f;jGNLA!a.\u00022\ni\"+Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/\u0001\u0005rk\u0016\u0014\u0018p\u00149t+\t\ti\f\u0005\u0003\u0002@\u0006\rWBAAa\u0015\u0011\tY'a\b\n\t\u0005\u0015\u0017\u0011\u0019\u0002\r\u0007>\u0014X-U;fef|\u0005o]\u0001\ncV,'/_(qg\u0002\nqAY;dW\u0016$8/\u0006\u0002\u0002NB!\u0011qTAh\u0013\u0011\t\t.!)\u0003%\u0005\u001b\u0018P\\2Ck\u000e\\W\r^'b]\u0006<WM]\u0001\u0006kN,'o]\u000b\u0003\u0003/\u0004B!a#\u0002Z&!\u00111\\AG\u0005A\t5/\u001f8d+N,'/T1oC\u001e,'/\u0001\u0007rk\u0016\u0014\u00180\u00138eKb,7/\u0006\u0002\u0002bB!\u00111]At\u001b\t\t)O\u0003\u0003\u0002l\u0005E\u0015\u0002BAu\u0003K\u0014a#Q:z]\u000e\fV/\u001a:z\u0013:$W\r_'b]\u0006<WM]\u0001\u000eg\u0016\f'o\u00195J]\u0012,\u00070Z:\u0016\u0005\u0005=\b\u0003BAy\u0003kl!!a=\u000b\t\u0005u\u0014\u0011S\u0005\u0005\u0003o\f\u0019PA\fBgft7mU3be\u000eD\u0017J\u001c3fq6\u000bg.Y4fe\u0006\u0001\u0012M\\1msRL7m]%oI\u0016DXm]\u000b\u0003\u0003{\u0004B!a,\u0002\u0000&!!\u0011AAY\u0005i\t5/\u001f8d\u0003:\fG.\u001f;jGNLe\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003E)g/\u001a8uS:<g)\u001e8di&|gn]\u000b\u0003\u0005\u000f\u0001BA!\u0003\u0003\u00105\u0011!1\u0002\u0006\u0005\u0005\u001b\t\t*\u0001\u0005fm\u0016tG/\u001b8h\u0013\u0011\u0011\tBa\u0003\u00039\u0005\u001b\u0018P\\2Fm\u0016tG/\u001b8h\rVt7\r^5p]6\u000bg.Y4fe\"\u001aQE!\u0006\u0011\t\t]!1\u0005\b\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!QD3\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\"\tm\u0011!C*uC\nLG.\u001b;z\u0013\u0011\u0011)Ca\n\u0003\u0017Us7m\\7nSR$X\r\u001a\u0006\u0005\u0005C\u0011Y\u0002\u0006\u0003\u0003,\tE\u0002c\u0001<\u0003.%\u0019!qF$\u0003\u0017\u0005\u001b\u0018P\\2Ck\u000e\\W\r\u001e\u0005\b\u0005g1\u0003\u0019\u0001B\u001b\u0003)\u0011WoY6fi:\u000bW.\u001a\t\u0005\u0005o\u0011)E\u0004\u0003\u0003:\t\u0005\u0003c\u0001B\u001e'6\u0011!Q\b\u0006\u0004\u0005\u007fy\u0015A\u0002\u001fs_>$h(C\u0002\u0003DM\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B$\u0005\u0013\u0012aa\u0015;sS:<'b\u0001B\"'R1!Q\nB.\u0005?\u0002R! B(\u0005'J1A!\u0015\u007f\u0005\u00191U\u000f^;sKB!!Q\u000bB,\u001b\t\tI'\u0003\u0003\u0003Z\u0005%$aC)vKJL(+Z:vYRDqA!\u0018(\u0001\u0004\u0011)$A\u0005ti\u0006$X-\\3oi\"9!\u0011M\u0014A\u0002\t\r\u0014aB8qi&|gn\u001d\t\u0005\u0005+\u0012)'\u0003\u0003\u0003h\u0005%$\u0001D)vKJLx\n\u001d;j_:\u001cHC\u0003B'\u0005W\u0012iGa\u001e\u0003|!9!Q\f\u0015A\u0002\tU\u0002\"\u0003B8QA\u0005\t\u0019\u0001B9\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0005+\u0012\u0019(\u0003\u0003\u0003v\u0005%$aD)vKJL\b+\u0019:b[\u0016$XM]:\t\u0013\te\u0004\u0006%AA\u0002\u0005e\u0012a\u0002;j[\u0016|W\u000f\u001e\u0005\n\u0005{B\u0003\u0013!a\u0001\u0005\u007f\nQ!\u00193i_\u000e\u00042A\u0015BA\u0013\r\u0011\u0019i\u0015\u0002\b\u0005>|G.Z1o\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001BEU\u0011\u0011\tHa#,\u0005\t5\u0005\u0003\u0002BH\u0005/k!A!%\u000b\t\tM%QS\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\bT\u0013\u0011\u0011IJ!%\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yJ\u000b\u0003\u0002:\t-\u0015aD9vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0015&\u0006\u0002B@\u0005\u0017\u000ba\"\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0003,\n]&\u0011\u0018\t\u0006{\n=#Q\u0016\t\u0005\u0005_\u0013\u0019,\u0004\u0002\u00032*\u0019\u00111W$\n\t\tU&\u0011\u0017\u0002\u0010\u0003:\fG.\u001f;jGN\u0014Vm];mi\"9!Q\f\u0017A\u0002\tU\u0002b\u0002B1Y\u0001\u0007!1\u0018\t\u0005\u0005_\u0013i,\u0003\u0003\u0003@\nE&\u0001E!oC2LH/[2t\u001fB$\u0018n\u001c8t)!\u0011YKa1\u0003F\n5\u0007b\u0002B/[\u0001\u0007!Q\u0007\u0005\n\u0005_j\u0003\u0013!a\u0001\u0005\u000f\u0004BAa,\u0003J&!!1\u001aBY\u0005M\te.\u00197zi&\u001c7\u000fU1sC6,G/\u001a:t\u0011%\u0011I(\fI\u0001\u0002\u0004\tI$\u0001\rb]\u0006d\u0017\u0010^5dgF+XM]=%I\u00164\u0017-\u001e7uII*\"Aa5+\t\t\u001d'1R\u0001\u0019C:\fG.\u001f;jGN\fV/\u001a:zI\u0011,g-Y;mi\u0012\u001a\u0014aC:fCJ\u001c\u0007.U;fef$\u0002Ba7\u0003l\n=(Q \t\u0006{\n=#Q\u001c\t\u0005\u0005?\u00149/\u0004\u0002\u0003b*!!1\u001dBs\u0003\u0019\u0011Xm];mi*\u0019\u0011QP$\n\t\t%(\u0011\u001d\u0002\r'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\b\u0005[\u0004\u0004\u0019\u0001B\u001b\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0002lA\u0002\rA!=\u0011\t\tM(\u0011`\u0007\u0003\u0005kTAAa>\u0003f\u00069\u0011/^3sS\u0016\u001c\u0018\u0002\u0002B~\u0005k\u00141bU3be\u000eD\u0017+^3ss\"9!\u0011\r\u0019A\u0002\t}\b\u0003BB\u0001\u0007\u0007i!A!:\n\t\r\u0015!Q\u001d\u0002\u000e'\u0016\f'o\u00195PaRLwN\\:\u0015\u0011\tm7\u0011BB\u0006\u0007\u001bAqA!<2\u0001\u0004\u0011)\u0004C\u0004\u0002lE\u0002\rA!=\t\u0013\te\u0014\u0007%AA\u0002\u0005e\u0012!F:fCJ\u001c\u0007.U;fef$C-\u001a4bk2$HeM\u0001\u000bI&\u001c8m\u001c8oK\u000e$H\u0003BB\u000b\u0007;\u0001R! B(\u0007/\u00012AUB\r\u0013\r\u0019Yb\u0015\u0002\u0005+:LG\u000fC\u0005\u0003zM\u0002\n\u00111\u0001\u0002:\u0005!B-[:d_:tWm\u0019;%I\u00164\u0017-\u001e7uIE\n1\u0002Z5bO:|7\u000f^5dgR!1QEB\u0019!\u0015i(qJB\u0014!\u0011\u0019Ic!\f\u000e\u0005\r-\"bAB\u0011K&!1qFB\u0016\u0005E!\u0015.Y4o_N$\u0018nY:SKN,H\u000e\u001e\u0005\n\u0007g)\u0004\u0013!a\u0001\u0005k\t\u0001B]3q_J$\u0018\nZ\u0001\u0016I&\fwM\\8ti&\u001c7\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019ID\u000b\u0003\u00036\t-E\u0003BB\u0013\u0007{AqA!\u00198\u0001\u0004\u0019y\u0004\u0005\u0003\u0004B\r\u0015SBAB\"\u0015\r\u0019\tcR\u0005\u0005\u0007\u000f\u001a\u0019E\u0001\nES\u0006<gn\\:uS\u000e\u001cx\n\u001d;j_:\u001c\u0018\u0001\u00029j]\u001e$Ba!\u0014\u0004VA)QPa\u0014\u0004PA!1\u0011FB)\u0013\u0011\u0019\u0019fa\u000b\u0003\u0015AKgn\u001a*fgVdG\u000fC\u0005\u0003za\u0002\n\u00111\u0001\u0004XA)!k!\u0017\u0002:%\u001911L*\u0003\r=\u0003H/[8o\u00039\u0001\u0018N\\4%I\u00164\u0017-\u001e7uIE*\"a!\u0019+\t\r]#1\u0012\u000b\u0005\u0007\u001b\u001a)\u0007C\u0004\u0003bi\u0002\raa\u001a\u0011\t\r\u00053\u0011N\u0005\u0005\u0007W\u001a\u0019EA\u0006QS:<w\n\u001d;j_:\u001c\u0018AD<bSR,f\u000e^5m%\u0016\fG-\u001f\u000b\u0005\u0007+\u0019\t\bC\u0004\u0003zm\u0002\r!!\u000f\u0015\r\rU1QOB<\u0011\u001d\u0011I\b\u0010a\u0001\u0003sAqA!\u0019=\u0001\u0004\u0019I\b\u0005\u0003\u0004B\rm\u0014\u0002BB?\u0007\u0007\u0012QcV1jiVsG/\u001b7SK\u0006$\u0017p\u00149uS>t7/\u0001\u000bqKJ4wN]7HY>\u0014\u0017\r\\\"p]:,7\r\u001e\u000b\u0003\u0007/\tA\"Q:z]\u000e\u001cE.^:uKJ\u0004\"A^ \u0014\u0005}\nFCABC\u0003\u001d\u0019wN\u001c8fGR$\u0002ba$\u0004\u001a\u000em5q\u0014\t\u0006\u0007#\u001b)*^\u0007\u0003\u0007'S!a\\*\n\t\r]51\u0013\u0002\u0004)JL\bB\u00026B\u0001\u0004\u0011)\u0004C\u0004\u0004\u001e\u0006\u0003\rA!\u000e\u0002\u0011U\u001cXM\u001d8b[\u0016Dqa!)B\u0001\u0004\u0011)$\u0001\u0005qCN\u001cxo\u001c:e)\u0019\u0019yi!*\u0004(\"1!N\u0011a\u0001\u0005kAqA!\u0019C\u0001\u0004\u0019I\u000bE\u0002w\u0007WK1a!,H\u00059\u0019E.^:uKJ|\u0005\u000f^5p]N$baa$\u00042\u000e\u0005\u0007bBBZ\u0007\u0002\u00071QW\u0001\ng\u0016,GMT8eKN\u0004bAa\u000e\u00048\u000em\u0016\u0002BB]\u0005\u0013\u00121aU3u!\rY6QX\u0005\u0004\u0007\u007fc&\u0001C*fK\u0012tu\u000eZ3\t\u000f\t\u00054\t1\u0001\u0004*\u0006IR\r\u001f;sC\u000e$8\t\\;ti\u0016\u0014XI\u001c<je>tW.\u001a8u)\u0019\u00199m!3\u0004LB)1\u0011SBK5\"1!\u000e\u0012a\u0001\u0005kAqa!4E\u0001\u0004\u0019I+\u0001\u0003paR\u001cH\u0003BBd\u0007#Dqa!4F\u0001\u0004\u0019I\u000b")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final CoreCouchbaseOps couchbaseOps;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final AnalyticsHandler analyticsHandler;
    private final CoreSearchOps searchOps;
    private final CoreQueryOps queryOps;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveUserManager$lzycompute();
        }
        return this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            return this.analyticsHandler().queryAsync(request, this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return CoreCommonConverters$.MODULE$.convert(this.searchOps().searchQueryAsync(indexName, query.toCore(), options.toCore()), this.ec()).map((Function1 & Serializable & scala.Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.core().waitUntilReady(options.serviceTypes().isEmpty() ? null : (Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$1) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            core.initGlobalConfig();
        }
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchOps = this.core().searchOps(null);
        this.queryOps = this.core().queryOps();
    }
}

