/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathExistsException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonDeserializer$IntConvert$;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonSerializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions$;
import com.couchbase.client.scala.datastructures.CouchbaseSet$;
import com.couchbase.client.scala.json.JsonArraySafe;
import com.couchbase.client.scala.json.JsonArraySafe$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.AbstractSet;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001\u0002\u0010 \u0001)B\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\tc\u0001\u0011\t\u0011)A\u0005\u001b\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015a\u0003[\u0011!\u0001\u0007A!A!\u0002\u0017\t\u0007\"\u00023\u0001\t\u0003)\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007_\u0002\u0001\u000b\u0011B+\t\u000fA\u0004!\u0019!C\u0005c\"1\u0001\u0010\u0001Q\u0001\nIDq!\u001f\u0001C\u0002\u0013%!\u0010\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\tI\u0006\u0001C!\u00037Bq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000\u001dI\u00111Q\u0010\u0002\u0002#\u0005\u0011Q\u0011\u0004\t=}\t\t\u0011#\u0001\u0002\b\"1Am\u0007C\u0001\u0003\u001fC\u0011\"!%\u001c#\u0003%\t!a%\u0003\u0019\r{Wo\u00195cCN,7+\u001a;\u000b\u0005\u0001\n\u0013A\u00043bi\u0006\u001cHO];diV\u0014Xm\u001d\u0006\u0003E\r\nQa]2bY\u0006T!\u0001J\u0013\u0002\r\rd\u0017.\u001a8u\u0015\t1s%A\u0005d_V\u001c\u0007NY1tK*\t\u0001&A\u0002d_6\u001c\u0001!\u0006\u0002,oM\u0011\u0001\u0001\f\t\u0004[M*T\"\u0001\u0018\u000b\u0005=\u0002\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003cI\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0013B\u0001\u001b/\u0005-\t%m\u001d;sC\u000e$8+\u001a;\u0011\u0005Y:D\u0002\u0001\u0003\u0006q\u0001\u0011\r!\u000f\u0002\u0002)F\u0011!H\u0010\t\u0003wqj\u0011AM\u0005\u0003{I\u0012qAT8uQ&tw\r\u0005\u0002<\u007f%\u0011\u0001I\r\u0002\u0004\u0003:L\u0018AA5e!\t\u0019%J\u0004\u0002E\u0011B\u0011QIM\u0007\u0002\r*\u0011q)K\u0001\u0007yI|w\u000e\u001e \n\u0005%\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!\u0013\u001a\u0011\u00059{U\"A\u0011\n\u0005A\u000b#AC\"pY2,7\r^5p]\u00069q\u000e\u001d;j_:\u001c\bcA\u001eT+&\u0011AK\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Y;V\"A\u0010\n\u0005a{\"AG\"pk\u000eD'-Y:f\u0007>dG.Z2uS>tw\n\u001d;j_:\u001c\u0018A\u00023fG>$W\rE\u0002\\=Vj\u0011\u0001\u0018\u0006\u0003;\u0006\nQaY8eK\u000eL!a\u0018/\u0003!)\u001bxN\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AB3oG>$W\rE\u0002\\EVJ!a\u0019/\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>fe\u00061A(\u001b8jiz\"BA\u001a6lYR\u0019q\r[5\u0011\u0007Y\u0003Q\u0007C\u0003Z\r\u0001\u000f!\fC\u0003a\r\u0001\u000f\u0011\rC\u0003B\r\u0001\u0007!\tC\u00032\r\u0001\u0007Q\nC\u0004R\rA\u0005\t\u0019\u0001*\u0002\t=\u0004Ho]\u000b\u0002+\u0006)q\u000e\u001d;tA\u0005yAn\\8lkBLen\u00149uS>t7/F\u0001s!\t\u0019h/D\u0001u\u0015\t)\u0018%\u0001\u0002lm&\u0011q\u000f\u001e\u0002\u0010\u0019>|7.\u001e9J]>\u0003H/[8og\u0006\u0001Bn\\8lkBLen\u00149uS>t7\u000fI\u0001\u0010[V$\u0018\r^3J]>\u0003H/[8ogV\t1\u0010\u0005\u0002ty&\u0011Q\u0010\u001e\u0002\u0010\u001bV$\u0018\r^3J]>\u0003H/[8og\u0006\u0001R.\u001e;bi\u0016Len\u00149uS>t7\u000fI\u0001\u000bO\u0016$x\n\u001d;j_:\u001cXCAA\u0002!\r\u0019\u0018QA\u0005\u0004\u0003\u000f!(AC$fi>\u0003H/[8og\u0006Yq-\u001a;PaRLwN\\:!\u00035Ign]3si>\u0003H/[8ogV\u0011\u0011q\u0002\t\u0004g\u0006E\u0011bAA\ni\ni\u0011J\\:feR|\u0005\u000f^5p]N\fa\"\u001b8tKJ$x\n\u001d;j_:\u001c\b%\u0001\u0004sK6|g/\u001a\u000b\u0005\u00037\t\t\u0003E\u0002<\u0003;I1!a\b3\u0005\u001d\u0011un\u001c7fC:Da!a\t\u0012\u0001\u0004)\u0014\u0001B3mK6\f!\"\u001b8ji&\fG.\u001b>f)\t\tI\u0003E\u0002<\u0003WI1!!\f3\u0005\u0011)f.\u001b;\u0002\tML'0\u001a\u000b\u0003\u0003g\u00012aOA\u001b\u0013\r\t9D\r\u0002\u0004\u0013:$\u0018aA1mYR\u0011\u0011Q\b\t\u0005\u0007\u0006}R'C\u0002\u0002B1\u00131aU3u\u0003\u001d1wN]3bG\",B!a\u0012\u0002VQ!\u0011\u0011FA%\u0011\u001d\tY%\u0006a\u0001\u0003\u001b\n\u0011A\u001a\t\u0007w\u0005=S'a\u0015\n\u0007\u0005E#GA\u0005Gk:\u001cG/[8ocA\u0019a'!\u0016\u0005\r\u0005]SC1\u0001:\u0005\u0005)\u0016\u0001C5uKJ\fGo\u001c:\u0016\u0005\u0005u\u0003#BA0\u0003S*d\u0002BA1\u0003Kr1!RA2\u0013\u0005\u0011\u0013bAA4e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA6\u0003[\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003O\u0012\u0014\u0001\u0003\u0013qYV\u001cH%Z9\u0015\t\u0005M\u0014QO\u0007\u0002\u0001!1\u00111E\fA\u0002U\n\u0011\u0002J7j]V\u001cH%Z9\u0015\t\u0005M\u00141\u0010\u0005\u0007\u0003GA\u0002\u0019A\u001b\u0002\u0011\r|g\u000e^1j]N$B!a\u0007\u0002\u0002\"1\u00111E\rA\u0002U\nAbQ8vG\"\u0014\u0017m]3TKR\u0004\"AV\u000e\u0014\u0007m\tI\tE\u0002<\u0003\u0017K1!!$3\u0005\u0019\te.\u001f*fMR\u0011\u0011QQ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005U\u00151V\u000b\u0003\u0003/S3AUAMW\t\tY\n\u0005\u0003\u0002\u001e\u0006\u001dVBAAP\u0015\u0011\t\t+a)\u0002\u0013Ut7\r[3dW\u0016$'bAASe\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0016q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G!\u0002\u001d\u001e\u0005\u0004I\u0004")
public class CouchbaseSet<T>
extends AbstractSet<T> {
    private final String id;
    private final Collection collection;
    private final JsonSerializer<T> encode;
    private final CouchbaseCollectionOptions opts;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;
    private final GetOptions getOptions;
    private final InsertOptions insertOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseSet$.MODULE$.$lessinit$greater$default$3();
    }

    private CouchbaseCollectionOptions opts() {
        return this.opts;
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    private GetOptions getOptions() {
        return this.getOptions;
    }

    private InsertOptions insertOptions() {
        return this.insertOptions;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean remove(T elem) {
        Success success;
        Seq values;
        BooleanRef out = BooleanRef.create((boolean)false);
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable & scala.Serializable)array -> array.toSeq());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (Seq)(success = (Success)try_).value()) instanceof Seq) {
            Seq seq = values;
            Seq zipped = (Seq)seq.toSeq().zipWithIndex(Seq$.MODULE$.canBuildFrom());
            zipped.foreach((Function1 & Serializable & scala.Serializable)eAndIndex -> {
                CouchbaseSet.$anonfun$remove$3(this, elem, op, out, eAndIndex);
                return BoxedUnit.UNIT;
            });
            return out.elem;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                BoxesRunTime.boxToBoolean((boolean)false);
                return out.elem;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        Throwable err = failure.exception();
        throw err;
    }

    private void initialize() {
        this.collection.insert(this.id, JsonArraySafe$.MODULE$.create(), this.insertOptions(), JsonSerializer$JsonArraySafeConvert$.MODULE$).get();
    }

    public int size() {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)((Seq)new .colon.colon((Object)LookupInSpec$.MODULE$.count(""), (List)Nil$.MODULE$)), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable & scala.Serializable)result -> result.contentAs(0, JsonDeserializer$IntConvert$.MODULE$, ClassTag$.MODULE$.Int()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            return count;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return 0;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    private Set<T> all() {
        Success success;
        Set values;
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable & scala.Serializable)array -> array.toSeq().toSet());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (Set)(success = (Success)try_).value()) != null) {
            Set set = values;
            return set;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return Predef$.MODULE$.Set().empty();
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public <U> void foreach(Function1<T, U> f) {
        this.all().foreach(f);
    }

    public Iterator<T> iterator() {
        return this.all().iterator();
    }

    public CouchbaseSet<T> $plus$eq(T elem) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAddUnique("", elem, this.encode), (List)Nil$.MODULE$)), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return this;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                this.initialize();
                return this.$plus$eq(elem);
            }
        }
        if (bl && failure.exception() instanceof PathExistsException) {
            return this;
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public CouchbaseSet<T> $minus$eq(T elem) {
        this.remove(elem);
        return this;
    }

    public boolean contains(T elem) {
        return this.all().contains(elem);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$remove$3(CouchbaseSet $this, Object elem$1, Try op$1, BooleanRef out$1, Tuple2 eAndIndex) {
        block7: {
            block9: {
                block8: {
                    e = eAndIndex._1();
                    index = eAndIndex._2$mcI$sp();
                    if (!BoxesRunTime.equals((Object)e, (Object)elem$1)) break block7;
                    mutateResult = $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)((Seq)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$)), $this.mutateInOptions().cas(((GetResult)op$1.get()).cas()));
                    var9_8 = false;
                    var10_9 = null;
                    var11_10 = mutateResult;
                    if (!(var11_10 instanceof Success)) break block8;
                    v0 = true;
                    break block9;
                }
                if (!(var11_10 instanceof Failure)) ** GOTO lbl-1000
                var9_8 = true;
                var10_9 = (Failure)var11_10;
                if (var10_9.exception() instanceof PathNotFoundException) {
                    v0 = false;
                } else if (var9_8 && (err = var10_9.exception()) instanceof CasMismatchException) {
                    v0 = $this.remove(elem$1);
                } else if (var9_8 && (err = var10_9.exception()) instanceof DocumentNotFoundException) {
                    v0 = false;
                } else {
                    if (var9_8) {
                        err = var10_9.exception();
                        throw err;
                    }
                    throw new MatchError(var11_10);
                }
            }
            out$1.elem = v0;
            return;
        }
    }

    public CouchbaseSet(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode) {
        CouchbaseCollectionOptions couchbaseCollectionOptions;
        this.id = id;
        this.collection = collection;
        this.encode = encode;
        Option<CouchbaseCollectionOptions> option = options;
        if (option instanceof Some) {
            CouchbaseCollectionOptions v;
            Some some = (Some)option;
            couchbaseCollectionOptions = v = (CouchbaseCollectionOptions)some.value();
        } else {
            couchbaseCollectionOptions = CouchbaseCollectionOptions$.MODULE$.apply(collection, CouchbaseCollectionOptions$.MODULE$.apply$default$2());
        }
        this.opts = couchbaseCollectionOptions;
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.getOptions = new GetOptions(GetOptions$.MODULE$.apply$default$1(), GetOptions$.MODULE$.apply$default$2(), GetOptions$.MODULE$.apply$default$3(), GetOptions$.MODULE$.apply$default$4(), GetOptions$.MODULE$.apply$default$5(), GetOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.insertOptions = new InsertOptions(InsertOptions$.MODULE$.apply$default$1(), InsertOptions$.MODULE$.apply$default$2(), InsertOptions$.MODULE$.apply$default$3(), InsertOptions$.MODULE$.apply$default$4(), InsertOptions$.MODULE$.apply$default$5(), InsertOptions$.MODULE$.apply$default$6(), InsertOptions$.MODULE$.apply$default$7()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

