/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r=h\u0001\u0002%J\u0001IC\u0001\u0002\u0017\u0001\u0003\u0002\u0013\u0006I!\u0017\u0005\nE\u0002\u0011)\u0019!C\u0001\u0013\u000eD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\nY\u0002\u0011)\u0019!C\u0001\u00136D\u0001\u0002 \u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\n{\u0002\u0011)\u0019!C\u0001\u0013zD\u0011\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!Q\u0011Q\u0004\u0001C\u0002\u0013\r\u0011*a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0001b\u0018\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\b\u0003c\u0001\u0001\u0015!\u0003]\u0011%A\u0007A1A\u0005\u00025\u000b\u0019\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001b\u0011)\ty\u0004\u0001b\u0001\n\u0003I\u0015\u0011\t\u0005\t\u0003\u0013\u0002\u0001\u0015!\u0003\u0002D!Q\u00111\n\u0001C\u0002\u0013\u0005\u0011*!\u0014\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u001fB!\"!\u0018\u0001\u0005\u0004%\t!SA'\u0011!\ty\u0006\u0001Q\u0001\n\u0005=\u0003BCA1\u0001\t\u0007I\u0011A%\u0002d!A\u0011\u0011\u000f\u0001!\u0002\u0013\t)\u0007\u0003\u0006\u0002t\u0001\u0011\r\u0011\"\u0001J\u0003kB\u0001\"a\"\u0001A\u0003%\u0011q\u000f\u0005\u000b\u0003\u0013\u0003!\u0019!C\u0001\u0013\u0006-\u0005\u0002CAJ\u0001\u0001\u0006I!!$\t\u0017\u0005U\u0005\u0001#b\u0001\n\u0003I\u0015q\u0013\u0005\f\u0003S\u0003\u0001R1A\u0005\u0002%\u000bY\u000bC\u0006\u0002:\u0002A)\u0019!C\u0001\u0013\u0006m\u0006BCAe\u0001\t\u0007I\u0011A%\u0002L\"A\u00111\u001c\u0001!\u0002\u0013\ti\r\u0003\u0006\u0002^\u0002A)\u0019!C\u0001\u0003?D!\"a:\u0001\u0011\u000b\u0007I\u0011AAu\u0011)\t\t\u0010\u0001EC\u0002\u0013\u0005\u00111\u001f\u0005\u000b\u0003\u007f\u0004\u0001R1A\u0005\u0002\t\u0005\u0001B\u0003B\b\u0001!\u0015\r\u0011\"\u0001\u0003\u0012!Q!\u0011\u0004\u0001\t\u0006\u0004%\tAa\u0007\t\u000f\u0005M\u0006\u0001\"\u0001\u0003@!9\u0011\u0011\u0011\u0001\u0005\u0002\tE\u0003bBAA\u0001\u0011\u0005!q\u000e\u0005\n\u0005\u0017\u0003\u0011\u0013!C\u0001\u0005\u001bC\u0011B!)\u0001#\u0003%\tAa)\t\u0013\t\u001d\u0006!%A\u0005\u0002\t%\u0006b\u0002BW\u0001\u0011\u0005!q\u0016\u0005\b\u0005[\u0003A\u0011\u0001Bd\u0011%\u0011)\u000eAI\u0001\n\u0003\u00119\u000eC\u0005\u0003\\\u0002\t\n\u0011\"\u0001\u0003$\"9!Q\u001c\u0001\u0005\u0002\t}\u0007b\u0002Bo\u0001\u0011\u00051Q\u0002\u0005\n\u0007+\u0001\u0011\u0013!C\u0001\u0005GCqaa\u0006\u0001\t\u0003\u0019I\u0002C\u0005\u0004&\u0001\t\n\u0011\"\u0001\u0003$\"91q\u0005\u0001\u0005\u0002\r%\u0002\"CB\u001e\u0001E\u0005I\u0011AB\u001f\u0011\u001d\u00199\u0003\u0001C\u0001\u0007\u0003Bqaa\u0014\u0001\t\u0003\u0019\t\u0006C\u0005\u0004d\u0001\t\n\u0011\"\u0001\u0004f!91q\n\u0001\u0005\u0002\r%\u0004bBB:\u0001\u0011\u00051Q\u000f\u0005\b\u0007g\u0002A\u0011AB=\u0011!\u0019)\t\u0001C\u0001\u0013\u000e\u001duaBBE\u0013\"\u000511\u0012\u0004\u0007\u0011&C\ta!$\t\u000f\u00055q\b\"\u0001\u0004\u0010\"91\u0011S \u0005\u0002\rM\u0005bBBI\u007f\u0011\u00051\u0011\u0016\u0005\b\u0007#{D\u0011AB[\u0011!\u0011in\u0010C\u0001\u0017\u000em\u0006\u0002CBk\u007f\u0011\u00051ja6\t\u0011\rUw\b\"\u0001L\u0007CD\u0001b!:@\t\u0003Y5q\u001d\u0002\r\u0003NLhnY\"mkN$XM\u001d\u0006\u0003\u0015.\u000bQa]2bY\u0006T!\u0001T'\u0002\r\rd\u0017.\u001a8u\u0015\tqu*A\u0005d_V\u001c\u0007NY1tK*\t\u0001+A\u0002d_6\u001c\u0001a\u0005\u0002\u0001'B\u0011AKV\u0007\u0002+*\t!*\u0003\u0002X+\n1\u0011I\\=SK\u001a\f1\"\u001a8wSJ|g.\\3oiB\u0019AK\u0017/\n\u0005m+&\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005u\u0003W\"\u00010\u000b\u0005}K\u0015aA3om&\u0011\u0011M\u0018\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u0002IB\u0011Q-[\u0007\u0002M*\u0011ql\u001a\u0006\u0003Q.\u000bAaY8sK&\u0011!N\u001a\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005I1/Z3e\u001d>$Wm]\u000b\u0002]B\u0019qN^=\u000f\u0005A$\bCA9V\u001b\u0005\u0011(BA:R\u0003\u0019a$o\\8u}%\u0011Q/V\u0001\u0007!J,G-\u001a4\n\u0005]D(aA*fi*\u0011Q/\u0016\t\u0003;jL!a\u001f0\u0003\u0011M+W\r\u001a(pI\u0016\f!b]3fI:{G-Z:!\u0003A\u0019wN\u001c8fGRLwN\\*ue&tw-F\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003O\u0006!Q\u000f^5m\u0013\u0011\tI!a\u0001\u0003!\r{gN\\3di&|gn\u0015;sS:<\u0017!E2p]:,7\r^5p]N#(/\u001b8hA\u00051A(\u001b8jiz\"\"\"!\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e!\r\t\u0019\u0002A\u0007\u0002\u0013\"1\u0001\f\u0003CA\u0002eCQA\u0019\u0005A\u0002\u0011DQ\u0001\u001c\u0005A\u00029DQ! \u0005A\u0002}\f!!Z2\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001dR+\u0001\u0006d_:\u001cWO\u001d:f]RLA!a\u000b\u0002&\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004S#\u0001/\u0002\t\u0015tg\u000fI\u000b\u0003\u0003k\u0001B!a\u000e\u0002:5\tq-C\u0002\u0002<\u001d\u0014AaQ8sK\u0006)1m\u001c:fA\u0005\u0011\u0001\u000e]\u000b\u0003\u0003\u0007\u0002B!a\u0005\u0002F%\u0019\u0011qI%\u0003%!\u000bg\u000e\u001a7fe\n\u000b7/[2QCJ\fWn]\u0001\u0004QB\u0004\u0013!D:fCJ\u001c\u0007\u000eV5nK>,H/\u0006\u0002\u0002PA!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005\u0015\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\n\t\u0005e\u00131\u000b\u0002\t\tV\u0014\u0018\r^5p]\u0006q1/Z1sG\"$\u0016.\\3pkR\u0004\u0013\u0001E1oC2LH/[2t)&lWm\\;u\u0003E\tg.\u00197zi&\u001c7\u000fV5nK>,H\u000fI\u0001\u000ee\u0016$(/_*ue\u0006$XmZ=\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-t-A\u0003sKR\u0014\u00180\u0003\u0003\u0002p\u0005%$!\u0004*fiJL8\u000b\u001e:bi\u0016<\u00170\u0001\bsKR\u0014\u0018p\u0015;sCR,w-\u001f\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014XCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\n\u0001\u0002[1oI2,'o\u001d\u0006\u0004\u0003\u0003K\u0015!B9vKJL\u0018\u0002BAC\u0003w\u0012\u0001#\u00118bYf$\u0018nY:IC:$G.\u001a:\u0002#\u0005t\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014\b%A\u0007tK\u0006\u00148\r\u001b%b]\u0012dWM]\u000b\u0003\u0003\u001b\u0003B!!\u001f\u0002\u0010&!\u0011\u0011SA>\u00055\u0019V-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0006q1/Z1sG\"D\u0015M\u001c3mKJ\u0004\u0013a\u0005:fC\u000e$\u0018N^3Vg\u0016\u0014X*\u00198bO\u0016\u0014XCAAM!\u0011\tY*!*\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bA!^:fe*\u0019\u00111U%\u0002\u000f5\fg.Y4fe&!\u0011qUAO\u0005M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0003U\u0011X-Y2uSZ,')^2lKRl\u0015M\\1hKJ,\"!!,\u0011\t\u0005=\u0016QW\u0007\u0003\u0003cSA!a-\u0002\"\u00061!-^2lKRLA!a.\u00022\n)\"+Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014\u0018!\b:fC\u000e$\u0018N^3B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\t\u0005\r\u0017\u0011U\u0001\nC:\fG.\u001f;jGNLA!a2\u0002B\ni\"+Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/\u0001\u0005rk\u0016\u0014\u0018p\u00149t+\t\ti\r\u0005\u0003\u0002P\u0006]WBAAi\u0015\u0011\t\t)a5\u000b\u0007\u0005Uw-A\u0002ba&LA!!7\u0002R\na1i\u001c:f#V,'/_(qg\u0006I\u0011/^3ss>\u00038\u000fI\u0001\bEV\u001c7.\u001a;t+\t\t\t\u000f\u0005\u0003\u00020\u0006\r\u0018\u0002BAs\u0003c\u0013!#Q:z]\u000e\u0014UoY6fi6\u000bg.Y4fe\u0006)Qo]3sgV\u0011\u00111\u001e\t\u0005\u00037\u000bi/\u0003\u0003\u0002p\u0006u%\u0001E!ts:\u001cWk]3s\u001b\u0006t\u0017mZ3s\u00031\tX/\u001a:z\u0013:$W\r_3t+\t\t)\u0010\u0005\u0003\u0002x\u0006mXBAA}\u0015\u0011\t\t)!)\n\t\u0005u\u0018\u0011 \u0002\u0017\u0003NLhnY)vKJL\u0018J\u001c3fq6\u000bg.Y4fe\u0006i1/Z1sG\"Le\u000eZ3yKN,\"Aa\u0001\u0011\t\t\u0015!1B\u0007\u0003\u0005\u000fQAA!\u0003\u0002\"\u000611/Z1sG\"LAA!\u0004\u0003\b\t9\u0012i]=oGN+\u0017M]2i\u0013:$W\r_'b]\u0006<WM]\u0001\u0011C:\fG.\u001f;jGNLe\u000eZ3yKN,\"Aa\u0005\u0011\t\u0005}&QC\u0005\u0005\u0005/\t\tM\u0001\u000eBgft7-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/A\tfm\u0016tG/\u001b8h\rVt7\r^5p]N,\"A!\b\u0011\t\t}!QE\u0007\u0003\u0005CQAAa\t\u0002\"\u0006AQM^3oi&tw-\u0003\u0003\u0003(\t\u0005\"\u0001H!ts:\u001cWI^3oi&twMR;oGRLwN\\'b]\u0006<WM\u001d\u0015\u0004K\t-\u0002\u0003\u0002B\u0017\u0005sqAAa\f\u000365\u0011!\u0011\u0007\u0006\u0004\u0005g9\u0017AC1o]>$\u0018\r^5p]&!!q\u0007B\u0019\u0003%\u0019F/\u00192jY&$\u00180\u0003\u0003\u0003<\tu\"aC+oG>lW.\u001b;uK\u0012TAAa\u000e\u00032Q!!\u0011\tB$!\u0011\t\u0019Ba\u0011\n\u0007\t\u0015\u0013JA\u0006Bgft7MQ;dW\u0016$\bb\u0002B%M\u0001\u0007!1J\u0001\u000bEV\u001c7.\u001a;OC6,\u0007cA8\u0003N%\u0019!q\n=\u0003\rM#(/\u001b8h)\u0019\u0011\u0019F!\u0019\u0003fA1\u00111\u0005B+\u00053JAAa\u0016\u0002&\t1a)\u001e;ve\u0016\u0004BAa\u0017\u0003^5\u0011\u0011qP\u0005\u0005\u0005?\nyHA\u0006Rk\u0016\u0014\u0018PU3tk2$\bb\u0002B2O\u0001\u0007!1J\u0001\ngR\fG/Z7f]RDqAa\u001a(\u0001\u0004\u0011I'A\u0004paRLwN\\:\u0011\t\tm#1N\u0005\u0005\u0005[\nyH\u0001\u0007Rk\u0016\u0014\u0018p\u00149uS>t7\u000f\u0006\u0006\u0003T\tE$1\u000fB?\u0005\u0003CqAa\u0019)\u0001\u0004\u0011Y\u0005C\u0005\u0003v!\u0002\n\u00111\u0001\u0003x\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\tm#\u0011P\u0005\u0005\u0005w\nyHA\bRk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t\u0011%\u0011y\b\u000bI\u0001\u0002\u0004\ty%A\u0004uS6,w.\u001e;\t\u0013\t\r\u0005\u0006%AA\u0002\t\u0015\u0015!B1eQ>\u001c\u0007c\u0001+\u0003\b&\u0019!\u0011R+\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011/^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0010*\"!q\u000fBIW\t\u0011\u0019\n\u0005\u0003\u0003\u0016\nuUB\u0001BL\u0015\u0011\u0011IJa'\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001a+&!!q\u0014BL\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0015\u0016\u0005\u0003\u001f\u0012\t*A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011YK\u000b\u0003\u0003\u0006\nE\u0015AD1oC2LH/[2t#V,'/\u001f\u000b\u0007\u0005c\u0013iLa0\u0011\r\u0005\r\"Q\u000bBZ!\u0011\u0011)L!/\u000e\u0005\t]&bAAb\u0013&!!1\u0018B\\\u0005=\te.\u00197zi&\u001c7OU3tk2$\bb\u0002B2Y\u0001\u0007!1\n\u0005\b\u0005Ob\u0003\u0019\u0001Ba!\u0011\u0011)La1\n\t\t\u0015'q\u0017\u0002\u0011\u0003:\fG.\u001f;jGN|\u0005\u000f^5p]N$\u0002B!-\u0003J\n-'1\u001b\u0005\b\u0005Gj\u0003\u0019\u0001B&\u0011%\u0011)(\fI\u0001\u0002\u0004\u0011i\r\u0005\u0003\u00036\n=\u0017\u0002\u0002Bi\u0005o\u00131#\u00118bYf$\u0018nY:QCJ\fW.\u001a;feND\u0011Ba .!\u0003\u0005\r!a\u0014\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003Z*\"!Q\u001aBI\u0003a\tg.\u00197zi&\u001c7/U;fef$C-\u001a4bk2$HeM\u0001\fg\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\u0006\u0005\u0003b\nE(Q_B\u0002!\u0019\t\u0019C!\u0016\u0003dB!!Q\u001dBw\u001b\t\u00119O\u0003\u0003\u0003j\n-\u0018A\u0002:fgVdGOC\u0002\u0003\n%KAAa<\u0003h\na1+Z1sG\"\u0014Vm];mi\"9!1\u001f\u0019A\u0002\t-\u0013!C5oI\u0016Dh*Y7f\u0011\u001d\t\t\t\ra\u0001\u0005o\u0004BA!?\u0003\u00006\u0011!1 \u0006\u0005\u0005{\u0014Y/A\u0004rk\u0016\u0014\u0018.Z:\n\t\r\u0005!1 \u0002\f'\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010C\u0004\u0003hA\u0002\ra!\u0002\u0011\t\r\u001d1\u0011B\u0007\u0003\u0005WLAaa\u0003\u0003l\ni1+Z1sG\"|\u0005\u000f^5p]N$\u0002B!9\u0004\u0010\rE11\u0003\u0005\b\u0005g\f\u0004\u0019\u0001B&\u0011\u001d\t\t)\ra\u0001\u0005oD\u0011Ba 2!\u0003\u0005\r!a\u0014\u0002+M,\u0017M]2i#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005QA-[:d_:tWm\u0019;\u0015\t\rm11\u0005\t\u0007\u0003G\u0011)f!\b\u0011\u0007Q\u001by\"C\u0002\u0004\"U\u0013A!\u00168ji\"I!qP\u001a\u0011\u0002\u0003\u0007\u0011qJ\u0001\u0015I&\u001c8m\u001c8oK\u000e$H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u000b\u0005\u0007W\u00199\u0004\u0005\u0004\u0002$\tU3Q\u0006\t\u0005\u0007_\u0019\u0019$\u0004\u0002\u00042)\u00191qE4\n\t\rU2\u0011\u0007\u0002\u0012\t&\fwM\\8ti&\u001c7OU3tk2$\b\"CB\u001dkA\u0005\t\u0019\u0001B&\u0003!\u0011X\r]8si&#\u0017!\u00063jC\u001etwn\u001d;jGN$C-\u001a4bk2$H%M\u000b\u0003\u0007\u007fQCAa\u0013\u0003\u0012R!11FB\"\u0011\u001d\u00119g\u000ea\u0001\u0007\u000b\u0002Baa\u0012\u0004L5\u00111\u0011\n\u0006\u0004\u0007OI\u0015\u0002BB'\u0007\u0013\u0012!\u0003R5bO:|7\u000f^5dg>\u0003H/[8og\u0006!\u0001/\u001b8h)\u0011\u0019\u0019fa\u0017\u0011\r\u0005\r\"QKB+!\u0011\u0019yca\u0016\n\t\re3\u0011\u0007\u0002\u000b!&twMU3tk2$\b\"\u0003B@qA\u0005\t\u0019AB/!\u0015!6qLA(\u0013\r\u0019\t'\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001dALgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\r\u0016\u0005\u0007;\u0012\t\n\u0006\u0003\u0004T\r-\u0004b\u0002B4u\u0001\u00071Q\u000e\t\u0005\u0007\u000f\u001ay'\u0003\u0003\u0004r\r%#a\u0003)j]\u001e|\u0005\u000f^5p]N\fab^1jiVsG/\u001b7SK\u0006$\u0017\u0010\u0006\u0003\u0004\u001c\r]\u0004b\u0002B@w\u0001\u0007\u0011q\n\u000b\u0007\u00077\u0019Yh! \t\u000f\t}D\b1\u0001\u0002P!9!q\r\u001fA\u0002\r}\u0004\u0003BB$\u0007\u0003KAaa!\u0004J\t)r+Y5u+:$\u0018\u000e\u001c*fC\u0012Lx\n\u001d;j_:\u001c\u0018\u0001\u00069fe\u001a|'/\\$m_\n\fGnQ8o]\u0016\u001cG\u000f\u0006\u0002\u0004\u001e\u0005a\u0011i]=oG\u000ecWo\u001d;feB\u0019\u00111C \u0014\u0005}\u001aFCABF\u0003\u001d\u0019wN\u001c8fGR$\u0002b!&\u0004 \u000e\u00056Q\u0015\t\u0007\u0007/\u001bY*!\u0005\u000e\u0005\re%bAA\u0003+&!1QTBM\u0005\r!&/\u001f\u0005\u0007{\u0006\u0003\rAa\u0013\t\u000f\r\r\u0016\t1\u0001\u0003L\u0005AQo]3s]\u0006lW\rC\u0004\u0004(\u0006\u0003\rAa\u0013\u0002\u0011A\f7o]<pe\u0012$ba!&\u0004,\u000e5\u0006BB?C\u0001\u0004\u0011Y\u0005C\u0004\u0003h\t\u0003\raa,\u0011\t\u0005M1\u0011W\u0005\u0004\u0007gK%AD\"mkN$XM](qi&|gn\u001d\u000b\u0007\u0007+\u001b9l!/\t\u000b1\u001c\u0005\u0019\u00018\t\u000f\t\u001d4\t1\u0001\u00040R11QXBa\u0007'$BA!9\u0004@\"9\u0011Q\u0004#A\u0004\u0005\u0005\u0002bBBb\t\u0002\u00071QY\u0001\be\u0016\fX/Z:u!\u0011\u00199ma4\u000e\u0005\r%'\u0002\u0002B\u0005\u0007\u0017T1a!4h\u0003\ri7oZ\u0005\u0005\u0007#\u001cIMA\u0007TK\u0006\u00148\r\u001b*fcV,7\u000f\u001e\u0005\u0007Q\u0012\u0003\r!!\u000e\u00023\u0015DHO]1di\u000ecWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0007\u00073\u001cYn!8\u0011\u000b\r]51\u0014/\t\ru,\u0005\u0019\u0001B&\u0011\u001d\u0019y.\u0012a\u0001\u0007_\u000bAa\u001c9ugR!1\u0011\\Br\u0011\u001d\u0019yN\u0012a\u0001\u0007_\u000bQd]3fI:{G-Z:Ge>l7i\u001c8oK\u000e$\u0018n\u001c8TiJLgn\u001a\u000b\u0006]\u000e%8Q\u001e\u0005\u0007\u0007W<\u0005\u0019A@\u0002\u0005\r\u001c\b\"\u0002-H\u0001\u0004a\u0006")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final CoreQueryOps queryOps;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveUserManager$lzycompute();
        }
        return this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, options.toCore(), null, null, null)).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null)).map((Function1 & Serializable & scala.Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            return this.analyticsHandler().queryAsync(request, this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            return AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)seedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toCore(), Set$.MODULE$.canBuildFrom())).asJava()), (ConnectionString)connectionString);
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.queryOps = this.core().queryOps();
    }
}

