/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.kv.ExistsOptions;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetAllReplicasOptions;
import com.couchbase.client.scala.kv.GetAllReplicasOptions$;
import com.couchbase.client.scala.kv.GetAndLockOptions;
import com.couchbase.client.scala.kv.GetAndTouchOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.ReplaceOptions;
import com.couchbase.client.scala.kv.ScanOptions;
import com.couchbase.client.scala.kv.ScanOptions$;
import com.couchbase.client.scala.kv.ScanResult;
import com.couchbase.client.scala.kv.ScanType;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.TouchOptions;
import com.couchbase.client.scala.kv.UnlockOptions;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.TimeoutUtil$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011Mb\u0001B#G\u0001=C\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u00065\u0002!\ta\u0017\u0005\t=\u0002\u0011\r\u0011\"\u0001G?\"1\u0011\u000f\u0001Q\u0001\n\u0001D\u0001B\u001d\u0001C\u0002\u0013\u0005ai\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B5\t\u000fU\u0004!\u0019!C\u0005m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0001\u0011%\ti\u0001\u0001b\u0001\n\u0017\ty\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\t\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!!\u000e\u0001\t\u0003\ti\u0002C\u0004\u00028\u0001!\t!!\b\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u0003c\u0003\u0011\u0013!C\u0001\u0003gCq!!\u000f\u0001\t\u0003\tY\fC\u0004\u0002X\u0002!\t!!7\t\u0013\u0005e\b!%A\u0005\u0002\u0005m\b\"\u0003B\u0002\u0001E\u0005I\u0011\u0001B\u0003\u0011%\u0011I\u0001AI\u0001\n\u0003\u0011Y\u0001C\u0004\u0002X\u0002!\tAa\u0004\t\u000f\t%\u0002\u0001\"\u0001\u0003,!I!\u0011\t\u0001\u0012\u0002\u0013\u0005!1\t\u0005\n\u0005\u000f\u0002\u0011\u0013!C\u0001\u0005\u0013BqA!\u000b\u0001\t\u0003\u0011i\u0005C\u0004\u0003h\u0001!\tA!\u001b\t\u0013\tM\u0004!%A\u0005\u0002\u0005u\b\"\u0003B;\u0001E\u0005I\u0011AAM\u0011%\u00119\bAI\u0001\n\u0003\t)\fC\u0004\u0003h\u0001!\tA!\u001f\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"I!Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\b\u0005\u000b\u0003A\u0011\u0001BL\u0011\u001d\u0011\u0019\u000b\u0001C\u0001\u0005KC\u0011Ba6\u0001#\u0003%\t!!@\t\u0013\te\u0007!%A\u0005\u0002\tm\u0007\"\u0003Bp\u0001E\u0005I\u0011AAM\u0011%\u0011\t\u000fAI\u0001\n\u0003\t)\fC\u0004\u0003$\u0002!\tAa9\t\u000f\tE\b\u0001\"\u0001\u0003t\"I!Q \u0001\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\b\u0005c\u0004A\u0011\u0001B\u0000\u0011\u001d\u0019i\u0001\u0001C\u0001\u0007\u001fA\u0011ba\b\u0001#\u0003%\t!!.\t\u000f\r5\u0001\u0001\"\u0001\u0004\"!91q\u0006\u0001\u0005\u0002\rE\u0002\"CB\u001e\u0001E\u0005I\u0011AA[\u0011\u001d\u0019y\u0003\u0001C\u0001\u0007{Aqaa\u0013\u0001\t\u0003\u0019i\u0005C\u0005\u0004f\u0001\t\n\u0011\"\u0001\u00026\"911\n\u0001\u0005\u0002\r\u001d\u0004bBB;\u0001\u0011\u00051q\u000f\u0005\n\u0007\u000b\u0003\u0011\u0013!C\u0001\u0003kCqa!\u001e\u0001\t\u0003\u00199\tC\u0004\u0004\u0014\u0002!\ta!&\t\u0013\r\u0005\u0006!%A\u0005\u0002\u0005U\u0006bBBJ\u0001\u0011\u000511\u0015\u0005\b\u0007_\u0003A\u0011ABY\u0011%\u0019I\fAI\u0001\n\u0003\t)\fC\u0004\u00040\u0002!\taa/\t\u000f\r%\u0007\u0001\"\u0001\u0004L\"I1\u0011\u001c\u0001\u0012\u0002\u0013\u0005\u0011Q\u0017\u0005\b\u0007\u0013\u0004A\u0011ABn\u0011\u001d\u00199\u000f\u0001C\u0001\u0007SDqaa:\u0001\t\u0003!\u0019C\u0001\nSK\u0006\u001cG/\u001b<f\u0007>dG.Z2uS>t'BA$I\u0003\u0015\u00198-\u00197b\u0015\tI%*\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u00172\u000b\u0011bY8vG\"\u0014\u0017m]3\u000b\u00035\u000b1aY8n\u0007\u0001\u0019\"\u0001\u0001)\u0011\u0005E\u001bV\"\u0001*\u000b\u0003\u001dK!\u0001\u0016*\u0003\r\u0005s\u0017PU3g\u0003\u0015\t7/\u001f8d!\t9\u0006,D\u0001G\u0013\tIfIA\bBgft7mQ8mY\u0016\u001cG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011A,\u0018\t\u0003/\u0002AQ!\u0016\u0002A\u0002Y\u000b\u0011b\u001b<US6,w.\u001e;\u0016\u0003\u0001\u0004B!U1dS&\u0011!M\u0015\u0002\n\rVt7\r^5p]F\u0002\"\u0001Z4\u000e\u0003\u0015T!A\u001a$\u0002\u0015\u0011,(/\u00192jY&$\u00180\u0003\u0002iK\nQA)\u001e:bE&d\u0017\u000e^=\u0011\u0005)|W\"A6\u000b\u00051l\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00059\u0014\u0016AC2p]\u000e,(O]3oi&\u0011\u0001o\u001b\u0002\t\tV\u0014\u0018\r^5p]\u0006Q1N\u001e+j[\u0016|W\u000f\u001e\u0011\u0002\u001b-4(+Z1e)&lWm\\;u+\u0005I\u0017AD6w%\u0016\fG\rV5nK>,H\u000fI\u0001\fK:4\u0018N]8o[\u0016tG/F\u0001x!\tA80D\u0001z\u0015\tQh)A\u0002f]ZL!\u0001`=\u0003%\rcWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e^\u0001\rK:4\u0018N]8o[\u0016tG\u000fI\u0001\u0005G>\u0014X-\u0006\u0002\u0002\u0002A!\u00111AA\u0004\u001b\t\t)A\u0003\u0002\u007f\u0011&!\u0011\u0011BA\u0003\u0005\u0011\u0019uN]3\u0002\u000b\r|'/\u001a\u0011\u0002\u0005\u0015\u001cWCAA\t!\u0011\t\u0019\"!\u0006\u000e\u00035L1!a\u0006n\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\nAA\\1nKV\u0011\u0011q\u0004\t\u0005\u0003C\tyC\u0004\u0003\u0002$\u0005-\u0002cAA\u0013%6\u0011\u0011q\u0005\u0006\u0004\u0003Sq\u0015A\u0002\u001fs_>$h(C\u0002\u0002.I\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u0011aa\u0015;sS:<'bAA\u0017%\u0006Q!-^2lKRt\u0015-\\3\u0002\u0013M\u001cw\u000e]3OC6,\u0017AB5og\u0016\u0014H/\u0006\u0003\u0002>\u0005UDCCA \u0003\u000f\u000bY)a$\u0002\u0012R!\u0011\u0011IA1!\u0019\t\u0019%!\u0015\u0002V5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0005qk\nd\u0017n\u001d5fe*\u0019q)a\u0013\u000b\u0007y\fiE\u0003\u0002\u0002P\u00059!/Z1di>\u0014\u0018\u0002BA*\u0003\u000b\u0012QaU'p]>\u0004B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u000372\u0015AA6w\u0013\u0011\ty&!\u0017\u0003\u001d5+H/\u0019;j_:\u0014Vm];mi\"9\u00111\r\tA\u0004\u0005\u0015\u0014AC:fe&\fG.\u001b>feB1\u0011qMA7\u0003cj!!!\u001b\u000b\u0007\u0005-d)A\u0003d_\u0012,7-\u0003\u0003\u0002p\u0005%$A\u0004&t_:\u001cVM]5bY&TXM\u001d\t\u0005\u0003g\n)\b\u0004\u0001\u0005\u000f\u0005]\u0004C1\u0001\u0002z\t\tA+\u0005\u0003\u0002|\u0005\u0005\u0005cA)\u0002~%\u0019\u0011q\u0010*\u0003\u000f9{G\u000f[5oOB\u0019\u0011+a!\n\u0007\u0005\u0015%KA\u0002B]fDq!!#\u0011\u0001\u0004\ty\"\u0001\u0002jI\"9\u0011Q\u0012\tA\u0002\u0005E\u0014aB2p]R,g\u000e\u001e\u0005\bMB\u0001\n\u00111\u0001d\u0011!\t\u0019\n\u0005I\u0001\u0002\u0004I\u0017a\u0002;j[\u0016|W\u000f^\u0001\u0011S:\u001cXM\u001d;%I\u00164\u0017-\u001e7uIM*B!!'\u00020V\u0011\u00111\u0014\u0016\u0004G\u0006u5FAAP!\u0011\t\t+a+\u000e\u0005\u0005\r&\u0002BAS\u0003O\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005%&+\u0001\u0006b]:|G/\u0019;j_:LA!!,\u0002$\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005]\u0014C1\u0001\u0002z\u0005\u0001\u0012N\\:feR$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003k\u000bI,\u0006\u0002\u00028*\u001a\u0011.!(\u0005\u000f\u0005]$C1\u0001\u0002zU!\u0011QXAd)!\ty,!3\u0002L\u00065G\u0003BA!\u0003\u0003Dq!a\u0019\u0014\u0001\b\t\u0019\r\u0005\u0004\u0002h\u00055\u0014Q\u0019\t\u0005\u0003g\n9\rB\u0004\u0002xM\u0011\r!!\u001f\t\u000f\u0005%5\u00031\u0001\u0002 !9\u0011QR\nA\u0002\u0005\u0015\u0007bBAh'\u0001\u0007\u0011\u0011[\u0001\b_B$\u0018n\u001c8t!\u0011\t9&a5\n\t\u0005U\u0017\u0011\f\u0002\u000e\u0013:\u001cXM\u001d;PaRLwN\\:\u0002\u000fI,\u0007\u000f\\1dKV!\u00111\\As)1\ti.a:\u0002j\u0006-\u0018Q_A|)\u0011\t\t%a8\t\u000f\u0005\rD\u0003q\u0001\u0002bB1\u0011qMA7\u0003G\u0004B!a\u001d\u0002f\u00129\u0011q\u000f\u000bC\u0002\u0005e\u0004bBAE)\u0001\u0007\u0011q\u0004\u0005\b\u0003\u001b#\u0002\u0019AAr\u0011%\ti\u000f\u0006I\u0001\u0002\u0004\ty/A\u0002dCN\u00042!UAy\u0013\r\t\u0019P\u0015\u0002\u0005\u0019>tw\rC\u0004g)A\u0005\t\u0019A2\t\u0011\u0005ME\u0003%AA\u0002%\f\u0011C]3qY\u0006\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0011\tiP!\u0001\u0016\u0005\u0005}(\u0006BAx\u0003;#q!a\u001e\u0016\u0005\u0004\tI(A\tsKBd\u0017mY3%I\u00164\u0017-\u001e7uIQ*B!!'\u0003\b\u00119\u0011q\u000f\fC\u0002\u0005e\u0014!\u0005:fa2\f7-\u001a\u0013eK\u001a\fW\u000f\u001c;%kU!\u0011Q\u0017B\u0007\t\u001d\t9h\u0006b\u0001\u0003s*BA!\u0005\u0003\u001cQA!1\u0003B\u000f\u0005?\u0011\t\u0003\u0006\u0003\u0002B\tU\u0001bBA21\u0001\u000f!q\u0003\t\u0007\u0003O\niG!\u0007\u0011\t\u0005M$1\u0004\u0003\b\u0003oB\"\u0019AA=\u0011\u001d\tI\t\u0007a\u0001\u0003?Aq!!$\u0019\u0001\u0004\u0011I\u0002C\u0004\u0002Pb\u0001\rAa\t\u0011\t\u0005]#QE\u0005\u0005\u0005O\tIF\u0001\bSKBd\u0017mY3PaRLwN\\:\u0002\rU\u00048/\u001a:u+\u0011\u0011iCa\u000e\u0015\u0015\t=\"\u0011\bB\u001e\u0005{\u0011y\u0004\u0006\u0003\u0002B\tE\u0002bBA23\u0001\u000f!1\u0007\t\u0007\u0003O\niG!\u000e\u0011\t\u0005M$q\u0007\u0003\b\u0003oJ\"\u0019AA=\u0011\u001d\tI)\u0007a\u0001\u0003?Aq!!$\u001a\u0001\u0004\u0011)\u0004C\u0004g3A\u0005\t\u0019A2\t\u0011\u0005M\u0015\u0004%AA\u0002%\f\u0001#\u001e9tKJ$H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005e%Q\t\u0003\b\u0003oR\"\u0019AA=\u0003A)\bo]3si\u0012\"WMZ1vYR$C'\u0006\u0003\u00026\n-CaBA<7\t\u0007\u0011\u0011P\u000b\u0005\u0005\u001f\u0012I\u0006\u0006\u0005\u0003R\tm#Q\fB0)\u0011\t\tEa\u0015\t\u000f\u0005\rD\u0004q\u0001\u0003VA1\u0011qMA7\u0005/\u0002B!a\u001d\u0003Z\u00119\u0011q\u000f\u000fC\u0002\u0005e\u0004bBAE9\u0001\u0007\u0011q\u0004\u0005\b\u0003\u001bc\u0002\u0019\u0001B,\u0011\u001d\ty\r\ba\u0001\u0005C\u0002B!a\u0016\u0003d%!!QMA-\u00055)\u0006o]3si>\u0003H/[8og\u00061!/Z7pm\u0016$\"\"!\u0011\u0003l\t5$q\u000eB9\u0011\u001d\tI)\ba\u0001\u0003?A\u0011\"!<\u001e!\u0003\u0005\r!a<\t\u000f\u0019l\u0002\u0013!a\u0001G\"A\u00111S\u000f\u0011\u0002\u0003\u0007\u0011.\u0001\tsK6|g/\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0001\"/Z7pm\u0016$C-\u001a4bk2$HeM\u0001\u0011e\u0016lwN^3%I\u00164\u0017-\u001e7uIQ\"b!!\u0011\u0003|\tu\u0004bBAEC\u0001\u0007\u0011q\u0004\u0005\b\u0003\u001f\f\u0003\u0019\u0001B@!\u0011\t9F!!\n\t\t\r\u0015\u0011\f\u0002\u000e%\u0016lwN^3PaRLwN\\:\u0002\u0007\u001d,G\u000f\u0006\u0004\u0003\n\nE%1\u0013\t\u0007\u0003\u0007\n\tFa#\u0011\t\u0005]#QR\u0005\u0005\u0005\u001f\u000bIFA\u0005HKR\u0014Vm];mi\"9\u0011\u0011\u0012\u0012A\u0002\u0005}\u0001\u0002CAJEA\u0005\t\u0019A5\u0002\u001b\u001d,G\u000f\n3fM\u0006,H\u000e\u001e\u00133)\u0019\u0011II!'\u0003\u001c\"9\u0011\u0011\u0012\u0013A\u0002\u0005}\u0001bBAhI\u0001\u0007!Q\u0014\t\u0005\u0003/\u0012y*\u0003\u0003\u0003\"\u0006e#AC$fi>\u0003H/[8og\u0006AQ.\u001e;bi\u0016Le\u000e\u0006\b\u0003(\n=&\u0011\u0017Bd\u0005\u0013\u0014\u0019N!6\u0011\r\u0005\r\u0013\u0011\u000bBU!\u0011\t9Fa+\n\t\t5\u0016\u0011\f\u0002\u000f\u001bV$\u0018\r^3J]J+7/\u001e7u\u0011\u001d\tI)\na\u0001\u0003?AqAa-&\u0001\u0004\u0011),\u0001\u0003ta\u0016\u001c\u0007C\u0002B\\\u0005{\u0013\t-\u0004\u0002\u0003:*\u0019!1\u0018*\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003@\ne&aA*fcB!\u0011q\u000bBb\u0013\u0011\u0011)-!\u0017\u0003\u00195+H/\u0019;f\u0013:\u001c\u0006/Z2\t\u0013\u00055X\u0005%AA\u0002\u0005=\b\"\u0003BfKA\u0005\t\u0019\u0001Bg\u0003!!wnY;nK:$\b\u0003BA,\u0005\u001fLAA!5\u0002Z\tq1\u000b^8sKN+W.\u00198uS\u000e\u001c\bb\u00024&!\u0003\u0005\ra\u0019\u0005\t\u0003'+\u0003\u0013!a\u0001S\u0006\u0011R.\u001e;bi\u0016Le\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003IiW\u000f^1uK&sG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu'\u0006\u0002Bg\u0003;\u000b!#\\;uCR,\u0017J\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0011R.\u001e;bi\u0016Le\u000e\n3fM\u0006,H\u000e\u001e\u00137)!\u00119K!:\u0003h\n%\bbBAEU\u0001\u0007\u0011q\u0004\u0005\b\u0005gS\u0003\u0019\u0001B[\u0011\u001d\tyM\u000ba\u0001\u0005W\u0004B!a\u0016\u0003n&!!q^A-\u0005=iU\u000f^1uK&sw\n\u001d;j_:\u001c\u0018AC4fi\u0006sG\rT8dWRA!\u0011\u0012B{\u0005o\u0014Y\u0010C\u0004\u0002\n.\u0002\r!a\b\t\r\te8\u00061\u0001j\u0003!awnY6US6,\u0007\u0002CAJWA\u0005\t\u0019A5\u0002)\u001d,G/\u00118e\u0019>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00134)!\u0011Ii!\u0001\u0004\u0004\r\u0015\u0001bBAE[\u0001\u0007\u0011q\u0004\u0005\u0007\u0005sl\u0003\u0019A5\t\u000f\u0005=W\u00061\u0001\u0004\bA!\u0011qKB\u0005\u0013\u0011\u0019Y!!\u0017\u0003#\u001d+G/\u00118e\u0019>\u001c7n\u00149uS>t7/\u0001\u0004v]2|7m\u001b\u000b\t\u0007#\u0019Iba\u0007\u0004\u001eA1\u00111IA)\u0007'\u00012!UB\u000b\u0013\r\u00199B\u0015\u0002\u0005+:LG\u000fC\u0004\u0002\n:\u0002\r!a\b\t\u000f\u00055h\u00061\u0001\u0002p\"A\u00111\u0013\u0018\u0011\u0002\u0003\u0007\u0011.\u0001\tv]2|7m\u001b\u0013eK\u001a\fW\u000f\u001c;%gQA1\u0011CB\u0012\u0007K\u00199\u0003C\u0004\u0002\nB\u0002\r!a\b\t\u000f\u00055\b\u00071\u0001\u0002p\"9\u0011q\u001a\u0019A\u0002\r%\u0002\u0003BA,\u0007WIAa!\f\u0002Z\tiQK\u001c7pG.|\u0005\u000f^5p]N\f1bZ3u\u0003:$Gk\\;dQRA!\u0011RB\u001a\u0007k\u0019I\u0004C\u0004\u0002\nF\u0002\r!a\b\t\r\r]\u0012\u00071\u0001j\u0003\u0019)\u0007\u0010]5ss\"A\u00111S\u0019\u0011\u0002\u0003\u0007\u0011.A\u000bhKR\fe\u000e\u001a+pk\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0015\u0011\t%5qHB!\u0007\u0007Bq!!#4\u0001\u0004\ty\u0002\u0003\u0004\u00048M\u0002\r!\u001b\u0005\b\u0003\u001f\u001c\u0004\u0019AB#!\u0011\t9fa\u0012\n\t\r%\u0013\u0011\f\u0002\u0013\u000f\u0016$\u0018I\u001c3U_V\u001c\u0007n\u00149uS>t7/\u0001\u0005m_>\\W\u000f]%o)!\u0019yea\u0016\u0004Z\r\r\u0004CBA\"\u0003#\u001a\t\u0006\u0005\u0003\u0002X\rM\u0013\u0002BB+\u00033\u0012a\u0002T8pWV\u0004\u0018J\u001c*fgVdG\u000fC\u0004\u0002\nR\u0002\r!a\b\t\u000f\tMF\u00071\u0001\u0004\\A1!q\u0017B_\u0007;\u0002B!a\u0016\u0004`%!1\u0011MA-\u00051aun\\6va&s7\u000b]3d\u0011!\t\u0019\n\u000eI\u0001\u0002\u0004I\u0017A\u00057p_.,\b/\u00138%I\u00164\u0017-\u001e7uIM\"\u0002ba\u0014\u0004j\r-4Q\u000e\u0005\b\u0003\u00133\u0004\u0019AA\u0010\u0011\u001d\u0011\u0019L\u000ea\u0001\u00077Bq!a47\u0001\u0004\u0019y\u0007\u0005\u0003\u0002X\rE\u0014\u0002BB:\u00033\u0012q\u0002T8pWV\u0004\u0018J\\(qi&|gn]\u0001\u000eO\u0016$\u0018I\\=SKBd\u0017nY1\u0015\r\re4\u0011QBB!\u0019\t\u0019%!\u0015\u0004|A!\u0011qKB?\u0013\u0011\u0019y(!\u0017\u0003!\u001d+GOU3qY&\u001c\u0017MU3tk2$\bbBAEo\u0001\u0007\u0011q\u0004\u0005\t\u0003';\u0004\u0013!a\u0001S\u00069r-\u001a;B]f\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$HE\r\u000b\u0007\u0007s\u001aIia#\t\u000f\u0005%\u0015\b1\u0001\u0002 !9\u0011qZ\u001dA\u0002\r5\u0005\u0003BA,\u0007\u001fKAa!%\u0002Z\t!r)\u001a;B]f\u0014V\r\u001d7jG\u0006|\u0005\u000f^5p]N\fabZ3u\u00032d'+\u001a9mS\u000e\f7\u000f\u0006\u0004\u0004\u0018\u000eu5q\u0014\t\u0007\u0003\u0007\u001aIja\u001f\n\t\rm\u0015Q\t\u0002\u0006'\u001acW\u000f\u001f\u0005\b\u0003\u0013S\u0004\u0019AA\u0010\u0011!\t\u0019J\u000fI\u0001\u0002\u0004I\u0017\u0001G4fi\u0006cGNU3qY&\u001c\u0017m\u001d\u0013eK\u001a\fW\u000f\u001c;%eQ11qSBS\u0007OCq!!#=\u0001\u0004\ty\u0002C\u0004\u0002Pr\u0002\ra!+\u0011\t\u0005]31V\u0005\u0005\u0007[\u000bIFA\u000bHKR\fE\u000e\u001c*fa2L7-Y:PaRLwN\\:\u0002\u000bQ|Wo\u00195\u0015\u0011\u0005\u000531WB[\u0007oCq!!#>\u0001\u0004\ty\u0002\u0003\u0004\u00048u\u0002\r!\u001b\u0005\t\u0003'k\u0004\u0013!a\u0001S\u0006yAo\\;dQ\u0012\"WMZ1vYR$3\u0007\u0006\u0005\u0002B\ru6qXBa\u0011\u001d\tIi\u0010a\u0001\u0003?Aaaa\u000e@\u0001\u0004I\u0007bBAh\u007f\u0001\u000711\u0019\t\u0005\u0003/\u001a)-\u0003\u0003\u0004H\u0006e#\u0001\u0004+pk\u000eDw\n\u001d;j_:\u001c\u0018AB3ySN$8\u000f\u0006\u0004\u0004N\u000eU7q\u001b\t\u0007\u0003\u0007\n\tfa4\u0011\t\u0005]3\u0011[\u0005\u0005\u0007'\fIF\u0001\u0007Fq&\u001cHo\u001d*fgVdG\u000fC\u0004\u0002\n\u0002\u0003\r!a\b\t\u0011\u0005M\u0005\t%AA\u0002%\f\u0001#\u001a=jgR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0015\r\r57Q\\Bp\u0011\u001d\tII\u0011a\u0001\u0003?Aq!a4C\u0001\u0004\u0019\t\u000f\u0005\u0003\u0002X\r\r\u0018\u0002BBs\u00033\u0012Q\"\u0012=jgR\u001cx\n\u001d;j_:\u001c\u0018\u0001B:dC:$Baa;\u0004tB1\u00111IBM\u0007[\u0004B!a\u0016\u0004p&!1\u0011_A-\u0005)\u00196-\u00198SKN,H\u000e\u001e\u0005\b\u0007k\u001c\u0005\u0019AB|\u0003!\u00198-\u00198UsB,\u0007\u0003BA,\u0007sLAaa?\u0002Z\tA1kY1o)f\u0004X\rK\u0002D\u0007\u007f\u0004B\u0001\"\u0001\u0005\u001e9!A1\u0001C\f\u001d\u0011!)\u0001\"\u0006\u000f\t\u0011\u001dA1\u0003\b\u0005\t\u0013!\tB\u0004\u0003\u0005\f\u0011=a\u0002BA\u0013\t\u001bI\u0011!T\u0005\u0003\u00172K!!\u0013&\n\u0005yD\u0015\u0002BAU\u0003\u000bIA\u0001\"\u0007\u0005\u001c\u0005I1\u000b^1cS2LG/\u001f\u0006\u0005\u0003S\u000b)!\u0003\u0003\u0005 \u0011\u0005\"\u0001\u0003,pY\u0006$\u0018\u000e\\3\u000b\t\u0011eA1\u0004\u000b\u0007\u0007W$)\u0003b\n\t\u000f\rUH\t1\u0001\u0004x\"9A\u0011\u0006#A\u0002\u0011-\u0012\u0001B8qiN\u0004B!a\u0016\u0005.%!AqFA-\u0005-\u00196-\u00198PaRLwN\\:)\u0007\u0011\u001by\u0010")
public class ReactiveCollection {
    private final AsyncCollection async;
    private final Function1<Durability, Duration> kvTimeout;
    private final Duration kvReadTimeout;
    private final ClusterEnvironment environment;
    private final Core core;
    private final ExecutionContext ec;

    public Function1<Durability, Duration> kvTimeout() {
        return this.kvTimeout;
    }

    public Duration kvReadTimeout() {
        return this.kvReadTimeout;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    private Core core() {
        return this.core;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public String name() {
        return this.async.name();
    }

    public String bucketName() {
        return this.async.bucketName();
    }

    public String scopeName() {
        return this.async.scopeName();
    }

    public <T> SMono<MutationResult> insert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> insert(String id, T content, InsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability insert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration insert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> replace(String id, T content, long cas, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, cas, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> replace(String id, T content, ReplaceOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, options, serializer), this.ec()));
    }

    public <T> long replace$default$3() {
        return 0L;
    }

    public <T> Durability replace$default$4() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration replace$default$5() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> upsert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> upsert(String id, T content, UpsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability upsert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration upsert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<MutationResult> remove(String id, long cas, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, cas, durability, timeout), this.ec()));
    }

    public SMono<MutationResult> remove(String id, RemoveOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, options), this.ec()));
    }

    public long remove$default$2() {
        return 0L;
    }

    public Durability remove$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration remove$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> get(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, timeout), this.ec()));
    }

    public SMono<GetResult> get(String id, GetOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, options), this.ec()));
    }

    public Duration get$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, long cas, StoreSemantics document, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, cas, document, durability, timeout), this.ec()));
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, MutateInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, options), this.ec()));
    }

    public long mutateIn$default$3() {
        return 0L;
    }

    public StoreSemantics mutateIn$default$4() {
        return StoreSemantics$Replace$.MODULE$;
    }

    public Durability mutateIn$default$5() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration mutateIn$default$6() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, timeout), this.ec()));
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, options), this.ec()));
    }

    public Duration getAndLock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<BoxedUnit> unlock(String id, long cas, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, timeout), this.ec()));
    }

    public SMono<BoxedUnit> unlock(String id, long cas, UnlockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, options), this.ec()));
    }

    public Duration unlock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, timeout), this.ec()));
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, options), this.ec()));
    }

    public Duration getAndTouch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, timeout), this.ec()));
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, LookupInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, options), this.ec()));
    }

    public Duration lookupIn$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.getAnyReplica(id, new GetAnyReplicaOptions(GetAnyReplicaOptions$.MODULE$.apply$default$1(), GetAnyReplicaOptions$.MODULE$.apply$default$2(), GetAnyReplicaOptions$.MODULE$.apply$default$3(), GetAnyReplicaOptions$.MODULE$.apply$default$4()).timeout(timeout)));
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        return this.getAllReplicas(id, options.convert()).timeout(timeout).next();
    }

    public Duration getAnyReplica$default$2() {
        return this.kvReadTimeout();
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, Duration timeout) {
        return this.getAllReplicas(id, new GetAllReplicasOptions(GetAllReplicasOptions$.MODULE$.apply$default$1(), GetAllReplicasOptions$.MODULE$.apply$default$2(), GetAllReplicasOptions$.MODULE$.apply$default$3(), GetAllReplicasOptions$.MODULE$.apply$default$4()).timeout(timeout));
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        Success success;
        Seq reqs;
        RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().retryStrategy());
        Transcoder transcoder = (Transcoder)options.transcoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().transcoder());
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        Try<Seq<GetRequest>> reqsTry = this.async.getFromReplicaHandler().requestAll(id, DurationConversions$.MODULE$.scalaDurationToJava(timeout), retryStrategy, options.parentSpan());
        Try<Seq<GetRequest>> try_ = reqsTry;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
        }
        if (try_ instanceof Success && (reqs = (Seq)(success = (Success)try_).value()) != null) {
            Seq seq = reqs;
            return SFlux$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
                Seq monos = (Seq)seq.map((Function1 & Serializable & scala.Serializable)request -> {
                    this.core().send((Request)request);
                    return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)r -> {
                        GetRequest getRequest = request;
                        boolean isReplica = getRequest == null;
                        Option<GetReplicaResult> option = $this.async.getFromReplicaHandler().response((KeyValueRequest<GetResponse>)request, id, (GetResponse)r, isReplica, transcoder);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            GetReplicaResult getResult = (GetReplicaResult)some.value();
                            return SMono$.MODULE$.just((Object)getResult);
                        }
                        return SMono$.MODULE$.empty();
                    }).doOnNext((Function1 & Serializable & scala.Serializable)x$1 -> {
                        ReactiveCollection.$anonfun$getAllReplicas$6(request, x$1);
                        return BoxedUnit.UNIT;
                    }).doOnError((Function1 & Serializable & scala.Serializable)err -> {
                        ReactiveCollection.$anonfun$getAllReplicas$7(request, err);
                        return BoxedUnit.UNIT;
                    });
                }, Seq$.MODULE$.canBuildFrom());
                return SFlux$.MODULE$.mergeSequential(monos, SFlux$.MODULE$.mergeSequential$default$2(), SFlux$.MODULE$.mergeSequential$default$3()).timeout(timeout);
            });
        }
        throw new MatchError(try_);
    }

    public Duration getAllReplicas$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutationResult> touch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, timeout), this.ec()));
    }

    public SMono<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, options), this.ec()));
    }

    public Duration touch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<ExistsResult> exists(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, timeout), this.ec()));
    }

    public SMono<ExistsResult> exists(String id, ExistsOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, options), this.ec()));
    }

    public Duration exists$default$2() {
        return this.kvReadTimeout();
    }

    @Stability.Volatile
    public SFlux<ScanResult> scan(ScanType scanType) {
        return this.scan(scanType, new ScanOptions(ScanOptions$.MODULE$.apply$default$1(), ScanOptions$.MODULE$.apply$default$2(), ScanOptions$.MODULE$.apply$default$3(), ScanOptions$.MODULE$.apply$default$4(), ScanOptions$.MODULE$.apply$default$5(), ScanOptions$.MODULE$.apply$default$6(), ScanOptions$.MODULE$.apply$default$7(), ScanOptions$.MODULE$.apply$default$8(), ScanOptions$.MODULE$.apply$default$9()));
    }

    @Stability.Volatile
    public SFlux<ScanResult> scan(ScanType scanType, ScanOptions opts) {
        return this.async.scanRequest(scanType, opts);
    }

    public static final /* synthetic */ void $anonfun$getAllReplicas$6(GetRequest request$1, GetReplicaResult x$1) {
        request$1.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$getAllReplicas$7(GetRequest request$1, Throwable err) {
        request$1.context().logicallyComplete(err);
    }

    public ReactiveCollection(AsyncCollection async) {
        this.async = async;
        this.kvTimeout = (Function1 & Serializable & scala.Serializable)durability -> TimeoutUtil$.MODULE$.kvTimeout($this.async.environment(), (Durability)durability);
        this.kvReadTimeout = async.kvReadTimeout();
        this.environment = async.environment();
        this.core = async.core();
        this.ec = async.ec();
    }
}

