/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.BucketConfigUtil;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpecStandard;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Insert$;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.StoreSemantics$Upsert$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.concurrent.ExecutionContext;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005-e!B\u0004\t\u00011!\u0002\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\t\u000b\u0001\u0002A\u0011A\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\t\u0013\u0005=\u0003!%A\u0005\u0002\u0005E\u0003bBA6\u0001\u0011\u0005\u0011Q\u000e\u0005\n\u0003\u0013\u0003\u0011\u0013!C\u0001\u0003'\u0012q\"T;uCR,\u0017J\u001c%b]\u0012dWM\u001d\u0006\u0003\u0013)\t\u0001\u0002[1oI2,'o\u001d\u0006\u0003\u00171\t!a\u001b<\u000b\u00055q\u0011!B:dC2\f'BA\b\u0011\u0003\u0019\u0019G.[3oi*\u0011\u0011CE\u0001\nG>,8\r\u001b2bg\u0016T\u0011aE\u0001\u0004G>l7C\u0001\u0001\u0016!\t1\u0002$D\u0001\u0018\u0015\u0005i\u0011BA\r\u0018\u0005\u0019\te.\u001f*fM\u0006\u0011\u0001\u000e]\u0002\u0001!\tib$D\u0001\r\u0013\tyBBA\u0007IC:$G.\u001a:QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t\"\u0003CA\u0012\u0001\u001b\u0005A\u0001\"\u0002\u000e\u0003\u0001\u0004a\u0012a\u0002:fcV,7\u000f^\u000b\u0004O\u0005uBC\u0005\u0015E#v\u0013wM\u001c9v\u007f\u0006=\u00111CA\f\u0003O!\"!\u000b\u001f\u0011\u0007)\u0012D'D\u0001,\u0015\taS&A\u0005qk\nd\u0017n\u001d5fe*\u0011QB\f\u0006\u0003_A\nAaY8sK*\t\u0011'A\u0004sK\u0006\u001cGo\u001c:\n\u0005MZ#!B*N_:|\u0007CA\u001b;\u001b\u00051$BA\u00068\u0015\tA\u0014(A\u0002ng\u001eT!a\f\b\n\u0005m2$aE*vE\u0012|7-T;uCR,'+Z9vKN$\b\"B\u001f\u0004\u0001\bq\u0014AA3d!\ty$)D\u0001A\u0015\t\tu#\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0011!\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B#\u0004\u0001\u00041\u0015AA5e!\t9eJ\u0004\u0002I\u0019B\u0011\u0011jF\u0007\u0002\u0015*\u00111jG\u0001\u0007yI|w\u000e\u001e \n\u00055;\u0012A\u0002)sK\u0012,g-\u0003\u0002P!\n11\u000b\u001e:j]\u001eT!!T\f\t\u000bI\u001b\u0001\u0019A*\u0002\tM\u0004Xm\u0019\t\u0004)^KV\"A+\u000b\u0005Y;\u0012AC2pY2,7\r^5p]&\u0011\u0001,\u0016\u0002\u0004'\u0016\f\bC\u0001.\\\u001b\u0005Q\u0011B\u0001/\u000b\u00051iU\u000f^1uK&s7\u000b]3d\u0011\u0015q6\u00011\u0001`\u0003\r\u0019\u0017m\u001d\t\u0003-\u0001L!!Y\f\u0003\t1{gn\u001a\u0005\bG\u000e\u0001\n\u00111\u0001e\u0003!!wnY;nK:$\bC\u0001.f\u0013\t1'B\u0001\bTi>\u0014XmU3nC:$\u0018nY:\t\u000b!\u001c\u0001\u0019A5\u0002\u0015\u0011,(/\u00192jY&$\u0018\u0010\u0005\u0002kY6\t1N\u0003\u0002i\u0019%\u0011Qn\u001b\u0002\u000b\tV\u0014\u0018MY5mSRL\b\"B8\u0004\u0001\u0004y\u0016aE3ya&\u0014\u00180\u00129pG\"$\u0016.\\3TK\u000e\u001c\b\"B9\u0004\u0001\u0004\u0011\u0018A\u00049sKN,'O^3FqBL'/\u001f\t\u0003-ML!\u0001^\f\u0003\u000f\t{w\u000e\\3b]\")ao\u0001a\u0001o\u00069A/[7f_V$\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003\u0011!\u0018.\\3\u000b\u0003q\fAA[1wC&\u0011a0\u001f\u0002\t\tV\u0014\u0018\r^5p]\"9\u0011\u0011A\u0002A\u0002\u0005\r\u0011!\u0004:fiJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI!O\u0001\u0006e\u0016$(/_\u0005\u0005\u0003\u001b\t9AA\u0007SKR\u0014\u0018p\u0015;sCR,w-\u001f\u0005\u0007\u0003#\u0019\u0001\u0019\u0001:\u0002\u001b\u0005\u001c7-Z:t\t\u0016dW\r^3e\u0011\u0019\t)b\u0001a\u0001e\u0006y1M]3bi\u0016\f5\u000fR3mKR,G\rC\u0004\u0002\u001a\r\u0001\r!a\u0007\u0002\u0015Q\u0014\u0018M\\:d_\u0012,'\u000f\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\t\u0003D\u0001\u0006G>$WmY\u0005\u0005\u0003K\tyB\u0001\u0006Ue\u0006t7oY8eKJDq!!\u000b\u0004\u0001\u0004\tY#\u0001\u0006qCJ,g\u000e^*qC:\u0004RAFA\u0017\u0003cI1!a\f\u0018\u0005\u0019y\u0005\u000f^5p]B!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028e\n1a\u00198d\u0013\u0011\tY$!\u000e\u0003\u0017I+\u0017/^3tiN\u0003\u0018M\u001c\u0003\b\u0003\u007f\u0019!\u0019AA!\u0005\u0005!\u0016\u0003BA\"\u0003\u0013\u00022AFA#\u0013\r\t9e\u0006\u0002\b\u001d>$\b.\u001b8h!\r1\u00121J\u0005\u0004\u0003\u001b:\"aA!os\u0006\t\"/Z9vKN$H\u0005Z3gCVdG\u000f\n\u001b\u0016\t\u0005M\u0013\u0011N\u000b\u0003\u0003+R3\u0001ZA,W\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\u0013Ut7\r[3dW\u0016$'bAA2/\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0014Q\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GaBA \t\t\u0007\u0011\u0011I\u0001\te\u0016\u001c\bo\u001c8tKRQ\u0011qNA;\u0003\u0007\u000b))a\"\u0011\u0007i\u000b\t(C\u0002\u0002t)\u0011a\"T;uCR,\u0017J\u001c*fgVdG\u000f\u0003\u0004&\u000b\u0001\u0007\u0011q\u000f\t\u0006k\u0005e\u0014QP\u0005\u0004\u0003w2$aD&fsZ\u000bG.^3SKF,Xm\u001d;\u0011\u0007U\ny(C\u0002\u0002\u0002Z\u0012AcU;cI>\u001cW*\u001e;bi\u0016\u0014Vm\u001d9p]N,\u0007\"B#\u0006\u0001\u00041\u0005bB2\u0006!\u0003\u0005\r\u0001\u001a\u0005\b\u0003W*\u0001\u0019AA?\u0003I\u0011Xm\u001d9p]N,G\u0005Z3gCVdG\u000fJ\u001a")
public class MutateInHandler {
    private final HandlerParams hp;

    public <T> SMono<SubdocMutateRequest> request(String id, Seq<MutateInSpec> spec, long cas, StoreSemantics document, Durability durability, long expiryEpochTimeSecs, boolean preserveExpiry, Duration timeout, RetryStrategy retryStrategy, boolean accessDeleted, boolean createAsDeleted, Transcoder transcoder, Option<RequestSpan> parentSpan, ExecutionContext ec) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)cas), "cas").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)expiryEpochTimeSecs), "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))));
        if (validations.isFailure()) {
            return SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> validations);
        }
        Option failed = spec.collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends MutateInSpec, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                MutateInSpecStandard mutateInSpecStandard;
                A1 A1 = x1;
                if (A1 instanceof MutateInSpecStandard && (mutateInSpecStandard = (MutateInSpecStandard)A1).fragment().isFailure()) {
                    return (B1)mutateInSpecStandard;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MutateInSpec x1) {
                MutateInSpecStandard mutateInSpecStandard;
                MutateInSpec mutateInSpec = x1;
                return mutateInSpec instanceof MutateInSpecStandard && (mutateInSpecStandard = (MutateInSpecStandard)mutateInSpec).fragment().isFailure();
            }
        });
        Option option = failed;
        if (option instanceof Some) {
            Some some = (Some)option;
            MutateInSpecStandard failed2 = (MutateInSpecStandard)some.value();
            return SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)failed2.fragment().failed().get()));
        }
        ArrayList commands = new ArrayList();
        ((IterableLike)((SeqLike)((TraversableLike)spec.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)v -> ((MutateInSpec)v._1()).convert(v._2$mcI$sp()), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MutateInHandler.$anonfun$request$11(x$1)), (Ordering)Ordering.Boolean$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)commands.add(v)));
        if (commands.isEmpty()) {
            return SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)SubdocMutateRequest.errIfNoCommands((ErrorContext)ReducedKeyValueErrorContext.create((String)id))));
        }
        if (commands.size() > 16) {
            return SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)SubdocMutateRequest.errIfTooManyCommands((ErrorContext)ReducedKeyValueErrorContext.create((String)id))));
        }
        boolean requiresBucketConfig = createAsDeleted;
        RequestSpan span = this.hp.tracer().requestSpan("mutate_in", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()));
        if (requiresBucketConfig) {
            return SMono$.MODULE$.apply((Publisher)BucketConfigUtil.waitForBucketConfig((Core)this.hp.core(), (String)this.hp.bucketName(), (Duration)timeout)).flatMap((Function1 & Serializable & scala.Serializable)bucketConfig -> {
                StoreSemantics storeSemantics = document;
                StoreSemantics$Insert$ storeSemantics$Insert$ = StoreSemantics$Insert$.MODULE$;
                StoreSemantics storeSemantics2 = document;
                StoreSemantics$Upsert$ storeSemantics$Upsert$ = StoreSemantics$Upsert$.MODULE$;
                return SMono$.MODULE$.just((Object)new SubdocMutateRequest(timeout, $this.hp.core().context(), $this.hp.collectionIdentifier(), bucketConfig, retryStrategy, id, !(storeSemantics != null ? !storeSemantics.equals(storeSemantics$Insert$) : storeSemantics$Insert$ != null), !(storeSemantics2 != null ? !storeSemantics2.equals(storeSemantics$Upsert$) : storeSemantics$Upsert$ != null), false, accessDeleted, createAsDeleted, (List)commands, expiryEpochTimeSecs, preserveExpiry, cas, durability.toDurabilityLevel(), span));
            });
        }
        StoreSemantics storeSemantics = document;
        StoreSemantics$Insert$ storeSemantics$Insert$ = StoreSemantics$Insert$.MODULE$;
        StoreSemantics storeSemantics2 = document;
        StoreSemantics$Upsert$ storeSemantics$Upsert$ = StoreSemantics$Upsert$.MODULE$;
        return SMono$.MODULE$.just((Object)new SubdocMutateRequest(timeout, this.hp.core().context(), this.hp.collectionIdentifier(), null, retryStrategy, id, !(storeSemantics != null ? !storeSemantics.equals(storeSemantics$Insert$) : storeSemantics$Insert$ != null), !(storeSemantics2 != null ? !storeSemantics2.equals(storeSemantics$Upsert$) : storeSemantics$Upsert$ != null), false, accessDeleted, createAsDeleted, commands, expiryEpochTimeSecs, preserveExpiry, cas, durability.toDurabilityLevel(), span));
    }

    public <T> StoreSemantics request$default$4() {
        return StoreSemantics$Replace$.MODULE$;
    }

    public MutateInResult response(KeyValueRequest<SubdocMutateResponse> request, String id, StoreSemantics document, SubdocMutateResponse response) {
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            SubDocumentField[] values = response.values();
            return new MutateInResult(id, values, response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        }
        if (ResponseStatus.SUBDOC_FAILURE.equals(responseStatus)) {
            Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.error()));
            if (option instanceof Some) {
                Some some = (Some)option;
                CouchbaseException err = (CouchbaseException)some.value();
                throw err;
            }
            throw new CouchbaseException("Unknown SubDocument failure occurred", (ErrorContext)KeyValueErrorContext.completedRequest(request, (Response)response));
        }
        if (ResponseStatus.NOT_STORED.equals(responseStatus)) {
            StoreSemantics storeSemantics = document;
            if (StoreSemantics$Insert$.MODULE$.equals(storeSemantics)) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
                throw new DocumentExistsException((ErrorContext)ctx);
            }
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        if (ResponseStatus.EXISTS.equals(responseStatus)) {
            StoreSemantics storeSemantics = document;
            if (StoreSemantics$Insert$.MODULE$.equals(storeSemantics)) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
                throw new DocumentExistsException((ErrorContext)ctx);
            }
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
            throw new CasMismatchException((ErrorContext)ctx);
        }
        throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
    }

    public StoreSemantics response$default$3() {
        return StoreSemantics$Replace$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$request$11(SubdocMutateRequest.Command x$1) {
        return !x$1.xattr();
    }

    public MutateInHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

