/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.core.msg.kv.UpsertResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\tiQ\u000b]:feRD\u0015M\u001c3mKJT!a\u0002\u0005\u0002\u0011!\fg\u000e\u001a7feNT!!\u0003\u0006\u0002\u0005-4(BA\u0006\r\u0003\u0015\u00198-\u00197b\u0015\tia\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fA\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003E\t1aY8n'\r\u00011\u0003\u0007\t\u0003)Yi\u0011!\u0006\u0006\u0002\u0017%\u0011q#\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\teQB$J\u0007\u0002\r%\u00111D\u0002\u0002\u0017\u0017\u0016Lh+\u00197vKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011QdI\u0007\u0002=)\u0011\u0011b\b\u0006\u0003A\u0005\n1!\\:h\u0015\t\u0011C\"\u0001\u0003d_J,\u0017B\u0001\u0013\u001f\u00059)\u0006o]3siJ+7\u000f]8og\u0016\u0004\"AJ\u0014\u000e\u0003!I!\u0001\u000b\u0005\u0003\u001d5+H/\u0019;j_:\u0014Vm];mi\u0006\u0011\u0001\u000e]\u0002\u0001!\taS&D\u0001\u000b\u0013\tq#BA\u0007IC:$G.\u001a:QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\r\u0001\u0011\u0015I#\u00011\u0001,\u0003\u001d\u0011X-];fgR,\"!\u000e)\u0015\u001bYzD*\u00171fURd\u0018\u0011BA\n!\r9$\bP\u0007\u0002q)\u0011\u0011(F\u0001\u0005kRLG.\u0003\u0002<q\t\u0019AK]=\u0011\u0005ui\u0014B\u0001 \u001f\u00055)\u0006o]3siJ+\u0017/^3ti\")\u0001i\u0001a\u0001\u0003\u0006\u0011\u0011\u000e\u001a\t\u0003\u0005&s!aQ$\u0011\u0005\u0011+R\"A#\u000b\u0005\u0019S\u0013A\u0002\u001fs_>$h(\u0003\u0002I+\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tAU\u0003C\u0003N\u0007\u0001\u0007a*A\u0004d_:$XM\u001c;\u0011\u0005=\u0003F\u0002\u0001\u0003\u0006#\u000e\u0011\rA\u0015\u0002\u0002)F\u00111K\u0016\t\u0003)QK!!V\u000b\u0003\u000f9{G\u000f[5oOB\u0011AcV\u0005\u00031V\u00111!\u00118z\u0011\u0015Q6\u00011\u0001\\\u0003)!WO]1cS2LG/\u001f\t\u00039zk\u0011!\u0018\u0006\u00035*I!aX/\u0003\u0015\u0011+(/\u00192jY&$\u0018\u0010C\u0003b\u0007\u0001\u0007!-A\nfqBL'/_#q_\u000eDG+[7f'\u0016\u001c7\u000f\u0005\u0002\u0015G&\u0011A-\u0006\u0002\u0005\u0019>tw\rC\u0003g\u0007\u0001\u0007q-\u0001\bqe\u0016\u001cXM\u001d<f\u000bb\u0004\u0018N]=\u0011\u0005QA\u0017BA5\u0016\u0005\u001d\u0011un\u001c7fC:DQa[\u0002A\u00021\fq\u0001^5nK>,H\u000f\u0005\u0002ne6\taN\u0003\u0002pa\u0006!A/[7f\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d8\u0003\u0011\u0011+(/\u0019;j_:DQ!^\u0002A\u0002Y\fQB]3uef\u001cFO]1uK\u001eL\bCA<{\u001b\u0005A(BA=\"\u0003\u0015\u0011X\r\u001e:z\u0013\tY\bPA\u0007SKR\u0014\u0018p\u0015;sCR,w-\u001f\u0005\u0006{\u000e\u0001\rA`\u0001\u000biJ\fgn]2pI\u0016\u0014\bcA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007Q\u0011!B2pI\u0016\u001c\u0017\u0002BA\u0004\u0003\u0003\u0011!\u0002\u0016:b]N\u001cw\u000eZ3s\u0011\u001d\tYa\u0001a\u0001\u0003\u001b\t!b]3sS\u0006d\u0017N_3s!\u0011y\u0018q\u0002(\n\t\u0005E\u0011\u0011\u0001\u0002\u000f\u0015N|gnU3sS\u0006d\u0017N_3s\u0011\u001d\t)b\u0001a\u0001\u0003/\t!\u0002]1sK:$8\u000b]1o!\u0015!\u0012\u0011DA\u000f\u0013\r\tY\"\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\"\u0003\r\u0019gnY\u0005\u0005\u0003O\t\tCA\u0006SKF,Xm\u001d;Ta\u0006t\u0017\u0001\u0003:fgB|gn]3\u0015\u000f\u0015\ni#!\u000e\u00028!11\u0007\u0002a\u0001\u0003_\u0001B!HA\u00199%\u0019\u00111\u0007\u0010\u0003\u001f-+\u0017PV1mk\u0016\u0014V-];fgRDQ\u0001\u0011\u0003A\u0002\u0005Ca!!\u000b\u0005\u0001\u0004a\u0002")
public class UpsertHandler
implements KeyValueRequestHandler<UpsertResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<UpsertRequest> request(String id, T content, Durability durability, long expiryEpochTimeSecs, boolean preserveExpiry, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try<EncodedValue> try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)expiryEpochTimeSecs), "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))));
        if (validations.isFailure()) {
            return validations;
        }
        RequestSpan span = this.hp.tracer().requestSpan("upsert", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()));
        RequestSpan encodeSpan = CbTracing.newSpan((RequestTracer)this.hp.tracer(), (String)"request_encoding", (RequestSpan)span);
        long start = System.nanoTime();
        Transcoder transcoder2 = transcoder;
        if (transcoder2 instanceof TranscoderWithSerializer) {
            TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
            try_ = transcoderWithSerializer.encode(content, serializer);
        } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
            TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
            try_ = transcoderWithoutSerializer.encode(content);
        } else {
            throw new MatchError((Object)transcoder2);
        }
        Try<EncodedValue> encoded = try_;
        long end = System.nanoTime();
        encodeSpan.end();
        Try<EncodedValue> try_2 = encoded;
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            EncodedValue en = (EncodedValue)success.value();
            UpsertRequest out = new UpsertRequest(id, en.encoded(), expiryEpochTimeSecs, preserveExpiry, en.flags(), timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
            out.context().encodeLatency(end - start);
            return new Success((Object)out);
        }
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable err = failure.exception();
            return new Failure((Throwable)new EncodingFailureException(err));
        }
        throw new MatchError(try_2);
    }

    @Override
    public MutationResult response(KeyValueRequest<UpsertResponse> request, String id, UpsertResponse response) {
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            return new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        }
        throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
    }

    public UpsertHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

