/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.kv.ExistsOptions;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetAllReplicasOptions;
import com.couchbase.client.scala.kv.GetAllReplicasOptions$;
import com.couchbase.client.scala.kv.GetAndLockOptions;
import com.couchbase.client.scala.kv.GetAndTouchOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions;
import com.couchbase.client.scala.kv.GetAnyReplicaOptions$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.ReplaceOptions;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.TouchOptions;
import com.couchbase.client.scala.kv.UnlockOptions;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.TimeoutUtil$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r\rh\u0001B\"E\u00015C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u00061\u0002!\t!\u0017\u0005\t9\u0002\u0011\r\u0011\"\u0001E;\"1q\u000e\u0001Q\u0001\nyC\u0001\u0002\u001d\u0001C\u0002\u0013\u0005A)\u001d\u0005\u0007e\u0002\u0001\u000b\u0011B4\t\u000fM\u0004!\u0019!C\u0005i\"11\u0010\u0001Q\u0001\nUDq\u0001 \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005%\u0001A1A\u0005\f\u0005-\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0004\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005e\u0001bBA\u001a\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011%\t\t\nAI\u0001\n\u0003\t\u0019\nC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u00020\"9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0006bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\n\u0003k\u0004\u0011\u0013!C\u0001\u0003oD\u0011\"a@\u0001#\u0003%\tA!\u0001\t\u0013\t\u0015\u0001!%A\u0005\u0002\t\u001d\u0001bBAj\u0001\u0011\u0005!1\u0002\u0005\b\u0005K\u0001A\u0011\u0001B\u0014\u0011%\u0011i\u0004AI\u0001\n\u0003\u0011y\u0004C\u0005\u0003D\u0001\t\n\u0011\"\u0001\u0003F!9!Q\u0005\u0001\u0005\u0002\t%\u0003b\u0002B2\u0001\u0011\u0005!Q\r\u0005\n\u0005_\u0002\u0011\u0013!C\u0001\u0003sD\u0011B!\u001d\u0001#\u0003%\t!!&\t\u0013\tM\u0004!%A\u0005\u0002\u0005E\u0006b\u0002B2\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011%\u0011\t\nAI\u0001\n\u0003\t\t\fC\u0004\u0003\u0002\u0002!\tAa%\t\u000f\t}\u0005\u0001\"\u0001\u0003\"\"I!1\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005+\u0004\u0011\u0013!C\u0001\u0005/D\u0011Ba7\u0001#\u0003%\t!!&\t\u0013\tu\u0007!%A\u0005\u0002\u0005E\u0006b\u0002BP\u0001\u0011\u0005!q\u001c\u0005\b\u0005[\u0004A\u0011\u0001Bx\u0011%\u0011I\u0010AI\u0001\n\u0003\t\t\fC\u0004\u0003n\u0002!\tAa?\t\u000f\r%\u0001\u0001\"\u0001\u0004\f!I11\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0017\u0005\b\u0007\u0013\u0001A\u0011AB\u000f\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[A\u0011ba\u000e\u0001#\u0003%\t!!-\t\u000f\r-\u0002\u0001\"\u0001\u0004:!91q\t\u0001\u0005\u0002\r%\u0003\"CB1\u0001E\u0005I\u0011AAY\u0011\u001d\u00199\u0005\u0001C\u0001\u0007GBqa!\u001d\u0001\t\u0003\u0019\u0019\bC\u0005\u0004\u0002\u0002\t\n\u0011\"\u0001\u00022\"91\u0011\u000f\u0001\u0005\u0002\r\r\u0005bBBH\u0001\u0011\u00051\u0011\u0013\u0005\n\u0007;\u0003\u0011\u0013!C\u0001\u0003cCqaa$\u0001\t\u0003\u0019y\nC\u0004\u0004,\u0002!\ta!,\t\u0013\rU\u0006!%A\u0005\u0002\u0005E\u0006bBBV\u0001\u0011\u00051q\u0017\u0005\b\u0007\u000b\u0004A\u0011ABd\u0011%\u0019)\u000eAI\u0001\n\u0003\t\t\fC\u0004\u0004F\u0002!\taa6\u0003%I+\u0017m\u0019;jm\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0003\u000b\u001a\u000bQa]2bY\u0006T!a\u0012%\u0002\r\rd\u0017.\u001a8u\u0015\tI%*A\u0005d_V\u001c\u0007NY1tK*\t1*A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u001dB\u0011q*U\u0007\u0002!*\tQ)\u0003\u0002S!\n1\u0011I\\=SK\u001a\fQ!Y:z]\u000e\u0004\"!\u0016,\u000e\u0003\u0011K!a\u0016#\u0003\u001f\u0005\u001b\u0018P\\2D_2dWm\u0019;j_:\fa\u0001P5oSRtDC\u0001.\\!\t)\u0006\u0001C\u0003T\u0005\u0001\u0007A+A\u0005lmRKW.Z8viV\ta\f\u0005\u0003P?\u0006<\u0017B\u00011Q\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002cK6\t1M\u0003\u0002e\t\u0006QA-\u001e:bE&d\u0017\u000e^=\n\u0005\u0019\u001c'A\u0003#ve\u0006\u0014\u0017\u000e\\5usB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\tIV\u0014\u0018\r^5p]*\u0011A\u000eU\u0001\u000bG>t7-\u001e:sK:$\u0018B\u00018j\u0005!!UO]1uS>t\u0017AC6w)&lWm\\;uA\u0005i1N\u001e*fC\u0012$\u0016.\\3pkR,\u0012aZ\u0001\u000fWZ\u0014V-\u00193US6,w.\u001e;!\u0003-)gN^5s_:lWM\u001c;\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001\u001f#\u0002\u0007\u0015tg/\u0003\u0002{o\n\u00112\t\\;ti\u0016\u0014XI\u001c<je>tW.\u001a8u\u00031)gN^5s_:lWM\u001c;!\u0003\u0011\u0019wN]3\u0016\u0003y\u00042a`A\u0002\u001b\t\t\tA\u0003\u0002}\r&!\u0011QAA\u0001\u0005\u0011\u0019uN]3\u0002\u000b\r|'/\u001a\u0011\u0002\u0005\u0015\u001cWCAA\u0007!\u0011\ty!!\u0005\u000e\u0003-L1!a\u0005l\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/A\u0002fG\u0002\nAA\\1nKV\u0011\u00111\u0004\t\u0005\u0003;\tYC\u0004\u0003\u0002 \u0005\u001d\u0002cAA\u0011!6\u0011\u00111\u0005\u0006\u0004\u0003Ka\u0015A\u0002\u001fs_>$h(C\u0002\u0002*A\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'bAA\u0015!\u0006Q!-^2lKRt\u0015-\\3\u0002\u0013M\u001cw\u000e]3OC6,\u0017AB5og\u0016\u0014H/\u0006\u0003\u0002:\u0005EDCCA\u001e\u0003\u0007\u000b9)a#\u0002\u000eR!\u0011QHA/!\u0019\ty$!\u0014\u0002R5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0005qk\nd\u0017n\u001d5fe*\u0019Q)a\u0012\u000b\u0007q\fIE\u0003\u0002\u0002L\u00059!/Z1di>\u0014\u0018\u0002BA(\u0003\u0003\u0012QaU'p]>\u0004B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0004\u0003/\"\u0015AA6w\u0013\u0011\tY&!\u0016\u0003\u001d5+H/\u0019;j_:\u0014Vm];mi\"9\u0011q\f\tA\u0004\u0005\u0005\u0014AC:fe&\fG.\u001b>feB1\u00111MA5\u0003[j!!!\u001a\u000b\u0007\u0005\u001dD)A\u0003d_\u0012,7-\u0003\u0003\u0002l\u0005\u0015$A\u0004&t_:\u001cVM]5bY&TXM\u001d\t\u0005\u0003_\n\t\b\u0004\u0001\u0005\u000f\u0005M\u0004C1\u0001\u0002v\t\tA+\u0005\u0003\u0002x\u0005u\u0004cA(\u0002z%\u0019\u00111\u0010)\u0003\u000f9{G\u000f[5oOB\u0019q*a \n\u0007\u0005\u0005\u0005KA\u0002B]fDq!!\"\u0011\u0001\u0004\tY\"\u0001\u0002jI\"9\u0011\u0011\u0012\tA\u0002\u00055\u0014aB2p]R,g\u000e\u001e\u0005\bIB\u0001\n\u00111\u0001b\u0011!\ty\t\u0005I\u0001\u0002\u00049\u0017a\u0002;j[\u0016|W\u000f^\u0001\u0011S:\u001cXM\u001d;%I\u00164\u0017-\u001e7uIM*B!!&\u0002,V\u0011\u0011q\u0013\u0016\u0004C\u0006e5FAAN!\u0011\ti*a*\u000e\u0005\u0005}%\u0002BAQ\u0003G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\u0006+\u0001\u0006b]:|G/\u0019;j_:LA!!+\u0002 \n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000f\u0005M\u0014C1\u0001\u0002v\u0005\u0001\u0012N\\:feR$C-\u001a4bk2$H\u0005N\u000b\u0005\u0003c\u000b),\u0006\u0002\u00024*\u001aq-!'\u0005\u000f\u0005M$C1\u0001\u0002vU!\u0011\u0011XAb)!\tY,!2\u0002H\u0006%G\u0003BA\u001f\u0003{Cq!a\u0018\u0014\u0001\b\ty\f\u0005\u0004\u0002d\u0005%\u0014\u0011\u0019\t\u0005\u0003_\n\u0019\rB\u0004\u0002tM\u0011\r!!\u001e\t\u000f\u0005\u00155\u00031\u0001\u0002\u001c!9\u0011\u0011R\nA\u0002\u0005\u0005\u0007bBAf'\u0001\u0007\u0011QZ\u0001\b_B$\u0018n\u001c8t!\u0011\t\u0019&a4\n\t\u0005E\u0017Q\u000b\u0002\u000e\u0013:\u001cXM\u001d;PaRLwN\\:\u0002\u000fI,\u0007\u000f\\1dKV!\u0011q[Aq)1\tI.a9\u0002f\u0006\u001d\u0018\u0011_Az)\u0011\ti$a7\t\u000f\u0005}C\u0003q\u0001\u0002^B1\u00111MA5\u0003?\u0004B!a\u001c\u0002b\u00129\u00111\u000f\u000bC\u0002\u0005U\u0004bBAC)\u0001\u0007\u00111\u0004\u0005\b\u0003\u0013#\u0002\u0019AAp\u0011%\tI\u000f\u0006I\u0001\u0002\u0004\tY/A\u0002dCN\u00042aTAw\u0013\r\ty\u000f\u0015\u0002\u0005\u0019>tw\rC\u0004e)A\u0005\t\u0019A1\t\u0011\u0005=E\u0003%AA\u0002\u001d\f\u0011C]3qY\u0006\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0011\tI0!@\u0016\u0005\u0005m(\u0006BAv\u00033#q!a\u001d\u0016\u0005\u0004\t)(A\tsKBd\u0017mY3%I\u00164\u0017-\u001e7uIQ*B!!&\u0003\u0004\u00119\u00111\u000f\fC\u0002\u0005U\u0014!\u0005:fa2\f7-\u001a\u0013eK\u001a\fW\u000f\u001c;%kU!\u0011\u0011\u0017B\u0005\t\u001d\t\u0019h\u0006b\u0001\u0003k*BA!\u0004\u0003\u0018QA!q\u0002B\r\u00057\u0011i\u0002\u0006\u0003\u0002>\tE\u0001bBA01\u0001\u000f!1\u0003\t\u0007\u0003G\nIG!\u0006\u0011\t\u0005=$q\u0003\u0003\b\u0003gB\"\u0019AA;\u0011\u001d\t)\t\u0007a\u0001\u00037Aq!!#\u0019\u0001\u0004\u0011)\u0002C\u0004\u0002Lb\u0001\rAa\b\u0011\t\u0005M#\u0011E\u0005\u0005\u0005G\t)F\u0001\bSKBd\u0017mY3PaRLwN\\:\u0002\rU\u00048/\u001a:u+\u0011\u0011ICa\r\u0015\u0015\t-\"Q\u0007B\u001c\u0005s\u0011Y\u0004\u0006\u0003\u0002>\t5\u0002bBA03\u0001\u000f!q\u0006\t\u0007\u0003G\nIG!\r\u0011\t\u0005=$1\u0007\u0003\b\u0003gJ\"\u0019AA;\u0011\u001d\t))\u0007a\u0001\u00037Aq!!#\u001a\u0001\u0004\u0011\t\u0004C\u0004e3A\u0005\t\u0019A1\t\u0011\u0005=\u0015\u0004%AA\u0002\u001d\f\u0001#\u001e9tKJ$H\u0005Z3gCVdG\u000fJ\u001a\u0016\t\u0005U%\u0011\t\u0003\b\u0003gR\"\u0019AA;\u0003A)\bo]3si\u0012\"WMZ1vYR$C'\u0006\u0003\u00022\n\u001dCaBA:7\t\u0007\u0011QO\u000b\u0005\u0005\u0017\u0012)\u0006\u0006\u0005\u0003N\t]#\u0011\fB.)\u0011\tiDa\u0014\t\u000f\u0005}C\u0004q\u0001\u0003RA1\u00111MA5\u0005'\u0002B!a\u001c\u0003V\u00119\u00111\u000f\u000fC\u0002\u0005U\u0004bBAC9\u0001\u0007\u00111\u0004\u0005\b\u0003\u0013c\u0002\u0019\u0001B*\u0011\u001d\tY\r\ba\u0001\u0005;\u0002B!a\u0015\u0003`%!!\u0011MA+\u00055)\u0006o]3si>\u0003H/[8og\u00061!/Z7pm\u0016$\"\"!\u0010\u0003h\t%$1\u000eB7\u0011\u001d\t))\ba\u0001\u00037A\u0011\"!;\u001e!\u0003\u0005\r!a;\t\u000f\u0011l\u0002\u0013!a\u0001C\"A\u0011qR\u000f\u0011\u0002\u0003\u0007q-\u0001\tsK6|g/\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0001\"/Z7pm\u0016$C-\u001a4bk2$HeM\u0001\u0011e\u0016lwN^3%I\u00164\u0017-\u001e7uIQ\"b!!\u0010\u0003x\te\u0004bBACC\u0001\u0007\u00111\u0004\u0005\b\u0003\u0017\f\u0003\u0019\u0001B>!\u0011\t\u0019F! \n\t\t}\u0014Q\u000b\u0002\u000e%\u0016lwN^3PaRLwN\\:\u0002\u0007\u001d,G\u000f\u0006\u0004\u0003\u0006\n5%q\u0012\t\u0007\u0003\u007f\tiEa\"\u0011\t\u0005M#\u0011R\u0005\u0005\u0005\u0017\u000b)FA\u0005HKR\u0014Vm];mi\"9\u0011Q\u0011\u0012A\u0002\u0005m\u0001\u0002CAHEA\u0005\t\u0019A4\u0002\u001b\u001d,G\u000f\n3fM\u0006,H\u000e\u001e\u00133)\u0019\u0011)I!&\u0003\u0018\"9\u0011Q\u0011\u0013A\u0002\u0005m\u0001bBAfI\u0001\u0007!\u0011\u0014\t\u0005\u0003'\u0012Y*\u0003\u0003\u0003\u001e\u0006U#AC$fi>\u0003H/[8og\u0006AQ.\u001e;bi\u0016Le\u000e\u0006\b\u0003$\n-&Q\u0016Bb\u0005\u000b\u0014yM!5\u0011\r\u0005}\u0012Q\nBS!\u0011\t\u0019Fa*\n\t\t%\u0016Q\u000b\u0002\u000f\u001bV$\u0018\r^3J]J+7/\u001e7u\u0011\u001d\t))\na\u0001\u00037AqAa,&\u0001\u0004\u0011\t,\u0001\u0003ta\u0016\u001c\u0007C\u0002BZ\u0005s\u0013i,\u0004\u0002\u00036*\u0019!q\u0017)\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003<\nU&aA*fcB!\u00111\u000bB`\u0013\u0011\u0011\t-!\u0016\u0003\u00195+H/\u0019;f\u0013:\u001c\u0006/Z2\t\u0013\u0005%X\u0005%AA\u0002\u0005-\b\"\u0003BdKA\u0005\t\u0019\u0001Be\u0003!!wnY;nK:$\b\u0003BA*\u0005\u0017LAA!4\u0002V\tq1\u000b^8sKN+W.\u00198uS\u000e\u001c\bb\u00023&!\u0003\u0005\r!\u0019\u0005\t\u0003\u001f+\u0003\u0013!a\u0001O\u0006\u0011R.\u001e;bi\u0016Le\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003IiW\u000f^1uK&sG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\te'\u0006\u0002Be\u00033\u000b!#\\;uCR,\u0017J\u001c\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0011R.\u001e;bi\u0016Le\u000e\n3fM\u0006,H\u000e\u001e\u00137)!\u0011\u0019K!9\u0003d\n\u0015\bbBACU\u0001\u0007\u00111\u0004\u0005\b\u0005_S\u0003\u0019\u0001BY\u0011\u001d\tYM\u000ba\u0001\u0005O\u0004B!a\u0015\u0003j&!!1^A+\u0005=iU\u000f^1uK&sw\n\u001d;j_:\u001c\u0018AC4fi\u0006sG\rT8dWRA!Q\u0011By\u0005g\u00149\u0010C\u0004\u0002\u0006.\u0002\r!a\u0007\t\r\tU8\u00061\u0001h\u0003!awnY6US6,\u0007\u0002CAHWA\u0005\t\u0019A4\u0002)\u001d,G/\u00118e\u0019>\u001c7\u000e\n3fM\u0006,H\u000e\u001e\u00134)!\u0011)I!@\u0003\u0000\u000e\u0005\u0001bBAC[\u0001\u0007\u00111\u0004\u0005\u0007\u0005kl\u0003\u0019A4\t\u000f\u0005-W\u00061\u0001\u0004\u0004A!\u00111KB\u0003\u0013\u0011\u00199!!\u0016\u0003#\u001d+G/\u00118e\u0019>\u001c7n\u00149uS>t7/\u0001\u0004v]2|7m\u001b\u000b\t\u0007\u001b\u0019)ba\u0006\u0004\u001aA1\u0011qHA'\u0007\u001f\u00012aTB\t\u0013\r\u0019\u0019\u0002\u0015\u0002\u0005+:LG\u000fC\u0004\u0002\u0006:\u0002\r!a\u0007\t\u000f\u0005%h\u00061\u0001\u0002l\"A\u0011q\u0012\u0018\u0011\u0002\u0003\u0007q-\u0001\tv]2|7m\u001b\u0013eK\u001a\fW\u000f\u001c;%gQA1QBB\u0010\u0007C\u0019\u0019\u0003C\u0004\u0002\u0006B\u0002\r!a\u0007\t\u000f\u0005%\b\u00071\u0001\u0002l\"9\u00111\u001a\u0019A\u0002\r\u0015\u0002\u0003BA*\u0007OIAa!\u000b\u0002V\tiQK\u001c7pG.|\u0005\u000f^5p]N\f1bZ3u\u0003:$Gk\\;dQRA!QQB\u0018\u0007c\u0019)\u0004C\u0004\u0002\u0006F\u0002\r!a\u0007\t\r\rM\u0012\u00071\u0001h\u0003\u0019)\u0007\u0010]5ss\"A\u0011qR\u0019\u0011\u0002\u0003\u0007q-A\u000bhKR\fe\u000e\u001a+pk\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0015\u0011\t\u001551HB\u001f\u0007\u007fAq!!\"4\u0001\u0004\tY\u0002\u0003\u0004\u00044M\u0002\ra\u001a\u0005\b\u0003\u0017\u001c\u0004\u0019AB!!\u0011\t\u0019fa\u0011\n\t\r\u0015\u0013Q\u000b\u0002\u0013\u000f\u0016$\u0018I\u001c3U_V\u001c\u0007n\u00149uS>t7/\u0001\u0005m_>\\W\u000f]%o)!\u0019Yea\u0015\u0004V\r}\u0003CBA \u0003\u001b\u001ai\u0005\u0005\u0003\u0002T\r=\u0013\u0002BB)\u0003+\u0012a\u0002T8pWV\u0004\u0018J\u001c*fgVdG\u000fC\u0004\u0002\u0006R\u0002\r!a\u0007\t\u000f\t=F\u00071\u0001\u0004XA1!1\u0017B]\u00073\u0002B!a\u0015\u0004\\%!1QLA+\u00051aun\\6va&s7\u000b]3d\u0011!\ty\t\u000eI\u0001\u0002\u00049\u0017A\u00057p_.,\b/\u00138%I\u00164\u0017-\u001e7uIM\"\u0002ba\u0013\u0004f\r\u001d4\u0011\u000e\u0005\b\u0003\u000b3\u0004\u0019AA\u000e\u0011\u001d\u0011yK\u000ea\u0001\u0007/Bq!a37\u0001\u0004\u0019Y\u0007\u0005\u0003\u0002T\r5\u0014\u0002BB8\u0003+\u0012q\u0002T8pWV\u0004\u0018J\\(qi&|gn]\u0001\u000eO\u0016$\u0018I\\=SKBd\u0017nY1\u0015\r\rU4QPB@!\u0019\ty$!\u0014\u0004xA!\u00111KB=\u0013\u0011\u0019Y(!\u0016\u0003!\u001d+GOU3qY&\u001c\u0017MU3tk2$\bbBACo\u0001\u0007\u00111\u0004\u0005\t\u0003\u001f;\u0004\u0013!a\u0001O\u00069r-\u001a;B]f\u0014V\r\u001d7jG\u0006$C-\u001a4bk2$HE\r\u000b\u0007\u0007k\u001a)ia\"\t\u000f\u0005\u0015\u0015\b1\u0001\u0002\u001c!9\u00111Z\u001dA\u0002\r%\u0005\u0003BA*\u0007\u0017KAa!$\u0002V\t!r)\u001a;B]f\u0014V\r\u001d7jG\u0006|\u0005\u000f^5p]N\fabZ3u\u00032d'+\u001a9mS\u000e\f7\u000f\u0006\u0004\u0004\u0014\u000ee51\u0014\t\u0007\u0003\u007f\u0019)ja\u001e\n\t\r]\u0015\u0011\t\u0002\u0006'\u001acW\u000f\u001f\u0005\b\u0003\u000bS\u0004\u0019AA\u000e\u0011!\tyI\u000fI\u0001\u0002\u00049\u0017\u0001G4fi\u0006cGNU3qY&\u001c\u0017m\u001d\u0013eK\u001a\fW\u000f\u001c;%eQ111SBQ\u0007GCq!!\"=\u0001\u0004\tY\u0002C\u0004\u0002Lr\u0002\ra!*\u0011\t\u0005M3qU\u0005\u0005\u0007S\u000b)FA\u000bHKR\fE\u000e\u001c*fa2L7-Y:PaRLwN\\:\u0002\u000bQ|Wo\u00195\u0015\u0011\u0005u2qVBY\u0007gCq!!\">\u0001\u0004\tY\u0002\u0003\u0004\u00044u\u0002\ra\u001a\u0005\t\u0003\u001fk\u0004\u0013!a\u0001O\u0006yAo\\;dQ\u0012\"WMZ1vYR$3\u0007\u0006\u0005\u0002>\re61XB_\u0011\u001d\t)i\u0010a\u0001\u00037Aaaa\r@\u0001\u00049\u0007bBAf\u007f\u0001\u00071q\u0018\t\u0005\u0003'\u001a\t-\u0003\u0003\u0004D\u0006U#\u0001\u0004+pk\u000eDw\n\u001d;j_:\u001c\u0018AB3ySN$8\u000f\u0006\u0004\u0004J\u000eE71\u001b\t\u0007\u0003\u007f\tiea3\u0011\t\u0005M3QZ\u0005\u0005\u0007\u001f\f)F\u0001\u0007Fq&\u001cHo\u001d*fgVdG\u000fC\u0004\u0002\u0006\u0002\u0003\r!a\u0007\t\u0011\u0005=\u0005\t%AA\u0002\u001d\f\u0001#\u001a=jgR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0015\r\r%7\u0011\\Bn\u0011\u001d\t)I\u0011a\u0001\u00037Aq!a3C\u0001\u0004\u0019i\u000e\u0005\u0003\u0002T\r}\u0017\u0002BBq\u0003+\u0012Q\"\u0012=jgR\u001cx\n\u001d;j_:\u001c\b")
public class ReactiveCollection {
    private final AsyncCollection async;
    private final Function1<Durability, Duration> kvTimeout;
    private final Duration kvReadTimeout;
    private final ClusterEnvironment environment;
    private final Core core;
    private final ExecutionContext ec;

    public Function1<Durability, Duration> kvTimeout() {
        return this.kvTimeout;
    }

    public Duration kvReadTimeout() {
        return this.kvReadTimeout;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    private Core core() {
        return this.core;
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    public String name() {
        return this.async.name();
    }

    public String bucketName() {
        return this.async.bucketName();
    }

    public String scopeName() {
        return this.async.scopeName();
    }

    public <T> SMono<MutationResult> insert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> insert(String id, T content, InsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.insert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability insert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration insert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> replace(String id, T content, long cas, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, cas, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> replace(String id, T content, ReplaceOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.replace(id, content, options, serializer), this.ec()));
    }

    public <T> long replace$default$3() {
        return 0L;
    }

    public <T> Durability replace$default$4() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration replace$default$5() {
        return Duration$.MODULE$.MinusInf();
    }

    public <T> SMono<MutationResult> upsert(String id, T content, Durability durability, Duration timeout, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, durability, timeout, serializer), this.ec()));
    }

    public <T> SMono<MutationResult> upsert(String id, T content, UpsertOptions options, JsonSerializer<T> serializer) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.upsert(id, content, options, serializer), this.ec()));
    }

    public <T> Durability upsert$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public <T> Duration upsert$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<MutationResult> remove(String id, long cas, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, cas, durability, timeout), this.ec()));
    }

    public SMono<MutationResult> remove(String id, RemoveOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.remove(id, options), this.ec()));
    }

    public long remove$default$2() {
        return 0L;
    }

    public Durability remove$default$3() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration remove$default$4() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> get(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, timeout), this.ec()));
    }

    public SMono<GetResult> get(String id, GetOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.get(id, options), this.ec()));
    }

    public Duration get$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, long cas, StoreSemantics document, Durability durability, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, cas, document, durability, timeout), this.ec()));
    }

    public SMono<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, MutateInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.mutateIn(id, spec, options), this.ec()));
    }

    public long mutateIn$default$3() {
        return 0L;
    }

    public StoreSemantics mutateIn$default$4() {
        return StoreSemantics$Replace$.MODULE$;
    }

    public Durability mutateIn$default$5() {
        return Durability$Disabled$.MODULE$;
    }

    public Duration mutateIn$default$6() {
        return Duration$.MODULE$.MinusInf();
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, timeout), this.ec()));
    }

    public SMono<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndLock(id, lockTime, options), this.ec()));
    }

    public Duration getAndLock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<BoxedUnit> unlock(String id, long cas, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, timeout), this.ec()));
    }

    public SMono<BoxedUnit> unlock(String id, long cas, UnlockOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.unlock(id, cas, options), this.ec()));
    }

    public Duration unlock$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, timeout), this.ec()));
    }

    public SMono<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.getAndTouch(id, expiry, options), this.ec()));
    }

    public Duration getAndTouch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, timeout), this.ec()));
    }

    public SMono<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, LookupInOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.lookupIn(id, spec, options), this.ec()));
    }

    public Duration lookupIn$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.getAnyReplica(id, new GetAnyReplicaOptions(GetAnyReplicaOptions$.MODULE$.apply$default$1(), GetAnyReplicaOptions$.MODULE$.apply$default$2(), GetAnyReplicaOptions$.MODULE$.apply$default$3(), GetAnyReplicaOptions$.MODULE$.apply$default$4()).timeout(timeout)));
    }

    public SMono<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        return this.getAllReplicas(id, options.convert()).timeout(timeout).next();
    }

    public Duration getAnyReplica$default$2() {
        return this.kvReadTimeout();
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, Duration timeout) {
        return this.getAllReplicas(id, new GetAllReplicasOptions(GetAllReplicasOptions$.MODULE$.apply$default$1(), GetAllReplicasOptions$.MODULE$.apply$default$2(), GetAllReplicasOptions$.MODULE$.apply$default$3(), GetAllReplicasOptions$.MODULE$.apply$default$4()).timeout(timeout));
    }

    public SFlux<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        Success success;
        Seq reqs;
        SFlux sFlux;
        RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().retryStrategy());
        Transcoder transcoder = (Transcoder)options.transcoder().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.environment().transcoder());
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        Try<Seq<GetRequest>> reqsTry = this.async.getFromReplicaHandler().requestAll(id, DurationConversions$.MODULE$.scalaDurationToJava(timeout), retryStrategy, options.parentSpan());
        Try<Seq<GetRequest>> try_ = reqsTry;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
        } else if (try_ instanceof Success && (reqs = (Seq)(success = (Success)try_).value()) != null) {
            Seq seq = reqs;
            sFlux = SFlux$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
                Seq monos = (Seq)seq.map((Function1 & Serializable & scala.Serializable)request -> {
                    this.core().send((Request)request);
                    return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)r -> {
                        SMono sMono;
                        GetRequest getRequest = request;
                        boolean bl = getRequest == null;
                        boolean isReplica = bl;
                        Option<GetReplicaResult> option = $this.async.getFromReplicaHandler().response((KeyValueRequest<GetResponse>)request, id, (GetResponse)r, isReplica, transcoder);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            GetReplicaResult getResult = (GetReplicaResult)some.value();
                            sMono = SMono$.MODULE$.just((Object)getResult);
                        } else {
                            sMono = SMono$.MODULE$.empty();
                        }
                        return sMono;
                    }).doOnNext((Function1 & Serializable & scala.Serializable)x$1 -> {
                        ReactiveCollection.$anonfun$getAllReplicas$6(request, x$1);
                        return BoxedUnit.UNIT;
                    }).doOnError((Function1 & Serializable & scala.Serializable)err -> {
                        ReactiveCollection.$anonfun$getAllReplicas$7(request, err);
                        return BoxedUnit.UNIT;
                    });
                }, Seq$.MODULE$.canBuildFrom());
                return SFlux$.MODULE$.mergeSequential(monos, SFlux$.MODULE$.mergeSequential$default$2(), SFlux$.MODULE$.mergeSequential$default$3()).timeout(timeout);
            });
        } else {
            throw new MatchError(try_);
        }
        return sFlux;
    }

    public Duration getAllReplicas$default$2() {
        return this.kvReadTimeout();
    }

    public SMono<MutationResult> touch(String id, Duration expiry, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, timeout), this.ec()));
    }

    public SMono<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.touch(id, expiry, options), this.ec()));
    }

    public Duration touch$default$3() {
        return this.kvReadTimeout();
    }

    public SMono<ExistsResult> exists(String id, Duration timeout) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, timeout), this.ec()));
    }

    public SMono<ExistsResult> exists(String id, ExistsOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture($this.async.exists(id, options), this.ec()));
    }

    public Duration exists$default$2() {
        return this.kvReadTimeout();
    }

    public static final /* synthetic */ void $anonfun$getAllReplicas$6(GetRequest request$1, GetReplicaResult x$1) {
        request$1.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$getAllReplicas$7(GetRequest request$1, Throwable err) {
        request$1.context().logicallyComplete(err);
    }

    public ReactiveCollection(AsyncCollection async) {
        this.async = async;
        this.kvTimeout = (Function1 & Serializable & scala.Serializable)durability -> TimeoutUtil$.MODULE$.kvTimeout($this.async.environment(), (Durability)durability);
        this.kvReadTimeout = async.kvReadTimeout();
        this.environment = async.environment();
        this.core = async.core();
        this.ec = async.ec();
    }
}

