/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandlerWithTranscoder;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000bQ\u0004A\u0011I;\u0003%\u001d+G/\u00118e)>,8\r\u001b%b]\u0012dWM\u001d\u0006\u0003\u000f!\t\u0001\u0002[1oI2,'o\u001d\u0006\u0003\u0013)\t!a\u001b<\u000b\u0005-a\u0011!B:dC2\f'BA\u0007\u000f\u0003\u0019\u0019G.[3oi*\u0011q\u0002E\u0001\nG>,8\r\u001b2bg\u0016T\u0011!E\u0001\u0004G>l7c\u0001\u0001\u00141A\u0011ACF\u0007\u0002+)\t1\"\u0003\u0002\u0018+\t1\u0011I\\=SK\u001a\u0004B!\u0007\u000e\u001dK5\ta!\u0003\u0002\u001c\r\t!3*Z=WC2,XMU3rk\u0016\u001cH\u000fS1oI2,'oV5uQR\u0013\u0018M\\:d_\u0012,'\u000f\u0005\u0002\u001eG5\taD\u0003\u0002\n?)\u0011\u0001%I\u0001\u0004[N<'B\u0001\u0012\r\u0003\u0011\u0019wN]3\n\u0005\u0011r\"aE$fi\u0006sG\rV8vG\"\u0014Vm\u001d9p]N,\u0007C\u0001\u0014(\u001b\u0005A\u0011B\u0001\u0015\t\u0005%9U\r\u001e*fgVdG/\u0001\u0002ia\u000e\u0001\u0001C\u0001\u0017.\u001b\u0005Q\u0011B\u0001\u0018\u000b\u00055A\u0015M\u001c3mKJ\u0004\u0016M]1ng\u00061A(\u001b8jiz\"\"!\r\u001a\u0011\u0005e\u0001\u0001\"B\u0015\u0003\u0001\u0004Y\u0013a\u0002:fcV,7\u000f^\u000b\u0003k-$bAN M-b\u0003\u0007cA\u001c;y5\t\u0001H\u0003\u0002:+\u0005!Q\u000f^5m\u0013\tY\u0004HA\u0002Uef\u0004\"!H\u001f\n\u0005yr\"AE$fi\u0006sG\rV8vG\"\u0014V-];fgRDQ\u0001Q\u0002A\u0002\u0005\u000b!!\u001b3\u0011\u0005\tKeBA\"H!\t!U#D\u0001F\u0015\t1%&\u0001\u0004=e>|GOP\u0005\u0003\u0011V\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*\u0006\u0005\u0006\u001b\u000e\u0001\rAT\u0001\u000bKb\u0004\u0018N]1uS>t\u0007CA(U\u001b\u0005\u0001&BA)S\u0003\u0011!\u0018.\\3\u000b\u0003M\u000bAA[1wC&\u0011Q\u000b\u0015\u0002\t\tV\u0014\u0018\r^5p]\")qk\u0001a\u0001\u001d\u00069A/[7f_V$\b\"B-\u0004\u0001\u0004Q\u0016!\u0004:fiJL8\u000b\u001e:bi\u0016<\u0017\u0010\u0005\u0002\\=6\tAL\u0003\u0002^C\u0005)!/\u001a;ss&\u0011q\f\u0018\u0002\u000e%\u0016$(/_*ue\u0006$XmZ=\t\u000b\u0005\u001c\u0001\u0019\u00012\u0002\u0015A\f'/\u001a8u'B\fg\u000eE\u0002\u0015G\u0016L!\u0001Z\u000b\u0003\r=\u0003H/[8o!\t1\u0017.D\u0001h\u0015\tA\u0017%A\u0002d]\u000eL!A[4\u0003\u0017I+\u0017/^3tiN\u0003\u0018M\u001c\u0003\u0006Y\u000e\u0011\r!\u001c\u0002\u0002)F\u0011a.\u001d\t\u0003)=L!\u0001]\u000b\u0003\u000f9{G\u000f[5oOB\u0011AC]\u0005\u0003gV\u00111!\u00118z\u0003!\u0011Xm\u001d9p]N,G#B\u0013wund\b\"B\u001a\u0005\u0001\u00049\bcA\u000fy9%\u0011\u0011P\b\u0002\u0010\u0017\u0016Lh+\u00197vKJ+\u0017/^3ti\")\u0001\t\u0002a\u0001\u0003\")A\u000f\u0002a\u00019!)Q\u0010\u0002a\u0001}\u0006QAO]1og\u000e|G-\u001a:\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0006\u0002\u000b\r|G-Z2\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u000b)J\fgn]2pI\u0016\u0014\b")
public class GetAndTouchHandler
implements KeyValueRequestHandlerWithTranscoder<GetAndTouchResponse, GetResult> {
    private final HandlerParams hp;

    public <T> Try<GetAndTouchRequest> request(String id, Duration expiration, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(expiration, "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))));
        return validations.isFailure() ? validations : new Success((Object)new GetAndTouchRequest(id, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, expiration.getSeconds(), this.hp.tracer().requestSpan("get_and_touch", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
    }

    @Override
    public GetResult response(KeyValueRequest<GetAndTouchResponse> request, String id, GetAndTouchResponse response, Transcoder transcoder) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (ResponseStatus)response.status());
                throw new DocumentNotFoundException((ErrorContext)ctx);
            }
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        GetResult getResult = new GetResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)response.content()), response.flags(), response.cas(), (Option<Instant>)Option$.MODULE$.empty(), transcoder);
        return getResult;
    }

    public GetAndTouchHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

