/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rmh\u0001B%K\u0001MC\u0001\"\u0017\u0001\u0003\u0002\u0013\u0006IA\u0017\u0005\nG\u0002\u0011)\u0019!C\u0001\u0015\u0012D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\n[\u0002\u0011)\u0019!C\u0001\u0015:D\u0001\" \u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\u0006}\u0002!\ta \u0005\u000b\u0003\u0017\u0001!\u0019!C\u0002\u0015\u00065\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0004\t\u0011\u0001\u0004!\u0019!C\u0001\u0003;Aq!a\b\u0001A\u0003%Q\fC\u0005j\u0001\t\u0007I\u0011\u0001(\u0002\"!A\u00111\u0006\u0001!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002.\u0001\u0011\r\u0011\"\u0001K\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\u000b\u0003s\u0001!\u0019!C\u0001\u0015\u0006m\u0002\u0002CA%\u0001\u0001\u0006I!!\u0010\t\u0015\u0005-\u0003A1A\u0005\u0002)\u000bY\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA\u001f\u0011)\ty\u0005\u0001b\u0001\n\u0003Q\u0015\u0011\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002T!Q\u0011\u0011\r\u0001C\u0002\u0013\u0005!*a\u0019\t\u0011\u0005U\u0004\u0001)A\u0005\u0003KB!\"a\u001e\u0001\u0005\u0004%\tASA=\u0011!\t\t\t\u0001Q\u0001\n\u0005m\u0004BCAB\u0001\t\u0007I\u0011\u0001&\u0002\u0006\"A\u0011Q\u0012\u0001!\u0002\u0013\t9\tC\u0006\u0002\u0010\u0002A)\u0019!C\u0001\u0015\u0006E\u0005bCAR\u0001!\u0015\r\u0011\"\u0001K\u0003KC1\"a-\u0001\u0011\u000b\u0007I\u0011\u0001&\u00026\"Q\u00111\u0019\u0001C\u0002\u0013\u0005!*!2\t\u0011\u0005\r\b\u0001)A\u0005\u0003\u000fD!\"!:\u0001\u0005\u0004%\tASAt\u0011!\t\t\u0010\u0001Q\u0001\n\u0005%\bBCAz\u0001!\u0015\r\u0011\"\u0001\u0002v\"Q!1\u0003\u0001\t\u0006\u0004%\tA!\u0006\t\u0015\t}\u0001\u0001#b\u0001\n\u0003\u0011\t\u0003\u0003\u0006\u00030\u0001A)\u0019!C\u0001\u0005cA!B!\u0011\u0001\u0011\u000b\u0007I\u0011\u0001B\"\u0011\u001d\ti\u000b\u0001C\u0001\u0005\u001bBq!a\u001c\u0001\t\u0003\u0011I\u0006C\u0004\u0002p\u0001!\tAa\u001e\t\u0013\tM\u0005!%A\u0005\u0002\tU\u0005\"\u0003BU\u0001E\u0005I\u0011\u0001BV\u0011%\u0011y\u000bAI\u0001\n\u0003\u0011\t\fC\u0004\u00036\u0002!\tAa.\t\u000f\tU\u0006\u0001\"\u0001\u0003P\"I!Q\u001c\u0001\u0012\u0002\u0013\u0005!q\u001c\u0005\n\u0005G\u0004\u0011\u0013!C\u0001\u0005WCqA!:\u0001\t\u0003\u00119\u000fC\u0004\u0003f\u0002!\ta!\u0006\t\u0013\ru\u0001!%A\u0005\u0002\t-\u0006bBB\u0010\u0001\u0011\u00051\u0011\u0005\u0005\n\u0007[\u0001\u0011\u0013!C\u0001\u0005WCqaa\f\u0001\t\u0003\u0019\t\u0004C\u0005\u0004D\u0001\t\n\u0011\"\u0001\u0004F!91q\u0006\u0001\u0005\u0002\r%\u0003bBB,\u0001\u0011\u00051\u0011\f\u0005\n\u0007W\u0002\u0011\u0013!C\u0001\u0007[Bqaa\u0016\u0001\t\u0003\u0019\t\bC\u0004\u0004|\u0001!\ta! \t\u000f\rm\u0004\u0001\"\u0001\u0004\u0002\"A1Q\u0012\u0001\u0005\u0002)\u001byiB\u0004\u0004\u0012*C\taa%\u0007\r%S\u0005\u0012ABK\u0011\u0019q\b\t\"\u0001\u0004\u0018\"91\u0011\u0014!\u0005\u0002\rm\u0005bBBM\u0001\u0012\u00051Q\u0017\u0005\b\u00073\u0003E\u0011ABa\u0011!\u0011)\u000f\u0011C\u0001\u0019\u000e\u001d\u0007\u0002CBq\u0001\u0012\u0005Aja9\t\u0011\r\u0005\b\t\"\u0001M\u0007[D\u0001b!=A\t\u0003a51\u001f\u0002\r\u0003NLhnY\"mkN$XM\u001d\u0006\u0003\u00172\u000bQa]2bY\u0006T!!\u0014(\u0002\r\rd\u0017.\u001a8u\u0015\ty\u0005+A\u0005d_V\u001c\u0007NY1tK*\t\u0011+A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)B\u0011QkV\u0007\u0002-*\t1*\u0003\u0002Y-\n1\u0011I\\=SK\u001a\f1\"\u001a8wSJ|g.\\3oiB\u0019QkW/\n\u0005q3&\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005y\u000bW\"A0\u000b\u0005\u0001T\u0015aA3om&\u0011!m\u0018\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u0002KB\u0011aM[\u0007\u0002O*\u0011\u0001\r\u001b\u0006\u0003S2\u000bAaY8sK&\u00111n\u001a\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005I1/Z3e\u001d>$Wm]\u000b\u0002_B\u0019\u0001o\u001e>\u000f\u0005E,\bC\u0001:W\u001b\u0005\u0019(B\u0001;S\u0003\u0019a$o\\8u}%\u0011aOV\u0001\u0007!J,G-\u001a4\n\u0005aL(aA*fi*\u0011aO\u0016\t\u0003=nL!\u0001`0\u0003\u0011M+W\r\u001a(pI\u0016\f!b]3fI:{G-Z:!\u0003\u0019a\u0014N\\5u}QA\u0011\u0011AA\u0003\u0003\u000f\tI\u0001E\u0002\u0002\u0004\u0001i\u0011A\u0013\u0005\u00073\u001a!\t\u0019\u0001.\t\u000b\r4\u0001\u0019A3\t\u000b54\u0001\u0019A8\u0002\u0005\u0015\u001cWCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b-\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00111\u0003\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!+\u0005i\u0016\u0001B3om\u0002*\"!a\t\u0011\t\u0005\u0015\u0012qE\u0007\u0002Q&\u0019\u0011\u0011\u00065\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\u0003QB,\"!!\r\u0011\t\u0005\r\u00111G\u0005\u0004\u0003kQ%A\u0005%b]\u0012dWM\u001d\"bg&\u001c\u0007+\u0019:b[N\f1\u0001\u001b9!\u00035\u0019X-\u0019:dQRKW.Z8viV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\n\u0003!!WO]1uS>t\u0017\u0002BA$\u0003\u0003\u0012\u0001\u0002R;sCRLwN\\\u0001\u000fg\u0016\f'o\u00195US6,w.\u001e;!\u0003A\tg.\u00197zi&\u001c7\u000fV5nK>,H/A\tb]\u0006d\u0017\u0010^5dgRKW.Z8vi\u0002\nQB]3uef\u001cFO]1uK\u001eLXCAA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-Q\u0006)!/\u001a;ss&!\u0011QLA,\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\u0006q!/\u001a;ssN#(/\u0019;fOf\u0004\u0013\u0001D9vKJL\b*\u00198eY\u0016\u0014XCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0001\u0002[1oI2,'o\u001d\u0006\u0004\u0003_R\u0015!B9vKJL\u0018\u0002BA:\u0003S\u0012A\"U;fefD\u0015M\u001c3mKJ\fQ\"];fefD\u0015M\u001c3mKJ\u0004\u0013\u0001E1oC2LH/[2t\u0011\u0006tG\r\\3s+\t\tY\b\u0005\u0003\u0002h\u0005u\u0014\u0002BA@\u0003S\u0012\u0001#\u00118bYf$\u0018nY:IC:$G.\u001a:\u0002#\u0005t\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014\b%A\u0007tK\u0006\u00148\r\u001b%b]\u0012dWM]\u000b\u0003\u0003\u000f\u0003B!a\u001a\u0002\n&!\u00111RA5\u00055\u0019V-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0006q1/Z1sG\"D\u0015M\u001c3mKJ\u0004\u0013a\u0005:fC\u000e$\u0018N^3Vg\u0016\u0014X*\u00198bO\u0016\u0014XCAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bA!^:fe*\u0019\u0011Q\u0014&\u0002\u000f5\fg.Y4fe&!\u0011\u0011UAL\u0005M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0003U\u0011X-Y2uSZ,')^2lKRl\u0015M\\1hKJ,\"!a*\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WSA!!,\u0002\u001c\u00061!-^2lKRLA!!-\u0002,\n)\"+Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014\u0018!\b:fC\u000e$\u0018N^3B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u007fk!!a/\u000b\t\u0005u\u00161T\u0001\nC:\fG.\u001f;jGNLA!!1\u0002<\ni\"+Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/\u0001\u000bF[B$\u0018PT1nK\u0012\u0004\u0016M]1nKR,'o]\u000b\u0003\u0003\u000f\u0004\u0002\"!3\u0002T\u0006]\u0017Q\\\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#4\u0016AC2pY2,7\r^5p]&!\u0011Q[Af\u0005\ri\u0015\r\u001d\t\u0004a\u0006e\u0017bAAns\n11\u000b\u001e:j]\u001e\u00042!VAp\u0013\r\t\tO\u0016\u0002\u0004\u0003:L\u0018!F#naRLh*Y7fIB\u000b'/Y7fi\u0016\u00148\u000fI\u0001\u001a\u000b6\u0004H/\u001f)pg&$\u0018n\u001c8bYB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002jB1\u00111^Aw\u0003;l!!a4\n\t\u0005=\u0018q\u001a\u0002\u0004'\u0016\f\u0018AG#naRL\bk\\:ji&|g.\u00197QCJ\fW.\u001a;feN\u0004\u0013a\u00022vG.,Go]\u000b\u0003\u0003o\u0004B!!+\u0002z&!\u00111`AV\u0005I\t5/\u001f8d\u0005V\u001c7.\u001a;NC:\fw-\u001a:)\u0007\t\ny\u0010\u0005\u0003\u0003\u0002\t5a\u0002\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\u0007\t\u001d\u0001.\u0001\u0006b]:|G/\u0019;j_:LAAa\u0003\u0003\u0006\u0005I1\u000b^1cS2LG/_\u0005\u0005\u0005\u001f\u0011\tB\u0001\u0005W_2\fG/\u001b7f\u0015\u0011\u0011YA!\u0002\u0002\u000bU\u001cXM]:\u0016\u0005\t]\u0001\u0003BAK\u00053IAAa\u0007\u0002\u0018\n\u0001\u0012i]=oGV\u001bXM]'b]\u0006<WM\u001d\u0015\u0004G\u0005}\u0018\u0001D9vKJL\u0018J\u001c3fq\u0016\u001cXC\u0001B\u0012!\u0011\u0011)C!\u000b\u000e\u0005\t\u001d\"\u0002BA8\u00037KAAa\u000b\u0003(\t1\u0012i]=oGF+XM]=J]\u0012,\u00070T1oC\u001e,'\u000fK\u0002%\u0003\u007f\fQb]3be\u000eD\u0017J\u001c3fq\u0016\u001cXC\u0001B\u001a!\u0011\u0011)Da\u000f\u000e\u0005\t]\"\u0002\u0002B\u001d\u00037\u000baa]3be\u000eD\u0017\u0002\u0002B\u001f\u0005o\u0011q#Q:z]\u000e\u001cV-\u0019:dQ&sG-\u001a=NC:\fw-\u001a:)\u0007\u0015\ny0\u0001\tb]\u0006d\u0017\u0010^5dg&sG-\u001a=fgV\u0011!Q\t\t\u0005\u0003s\u00139%\u0003\u0003\u0003J\u0005m&AG!ts:\u001c\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014\bf\u0001\u0014\u0002\u0000R!!q\nB+!\u0011\t\u0019A!\u0015\n\u0007\tM#JA\u0006Bgft7MQ;dW\u0016$\bb\u0002B,O\u0001\u0007\u0011q[\u0001\u000bEV\u001c7.\u001a;OC6,GC\u0002B.\u0005S\u0012i\u0007\u0005\u0004\u0002\u0012\tu#\u0011M\u0005\u0005\u0005?\n\u0019B\u0001\u0004GkR,(/\u001a\t\u0005\u0005G\u0012)'\u0004\u0002\u0002n%!!qMA7\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000f\t-\u0004\u00061\u0001\u0002X\u0006I1\u000f^1uK6,g\u000e\u001e\u0005\b\u0005_B\u0003\u0019\u0001B9\u0003\u001dy\u0007\u000f^5p]N\u0004BAa\u0019\u0003t%!!QOA7\u00051\tV/\u001a:z\u001fB$\u0018n\u001c8t))\u0011YF!\u001f\u0003|\t\u0015%\u0011\u0012\u0005\b\u0005WJ\u0003\u0019AAl\u0011%\u0011i(\u000bI\u0001\u0002\u0004\u0011y(\u0001\u0006qCJ\fW.\u001a;feN\u0004BAa\u0019\u0003\u0002&!!1QA7\u0005=\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001c\b\"\u0003BDSA\u0005\t\u0019AA\u001f\u0003\u001d!\u0018.\\3pkRD\u0011Ba#*!\u0003\u0005\rA!$\u0002\u000b\u0005$\u0007n\\2\u0011\u0007U\u0013y)C\u0002\u0003\u0012Z\u0013qAQ8pY\u0016\fg.A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119J\u000b\u0003\u0003\u0000\te5F\u0001BN!\u0011\u0011iJ!*\u000e\u0005\t}%\u0002\u0002BQ\u0005G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001da+\u0003\u0003\u0003(\n}%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011/^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003.*\"\u0011Q\bBM\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\"TC\u0001BZU\u0011\u0011iI!'\u0002\u001d\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ssR1!\u0011\u0018Bc\u0005\u000f\u0004b!!\u0005\u0003^\tm\u0006\u0003\u0002B_\u0005\u0003l!Aa0\u000b\u0007\u0005u&*\u0003\u0003\u0003D\n}&aD!oC2LH/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\t-T\u00061\u0001\u0002X\"9!qN\u0017A\u0002\t%\u0007\u0003\u0002B_\u0005\u0017LAA!4\u0003@\n\u0001\u0012I\\1msRL7m](qi&|gn\u001d\u000b\t\u0005s\u0013\tNa5\u0003\\\"9!1\u000e\u0018A\u0002\u0005]\u0007\"\u0003B?]A\u0005\t\u0019\u0001Bk!\u0011\u0011iLa6\n\t\te'q\u0018\u0002\u0014\u0003:\fG.\u001f;jGN\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0005\u000fs\u0003\u0013!a\u0001\u0003{\t\u0001$\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tO\u000b\u0003\u0003V\ne\u0015\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y1/Z1sG\"\fV/\u001a:z)!\u0011IO!?\u0003~\u000e-\u0001CBA\t\u0005;\u0012Y\u000f\u0005\u0003\u0003n\nUXB\u0001Bx\u0015\u0011\u0011\tPa=\u0002\rI,7/\u001e7u\u0015\r\u0011IDS\u0005\u0005\u0005o\u0014yO\u0001\u0007TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u0003|F\u0002\r!a6\u0002\u0013%tG-\u001a=OC6,\u0007bBA8c\u0001\u0007!q \t\u0005\u0007\u0003\u00199!\u0004\u0002\u0004\u0004)!1Q\u0001Bz\u0003\u001d\tX/\u001a:jKNLAa!\u0003\u0004\u0004\tY1+Z1sG\"\fV/\u001a:z\u0011\u001d\u0011y'\ra\u0001\u0007\u001b\u0001Baa\u0004\u0004\u00125\u0011!1_\u0005\u0005\u0007'\u0011\u0019PA\u0007TK\u0006\u00148\r[(qi&|gn\u001d\u000b\t\u0005S\u001c9b!\u0007\u0004\u001c!9!1 \u001aA\u0002\u0005]\u0007bBA8e\u0001\u0007!q \u0005\n\u0005\u000f\u0013\u0004\u0013!a\u0001\u0003{\tQc]3be\u000eD\u0017+^3ss\u0012\"WMZ1vYR$3'\u0001\u0006eSN\u001cwN\u001c8fGR$Baa\t\u0004,A1\u0011\u0011\u0003B/\u0007K\u00012!VB\u0014\u0013\r\u0019IC\u0016\u0002\u0005+:LG\u000fC\u0005\u0003\bR\u0002\n\u00111\u0001\u0002>\u0005!B-[:d_:tWm\u0019;%I\u00164\u0017-\u001e7uIE\n1\u0002Z5bO:|7\u000f^5dgR!11GB !\u0019\t\tB!\u0018\u00046A!1qGB\u001e\u001b\t\u0019IDC\u0002\u00040!LAa!\u0010\u0004:\t\tB)[1h]>\u001cH/[2t%\u0016\u001cX\u000f\u001c;\t\u0013\r\u0005c\u0007%AA\u0002\u0005]\u0017\u0001\u0003:fa>\u0014H/\u00133\u0002+\u0011L\u0017m\u001a8pgRL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\t\u0016\u0005\u0003/\u0014I\n\u0006\u0003\u00044\r-\u0003b\u0002B8q\u0001\u00071Q\n\t\u0005\u0007\u001f\u001a\u0019&\u0004\u0002\u0004R)\u00191q\u0006&\n\t\rU3\u0011\u000b\u0002\u0013\t&\fwM\\8ti&\u001c7o\u00149uS>t7/\u0001\u0003qS:<G\u0003BB.\u0007G\u0002b!!\u0005\u0003^\ru\u0003\u0003BB\u001c\u0007?JAa!\u0019\u0004:\tQ\u0001+\u001b8h%\u0016\u001cX\u000f\u001c;\t\u0013\t\u001d\u0015\b%AA\u0002\r\u0015\u0004#B+\u0004h\u0005u\u0012bAB5-\n1q\n\u001d;j_:\fa\u0002]5oO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004p)\"1Q\rBM)\u0011\u0019Yfa\u001d\t\u000f\t=4\b1\u0001\u0004vA!1qJB<\u0013\u0011\u0019Ih!\u0015\u0003\u0017AKgnZ(qi&|gn]\u0001\u000fo\u0006LG/\u00168uS2\u0014V-\u00193z)\u0011\u0019\u0019ca \t\u000f\t\u001dE\b1\u0001\u0002>Q111EBB\u0007\u000bCqAa\">\u0001\u0004\ti\u0004C\u0004\u0003pu\u0002\raa\"\u0011\t\r=3\u0011R\u0005\u0005\u0007\u0017\u001b\tFA\u000bXC&$XK\u001c;jYJ+\u0017\rZ=PaRLwN\\:\u0002)A,'OZ8s[\u001ecwNY1m\u0007>tg.Z2u)\t\u0019)#\u0001\u0007Bgft7m\u00117vgR,'\u000fE\u0002\u0002\u0004\u0001\u001b\"\u0001\u0011+\u0015\u0005\rM\u0015aB2p]:,7\r\u001e\u000b\t\u0007;\u001bIk!,\u00042B11qTBS\u0003\u0003i!a!)\u000b\u0007\r\rf+\u0001\u0003vi&d\u0017\u0002BBT\u0007C\u00131\u0001\u0016:z\u0011\u001d\u0019YK\u0011a\u0001\u0003/\f\u0001cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\t\u000f\r=&\t1\u0001\u0002X\u0006AQo]3s]\u0006lW\rC\u0004\u00044\n\u0003\r!a6\u0002\u0011A\f7o]<pe\u0012$ba!(\u00048\u000ee\u0006bBBV\u0007\u0002\u0007\u0011q\u001b\u0005\b\u0005_\u001a\u0005\u0019AB^!\u0011\t\u0019a!0\n\u0007\r}&J\u0001\bDYV\u001cH/\u001a:PaRLwN\\:\u0015\r\ru51YBc\u0011\u0015iG\t1\u0001p\u0011\u001d\u0011y\u0007\u0012a\u0001\u0007w#ba!3\u0004N\u000e}G\u0003\u0002Bu\u0007\u0017Dq!a\u0003F\u0001\b\ty\u0001C\u0004\u0004P\u0016\u0003\ra!5\u0002\u000fI,\u0017/^3tiB!11[Bn\u001b\t\u0019)N\u0003\u0003\u0003:\r]'bABmQ\u0006\u0019Qn]4\n\t\ru7Q\u001b\u0002\u000e'\u0016\f'o\u00195SKF,Xm\u001d;\t\r%,\u0005\u0019AA\u0012\u0003e)\u0007\u0010\u001e:bGR\u001cE.^:uKJ,eN^5s_:lWM\u001c;\u0015\r\r\u00158q]Bu!\u0015\u0019yj!*^\u0011\u001d\u0019YK\u0012a\u0001\u0003/Dqaa;G\u0001\u0004\u0019Y,\u0001\u0003paR\u001cH\u0003BBs\u0007_Dqaa;H\u0001\u0004\u0019Y,A\u000ftK\u0016$gj\u001c3fg\u001a\u0013x.\\\"p]:,7\r^5p]N#(/\u001b8h)\u0015y7Q_B}\u0011\u001d\u00199\u0010\u0013a\u0001\u0003/\f!aY:\t\u000beC\u0005\u0019A/")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    @Stability.Volatile
    private AsyncBucketManager buckets;
    @Stability.Volatile
    private AsyncUserManager users;
    @Stability.Volatile
    private AsyncQueryIndexManager queryIndexes;
    @Stability.Volatile
    private AsyncSearchIndexManager searchIndexes;
    @Stability.Volatile
    private AsyncAnalyticsIndexManager analyticsIndexes;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile byte bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reactiveUserManager$lzycompute() : this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.reactiveBucketManager$lzycompute() : this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.reactiveAnalyticsIndexManager$lzycompute() : this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.users$lzycompute() : this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            future = this.analyticsHandler().queryAsync(request, this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Future<SearchResult> future;
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            future = AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.env().owned() ? this.env().shutdownInternal(timeout) : SMono$.MODULE$.empty())).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)seedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toCore(), Set$.MODULE$.canBuildFrom())).asJava()));
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)Seq$.MODULE$.empty();
    }
}

