/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.collection;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.config.CollectionsManifestCollection;
import com.couchbase.client.core.config.CollectionsManifestScope;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.collection.CollectionSpec;
import com.couchbase.client.scala.manager.collection.ScopeSpec;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001\u0002\u0015*\u0001YB\u0011\u0002\u0010\u0001\u0003\u0006\u0004%\t!L\u001f\t\u0011\t\u0003!\u0011!Q\u0001\nyBQa\u0011\u0001\u0005\u0002\u0011Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006IA\u0013\u0005\t!\u0002\u0011\r\u0011\"\u0001.#\"1!\f\u0001Q\u0001\nIC\u0001b\u0017\u0001C\u0002\u0013\u0005Q\u0006\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B/\t\r\u0011\u0004A\u0011A\u0017f\u0011!Y\b!%A\u0005\u00025b\bBCA\b\u0001E\u0005I\u0011A\u0017\u0002\u0012!A\u0011Q\u0003\u0001\u0005\u00025\n9\u0002C\u0005\u00028\u0001\t\n\u0011\"\u0001.y\"Q\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005Q&!\u0005\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!A\u0011Q\f\u0001\u0012\u0002\u0013\u0005A\u0010C\u0005\u0002`\u0001\t\n\u0011\"\u0001\u0002\u0012!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004\u0002CA8\u0001E\u0005I\u0011\u0001?\t\u0013\u0005E\u0004!%A\u0005\u0002\u0005E\u0001bBA:\u0001\u0011\u0005\u0011Q\u000f\u0005\t\u0003\u000b\u0003\u0011\u0013!C\u0001y\"I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011!\t\u0019\nAI\u0001\n\u0003a\b\"CAK\u0001E\u0005I\u0011AA\t\u0011\u001d\t9\n\u0001C\u0001\u00033C\u0001\"!)\u0001#\u0003%\t\u0001 \u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003#Aq!!*\u0001\t\u0003\t9\u000b\u0003\u0005\u00020\u0002\t\n\u0011\"\u0001}\u0011%\t\t\fAI\u0001\n\u0003\t\t\u0002C\u0004\u00024\u0002!I!!.\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAm\u0001\u0011%\u00111\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u0010\u0001C\u0005\u0003{\u0014\u0011DU3bGRLg/Z\"pY2,7\r^5p]6\u000bg.Y4fe*\u0011!fK\u0001\u000bG>dG.Z2uS>t'B\u0001\u0017.\u0003\u001di\u0017M\\1hKJT!AL\u0018\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\n\u0014AB2mS\u0016tGO\u0003\u00023g\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002i\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u000e\t\u0003qij\u0011!\u000f\u0006\u0002]%\u00111(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\r\t,8m[3u+\u0005q\u0004CA A\u001b\u0005i\u0013BA!.\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\u0002\u000f\t,8m[3uA\u00051A(\u001b8jiz\"\"!R$\u0011\u0005\u0019\u0003Q\"A\u0015\t\u000bq\u001a\u0001\u0019\u0001 \u0002\t\r|'/Z\u000b\u0002\u0015B\u00111*T\u0007\u0002\u0019*\u0011\u0001jL\u0005\u0003\u001d2\u0013AaQ8sK\u0006)1m\u001c:fA\u0005)B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$X#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005]K\u0014AC2p]\u000e,(O]3oi&\u0011\u0011\f\u0016\u0002\t\tV\u0014\u0018\r^5p]\u00061B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$\b%\u0001\u000beK\u001a\fW\u000f\u001c;SKR\u0014\u0018p\u0015;sCR,w-_\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rT\u0001\u0006e\u0016$(/_\u0005\u0003E~\u0013QBU3uef\u001cFO]1uK\u001eL\u0018!\u00063fM\u0006,H\u000e\u001e*fiJL8\u000b\u001e:bi\u0016<\u0017\u0010I\u0001\u0011G>dG.Z2uS>tW\t_5tiN$BAZ:xsB\u0019qM\u001c9\u000e\u0003!T!!\u001b6\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u0018l\u0015\tAENC\u0001n\u0003\u001d\u0011X-Y2u_JL!a\u001c5\u0003\u000bMkuN\\8\u0011\u0005a\n\u0018B\u0001::\u0005\u001d\u0011un\u001c7fC:DQA\u000b\u0006A\u0002Q\u0004\"AR;\n\u0005YL#AD\"pY2,7\r^5p]N\u0003Xm\u0019\u0005\bq*\u0001\n\u00111\u0001S\u0003\u001d!\u0018.\\3pkRDqA\u001f\u0006\u0011\u0002\u0003\u0007Q,A\u0007sKR\u0014\u0018p\u0015;sCR,w-_\u0001\u001bG>dG.Z2uS>tW\t_5tiN$C-\u001a4bk2$HEM\u000b\u0002{*\u0012!K`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI!O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0019w\u000e\u001c7fGRLwN\\#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019B\u000b\u0002^}\u0006Y1oY8qK\u0016C\u0018n\u001d;t)\u001d1\u0017\u0011DA\u001a\u0003kAq!a\u0007\u000e\u0001\u0004\ti\"A\u0005tG>\u0004XMT1nKB!\u0011qDA\u0017\u001d\u0011\t\t#!\u000b\u0011\u0007\u0005\r\u0012(\u0004\u0002\u0002&)\u0019\u0011qE\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tY#O\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0012\bC\u0004y\u001bA\u0005\t\u0019\u0001*\t\u000fil\u0001\u0013!a\u0001;\u0006)2oY8qK\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012\u0014!F:d_B,W\t_5tiN$C-\u001a4bk2$HeM\u0001\tO\u0016$8kY8qKRA\u0011qHA$\u0003\u0013\nY\u0005\u0005\u0003h]\u0006\u0005\u0003c\u0001$\u0002D%\u0019\u0011QI\u0015\u0003\u0013M\u001bw\u000e]3Ta\u0016\u001c\u0007bBA\u000e!\u0001\u0007\u0011Q\u0004\u0005\bqB\u0001\n\u00111\u0001S\u0011\u001dQ\b\u0003%AA\u0002uCs\u0001EA(\u0003+\nI\u0006E\u00029\u0003#J1!a\u0015:\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003/\n\u0001$^:fA\u001d,G/\u00117m'\u000e|\u0007/Z:!S:\u001cH/Z1eC\t\tY&A\u00032]Er#'\u0001\nhKR\u001c6m\u001c9fI\u0011,g-Y;mi\u0012\u0012\u0014AE4fiN\u001bw\u000e]3%I\u00164\u0017-\u001e7uIM\nAbZ3u\u00032d7kY8qKN$b!!\u001a\u0002l\u00055\u0004#B4\u0002h\u0005\u0005\u0013bAA5Q\n)1K\u00127vq\"9\u0001p\u0005I\u0001\u0002\u0004\u0011\u0006b\u0002>\u0014!\u0003\u0005\r!X\u0001\u0017O\u0016$\u0018\t\u001c7TG>\u0004Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u00051r-\u001a;BY2\u001c6m\u001c9fg\u0012\"WMZ1vYR$#'\u0001\tde\u0016\fG/Z\"pY2,7\r^5p]RA\u0011qOA@\u0003\u0003\u000b\u0019\t\u0005\u0003h]\u0006e\u0004c\u0001\u001d\u0002|%\u0019\u0011QP\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006UY\u0001\r\u0001\u001e\u0005\bqZ\u0001\n\u00111\u0001S\u0011\u001dQh\u0003%AA\u0002u\u000b!d\u0019:fCR,7i\u001c7mK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uII\n!d\u0019:fCR,7i\u001c7mK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM\na\u0002\u001a:pa\u000e{G\u000e\\3di&|g\u000e\u0006\u0005\u0002x\u00055\u0015qRAI\u0011\u0015Q\u0013\u00041\u0001u\u0011\u001dA\u0018\u0004%AA\u0002ICqA_\r\u0011\u0002\u0003\u0007Q,\u0001\ree>\u00048i\u001c7mK\u000e$\u0018n\u001c8%I\u00164\u0017-\u001e7uII\n\u0001\u0004\u001a:pa\u000e{G\u000e\\3di&|g\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003-\u0019'/Z1uKN\u001bw\u000e]3\u0015\u0011\u0005]\u00141TAO\u0003?Cq!a\u0007\u001d\u0001\u0004\ti\u0002C\u0004y9A\u0005\t\u0019\u0001*\t\u000fid\u0002\u0013!a\u0001;\u0006)2M]3bi\u0016\u001c6m\u001c9fI\u0011,g-Y;mi\u0012\u0012\u0014!F2sK\u0006$XmU2pa\u0016$C-\u001a4bk2$HeM\u0001\nIJ|\u0007oU2pa\u0016$\u0002\"a\u001e\u0002*\u0006-\u0016Q\u0016\u0005\b\u00037y\u0002\u0019AA\u000f\u0011\u001dAx\u0004%AA\u0002ICqA_\u0010\u0011\u0002\u0003\u0007Q,A\nee>\u00048kY8qK\u0012\"WMZ1vYR$#'A\nee>\u00048kY8qK\u0012\"WMZ1vYR$3'A\u0007qCRDgi\u001c:TG>\u0004Xm\u001d\u000b\u0005\u0003o\u000b)\r\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\ti,a0\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\fAA[1wC&!\u0011qFA^\u0011\u001d\t9M\ta\u0001\u0003;\t!BY;dW\u0016$h*Y7f\u00031\u0001\u0018\r\u001e5G_J\u001c6m\u001c9f)\u0019\t9,!4\u0002P\"9\u0011qY\u0012A\u0002\u0005u\u0001bBA\u000eG\u0001\u0007\u0011QD\u0001\u0013a\u0006$\bNR8s\u0007>dG.Z2uS>t7\u000f\u0006\u0004\u00028\u0006U\u0017q\u001b\u0005\b\u0003\u000f$\u0003\u0019AA\u000f\u0011\u001d\tY\u0002\na\u0001\u0003;\t\u0011\u0003]1uQ\u001a{'oQ8mY\u0016\u001cG/[8o)!\t9,!8\u0002`\u0006\u0005\bbBAdK\u0001\u0007\u0011Q\u0004\u0005\b\u00037)\u0003\u0019AA\u000f\u0011\u001d\t\u0019/\na\u0001\u0003;\tabY8mY\u0016\u001cG/[8o\u001d\u0006lW-\u0001\u0007m_\u0006$W*\u00198jM\u0016\u001cH\u000f\u0006\u0004\u0002j\u0006]\u0018\u0011 \t\u0005O:\fY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\r\t\t\u0010T\u0001\u0007G>tg-[4\n\t\u0005U\u0018q\u001e\u0002\u0014\u0007>dG.Z2uS>t7/T1oS\u001a,7\u000f\u001e\u0005\u0006q\u001a\u0002\rA\u0015\u0005\u0006u\u001a\u0002\r!X\u0001\u000fG\",7m\u001b$pe\u0016\u0013(o\u001c:t)!\tyPa\u0003\u0003\u001e\t}\u0001C\u0002B\u0001\u0005\u000f\tI(\u0004\u0002\u0003\u0004)\u0019!QA\u001d\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u0013\u0011\u0019AA\u0002UefDqA!\u0004(\u0001\u0004\u0011y!\u0001\u0005sKN\u0004xN\\:f!\u0011\u0011\tB!\u0007\u000e\u0005\tM!b\u0001\u0017\u0003\u0016)\u0019!q\u0003'\u0002\u00075\u001cx-\u0003\u0003\u0003\u001c\tM!AF$f]\u0016\u0014\u0018nY'b]\u0006<WM\u001d*fgB|gn]3\t\u000f\u0005mq\u00051\u0001\u0002\u001e!9\u00111]\u0014A\u0002\u0005u\u0001")
public class ReactiveCollectionManager {
    private final AsyncBucket bucket;
    private final Core core;
    private final Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public AsyncBucket bucket() {
        return this.bucket;
    }

    private Core core() {
        return this.core;
    }

    public Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    public SMono<Object> collectionExists(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable & scala.Serializable)manifest -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$1(collection, manifest)));
    }

    public Duration collectionExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy collectionExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<Object> scopeExists(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$1(scopeName, x$3)));
    }

    public Duration scopeExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy scopeExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<ScopeSpec> getScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllScopes(timeout, retryStrategy).collectSeq().flatMap((Function1 & Serializable & scala.Serializable)scopes -> {
            SMono sMono;
            Option option = scopes.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$getScope$2(scopeName, x$5)));
            if (option instanceof Some) {
                Some some = (Some)option;
                ScopeSpec scope = (ScopeSpec)some.value();
                sMono = SMono$.MODULE$.just((Object)scope);
            } else {
                sMono = SMono$.MODULE$.raiseError((Throwable)new ScopeNotFoundException(scopeName));
            }
            return sMono;
        });
    }

    public Duration getScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<ScopeSpec> getAllScopes(Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)manifest -> {
            Buffer scopes = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(manifest.scopes()).asScala()).map((Function1 & Serializable & scala.Serializable)scope -> {
                Seq collections = (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(scope.collections()).asScala()).map((Function1 & Serializable & scala.Serializable)coll -> new CollectionSpec(coll.name(), scope.name()), Buffer$.MODULE$.canBuildFrom());
                return new ScopeSpec(scope.name(), (Seq<CollectionSpec>)collections);
            }, Buffer$.MODULE$.canBuildFrom());
            return SFlux$.MODULE$.fromIterable((Iterable)scopes);
        });
    }

    public Duration getAllScopes$default$1() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getAllScopes$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", collection.name());
        String path = this.pathForCollections(this.bucket().name(), collection.scopeName());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration createCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForCollection(this.bucket().name(), collection.scopeName(), collection.name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration dropCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", scopeName);
        String path = this.pathForScopes(this.bucket().name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration createScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForScope(this.bucket().name(), scopeName);
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration dropScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropScope$default$3() {
        return this.defaultRetryStrategy();
    }

    private String pathForScopes(String bucketName) {
        return new StringBuilder(30).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)bucketName)).append("/scopes").toString();
    }

    private String pathForScope(String bucketName, String scopeName) {
        return new StringBuilder(1).append(this.pathForScopes(bucketName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)scopeName)).toString();
    }

    private String pathForCollections(String bucketName, String scopeName) {
        return new StringBuilder(12).append(this.pathForScope(bucketName, scopeName)).append("/collections").toString();
    }

    private String pathForCollection(String bucketName, String scopeName, String collectionName) {
        return new StringBuilder(1).append(this.pathForCollections(bucketName, scopeName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)collectionName)).toString();
    }

    private SMono<CollectionsManifest> loadManifest(Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.GET, this.pathForScopes(this.bucket().name()), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            String error = new String(response.content(), StandardCharsets.UTF_8);
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.INVALID_ARGS;
            return !(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null) ? (error.contains("Not allowed on this version of cluster") ? SMono$.MODULE$.raiseError((Throwable)new IllegalArgumentException("This version of Couchbase Server does not support this operation")) : SMono$.MODULE$.raiseError((Throwable)new IllegalArgumentException(error))) : SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CollectionsManifest)JacksonTransformers.MAPPER.readValue(response.content(), CollectionsManifest.class)));
        });
    }

    private Try<BoxedUnit> checkForErrors(GenericManagerResponse response, String scopeName, String collectionName) {
        Success success;
        if (response.status().success()) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else {
            String error = new String(response.content(), StandardCharsets.UTF_8);
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                success = error.matches(".*Scope.+not found.*") || error.contains("scope_not_found") ? new Failure((Throwable)new ScopeNotFoundException(scopeName)) : (error.matches(".*Collection.+not found.*") ? new Failure((Throwable)new CollectionNotFoundException(collectionName)) : (error.contains("Not found.") || error.contains("Requested resource not found.") ? new Failure((Throwable)FeatureNotAvailableException.collections()) : new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()))));
            } else {
                ResponseStatus responseStatus3 = response.status();
                ResponseStatus responseStatus4 = ResponseStatus.INVALID_ARGS;
                success = !(responseStatus3 != null ? !responseStatus3.equals(responseStatus4) : responseStatus4 != null) ? (error.matches(".*Scope.+not found.*") || error.contains("scope_not_found") ? new Failure((Throwable)new ScopeNotFoundException(scopeName)) : (error.matches(".*Scope.+already exists.*") ? new Failure((Throwable)new ScopeExistsException(scopeName)) : (error.matches(".*Collection.+already exists.*") ? new Failure((Throwable)new CollectionExistsException(collectionName)) : new Failure((Throwable)new IllegalArgumentException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()))))) : new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()));
            }
        }
        return success;
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$2(CollectionSpec collection$1, CollectionsManifestScope x$1) {
        String string = x$1.name();
        String string2 = collection$1.scopeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$4(CollectionSpec collection$1, CollectionsManifestCollection x$2) {
        String string = x$2.name();
        String string2 = collection$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$1(CollectionSpec collection$1, CollectionsManifest manifest) {
        Option foundCollection = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(manifest.scopes()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$2(collection$1, x$1))).flatMap((Function1 & Serializable & scala.Serializable)scope -> ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(scope.collections()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$4(collection$1, x$2))));
        return foundCollection.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$2(String scopeName$1, CollectionsManifestScope x$4) {
        String string = x$4.name();
        String string2 = scopeName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$1(String scopeName$1, CollectionsManifest x$3) {
        return ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3.scopes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$2(scopeName$1, x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$getScope$2(String scopeName$2, ScopeSpec x$5) {
        String string = x$5.name();
        String string2 = scopeName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReactiveCollectionManager(AsyncBucket bucket) {
        this.bucket = bucket;
        this.core = bucket.core();
        this.defaultManagerTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.defaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

