/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00194Q\u0001B\u0003\u0001\u0013EA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006E\u0001!\ta\t\u0002\u0011\u0003:\fG.\u001f;jGND\u0015M\u001c3mKJT!AB\u0004\u0002\u0011!\fg\u000e\u001a7feNT!\u0001C\u0005\u0002\u000bE,XM]=\u000b\u0005)Y\u0011!B:dC2\f'B\u0001\u0007\u000e\u0003\u0019\u0019G.[3oi*\u0011abD\u0001\nG>,8\r\u001b2bg\u0016T\u0011\u0001E\u0001\u0004G>l7C\u0001\u0001\u0013!\t\u0019R#D\u0001\u0015\u0015\u0005Q\u0011B\u0001\f\u0015\u0005\u0019\te.\u001f*fM\u0006\u0011\u0001\u000e]\u0002\u0001!\tQ2$D\u0001\n\u0013\ta\u0012B\u0001\nIC:$G.\u001a:CCNL7\rU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u000b!)qC\u0001a\u00013\u00059!/Z9vKN$XC\u0001\u0013^)\u001d)SGQ%O-n\u00032AJ\u0015,\u001b\u00059#B\u0001\u0015\u0015\u0003\u0011)H/\u001b7\n\u0005):#a\u0001+ssB\u0011AfM\u0007\u0002[)\u0011afL\u0001\nC:\fG.\u001f;jGNT!\u0001M\u0019\u0002\u00075\u001cxM\u0003\u00023\u0017\u0005!1m\u001c:f\u0013\t!TF\u0001\tB]\u0006d\u0017\u0010^5dgJ+\u0017/^3ti\")ag\u0001a\u0001o\u0005I1\u000f^1uK6,g\u000e\u001e\t\u0003q}r!!O\u001f\u0011\u0005i\"R\"A\u001e\u000b\u0005qB\u0012A\u0002\u001fs_>$h(\u0003\u0002?)\u00051\u0001K]3eK\u001aL!\u0001Q!\u0003\rM#(/\u001b8h\u0015\tqD\u0003C\u0003D\u0007\u0001\u0007A)A\u0004paRLwN\\:\u0011\u0005\u0015;U\"\u0001$\u000b\u00059J\u0011B\u0001%G\u0005A\te.\u00197zi&\u001c7o\u00149uS>t7\u000fC\u00033\u0007\u0001\u0007!\n\u0005\u0002L\u00196\t\u0011'\u0003\u0002Nc\t!1i\u001c:f\u0011\u0015y5\u00011\u0001Q\u0003-)gN^5s_:lWM\u001c;\u0011\u0005E#V\"\u0001*\u000b\u0005MK\u0011aA3om&\u0011QK\u0015\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG\u000fC\u0003X\u0007\u0001\u0007\u0001,\u0001\u0004ck\u000e\\W\r\u001e\t\u0004'e;\u0014B\u0001.\u0015\u0005\u0019y\u0005\u000f^5p]\")Al\u0001a\u00011\u0006)1oY8qK\u0012)al\u0001b\u0001?\n\tA+\u0005\u0002aGB\u00111#Y\u0005\u0003ER\u0011qAT8uQ&tw\r\u0005\u0002\u0014I&\u0011Q\r\u0006\u0002\u0004\u0003:L\b")
public class AnalyticsHandler {
    private final HandlerBasicParams hp;

    public <T> Try<AnalyticsRequest> request(String statement, AnalyticsOptions options, Core core, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.priority()), "priority").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            JsonObject params = options.encode();
            params.put("statement", statement);
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable & scala.Serializable)queryStr -> {
                byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
                Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().analyticsTimeout()));
                RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> environment.retryStrategy());
                return new AnalyticsRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, core.context().authenticator(), queryBytes, options.priority() ? -1 : 0, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), params.str("client_context_id"), statement, $this.hp.tracer().requestSpan("analytics", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())), (String)bucket.orNull(Predef$.MODULE$.$conforms()), (String)scope.orNull(Predef$.MODULE$.$conforms()));
            });
        }
        return try_;
    }

    public AnalyticsHandler(HandlerBasicParams hp) {
        this.hp = hp;
    }
}

