/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.ClusterOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.ClusterEnvironment$Builder$;
import com.couchbase.client.scala.env.PasswordAuthenticator;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.env.SeedNode$;
import com.couchbase.client.scala.query.handlers.SearchHandler$;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchRow;
import com.couchbase.client.scala.search.result.SearchRow$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.util.Try;

public final class AsyncCluster$ {
    public static AsyncCluster$ MODULE$;

    static {
        new AsyncCluster$();
    }

    public Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return this.connect(connectionString, new ClusterOptions(new PasswordAuthenticator(username, password), ClusterOptions$.MODULE$.apply$default$2()));
    }

    public Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return this.extractClusterEnvironment(connectionString, options).map((Function1 & Serializable & scala.Serializable)ce -> {
            Set<SeedNode> seedNodes = MODULE$.seedNodesFromConnectionString(connectionString, (ClusterEnvironment)ce);
            AsyncCluster cluster = new AsyncCluster((Function0<ClusterEnvironment>)(Function0 & Serializable & scala.Serializable)() -> ce, options.authenticator(), seedNodes);
            cluster.performGlobalConnect();
            return cluster;
        });
    }

    public Try<AsyncCluster> connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        return this.extractClusterEnvironment(options).map((Function1 & Serializable & scala.Serializable)ce -> {
            void var3_3;
            AsyncCluster cluster = new AsyncCluster((Function0<ClusterEnvironment>)(Function0 & Serializable & scala.Serializable)() -> ce, options.authenticator(), seedNodes);
            cluster.performGlobalConnect();
            return var3_3;
        });
    }

    public Future<SearchResult> searchQuery(SearchRequest request, Core core, ExecutionContext ec) {
        core.send((Request)request);
        Future ret = FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable & scala.Serializable)response -> FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows()).map((Function1 & Serializable & scala.Serializable)row -> SearchRow$.MODULE$.fromResponse((SearchChunkRow)row)).collectSeq().flatMap((Function1 & Serializable & scala.Serializable)rows -> FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)trailer -> new SearchResult((Seq<SearchRow>)rows, SearchHandler$.MODULE$.parseSearchFacets((SearchChunkTrailer)trailer), SearchHandler$.MODULE$.parseSearchMeta((SearchResponse)response, (SearchChunkTrailer)trailer))))).toFuture();
        ret.onComplete((Function1 & Serializable & scala.Serializable)x$4 -> request.context().logicallyComplete(), ec);
        return ret;
    }

    public Try<ClusterEnvironment> extractClusterEnvironment(String connectionString, ClusterOptions opts) {
        Try<ClusterEnvironment> try_;
        Option<ClusterEnvironment> option = opts.environment();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterEnvironment env = (ClusterEnvironment)some.value();
            try_ = new Try<ClusterEnvironment>((Object)env);
        } else {
            try_ = new ClusterEnvironment.Builder(true, ClusterEnvironment$Builder$.MODULE$.apply$default$2(), ClusterEnvironment$Builder$.MODULE$.apply$default$3(), ClusterEnvironment$Builder$.MODULE$.apply$default$4(), ClusterEnvironment$Builder$.MODULE$.apply$default$5(), ClusterEnvironment$Builder$.MODULE$.apply$default$6(), ClusterEnvironment$Builder$.MODULE$.apply$default$7(), ClusterEnvironment$Builder$.MODULE$.apply$default$8(), ClusterEnvironment$Builder$.MODULE$.apply$default$9(), ClusterEnvironment$Builder$.MODULE$.apply$default$10(), ClusterEnvironment$Builder$.MODULE$.apply$default$11(), ClusterEnvironment$Builder$.MODULE$.apply$default$12(), ClusterEnvironment$Builder$.MODULE$.apply$default$13(), ClusterEnvironment$Builder$.MODULE$.apply$default$14(), ClusterEnvironment$Builder$.MODULE$.apply$default$15(), ClusterEnvironment$Builder$.MODULE$.apply$default$16(), ClusterEnvironment$Builder$.MODULE$.apply$default$17(), ClusterEnvironment$Builder$.MODULE$.apply$default$18(), ClusterEnvironment$Builder$.MODULE$.apply$default$19()).connectionString(connectionString).build();
        }
        return try_;
    }

    public Try<ClusterEnvironment> extractClusterEnvironment(ClusterOptions opts) {
        Try<ClusterEnvironment> try_;
        Option<ClusterEnvironment> option = opts.environment();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterEnvironment env = (ClusterEnvironment)some.value();
            try_ = new Try<ClusterEnvironment>((Object)env);
        } else {
            try_ = new ClusterEnvironment.Builder(true, ClusterEnvironment$Builder$.MODULE$.apply$default$2(), ClusterEnvironment$Builder$.MODULE$.apply$default$3(), ClusterEnvironment$Builder$.MODULE$.apply$default$4(), ClusterEnvironment$Builder$.MODULE$.apply$default$5(), ClusterEnvironment$Builder$.MODULE$.apply$default$6(), ClusterEnvironment$Builder$.MODULE$.apply$default$7(), ClusterEnvironment$Builder$.MODULE$.apply$default$8(), ClusterEnvironment$Builder$.MODULE$.apply$default$9(), ClusterEnvironment$Builder$.MODULE$.apply$default$10(), ClusterEnvironment$Builder$.MODULE$.apply$default$11(), ClusterEnvironment$Builder$.MODULE$.apply$default$12(), ClusterEnvironment$Builder$.MODULE$.apply$default$13(), ClusterEnvironment$Builder$.MODULE$.apply$default$14(), ClusterEnvironment$Builder$.MODULE$.apply$default$15(), ClusterEnvironment$Builder$.MODULE$.apply$default$16(), ClusterEnvironment$Builder$.MODULE$.apply$default$17(), ClusterEnvironment$Builder$.MODULE$.apply$default$18(), ClusterEnvironment$Builder$.MODULE$.apply$default$19()).build();
        }
        return try_;
    }

    public Set<SeedNode> seedNodesFromConnectionString(String cs, ClusterEnvironment environment) {
        return ((TraversableOnce)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(ConnectionStringUtil.seedNodesFromConnectionString((String)cs, (boolean)environment.coreEnv().ioConfig().dnsSrvEnabled(), (boolean)environment.coreEnv().securityConfig().tlsEnabled(), (EventBus)environment.coreEnv().eventBus())).asScala()).map((Function1 & Serializable & scala.Serializable)sn -> SeedNode$.MODULE$.fromCore((com.couchbase.client.core.env.SeedNode)sn), Set$.MODULE$.canBuildFrom())).toSet();
    }

    private AsyncCluster$() {
        MODULE$ = this;
    }
}

