/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.GenericSearchRequest;
import com.couchbase.client.core.msg.search.GenericSearchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$CompletionStageOps$;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager$;
import com.couchbase.client.scala.manager.search.SearchIndex;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0012$\u0001AB\u0011B\u000e\u0001\u0003\u0006\u0004%\taJ\u001c\t\u0011q\u0002!\u0011!Q\u0001\naB\u0001\"\u0010\u0001\u0003\u0006\u0004%\u0019A\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u007f!)a\t\u0001C\u0001\u000f\"9Q\n\u0001b\u0001\n\u0013q\u0005B\u0002+\u0001A\u0003%q\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ru\u0003\u0001\u0015!\u0003X\u0011\u001dq\u0006A1A\u0005\n}CaA\u001a\u0001!\u0002\u0013\u0001\u0007\"B4\u0001\t\u0003A\u0007\"CA\u0001\u0001E\u0005I\u0011AA\u0002\u0011%\tI\u0002AI\u0001\n\u0003\tY\u0002C\u0004\u0002 \u0001!\t!!\t\t\u0013\u0005m\u0002!%A\u0005\u0002\u0005\r\u0001\"CA\u001f\u0001E\u0005I\u0011AA\u000e\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003B\u0011\"a\u0015\u0001#\u0003%\t!a\u0001\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005m\u0001bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\n\u0003C\u0002\u0011\u0013!C\u0001\u0003\u0007A\u0011\"a\u0019\u0001#\u0003%\t!a\u0007\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\ti\n\u0001C\u0005\u0003?Cq!!(\u0001\t\u0013\tymB\u0004\u0003\b\rB\tA!\u0003\u0007\r\t\u001a\u0003\u0012\u0001B\u0006\u0011\u00191u\u0004\"\u0001\u0003\u000e!A!qB\u0010\u0005\u0002\u001d\u0012\tBA\fBgft7mU3be\u000eD\u0017J\u001c3fq6\u000bg.Y4fe*\u0011A%J\u0001\u0007g\u0016\f'o\u00195\u000b\u0005\u0019:\u0013aB7b]\u0006<WM\u001d\u0006\u0003Q%\nQa]2bY\u0006T!AK\u0016\u0002\r\rd\u0017.\u001a8u\u0015\taS&A\u0005d_V\u001c\u0007NY1tK*\ta&A\u0002d_6\u001c\u0001a\u0005\u0002\u0001cA\u0011!\u0007N\u0007\u0002g)\t\u0001&\u0003\u00026g\t1\u0011I\\=SK\u001a\fqa\u00197vgR,'/F\u00019!\tI$(D\u0001(\u0013\tYtE\u0001\u0007Bgft7m\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003\t)7-F\u0001@!\t\u00015)D\u0001B\u0015\t\u00115'\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001R!\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u00051A(\u001b8jiz\"\"\u0001\u0013'\u0015\u0005%[\u0005C\u0001&\u0001\u001b\u0005\u0019\u0003\"B\u001f\u0006\u0001\by\u0004\"\u0002\u001c\u0006\u0001\u0004A\u0014\u0001B2pe\u0016,\u0012a\u0014\t\u0003!Jk\u0011!\u0015\u0006\u0003\u001b&J!aU)\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\u000f\t\u00164\u0017-\u001e7u)&lWm\\;u+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001.B\u0003!!WO]1uS>t\u0017B\u0001/Z\u0005!!UO]1uS>t\u0017a\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011+g-Y;miJ+GO]=TiJ\fG/Z4z+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2R\u0003\u0015\u0011X\r\u001e:z\u0013\t)'MA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016\t\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u0003!9W\r^%oI\u0016DH\u0003B5pyz\u00042\u0001\u00116m\u0013\tY\u0017I\u0001\u0004GkR,(/\u001a\t\u0003\u00156L!A\\\u0012\u0003\u0017M+\u0017M]2i\u0013:$W\r\u001f\u0005\u0006a2\u0001\r!]\u0001\nS:$W\r\u001f(b[\u0016\u0004\"A]=\u000f\u0005M<\bC\u0001;4\u001b\u0005)(B\u0001<0\u0003\u0019a$o\\8u}%\u0011\u0001pM\u0001\u0007!J,G-\u001a4\n\u0005i\\(AB*ue&twM\u0003\u0002yg!9Q\u0010\u0004I\u0001\u0002\u00049\u0016a\u0002;j[\u0016|W\u000f\u001e\u0005\b\u007f2\u0001\n\u00111\u0001a\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0006\u0011r-\u001a;J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)AK\u0002X\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\u0019\u0014AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013O\u0016$\u0018J\u001c3fq\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u001e)\u001a\u0001-a\u0002\u0002\u001b\u001d,G/\u00117m\u0013:$W\r_3t)\u0019\t\u0019#a\u000e\u0002:A!\u0001I[A\u0013!\u0015\t9#!\rm\u001d\u0011\tI#!\f\u000f\u0007Q\fY#C\u0001)\u0013\r\tycM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019$!\u000e\u0003\u0007M+\u0017OC\u0002\u00020MBq!`\b\u0011\u0002\u0003\u0007q\u000bC\u0004\u0000\u001fA\u0005\t\u0019\u00011\u0002/\u001d,G/\u00117m\u0013:$W\r_3tI\u0011,g-Y;mi\u0012\n\u0014aF4fi\u0006cG.\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-)\bo]3si&sG-\u001a=\u0015\u0011\u0005\r\u00131JA(\u0003#\u0002B\u0001\u00116\u0002FA\u0019!'a\u0012\n\u0007\u0005%3G\u0001\u0003V]&$\bBBA'%\u0001\u0007A.A\bj]\u0012,\u0007\u0010R3gS:LG/[8o\u0011\u001di(\u0003%AA\u0002]Cqa \n\u0011\u0002\u0003\u0007\u0001-A\u000bvaN,'\u000f^%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001a\u0002+U\u00048/\u001a:u\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005IAM]8q\u0013:$W\r\u001f\u000b\t\u0003\u0007\nY&!\u0018\u0002`!)\u0001/\u0006a\u0001c\"9Q0\u0006I\u0001\u0002\u00049\u0006bB@\u0016!\u0003\u0005\r\u0001Y\u0001\u0014IJ|\u0007/\u00138eKb$C-\u001a4bk2$HEM\u0001\u0014IJ|\u0007/\u00138eKb$C-\u001a4bk2$HeM\u0001\fS:$W\r_3t!\u0006$\b.\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0004u\u00065\u0014!C5oI\u0016D\b+\u0019;i)\u0011\tI'a\u001f\t\u000bAL\u0002\u0019A9\u0002\u001d%tG-\u001a=D_VtG\u000fU1uQR!\u0011\u0011NAA\u0011\u0015\u0001(\u00041\u0001r\u0003=9W\r^%oI\u0016D(+Z9vKN$H\u0003CAD\u0003+\u000bI*a'\u0011\t\u0005%\u0015\u0011S\u0007\u0003\u0003\u0017S1\u0001JAG\u0015\r\ty)U\u0001\u0004[N<\u0017\u0002BAJ\u0003\u0017\u0013AcR3oKJL7mU3be\u000eD'+Z9vKN$\bBBAL7\u0001\u0007\u0011/\u0001\u0003oC6,\u0007\"B?\u001c\u0001\u00049\u0006\"B@\u001c\u0001\u0004\u0001\u0017!D:fCJ\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0007\u0002\b\u0006\u0005\u0016QYAe\u0003\u0017\fi\rC\u0004\u0002$r\u0001\r!!*\u0002\r5,G\u000f[8e!\u0011\t9+!1\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bA\u0001\u001b;ua*!\u0011qVAY\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\t\u0019,!.\u0002\u000f!\fg\u000e\u001a7fe*!\u0011qWA]\u0003\u0015qW\r\u001e;z\u0015\u0011\tY,!0\u0002\u0005%|'bAA`#\u0006!A-\u001a9t\u0013\u0011\t\u0019-!+\u0003\u0015!#H\u000f]'fi\"|G\r\u0003\u0004\u0002Hr\u0001\r!]\u0001\u0005a\u0006$\b\u000eC\u0003~9\u0001\u0007q\u000bC\u0003\u00009\u0001\u0007\u0001\rC\u0003q9\u0001\u0007\u0011\u000f\u0006\b\u0002\b\u0006E\u0017\u0011]Av\u0003[\fy/!=\t\u0011\u0005MW\u0004\"a\u0001\u0003+\f1\u0002\u001b;uaJ+\u0017/^3tiB)!'a6\u0002\\&\u0019\u0011\u0011\\\u001a\u0003\u0011q\u0012\u0017P\\1nKz\u0002B!a*\u0002^&!\u0011q\\AU\u0005=1U\u000f\u001c7IiR\u0004(+Z9vKN$\bbBAr;\u0001\u0007\u0011Q]\u0001\u000bS\u0012,W\u000e]8uK:$\bc\u0001\u001a\u0002h&\u0019\u0011\u0011^\u001a\u0003\u000f\t{w\u000e\\3b]\")Q0\ba\u0001/\")q0\ba\u0001A\")\u0001/\ba\u0001c\"1\u0011qY\u000fA\u0002ED3\u0001AA{!\u0011\t9P!\u0001\u000f\t\u0005e\u0018Q`\u0007\u0003\u0003wT1!a\u0005R\u0013\u0011\ty0a?\u0002\u0013M#\u0018MY5mSRL\u0018\u0002\u0002B\u0002\u0005\u000b\u0011\u0001BV8mCRLG.\u001a\u0006\u0005\u0003\u007f\fY0A\fBgft7mU3be\u000eD\u0017J\u001c3fq6\u000bg.Y4feB\u0011!jH\n\u0003?E\"\"A!\u0003\u0002\u0019A\f'o]3J]\u0012,\u00070Z:\u0015\t\u0005\u0015\"1\u0003\u0005\b\u0005+\t\u0003\u0019\u0001B\f\u0003\tIg\u000eE\u00033\u00053\u0011i\"C\u0002\u0003\u001cM\u0012Q!\u0011:sCf\u00042A\rB\u0010\u0013\r\u0011\tc\r\u0002\u0005\u0005f$X\r")
public class AsyncSearchIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    public Future<SearchIndex> getIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.getIndexRequest(indexName, timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> {
            SearchIndexWrapper read = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), SearchIndexWrapper$.MODULE$.rw());
            int x$1 = read.numPlanPIndexes();
            String x$2 = read.indexDef().copy$default$1();
            String x$3 = read.indexDef().copy$default$2();
            Option<String> x$4 = read.indexDef().copy$default$3();
            Option<String> x$5 = read.indexDef().copy$default$4();
            Option<Obj> x$6 = read.indexDef().copy$default$5();
            Option<String> x$7 = read.indexDef().copy$default$6();
            Option<Obj> x$8 = read.indexDef().copy$default$7();
            Option<String> x$9 = read.indexDef().copy$default$8();
            Option<Obj> x$10 = read.indexDef().copy$default$9();
            return read.indexDef().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
        }, this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$1 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<Seq<SearchIndex>> getAllIndexes(Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.GET, this.indexesPath(), timeout, retryStrategy, null);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> AsyncSearchIndexManager$.MODULE$.parseIndexes(response.content()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getAllIndexes$default$1() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$2() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertIndex(SearchIndex indexDefinition, Duration timeout, RetryStrategy retryStrategy) {
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])indexDefinition.toJson().getBytes(StandardCharsets.UTF_8));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, this.indexPath(indexDefinition.name()), payload);
        request.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)payload.readableBytes()));
        DefaultFullHttpRequest req = request;
        GenericSearchRequest request2 = this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> req, false, timeout, retryStrategy, indexDefinition.name(), this.indexPath(indexDefinition.name()));
        this.core().send((Request)request2);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request2.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> request2.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$4 -> {
            AsyncSearchIndexManager.$anonfun$upsertIndex$3(x$4);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration upsertIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy upsertIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.DELETE, this.indexPath(indexName), timeout, retryStrategy, indexName);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$5 -> request.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$6 -> {
            AsyncSearchIndexManager.$anonfun$dropIndex$2(x$6);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration dropIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    private String indexesPath() {
        return "/api/index";
    }

    private String indexPath(String indexName) {
        return new StringBuilder(1).append(this.indexesPath()).append("/").append(UrlQueryStringBuilder.urlEncode((String)indexName)).toString();
    }

    private String indexCountPath(String indexName) {
        return new StringBuilder(6).append(this.indexPath(indexName)).append("/count").toString();
    }

    private GenericSearchRequest getIndexRequest(String name, Duration timeout, RetryStrategy retryStrategy) {
        return this.searchRequest(HttpMethod.GET, this.indexPath(name), timeout, retryStrategy, name);
    }

    private GenericSearchRequest searchRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy, String indexName) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        return this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null), timeout, retryStrategy, indexName, path);
    }

    private GenericSearchRequest searchRequest(Function0<FullHttpRequest> httpRequest, boolean idempotent, Duration timeout, RetryStrategy retryStrategy, String indexName, String path) {
        return new GenericSearchRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, () -> (FullHttpRequest)httpRequest.apply(), idempotent, null, indexName, path);
    }

    public static final /* synthetic */ void $anonfun$upsertIndex$3(GenericSearchResponse x$4) {
    }

    public static final /* synthetic */ void $anonfun$dropIndex$2(GenericSearchResponse x$6) {
    }

    public AsyncSearchIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

