/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.TouchRequest;
import com.couchbase.client.core.msg.kv.TouchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001}4Q!\u0002\u0004\u0001\u0015IA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006g\u0001!\t\u0001\u000e\u0005\u0006o\u0002!\t\u0001\u001f\u0002\r)>,8\r\u001b%b]\u0012dWM\u001d\u0006\u0003\u000f!\t\u0001\u0002[1oI2,'o\u001d\u0006\u0003\u0013)\t!a\u001b<\u000b\u0005-a\u0011!B:dC2\f'BA\u0007\u000f\u0003\u0019\u0019G.[3oi*\u0011q\u0002E\u0001\nG>,8\r\u001b2bg\u0016T\u0011!E\u0001\u0004G>l7c\u0001\u0001\u00141A\u0011ACF\u0007\u0002+)\t1\"\u0003\u0002\u0018+\t1\u0011I\\=SK\u001a\u0004B!\u0007\u000e\u001dK5\ta!\u0003\u0002\u001c\r\t12*Z=WC2,XMU3rk\u0016\u001cH\u000fS1oI2,'\u000f\u0005\u0002\u001eG5\taD\u0003\u0002\n?)\u0011\u0001%I\u0001\u0004[N<'B\u0001\u0012\r\u0003\u0011\u0019wN]3\n\u0005\u0011r\"!\u0004+pk\u000eD'+Z:q_:\u001cX\r\u0005\u0002'O5\t\u0001\"\u0003\u0002)\u0011\tqQ*\u001e;bi&|gNU3tk2$\u0018A\u00015q\u0007\u0001\u0001\"\u0001L\u0017\u000e\u0003)I!A\f\u0006\u0003\u001b!\u000bg\u000e\u001a7feB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u00033\u0001AQ!\u000b\u0002A\u0002-\nqA]3rk\u0016\u001cH/\u0006\u00026]R1ag\u0010'R7\u000e\u00042a\u000e\u001e=\u001b\u0005A$BA\u001d\u0016\u0003\u0011)H/\u001b7\n\u0005mB$a\u0001+ssB\u0011Q$P\u0005\u0003}y\u0011A\u0002V8vG\"\u0014V-];fgRDQ\u0001Q\u0002A\u0002\u0005\u000b!!\u001b3\u0011\u0005\tKeBA\"H!\t!U#D\u0001F\u0015\t1%&\u0001\u0004=e>|GOP\u0005\u0003\u0011V\ta\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*\u0006\u0005\u0006\u001b\u000e\u0001\rAT\u0001\u0014Kb\u0004\u0018N]=Fa>\u001c\u0007\u000eV5nKN+7m\u001d\t\u0003)=K!\u0001U\u000b\u0003\t1{gn\u001a\u0005\u0006%\u000e\u0001\raU\u0001\bi&lWm\\;u!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003uS6,'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013\u0001\u0002R;sCRLwN\u001c\u0005\u00069\u000e\u0001\r!X\u0001\u000ee\u0016$(/_*ue\u0006$XmZ=\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\f\u0013!\u0002:fiJL\u0018B\u00012`\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\")Am\u0001a\u0001K\u0006Q\u0001/\u0019:f]R\u001c\u0006/\u00198\u0011\u0007Q1\u0007.\u0003\u0002h+\t1q\n\u001d;j_:\u0004\"!\u001b7\u000e\u0003)T!a[\u0011\u0002\u0007\rt7-\u0003\u0002nU\nY!+Z9vKN$8\u000b]1o\t\u0015y7A1\u0001q\u0005\u0005!\u0016CA9u!\t!\"/\u0003\u0002t+\t9aj\u001c;iS:<\u0007C\u0001\u000bv\u0013\t1XCA\u0002B]f\f\u0001B]3ta>t7/\u001a\u000b\u0005Kelh\u0010C\u00034\t\u0001\u0007!\u0010E\u0002\u001ewrI!\u0001 \u0010\u0003\u001f-+\u0017PV1mk\u0016\u0014V-];fgRDQ\u0001\u0011\u0003A\u0002\u0005CQa\u001e\u0003A\u0002q\u0001")
public class TouchHandler
implements KeyValueRequestHandler<TouchResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<TouchRequest> request(String id, long expiryEpochTimeSecs, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)expiryEpochTimeSecs), "expiry").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))));
        return validations.isFailure() ? validations : new Success((Object)new TouchRequest(timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, id, expiryEpochTimeSecs, this.hp.tracer().requestSpan("touch", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
    }

    @Override
    public MutationResult response(KeyValueRequest<TouchResponse> request, String id, TouchResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public TouchHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

