/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.ReplaceResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\tq!+\u001a9mC\u000e,\u0007*\u00198eY\u0016\u0014(BA\u0004\t\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0005\u000b\u0003\tYgO\u0003\u0002\f\u0019\u0005)1oY1mC*\u0011QBD\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0001\u0012!C2pk\u000eD'-Y:f\u0015\u0005\t\u0012aA2p[N\u0019\u0001a\u0005\r\u0011\u0005Q1R\"A\u000b\u000b\u0003-I!aF\u000b\u0003\r\u0005s\u0017PU3g!\u0011I\"\u0004H\u0013\u000e\u0003\u0019I!a\u0007\u0004\u0003--+\u0017PV1mk\u0016\u0014V-];fgRD\u0015M\u001c3mKJ\u0004\"!H\u0012\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\n\u0013aA7tO*\u0011!\u0005D\u0001\u0005G>\u0014X-\u0003\u0002%=\ty!+\u001a9mC\u000e,'+Z:q_:\u001cX\r\u0005\u0002'O5\t\u0001\"\u0003\u0002)\u0011\tqQ*\u001e;bi&|gNU3tk2$\u0018A\u00015q\u0007\u0001\u0001\"\u0001L\u0017\u000e\u0003)I!A\f\u0006\u0003\u001b!\u000bg\u000e\u001a7feB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u00033\u0001AQ!\u000b\u0002A\u0002-\nqA]3rk\u0016\u001cH/\u0006\u00026!Riag\u0010'Z=\u0016<\u0017/_A\u0002\u0003\u001b\u00012a\u000e\u001e=\u001b\u0005A$BA\u001d\u0016\u0003\u0011)H/\u001b7\n\u0005mB$a\u0001+ssB\u0011Q$P\u0005\u0003}y\u0011aBU3qY\u0006\u001cWMU3rk\u0016\u001cH\u000fC\u0003A\u0007\u0001\u0007\u0011)\u0001\u0002jIB\u0011!)\u0013\b\u0003\u0007\u001e\u0003\"\u0001R\u000b\u000e\u0003\u0015S!A\u0012\u0016\u0002\rq\u0012xn\u001c;?\u0013\tAU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0015.\u0013aa\u0015;sS:<'B\u0001%\u0016\u0011\u0015i5\u00011\u0001O\u0003\u001d\u0019wN\u001c;f]R\u0004\"a\u0014)\r\u0001\u0011)\u0011k\u0001b\u0001%\n\tA+\u0005\u0002T-B\u0011A\u0003V\u0005\u0003+V\u0011qAT8uQ&tw\r\u0005\u0002\u0015/&\u0011\u0001,\u0006\u0002\u0004\u0003:L\b\"\u0002.\u0004\u0001\u0004Y\u0016aA2bgB\u0011A\u0003X\u0005\u0003;V\u0011A\u0001T8oO\")ql\u0001a\u0001A\u0006QA-\u001e:bE&d\u0017\u000e^=\u0011\u0005\u0005\u001cW\"\u00012\u000b\u0005}S\u0011B\u00013c\u0005)!UO]1cS2LG/\u001f\u0005\u0006M\u000e\u0001\raW\u0001\u0014Kb\u0004\u0018N]=Fa>\u001c\u0007\u000eV5nKN+7m\u001d\u0005\u0006Q\u000e\u0001\r![\u0001\bi&lWm\\;u!\tQw.D\u0001l\u0015\taW.\u0001\u0003uS6,'\"\u00018\u0002\t)\fg/Y\u0005\u0003a.\u0014\u0001\u0002R;sCRLwN\u001c\u0005\u0006e\u000e\u0001\ra]\u0001\u000ee\u0016$(/_*ue\u0006$XmZ=\u0011\u0005Q<X\"A;\u000b\u0005Y\f\u0013!\u0002:fiJL\u0018B\u0001=v\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\")!p\u0001a\u0001w\u0006QAO]1og\u000e|G-\u001a:\u0011\u0005q|X\"A?\u000b\u0005yT\u0011!B2pI\u0016\u001c\u0017bAA\u0001{\nQAK]1og\u000e|G-\u001a:\t\u000f\u0005\u00151\u00011\u0001\u0002\b\u0005Q1/\u001a:jC2L'0\u001a:\u0011\tq\fIAT\u0005\u0004\u0003\u0017i(A\u0004&t_:\u001cVM]5bY&TXM\u001d\u0005\b\u0003\u001f\u0019\u0001\u0019AA\t\u0003)\u0001\u0018M]3oiN\u0003\u0018M\u001c\t\u0006)\u0005M\u0011qC\u0005\u0004\u0003+)\"AB(qi&|g\u000e\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\ti\"I\u0001\u0004G:\u001c\u0017\u0002BA\u0011\u00037\u00111BU3rk\u0016\u001cHo\u00159b]\u0006A!/Z:q_:\u001cX\rF\u0004&\u0003O\ty#!\r\t\rM\"\u0001\u0019AA\u0015!\u0011i\u00121\u0006\u000f\n\u0007\u00055bDA\bLKf4\u0016\r\\;f%\u0016\fX/Z:u\u0011\u0015\u0001E\u00011\u0001B\u0011\u0019\t\u0019\u0003\u0002a\u00019\u0001")
public class ReplaceHandler
implements KeyValueRequestHandler<ReplaceResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<ReplaceRequest> request(String id, T content, long cas, Durability durability, long expiryEpochTimeSecs, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)cas), "cas").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)expiryEpochTimeSecs), "expiration").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Try<EncodedValue> try_2;
            RequestSpan span = this.hp.tracer().requestSpan("replace", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()));
            RequestSpan encodeSpan = this.hp.tracer().requestSpan("request_encoding", span);
            long start = System.nanoTime();
            Transcoder transcoder2 = transcoder;
            if (transcoder2 instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
                try_2 = transcoderWithSerializer.encode(content, serializer);
            } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
                try_2 = transcoderWithoutSerializer.encode(content);
            } else {
                throw new MatchError((Object)transcoder2);
            }
            Try<EncodedValue> encoded = try_2;
            long end = System.nanoTime();
            encodeSpan.end();
            Try<EncodedValue> try_3 = encoded;
            if (try_3 instanceof Success) {
                Success success = (Success)try_3;
                EncodedValue en = (EncodedValue)success.value();
                ReplaceRequest out = new ReplaceRequest(id, en.encoded(), expiryEpochTimeSecs, en.flags(), timeout, cas, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
                out.context().encodeLatency(end - start);
                failure = new Success((Object)out);
            } else if (try_3 instanceof Failure) {
                Failure failure2 = (Failure)try_3;
                Throwable err = failure2.exception();
                failure = new Failure((Throwable)new EncodingFailureException(err));
            } else {
                throw new MatchError(try_3);
            }
            try_ = failure;
        }
        return try_;
    }

    @Override
    public MutationResult response(KeyValueRequest<ReplaceResponse> request, String id, ReplaceResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public ReplaceHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

