/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.GenericSearchRequest;
import com.couchbase.client.core.msg.search.GenericSearchResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$CompletionStageOps$;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager$;
import com.couchbase.client.scala.manager.search.SearchIndex;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0012%\u0001EB\u0011b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000b\u001d\t\u0011u\u0002!\u0011!Q\u0001\neB\u0001B\u0010\u0001\u0003\u0006\u0004%\u0019a\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u0001\")q\t\u0001C\u0001\u0011\"9a\n\u0001b\u0001\n\u0013y\u0005BB+\u0001A\u0003%\u0001\u000bC\u0004W\u0001\t\u0007I\u0011B,\t\ry\u0003\u0001\u0015!\u0003Y\u0011\u001dy\u0006A1A\u0005\n\u0001Daa\u001a\u0001!\u0002\u0013\t\u0007\"\u00025\u0001\t\u0013I\u0007bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\n\u0003C\u0001\u0011\u0013!C\u0001\u0003GA\u0011\"!\u000f\u0001#\u0003%\t!a\u000f\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!I\u0011q\n\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003wAq!a\u0015\u0001\t\u0003\t)\u0006C\u0005\u0002h\u0001\t\n\u0011\"\u0001\u0002$!I\u0011\u0011\u000e\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\b\u0003W\u0002A\u0011AA7\u0011%\t)\bAI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002x\u0001\t\n\u0011\"\u0001\u0002<!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBAF\u0001\u0011%\u0011Q\u0012\u0005\b\u0003#\u0003A\u0011BAJ\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!-\u0001\t\u0013\t\u0019\fC\u0004\u00022\u0002!I!!9\b\u000f\tUA\u0005#\u0001\u0003\u0018\u001911\u0005\nE\u0001\u00053Aaa\u0012\u0011\u0005\u0002\tm\u0001\u0002\u0003B\u000fA\u0011\u0005\u0001Fa\b\u0003/\u0005\u001b\u0018P\\2TK\u0006\u00148\r[%oI\u0016DX*\u00198bO\u0016\u0014(BA\u0013'\u0003\u0019\u0019X-\u0019:dQ*\u0011q\u0005K\u0001\b[\u0006t\u0017mZ3s\u0015\tI#&A\u0003tG\u0006d\u0017M\u0003\u0002,Y\u000511\r\\5f]RT!!\f\u0018\u0002\u0013\r|Wo\u00195cCN,'\"A\u0018\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0011\u0004CA\u001a6\u001b\u0005!$\"A\u0015\n\u0005Y\"$AB!osJ+g-A\u0004dYV\u001cH/\u001a:\u0016\u0003e\u0002\"AO\u001e\u000e\u0003!J!\u0001\u0010\u0015\u0003\u0019\u0005\u001b\u0018P\\2DYV\u001cH/\u001a:\u0002\u0011\rdWo\u001d;fe\u0002\n!!Z2\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u001b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002F\u0005\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002J\u001bR\u0011!\n\u0014\t\u0003\u0017\u0002i\u0011\u0001\n\u0005\u0006}\u0015\u0001\u001d\u0001\u0011\u0005\u0006o\u0015\u0001\r!O\u0001\u0005G>\u0014X-F\u0001Q!\t\t6+D\u0001S\u0015\tq%&\u0003\u0002U%\n!1i\u001c:f\u0003\u0015\u0019wN]3!\u00039!UMZ1vYR$\u0016.\\3pkR,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037\n\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0003;j\u0013\u0001\u0002R;sCRLwN\\\u0001\u0010\t\u00164\u0017-\u001e7u)&lWm\\;uA\u0005!B)\u001a4bk2$(+\u001a;ssN#(/\u0019;fOf,\u0012!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IJ\u000bQA]3uefL!AZ2\u0003\u001bI+GO]=TiJ\fG/Z4z\u0003U!UMZ1vYR\u0014V\r\u001e:z'R\u0014\u0018\r^3hs\u0002\n1\u0002\u001e:b]N4wN]7feR\u0011!.\u001f\t\u0005g-lW.\u0003\u0002mi\tIa)\u001e8di&|g.\r\t\u0003]Zt!a\u001c;\u000f\u0005A\u001cX\"A9\u000b\u0005I\u0004\u0014A\u0002\u001fs_>$h(C\u0001*\u0013\t)H'A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(!\u0003+ie><\u0018M\u00197f\u0015\t)H\u0007C\u0003{\u0019\u0001\u000710A\u0005j]\u0012,\u0007PT1nKB\u0019A0!\u0001\u000f\u0005ut\bC\u000195\u0013\tyH'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0007\t)A\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fR\n\u0001bZ3u\u0013:$W\r\u001f\u000b\t\u0003\u0017\t9\"!\u0007\u0002\u001eA)\u0011)!\u0004\u0002\u0012%\u0019\u0011q\u0002\"\u0003\r\u0019+H/\u001e:f!\rY\u00151C\u0005\u0004\u0003+!#aC*fCJ\u001c\u0007.\u00138eKbDQA_\u0007A\u0002mD\u0001\"a\u0007\u000e!\u0003\u0005\r\u0001W\u0001\bi&lWm\\;u\u0011!\ty\"\u0004I\u0001\u0002\u0004\t\u0017!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170\u0001\nhKRLe\u000eZ3yI\u0011,g-Y;mi\u0012\u0012TCAA\u0013U\rA\u0016qE\u0016\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0007\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00055\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011r-\u001a;J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tiDK\u0002b\u0003O\tQbZ3u\u00032d\u0017J\u001c3fq\u0016\u001cHCBA\"\u0003\u0017\ni\u0005E\u0003B\u0003\u001b\t)\u0005E\u0003o\u0003\u000f\n\t\"C\u0002\u0002Ja\u00141aU3r\u0011!\tY\u0002\u0005I\u0001\u0002\u0004A\u0006\u0002CA\u0010!A\u0005\t\u0019A1\u0002/\u001d,G/\u00117m\u0013:$W\r_3tI\u0011,g-Y;mi\u0012\n\u0014aF4fi\u0006cG.\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-)\bo]3si&sG-\u001a=\u0015\u0011\u0005]\u0013qLA2\u0003K\u0002R!QA\u0007\u00033\u00022aMA.\u0013\r\ti\u0006\u000e\u0002\u0005+:LG\u000fC\u0004\u0002bM\u0001\r!!\u0005\u0002\u001f%tG-\u001a=EK\u001aLg.\u001b;j_:D\u0001\"a\u0007\u0014!\u0003\u0005\r\u0001\u0017\u0005\t\u0003?\u0019\u0002\u0013!a\u0001C\u0006)R\u000f]:feRLe\u000eZ3yI\u0011,g-Y;mi\u0012\u0012\u0014!F;qg\u0016\u0014H/\u00138eKb$C-\u001a4bk2$HeM\u0001\nIJ|\u0007/\u00138eKb$\u0002\"a\u0016\u0002p\u0005E\u00141\u000f\u0005\u0006uZ\u0001\ra\u001f\u0005\t\u000371\u0002\u0013!a\u00011\"A\u0011q\u0004\f\u0011\u0002\u0003\u0007\u0011-A\nee>\u0004\u0018J\u001c3fq\u0012\"WMZ1vYR$#'A\nee>\u0004\u0018J\u001c3fq\u0012\"WMZ1vYR$3'A\u0006j]\u0012,\u00070Z:QCRDWCAA?!\u0011\ty(!#\u000e\u0005\u0005\u0005%\u0002BAB\u0003\u000b\u000bA\u0001\\1oO*\u0011\u0011qQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0004\u0005\u0005\u0015!C5oI\u0016D\b+\u0019;i)\u0011\ti(a$\t\u000biT\u0002\u0019A>\u0002\u001d%tG-\u001a=D_VtG\u000fU1uQR!\u0011QPAK\u0011\u0015Q8\u00041\u0001|\u0003=9W\r^%oI\u0016D(+Z9vKN$H\u0003CAN\u0003S\u000bi+a,\u0011\t\u0005u\u0015QU\u0007\u0003\u0003?S1!JAQ\u0015\r\t\u0019KU\u0001\u0004[N<\u0017\u0002BAT\u0003?\u0013AcR3oKJL7mU3be\u000eD'+Z9vKN$\bBBAV9\u0001\u000710\u0001\u0003oC6,\u0007BBA\u000e9\u0001\u0007\u0001\f\u0003\u0004\u0002 q\u0001\r!Y\u0001\u000eg\u0016\f'o\u00195SKF,Xm\u001d;\u0015\u0015\u0005m\u0015QWAm\u0003;\fy\u000eC\u0004\u00028v\u0001\r!!/\u0002\r5,G\u000f[8e!\u0011\tY,!6\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\fA\u0001\u001b;ua*!\u00111YAc\u0003\u0015\u0019w\u000eZ3d\u0015\u0011\t9-!3\u0002\u000f!\fg\u000e\u001a7fe*!\u00111ZAg\u0003\u0015qW\r\u001e;z\u0015\u0011\ty-!5\u0002\u0005%|'bAAj%\u0006!A-\u001a9t\u0013\u0011\t9.!0\u0003\u0015!#H\u000f]'fi\"|G\r\u0003\u0004\u0002\\v\u0001\ra_\u0001\u0005a\u0006$\b\u000e\u0003\u0004\u0002\u001cu\u0001\r\u0001\u0017\u0005\u0007\u0003?i\u0002\u0019A1\u0015\u0015\u0005m\u00151]Az\u0003{\fy\u0010\u0003\u0005\u0002fz!\t\u0019AAt\u0003-AG\u000f\u001e9SKF,Xm\u001d;\u0011\u000bM\nI/!<\n\u0007\u0005-HG\u0001\u0005=Eft\u0017-\\3?!\u0011\tY,a<\n\t\u0005E\u0018Q\u0018\u0002\u0010\rVdG\u000e\u0013;uaJ+\u0017/^3ti\"9\u0011Q\u001f\u0010A\u0002\u0005]\u0018AC5eK6\u0004x\u000e^3oiB\u00191'!?\n\u0007\u0005mHGA\u0004C_>dW-\u00198\t\r\u0005ma\u00041\u0001Y\u0011\u0019\tyB\ba\u0001C\"\u001a\u0001Aa\u0001\u0011\t\t\u0015!q\u0002\b\u0005\u0005\u000f\u0011Y!\u0004\u0002\u0003\n)\u0019\u00111\u0007*\n\t\t5!\u0011B\u0001\n'R\f'-\u001b7jifLAA!\u0005\u0003\u0014\tAak\u001c7bi&dWM\u0003\u0003\u0003\u000e\t%\u0011aF!ts:\u001c7+Z1sG\"Le\u000eZ3y\u001b\u0006t\u0017mZ3s!\tY\u0005e\u0005\u0002!eQ\u0011!qC\u0001\ra\u0006\u00148/Z%oI\u0016DXm\u001d\u000b\u0005\u0003\u000b\u0012\t\u0003C\u0004\u0003$\t\u0002\rA!\n\u0002\u0005%t\u0007#B\u001a\u0003(\t-\u0012b\u0001B\u0015i\t)\u0011I\u001d:bsB\u00191G!\f\n\u0007\t=BG\u0001\u0003CsR,\u0007")
public class AsyncSearchIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private Function1<Throwable, Throwable> transformer(String indexName) {
        return (Function1 & Serializable & scala.Serializable)err -> err.getMessage().contains("index not found") ? new IndexNotFoundException(indexName) : err;
    }

    public Future<SearchIndex> getIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.getIndexRequest(indexName, timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> {
            SearchIndexWrapper read = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), SearchIndexWrapper$.MODULE$.rw());
            int x$1 = read.numPlanPIndexes();
            String x$2 = read.indexDef().copy$default$1();
            String x$3 = read.indexDef().copy$default$2();
            Option<String> x$4 = read.indexDef().copy$default$3();
            Option<String> x$5 = read.indexDef().copy$default$4();
            Option<Obj> x$6 = read.indexDef().copy$default$5();
            Option<String> x$7 = read.indexDef().copy$default$6();
            Option<Obj> x$8 = read.indexDef().copy$default$7();
            Option<String> x$9 = read.indexDef().copy$default$8();
            Option<Obj> x$10 = read.indexDef().copy$default$9();
            return read.indexDef().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
        }, this.ec()).transform((Function1 & Serializable & scala.Serializable)x -> (SearchIndex)Predef$.MODULE$.identity(x), this.transformer(indexName), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$1 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<Seq<SearchIndex>> getAllIndexes(Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.GET, this.indexesPath(), timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> AsyncSearchIndexManager$.MODULE$.parseIndexes(response.content()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getAllIndexes$default$1() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$2() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertIndex(SearchIndex indexDefinition, Duration timeout, RetryStrategy retryStrategy) {
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])indexDefinition.toJson().getBytes(StandardCharsets.UTF_8));
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, this.indexPath(indexDefinition.name()), payload);
        request.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)payload.readableBytes()));
        DefaultFullHttpRequest req = request;
        GenericSearchRequest request2 = this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> req, false, timeout, retryStrategy);
        this.core().send((Request)request2);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request2.response())).transform((Function1 & Serializable & scala.Serializable)x -> (GenericSearchResponse)Predef$.MODULE$.identity(x), this.transformer(indexDefinition.name()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> request2.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$4 -> {
            AsyncSearchIndexManager.$anonfun$upsertIndex$4(x$4);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration upsertIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy upsertIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        GenericSearchRequest request = this.searchRequest(HttpMethod.DELETE, this.indexPath(indexName), timeout, retryStrategy);
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$5 -> request.context().logicallyComplete(), this.ec());
        return out.transform((Function1 & Serializable & scala.Serializable)x -> (GenericSearchResponse)Predef$.MODULE$.identity(x), this.transformer(indexName), this.ec()).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            AsyncSearchIndexManager.$anonfun$dropIndex$3(x$6);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration dropIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    private String indexesPath() {
        return "/api/index";
    }

    private String indexPath(String indexName) {
        return new StringBuilder(1).append(this.indexesPath()).append("/").append(UrlQueryStringBuilder.urlEncode((String)indexName)).toString();
    }

    private String indexCountPath(String indexName) {
        return new StringBuilder(6).append(this.indexPath(indexName)).append("/count").toString();
    }

    private GenericSearchRequest getIndexRequest(String name, Duration timeout, RetryStrategy retryStrategy) {
        return this.searchRequest(HttpMethod.GET, this.indexPath(name), timeout, retryStrategy);
    }

    private GenericSearchRequest searchRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        return this.searchRequest((Function0<FullHttpRequest>)(Function0 & Serializable & scala.Serializable)() -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null), timeout, retryStrategy);
    }

    private GenericSearchRequest searchRequest(Function0<FullHttpRequest> httpRequest, boolean idempotent, Duration timeout, RetryStrategy retryStrategy) {
        return new GenericSearchRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, () -> (FullHttpRequest)httpRequest.apply(), idempotent, null);
    }

    public static final /* synthetic */ void $anonfun$upsertIndex$4(GenericSearchResponse x$4) {
    }

    public static final /* synthetic */ void $anonfun$dropIndex$3(GenericSearchResponse x$6) {
    }

    public AsyncSearchIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

