/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001}3Q\u0001B\u0003\u0001\u0013EA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u0006;\u0001!\tA\b\u0005\u0006E\u0001!\ta\t\u0002\u0011\u0003:\fG.\u001f;jGND\u0015M\u001c3mKJT!AB\u0004\u0002\u0011!\fg\u000e\u001a7feNT!\u0001C\u0005\u0002\u000bE,XM]=\u000b\u0005)Y\u0011!B:dC2\f'B\u0001\u0007\u000e\u0003\u0019\u0019G.[3oi*\u0011abD\u0001\nG>,8\r\u001b2bg\u0016T\u0011\u0001E\u0001\u0004G>l7C\u0001\u0001\u0013!\t\u0019R#D\u0001\u0015\u0015\u0005Q\u0011B\u0001\f\u0015\u0005\u0019\te.\u001f*fM\u0006\u0011\u0001\u000e]\u0002\u0001!\tQ2$D\u0001\n\u0013\ta\u0012B\u0001\nIC:$G.\u001a:CCNL7\rU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u000b!)qC\u0001a\u00013\u00059!/Z9vKN$XC\u0001\u0013W)\u0015)SGQ%O!\r1\u0013fK\u0007\u0002O)\u0011\u0001\u0006F\u0001\u0005kRLG.\u0003\u0002+O\t\u0019AK]=\u0011\u00051\u001aT\"A\u0017\u000b\u00059z\u0013!C1oC2LH/[2t\u0015\t\u0001\u0014'A\u0002ng\u001eT!AM\u0006\u0002\t\r|'/Z\u0005\u0003i5\u0012\u0001#\u00118bYf$\u0018nY:SKF,Xm\u001d;\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u0013M$\u0018\r^3nK:$\bC\u0001\u001d@\u001d\tIT\b\u0005\u0002;)5\t1H\u0003\u0002=1\u00051AH]8pizJ!A\u0010\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}QAQaQ\u0002A\u0002\u0011\u000bqa\u001c9uS>t7\u000f\u0005\u0002F\u000f6\taI\u0003\u0002/\u0013%\u0011\u0001J\u0012\u0002\u0011\u0003:\fG.\u001f;jGN|\u0005\u000f^5p]NDQAM\u0002A\u0002)\u0003\"a\u0013'\u000e\u0003EJ!!T\u0019\u0003\t\r{'/\u001a\u0005\u0006\u001f\u000e\u0001\r\u0001U\u0001\fK:4\u0018N]8o[\u0016tG\u000f\u0005\u0002R)6\t!K\u0003\u0002T\u0013\u0005\u0019QM\u001c<\n\u0005U\u0013&AE\"mkN$XM]#om&\u0014xN\\7f]R$QaV\u0002C\u0002a\u0013\u0011\u0001V\t\u00033r\u0003\"a\u0005.\n\u0005m#\"a\u0002(pi\"Lgn\u001a\t\u0003'uK!A\u0018\u000b\u0003\u0007\u0005s\u0017\u0010")
public class AnalyticsHandler {
    private final HandlerBasicParams hp;

    public <T> Try<AnalyticsRequest> request(String statement, AnalyticsOptions options, Core core, ClusterEnvironment environment) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.priority()), "priority").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            JsonObject params = options.encode();
            params.put("statement", statement);
            try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable & scala.Serializable)queryStr -> {
                byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
                Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().analyticsTimeout()));
                RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> environment.retryStrategy());
                return new AnalyticsRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, core.context().authenticator(), queryBytes, options.priority() ? -1 : 0, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), params.str("client_context_id"), statement, $this.hp.tracer().requestSpan("cb.analytics", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())));
            });
        }
        return try_;
    }

    public AnalyticsHandler(HandlerBasicParams hp) {
        this.hp = hp;
    }
}

