/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.collection;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.config.CollectionsManifestCollection;
import com.couchbase.client.core.config.CollectionsManifestScope;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.collection.CollectionSpec;
import com.couchbase.client.scala.manager.collection.ScopeSpec;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0014)\u0001UB\u0011b\u000f\u0001\u0003\u0006\u0004%\t\u0001\f\u001f\t\u0011\u0005\u0003!\u0011!Q\u0001\nuBQA\u0011\u0001\u0005\u0002\rCqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004O\u0001\u0001\u0006I!\u0013\u0005\t\u001f\u0002\u0011\r\u0011\"\u0001-!\"1\u0011\f\u0001Q\u0001\nEC\u0001B\u0017\u0001C\u0002\u0013\u0005Af\u0017\u0005\u0007E\u0002\u0001\u000b\u0011\u0002/\t\r\r\u0004A\u0011\u0001\u0017e\u0011!Q\b!%A\u0005\u00021Z\bBCA\u0007\u0001E\u0005I\u0011\u0001\u0017\u0002\u0010!A\u00111\u0003\u0001\u0005\u00021\n)\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0001-w\"Q\u0011q\u0007\u0001\u0012\u0002\u0013\u0005A&a\u0004\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!A\u00111\f\u0001\u0012\u0002\u0013\u00051\u0010C\u0005\u0002^\u0001\t\n\u0011\"\u0001\u0002\u0010!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004\u0002CA7\u0001E\u0005I\u0011A>\t\u0013\u0005=\u0004!%A\u0005\u0002\u0005=\u0001bBA9\u0001\u0011\u0005\u00111\u000f\u0005\t\u0003\u0007\u0003\u0011\u0013!C\u0001w\"I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011!\t\t\nAI\u0001\n\u0003Y\b\"CAJ\u0001E\u0005I\u0011AA\b\u0011\u001d\t)\n\u0001C\u0001\u0003/C\u0001\"a(\u0001#\u0003%\ta\u001f\u0005\n\u0003C\u0003\u0011\u0013!C\u0001\u0003\u001fAq!a)\u0001\t\u0003\t)\u000b\u0003\u0005\u0002.\u0002\t\n\u0011\"\u0001|\u0011%\ty\u000bAI\u0001\n\u0003\ty\u0001C\u0004\u00022\u0002!I!a-\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003c\u0004A\u0011BAz\u0005e\u0011V-Y2uSZ,7i\u001c7mK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005%R\u0013AC2pY2,7\r^5p]*\u00111\u0006L\u0001\b[\u0006t\u0017mZ3s\u0015\tic&A\u0003tG\u0006d\u0017M\u0003\u00020a\u000511\r\\5f]RT!!\r\u001a\u0002\u0013\r|Wo\u00195cCN,'\"A\u001a\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u00011\u0004CA\u001c:\u001b\u0005A$\"A\u0017\n\u0005iB$AB!osJ+g-\u0001\u0004ck\u000e\\W\r^\u000b\u0002{A\u0011ahP\u0007\u0002Y%\u0011\u0001\t\f\u0002\f\u0003NLhn\u0019\"vG.,G/A\u0004ck\u000e\\W\r\u001e\u0011\u0002\rqJg.\u001b;?)\t!e\t\u0005\u0002F\u00015\t\u0001\u0006C\u0003<\u0007\u0001\u0007Q(\u0001\u0003d_J,W#A%\u0011\u0005)cU\"A&\u000b\u0005\u001ds\u0013BA'L\u0005\u0011\u0019uN]3\u0002\u000b\r|'/\u001a\u0011\u0002+\u0011,g-Y;mi6\u000bg.Y4feRKW.Z8viV\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006AA-\u001e:bi&|gN\u0003\u0002Wq\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005a\u001b&\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002-\u0011,g-Y;mi6\u000bg.Y4feRKW.Z8vi\u0002\nA\u0003Z3gCVdGOU3uef\u001cFO]1uK\u001eLX#\u0001/\u0011\u0005u\u0003W\"\u00010\u000b\u0005}[\u0015!\u0002:fiJL\u0018BA1_\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\u0006)B-\u001a4bk2$(+\u001a;ssN#(/\u0019;fOf\u0004\u0013\u0001E2pY2,7\r^5p]\u0016C\u0018n\u001d;t)\u0011)'O\u001e=\u0011\u0007\u0019lw.D\u0001h\u0015\tA\u0017.A\u0005qk\nd\u0017n\u001d5fe*\u0011QF\u001b\u0006\u0003\u000f.T\u0011\u0001\\\u0001\be\u0016\f7\r^8s\u0013\tqwMA\u0003T\u001b>tw\u000e\u0005\u00028a&\u0011\u0011\u000f\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015I#\u00021\u0001t!\t)E/\u0003\u0002vQ\tq1i\u001c7mK\u000e$\u0018n\u001c8Ta\u0016\u001c\u0007bB<\u000b!\u0003\u0005\r!U\u0001\bi&lWm\\;u\u0011\u001dI(\u0002%AA\u0002q\u000bQB]3uef\u001cFO]1uK\u001eL\u0018AG2pY2,7\r^5p]\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012T#\u0001?+\u0005Ek8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\ba\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ed_2dWm\u0019;j_:,\u00050[:ug\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0012)\u0012A,`\u0001\fg\u000e|\u0007/Z#ySN$8\u000fF\u0004f\u0003/\t\t$a\r\t\u000f\u0005eQ\u00021\u0001\u0002\u001c\u0005I1oY8qK:\u000bW.\u001a\t\u0005\u0003;\tYC\u0004\u0003\u0002 \u0005\u001d\u0002cAA\u0011q5\u0011\u00111\u0005\u0006\u0004\u0003K!\u0014A\u0002\u001fs_>$h(C\u0002\u0002*a\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'bAA\u0015q!9q/\u0004I\u0001\u0002\u0004\t\u0006bB=\u000e!\u0003\u0005\r\u0001X\u0001\u0016g\u000e|\u0007/Z#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u00198m\u001c9f\u000bbL7\u000f^:%I\u00164\u0017-\u001e7uIM\n\u0001bZ3u'\u000e|\u0007/\u001a\u000b\t\u0003{\t)%a\u0012\u0002JA!a-\\A !\r)\u0015\u0011I\u0005\u0004\u0003\u0007B#!C*d_B,7\u000b]3d\u0011\u001d\tI\u0002\u0005a\u0001\u00037Aqa\u001e\t\u0011\u0002\u0003\u0007\u0011\u000bC\u0004z!A\u0005\t\u0019\u0001/)\u000fA\ti%a\u0015\u0002XA\u0019q'a\u0014\n\u0007\u0005E\u0003H\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!\u0016\u00021U\u001cX\rI4fi\u0006cGnU2pa\u0016\u001c\b%\u001b8ti\u0016\fG-\t\u0002\u0002Z\u0005)\u0011GL\u0019/e\u0005\u0011r-\u001a;TG>\u0004X\r\n3fM\u0006,H\u000e\u001e\u00133\u0003I9W\r^*d_B,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019\u001d,G/\u00117m'\u000e|\u0007/Z:\u0015\r\u0005\r\u0014\u0011NA6!\u00151\u0017QMA \u0013\r\t9g\u001a\u0002\u0006'\u001acW\u000f\u001f\u0005\boN\u0001\n\u00111\u0001R\u0011\u001dI8\u0003%AA\u0002q\u000bacZ3u\u00032d7kY8qKN$C-\u001a4bk2$H%M\u0001\u0017O\u0016$\u0018\t\u001c7TG>\u0004Xm\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u00012M]3bi\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u000b\t\u0003k\ni(a \u0002\u0002B!a-\\A<!\r9\u0014\u0011P\u0005\u0004\u0003wB$\u0001B+oSRDQ!\u000b\fA\u0002MDqa\u001e\f\u0011\u0002\u0003\u0007\u0011\u000bC\u0004z-A\u0005\t\u0019\u0001/\u00025\r\u0014X-\u0019;f\u0007>dG.Z2uS>tG\u0005Z3gCVdG\u000f\n\u001a\u00025\r\u0014X-\u0019;f\u0007>dG.Z2uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\u0011\u0014x\u000e]\"pY2,7\r^5p]RA\u0011QOAF\u0003\u001b\u000by\tC\u0003*3\u0001\u00071\u000fC\u0004x3A\u0005\t\u0019A)\t\u000feL\u0002\u0013!a\u00019\u0006ABM]8q\u0007>dG.Z2uS>tG\u0005Z3gCVdG\u000f\n\u001a\u00021\u0011\u0014x\u000e]\"pY2,7\r^5p]\u0012\"WMZ1vYR$3'A\u0006de\u0016\fG/Z*d_B,G\u0003CA;\u00033\u000bY*!(\t\u000f\u0005eA\u00041\u0001\u0002\u001c!9q\u000f\bI\u0001\u0002\u0004\t\u0006bB=\u001d!\u0003\u0005\r\u0001X\u0001\u0016GJ,\u0017\r^3TG>\u0004X\r\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0019'/Z1uKN\u001bw\u000e]3%I\u00164\u0017-\u001e7uIM\n\u0011\u0002\u001a:paN\u001bw\u000e]3\u0015\u0011\u0005U\u0014qUAU\u0003WCq!!\u0007 \u0001\u0004\tY\u0002C\u0004x?A\u0005\t\u0019A)\t\u000fe|\u0002\u0013!a\u00019\u0006\u0019BM]8q'\u000e|\u0007/\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0019BM]8q'\u000e|\u0007/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005a\u0001/\u0019;i\r>\u00148kY8qKR1\u0011QWAb\u0003\u000f\u0004B!a.\u0002B6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0003mC:<'BAA`\u0003\u0011Q\u0017M^1\n\t\u00055\u0012\u0011\u0018\u0005\b\u0003\u000b\u0014\u0003\u0019AA\u000e\u0003)\u0011WoY6fi:\u000bW.\u001a\u0005\b\u00033\u0011\u0003\u0019AA\u000e\u0003E\u0001\u0018\r\u001e5G_J\u001cu\u000e\u001c7fGRLwN\u001c\u000b\t\u0003k\u000bi-a4\u0002R\"9\u0011QY\u0012A\u0002\u0005m\u0001bBA\rG\u0001\u0007\u00111\u0004\u0005\b\u0003'\u001c\u0003\u0019AA\u000e\u00039\u0019w\u000e\u001c7fGRLwN\u001c(b[\u0016\fq\u0002]1uQ\u001a{'/T1oS\u001a,7\u000f\u001e\u000b\u0005\u0003k\u000bI\u000eC\u0004\u0002F\u0012\u0002\r!a\u0007\u0002\u00191|\u0017\rZ'b]&4Wm\u001d;\u0015\r\u0005}\u0017Q^Ax!\u00111W.!9\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:L\u0003\u0019\u0019wN\u001c4jO&!\u00111^As\u0005M\u0019u\u000e\u001c7fGRLwN\\:NC:Lg-Z:u\u0011\u00159X\u00051\u0001R\u0011\u0015IX\u00051\u0001]\u00039\u0019\u0007.Z2l\r>\u0014XI\u001d:peN$\u0002\"!>\u0003\u0002\tM!Q\u0003\t\u0007\u0003o\fi0a\u001e\u000e\u0005\u0005e(bAA~q\u0005!Q\u000f^5m\u0013\u0011\ty0!?\u0003\u0007Q\u0013\u0018\u0010C\u0004\u0003\u0004\u0019\u0002\rA!\u0002\u0002\u0011I,7\u000f]8og\u0016\u0004BAa\u0002\u0003\u00105\u0011!\u0011\u0002\u0006\u0004W\t-!b\u0001B\u0007\u0017\u0006\u0019Qn]4\n\t\tE!\u0011\u0002\u0002\u0017\u000f\u0016tWM]5d\u001b\u0006t\u0017mZ3s%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u0004\u0014A\u0002\u0005m\u0001bBAjM\u0001\u0007\u00111\u0004")
public class ReactiveCollectionManager {
    private final AsyncBucket bucket;
    private final Core core;
    private final Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public AsyncBucket bucket() {
        return this.bucket;
    }

    private Core core() {
        return this.core;
    }

    public Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    public SMono<Object> collectionExists(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable & scala.Serializable)manifest -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$1(collection, manifest)));
    }

    public Duration collectionExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy collectionExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<Object> scopeExists(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$1(scopeName, x$3)));
    }

    public Duration scopeExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy scopeExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<ScopeSpec> getScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllScopes(timeout, retryStrategy).collectSeq().flatMap((Function1 & Serializable & scala.Serializable)scopes -> {
            SMono sMono;
            Option option = scopes.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$getScope$2(scopeName, x$5)));
            if (option instanceof Some) {
                Some some = (Some)option;
                ScopeSpec scope = (ScopeSpec)some.value();
                sMono = SMono$.MODULE$.just((Object)scope);
            } else {
                sMono = SMono$.MODULE$.raiseError((Throwable)new ScopeNotFoundException(scopeName));
            }
            return sMono;
        });
    }

    public Duration getScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<ScopeSpec> getAllScopes(Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).flatMapMany((Function1 & Serializable & scala.Serializable)manifest -> {
            Buffer scopes = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(manifest.scopes()).asScala()).map((Function1 & Serializable & scala.Serializable)scope -> {
                Seq collections = (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(scope.collections()).asScala()).map((Function1 & Serializable & scala.Serializable)coll -> new CollectionSpec(coll.name(), scope.name()), Buffer$.MODULE$.canBuildFrom());
                return new ScopeSpec(scope.name(), (Seq<CollectionSpec>)collections);
            }, Buffer$.MODULE$.canBuildFrom());
            return SFlux$.MODULE$.fromIterable((Iterable)scopes);
        });
    }

    public Duration getAllScopes$default$1() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getAllScopes$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", collection.name());
        String path = this.pathForScope(this.bucket().name(), collection.scopeName());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration createCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForCollection(this.bucket().name(), collection.scopeName(), collection.name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration dropCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", scopeName);
        String path = this.pathForManifest(this.bucket().name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration createScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForScope(this.bucket().name(), scopeName);
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration dropScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropScope$default$3() {
        return this.defaultRetryStrategy();
    }

    private String pathForScope(String bucketName, String scopeName) {
        return new StringBuilder(1).append(this.pathForManifest(bucketName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)scopeName)).toString();
    }

    private String pathForCollection(String bucketName, String scopeName, String collectionName) {
        return new StringBuilder(1).append(this.pathForScope(bucketName, scopeName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)collectionName)).toString();
    }

    private String pathForManifest(String bucketName) {
        return new StringBuilder(35).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)bucketName)).append("/collections").toString();
    }

    private SMono<CollectionsManifest> loadManifest(Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.GET, this.pathForManifest(this.bucket().name()), timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)response -> {
            String error = new String(response.content(), StandardCharsets.UTF_8);
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.INVALID_ARGS;
            return !(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null) ? (error.contains("Not allowed on this version of cluster") ? SMono$.MODULE$.raiseError((Throwable)new IllegalArgumentException("This version of Couchbase Server does not support this operation")) : SMono$.MODULE$.raiseError((Throwable)new IllegalArgumentException(error))) : SMono$.MODULE$.fromTry((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (CollectionsManifest)JacksonTransformers.MAPPER.readValue(response.content(), CollectionsManifest.class)));
        });
    }

    private Try<BoxedUnit> checkForErrors(GenericManagerResponse response, String scopeName, String collectionName) {
        Success success;
        if (response.status().success()) {
            success = new Success((Object)BoxedUnit.UNIT);
        } else {
            String error = new String(response.content(), StandardCharsets.UTF_8);
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                success = error.contains("Scope with this name is not found") ? new Failure((Throwable)new ScopeNotFoundException(scopeName)) : (error.contains("Collection with this name is not found") ? new Failure((Throwable)new CollectionNotFoundException(collectionName)) : new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString())));
            } else {
                ResponseStatus responseStatus3 = response.status();
                ResponseStatus responseStatus4 = ResponseStatus.INVALID_ARGS;
                success = !(responseStatus3 != null ? !responseStatus3.equals(responseStatus4) : responseStatus4 != null) ? (error.contains("Scope with this name already exists") ? new Failure((Throwable)new ScopeExistsException(scopeName)) : (error.contains("Collection with this name already exists") ? new Failure((Throwable)new CollectionExistsException(collectionName)) : new Failure((Throwable)new IllegalArgumentException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString())))) : new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()));
            }
        }
        return success;
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$2(CollectionSpec collection$1, CollectionsManifestScope x$1) {
        String string = x$1.name();
        String string2 = collection$1.scopeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$4(CollectionSpec collection$1, CollectionsManifestCollection x$2) {
        String string = x$2.name();
        String string2 = collection$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$1(CollectionSpec collection$1, CollectionsManifest manifest) {
        Option foundCollection = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(manifest.scopes()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$2(collection$1, x$1))).flatMap((Function1 & Serializable & scala.Serializable)scope -> ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(scope.collections()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$4(collection$1, x$2))));
        return foundCollection.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$2(String scopeName$1, CollectionsManifestScope x$4) {
        String string = x$4.name();
        String string2 = scopeName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$1(String scopeName$1, CollectionsManifest x$3) {
        return ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$3.scopes()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$2(scopeName$1, x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$getScope$2(String scopeName$2, ScopeSpec x$5) {
        String string = x$5.name();
        String string2 = scopeName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReactiveCollectionManager(AsyncBucket bucket) {
        this.bucket = bucket;
        this.core = bucket.core();
        this.defaultManagerTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.defaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

