/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.events.request.PreparedStatementRetriedEvent;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.LRUCache;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonObjectSafeConvert$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$CompletionStageOps$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.json.JsonObjectSafe;
import com.couchbase.client.scala.query.QueryMetaData;
import com.couchbase.client.scala.query.QueryMetrics;
import com.couchbase.client.scala.query.QueryMetrics$;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.QueryStatus;
import com.couchbase.client.scala.query.QueryStatus$Aborted$;
import com.couchbase.client.scala.query.QueryStatus$Closed$;
import com.couchbase.client.scala.query.QueryStatus$Completed$;
import com.couchbase.client.scala.query.QueryStatus$Errors$;
import com.couchbase.client.scala.query.QueryStatus$Fatal$;
import com.couchbase.client.scala.query.QueryStatus$Running$;
import com.couchbase.client.scala.query.QueryStatus$Stopped$;
import com.couchbase.client.scala.query.QueryStatus$Success$;
import com.couchbase.client.scala.query.QueryStatus$Timeout$;
import com.couchbase.client.scala.query.QueryStatus$Unknown$;
import com.couchbase.client.scala.query.QueryWarning;
import com.couchbase.client.scala.query.ReactiveQueryResult;
import com.couchbase.client.scala.query.handlers.QueryCacheEntry;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t5a!B\r\u001b\u0001y1\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\fMBQ!\u000f\u0001\u0005\u0002iBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004H\u0001\u0001\u0006IA\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0013y\u0005B\u00024\u0001A\u0003%\u0001\u000bC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n%DQ\u0001\u001f\u0001\u0005\neDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003G\u0003A\u0011BAS\u0011\u001d\ti\u000b\u0001C\u0005\u0003_Cq!a/\u0001\t\u0013\ti\fC\u0004\u0002\u001a\u0002!\t!a2\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-(\u0001D)vKJL\b*\u00198eY\u0016\u0014(BA\u000e\u001d\u0003!A\u0017M\u001c3mKJ\u001c(BA\u000f\u001f\u0003\u0015\tX/\u001a:z\u0015\ty\u0002%A\u0003tG\u0006d\u0017M\u0003\u0002\"E\u000511\r\\5f]RT!a\t\u0013\u0002\u0013\r|Wo\u00195cCN,'\"A\u0013\u0002\u0007\r|Wn\u0005\u0002\u0001OA\u0011\u0001FK\u0007\u0002S)\tq$\u0003\u0002,S\t1\u0011I\\=SK\u001a\f!\u0001\u001b9\u0004\u0001A\u0011q\u0006M\u0007\u0002=%\u0011\u0011G\b\u0002\u0013\u0011\u0006tG\r\\3s\u0005\u0006\u001c\u0018n\u0019)be\u0006l7/\u0001\u0002fGB\u0011AgN\u0007\u0002k)\u0011a'K\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001d6\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0003w}\"\"\u0001\u0010 \u0011\u0005u\u0002Q\"\u0001\u000e\t\u000bI\u001a\u00019A\u001a\t\u000b1\u001a\u0001\u0019\u0001\u0018\u0002\t\r|'/Z\u000b\u0002\u0005B\u00111)R\u0007\u0002\t*\u0011\u0001\tI\u0005\u0003\r\u0012\u0013AaQ8sK\u0006)1m\u001c:fA\u0005q\u0011+^3ss\u000e\u000b7\r[3TSj,W#\u0001&\u0011\u0005!Z\u0015B\u0001'*\u0005\rIe\u000e^\u0001\u0010#V,'/_\"bG\",7+\u001b>fA\u0005Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0003A\u0003B!\u0015,YG6\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u00075\u000b\u0007\u000f\u0005\u0002ZA:\u0011!L\u0018\t\u00037&j\u0011\u0001\u0018\u0006\u0003;6\na\u0001\u0010:p_Rt\u0014BA0*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}K\u0003CA\u001fe\u0013\t)'DA\bRk\u0016\u0014\u0018pQ1dQ\u0016,e\u000e\u001e:z\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.\u001a\u0011\u0002/\u0015t\u0007.\u00198dK\u0012\u0004&/\u001a9be\u0016$WI\\1cY\u0016$W#A5\u0011\u0005!R\u0017BA6*\u0005\u001d\u0011un\u001c7fC:\f1$\u001a8iC:\u001cW\r\u001a)sKB\f'/\u001a3F]\u0006\u0014G.\u001a3`I\u0015\fHC\u00018r!\tAs.\u0003\u0002qS\t!QK\\5u\u0011\u001d\u00118\"!AA\u0002%\f1\u0001\u001f\u00132\u0003a)g\u000e[1oG\u0016$\u0007K]3qCJ,G-\u00128bE2,G\r\t\u0015\u0003\u0019U\u0004\"\u0001\u000b<\n\u0005]L#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002;U\u0004H-\u0019;f\u000b:D\u0017M\\2fIB\u0013X\r]1sK\u0012,e.\u00192mK\u0012$\"A\u001c>\t\u000bml\u0001\u0019\u0001?\u0002\r\r|gNZ5h!\tix0D\u0001\u007f\u0015\tYH)C\u0002\u0002\u0002y\u0014Qb\u00117vgR,'oQ8oM&<\u0017a\u0002:fcV,7\u000f^\u000b\u0005\u0003\u000f\tY\u0005\u0006\u0006\u0002\n\u0005\u0005\u0012QEA\u0019\u0003\u0003\u0002b!a\u0003\u0002\u0010\u0005MQBAA\u0007\u0015\t\u0019\u0016&\u0003\u0003\u0002\u0012\u00055!a\u0001+ssB!\u0011QCA\u000f\u001b\t\t9BC\u0002\u001e\u00033Q1!a\u0007E\u0003\ri7oZ\u0005\u0005\u0003?\t9B\u0001\u0007Rk\u0016\u0014\u0018PU3rk\u0016\u001cH\u000f\u0003\u0004\u0002$9\u0001\r\u0001W\u0001\ngR\fG/Z7f]RDq!a\n\u000f\u0001\u0004\tI#A\u0004paRLwN\\:\u0011\t\u0005-\u0012QF\u0007\u00029%\u0019\u0011q\u0006\u000f\u0003\u0019E+XM]=PaRLwN\\:\t\u000f\u0005Mb\u00021\u0001\u00026\u0005YQM\u001c<je>tW.\u001a8u!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e=\u0005\u0019QM\u001c<\n\t\u0005}\u0012\u0011\b\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG\u000fC\u0004\u0002D9\u0001\r!!\u0012\u0002\u0019E,XM]=D_:$X\r\u001f;\u0011\t!\n9\u0005W\u0005\u0004\u0003\u0013J#AB(qi&|g\u000eB\u0004\u0002N9\u0011\r!a\u0014\u0003\u0003Q\u000bB!!\u0015\u0002XA\u0019\u0001&a\u0015\n\u0007\u0005U\u0013FA\u0004O_RD\u0017N\\4\u0011\u0007!\nI&C\u0002\u0002\\%\u00121!\u00118z\u0003=\u0019wN\u001c<feR\u0014Vm\u001d9p]N,G\u0003BA1\u0003O\u0002B!a\u000b\u0002d%\u0019\u0011Q\r\u000f\u0003'I+\u0017m\u0019;jm\u0016\fV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000f\u0005%t\u00021\u0001\u0002l\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002\u0016\u00055\u0014\u0002BA8\u0003/\u0011Q\"U;fef\u0014Vm\u001d9p]N,\u0017!D9vKJL\u0018J\u001c;fe:\fG\u000e\u0006\u0005\u0002v\u0005%\u00151RAG!\u0019\t9(!\"\u0002l5\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005qk\nd\u0017n\u001d5fe*\u0019q$a \u000b\u0007\u0001\u000b\tI\u0003\u0002\u0002\u0004\u00069!/Z1di>\u0014\u0018\u0002BAD\u0003s\u0012QaU'p]>Dq!a\u0001\u0011\u0001\u0004\t\u0019\u0002C\u0004\u0002(A\u0001\r!!\u000b\t\r\u0005=\u0005\u00031\u0001j\u0003\u0015\tG\r[8d\u0003Yi\u0017-\u001f2f!J,\u0007/\u0019:f\u0003:$W\t_3dkR,GCBA;\u0003+\u000b9\nC\u0004\u0002\u0004E\u0001\r!a\u0005\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002*\u0005i\u0011/^3ssJ+\u0017m\u0019;jm\u0016$b!!(\u0002 \u0006\u0005\u0006CBA<\u0003\u000b\u000b\t\u0007C\u0004\u0002\u0004I\u0001\r!a\u0005\t\u000f\u0005\u001d\"\u00031\u0001\u0002*\u0005\u0019\"-^5mIB\u0013X\r]1sKJ+\u0017/^3tiR1\u00111CAT\u0003WCq!!+\u0014\u0001\u0004\t\u0019\"\u0001\u0005pe&<\u0017N\\1m\u0011\u001d\t9c\u0005a\u0001\u0003S\t1CY;jY\u0012,\u00050Z2vi\u0016\u0014V-];fgR$\u0002\"a\u0005\u00022\u0006U\u0016q\u0017\u0005\u0007\u0003g#\u0002\u0019A2\u0002\u0015\r\f7\r[3F]R\u0014\u0018\u0010C\u0004\u0002*R\u0001\r!a\u0005\t\u000f\u0005eF\u00031\u0001\u0002*\u0005yqN]5hS:\fGn\u00149uS>t7/\u0001\u000bdC\u000eDW-\u00128uef\u001cF/\u001b7m-\u0006d\u0017\u000e\u001a\u000b\u0006S\u0006}\u00161\u0019\u0005\u0007\u0003\u0003,\u0002\u0019A2\u0002\u000b\u0015tGO]=\t\r\u0005\u0015W\u00031\u0001j\u0003=)g\u000e[1oG\u0016$WI\\1cY\u0016$GCCAO\u0003\u0013\fY-!4\u0002P\"1\u00111\u0005\fA\u0002aCq!a\n\u0017\u0001\u0004\tI\u0003C\u0004\u00024Y\u0001\r!!\u000e\t\u000f\u0005\rc\u00031\u0001\u0002F\u0005Q\u0011/^3ss\u0006\u001b\u0018P\\2\u0015\u0015\u0005U\u0017\u0011]Ar\u0003K\f9\u000fE\u00035\u0003/\fY.C\u0002\u0002ZV\u0012aAR;ukJ,\u0007\u0003BA\u0016\u0003;L1!a8\u001d\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\r\u0005\rr\u00031\u0001Y\u0011\u001d\t9c\u0006a\u0001\u0003SAq!a\r\u0018\u0001\u0004\t)\u0004C\u0004\u0002D]\u0001\r!!\u0012\u0002\u001bA\u0014X\r]1sK\u0012\u0014V\r\u001e:z)\u0019\tiO!\u0002\u0003\nQ!\u0011QOAx\u0011\u001d\t\t\u0010\u0007a\u0001\u0003g\f1!\u001a:s!\u0011\t)0a@\u000f\t\u0005]\u00181 \b\u00047\u0006e\u0018\"A\u0010\n\u0007\u0005u\u0018&A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0005!1\u0001\u0002\n)\"\u0014xn^1cY\u0016T1!!@*\u0011\u001d\u00119\u0001\u0007a\u0001\u0003'\t1A]3r\u0011\u001d\u0011Y\u0001\u0007a\u0001\u0003S\tAa\u001c9ug\u0002")
public class QueryHandler {
    private final HandlerBasicParams hp;
    private final ExecutionContext ec;
    private final Core core;
    private final int QueryCacheSize;
    private final Map<String, QueryCacheEntry> queryCache;
    private volatile boolean enhancedPreparedEnabled;

    private Core core() {
        return this.core;
    }

    private int QueryCacheSize() {
        return this.QueryCacheSize;
    }

    private Map<String, QueryCacheEntry> queryCache() {
        return this.queryCache;
    }

    private boolean enhancedPreparedEnabled() {
        return this.enhancedPreparedEnabled;
    }

    private void enhancedPreparedEnabled_$eq(boolean x$1) {
        this.enhancedPreparedEnabled = x$1;
    }

    private void updateEnhancedPreparedEnabled(ClusterConfig config) {
        block0: {
            if (this.enhancedPreparedEnabled()) break block0;
            Set caps = (Set)config.clusterCapabilities().get(ServiceType.QUERY);
            this.enhancedPreparedEnabled_$eq(caps != null && caps.contains(ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS));
        }
    }

    private <T> Try<QueryRequest> request(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> queryContext) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.maxParallelism(), "maxParallelism").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.metrics()), "metrics").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.pipelineBatch(), "pipelineBatch").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.pipelineCap(), "pipelineCap").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.profile(), "profile").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.scanCap(), "scanCap").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.scanConsistency(), "scanConsistency").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))))))))))))));
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Option<RuntimeException> option = options.deferredException();
            if (option instanceof Some) {
                Some some = (Some)option;
                RuntimeException deferredException = (RuntimeException)some.value();
                failure = new Failure((Throwable)deferredException);
            } else {
                JsonObject params = options.encode();
                params.put("statement", statement);
                queryContext.foreach((Function1 & Serializable & scala.Serializable)v -> params.put("query_context", v));
                failure = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable & scala.Serializable)queryStr -> {
                    byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
                    Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable & scala.Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().queryTimeout()));
                    RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> environment.retryStrategy());
                    QueryRequest request = new QueryRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, this.core().context().authenticator(), statement, queryBytes, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), params.str("client_context_id"), $this.hp.tracer().requestSpan("cb.query", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())), (String)queryContext.orNull(Predef$.MODULE$.$conforms()));
                    return request;
                });
            }
            try_ = failure;
        }
        return try_;
    }

    private ReactiveQueryResult convertResponse(QueryResponse response) {
        SFlux rows = FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows());
        SMono meta = FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable & scala.Serializable)addl -> {
            Seq warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.warnings())).map((Function1 & Serializable & scala.Serializable)warnings -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala()).map((Function1 & Serializable & scala.Serializable)warning -> new QueryWarning(warning.code(), warning.message()), Buffer$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            String string = addl.status();
            QueryStatus queryStatus = "running".equals(string) ? QueryStatus$Running$.MODULE$ : ("success".equals(string) ? QueryStatus$Success$.MODULE$ : ("errors".equals(string) ? QueryStatus$Errors$.MODULE$ : ("completed".equals(string) ? QueryStatus$Completed$.MODULE$ : ("stopped".equals(string) ? QueryStatus$Stopped$.MODULE$ : ("timeout".equals(string) ? QueryStatus$Timeout$.MODULE$ : ("closed".equals(string) ? QueryStatus$Closed$.MODULE$ : ("fatal".equals(string) ? QueryStatus$Fatal$.MODULE$ : ("aborted".equals(string) ? QueryStatus$Aborted$.MODULE$ : QueryStatus$Unknown$.MODULE$))))))));
            QueryStatus$Running$ status = queryStatus;
            QueryMetaData out = new QueryMetaData(response.header().requestId(), (String)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().clientContextId())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), (Option<QueryMetrics>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.metrics())).flatMap((Function1 & Serializable & scala.Serializable)in -> QueryMetrics$.MODULE$.fromBytes((byte[])in)), (Seq<QueryWarning>)warnings2, status, OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.profile())));
            return out;
        });
        return new ReactiveQueryResult(rows, (SMono<QueryMetaData>)meta);
    }

    private SMono<QueryResponse> queryInternal(QueryRequest request, QueryOptions options, boolean adhoc) {
        return adhoc ? SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            this.core().send((Request)request);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)request, request.response(), true);
        }) : this.maybePrepareAndExecute(request, options);
    }

    private SMono<QueryResponse> maybePrepareAndExecute(QueryRequest request, QueryOptions options) {
        QueryCacheEntry cacheEntry = this.queryCache().get(request.statement());
        boolean enhancedEnabled = this.enhancedPreparedEnabled();
        return cacheEntry != null && this.cacheEntryStillValid(cacheEntry, enhancedEnabled) ? this.queryInternal(this.buildExecuteRequest(cacheEntry, request, options), options, true).onErrorResume((Function1 & Serializable & scala.Serializable)err -> this.preparedRetry(request, options, (Throwable)err)) : (enhancedEnabled ? this.queryInternal(this.buildPrepareRequest(request, options), options, true).flatMap((Function1 & Serializable & scala.Serializable)qr -> {
            SMono sMono;
            Optional preparedName = qr.header().prepared();
            if (!preparedName.isPresent()) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new CouchbaseException("No prepared name present but must be, this is a query bug!"));
            } else {
                this.queryCache().put(request.statement(), new QueryCacheEntry((String)preparedName.get(), false, (Option<String>)None$.MODULE$));
                sMono = SMono$.MODULE$.just(qr);
            }
            return sMono;
        }) : SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> {
            QueryRequest req = this.buildPrepareRequest(request, options);
            this.core().send((Request)req);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)req, req.response(), true);
        }).flatMapMany((Function1 & Serializable & scala.Serializable)result -> result.rows()).doOnNext((Function1 & Serializable & scala.Serializable)row -> {
            QueryHandler.$anonfun$maybePrepareAndExecute$5(this, enhancedEnabled, request, row);
            return BoxedUnit.UNIT;
        }).then().then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.maybePrepareAndExecute(request, options))).onErrorResume((Function1 & Serializable & scala.Serializable)err -> this.queryInternal(request, options, true)));
    }

    private SMono<ReactiveQueryResult> queryReactive(QueryRequest request, QueryOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.queryInternal(request, options, options.adhoc()).map((Function1 & Serializable & scala.Serializable)v -> this.convertResponse((QueryResponse)v)));
    }

    private QueryRequest buildPrepareRequest(QueryRequest original, QueryOptions options) {
        Object object;
        String statement = new StringBuilder(8).append("PREPARE ").append(original.statement()).toString();
        JsonObject query = JsonObject$.MODULE$.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        if (this.enhancedPreparedEnabled()) {
            query.put("auto_execute", BoxesRunTime.boxToBoolean((boolean)true));
            object = options.encode(query);
        } else {
            object = BoxedUnit.UNIT;
        }
        Object object2 = original.queryContext() != null ? query.put("query_context", original.queryContext()) : BoxedUnit.UNIT;
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), statement, query.toString().getBytes(StandardCharsets.UTF_8), true, query.str("client_context_id"), this.hp.tracer().requestSpan("cb.query", (RequestSpan)options.parentSpan().orNull(Predef$.MODULE$.$conforms())), original.queryContext());
    }

    private QueryRequest buildExecuteRequest(QueryCacheEntry cacheEntry, QueryRequest original, QueryOptions originalOptions) {
        JsonObject query = cacheEntry.export();
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        Object object = original.queryContext() != null ? query.put("query_context", original.queryContext()) : BoxedUnit.UNIT;
        originalOptions.encode(query);
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), original.statement(), query.toString().getBytes(StandardCharsets.UTF_8), BoxesRunTime.unboxToBoolean((Object)originalOptions.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), query.str("client_context_id"), this.hp.tracer().requestSpan("cb.query", (RequestSpan)originalOptions.parentSpan().orNull(Predef$.MODULE$.$conforms())), original.queryContext());
    }

    private boolean cacheEntryStillValid(QueryCacheEntry entry, boolean enhancedEnabled) {
        return enhancedEnabled && !entry.fullPlan() || !enhancedEnabled && entry.fullPlan();
    }

    public SMono<ReactiveQueryResult> queryReactive(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> queryContext) {
        SMono sMono;
        Try<QueryRequest> try_ = this.request(statement, options, environment, queryContext);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            sMono = this.queryReactive(req, options);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Future<QueryResult> queryAsync(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> queryContext) {
        Future future;
        Try<QueryRequest> try_ = this.request(statement, options, environment, queryContext);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            future = this.queryReactive(req, options).flatMap((Function1 & Serializable & scala.Serializable)response -> response.rows().collectSeq().flatMap((Function1 & Serializable & scala.Serializable)rows -> response.metaData().map((Function1 & Serializable & scala.Serializable)meta -> new QueryResult((Seq<QueryChunkRow>)rows, (QueryMetaData)meta)))).toFuture();
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    private SMono<QueryResponse> preparedRetry(QueryRequest req, QueryOptions opts, Throwable err) {
        SMono sMono;
        PreparedStatementFailureException preparedStatementFailureException;
        Throwable throwable = err;
        if (throwable instanceof PreparedStatementFailureException && (preparedStatementFailureException = (PreparedStatementFailureException)throwable).retryable()) {
            this.queryCache().remove(req.statement());
            RetryReason retryReason = RetryReason.QUERY_PREPARED_STATEMENT_FAILURE;
            CoreEnvironment env = req.context().environment();
            CompletableFuture cf = req.retryStrategy().shouldRetry((Request)req, retryReason);
            sMono = SMono$.MODULE$.fromFuture(FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(cf)), this.ec).flatMap((Function1 & Serializable & scala.Serializable)retryAction -> {
                SMono sMono;
                Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(retryAction.duration()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    java.time.Duration duration = (java.time.Duration)some.value();
                    java.time.Duration cappedDuration = RetryOrchestrator.capDuration((java.time.Duration)duration, (Request)req);
                    req.context().incrementRetryAttempts(cappedDuration, retryReason);
                    env.eventBus().publish((Event)new PreparedStatementRetriedEvent(cappedDuration, req.context(), retryReason, (Throwable)preparedStatementFailureException));
                    sMono = SMono$.MODULE$.delay(DurationConversions$.MODULE$.javaDurationToScala(cappedDuration), env.scheduler()).flatMap((Function1 & Serializable & scala.Serializable)l -> this.maybePrepareAndExecute(req, opts));
                } else {
                    sMono = SMono$.MODULE$.raiseError((Throwable)preparedStatementFailureException);
                }
                return sMono;
            });
        } else {
            sMono = SMono$.MODULE$.raiseError(err);
        }
        return sMono;
    }

    public static final /* synthetic */ void $anonfun$maybePrepareAndExecute$5(QueryHandler $this, boolean enhancedEnabled$1, QueryRequest request$2, QueryChunkRow row) {
        Try<JsonObjectSafe> json = JsonDeserializer$JsonObjectSafeConvert$.MODULE$.deserialize(row.data());
        Option nameOpt = json.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.str("name")).toOption();
        None$ plan = enhancedEnabled$1 ? None$.MODULE$ : json.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.str("encoded_plan")).toOption();
        Option option = nameOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            QueryCacheEntry entry = new QueryCacheEntry(name, !enhancedEnabled$1, (Option<String>)plan);
            $this.queryCache().put(request$2.statement(), entry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public QueryHandler(HandlerBasicParams hp, ExecutionContext ec) {
        this.hp = hp;
        this.ec = ec;
        this.core = hp.core();
        this.QueryCacheSize = 5000;
        this.queryCache = Collections.synchronizedMap(new LRUCache(this.QueryCacheSize()));
        this.enhancedPreparedEnabled = false;
        this.core().configurationProvider().configs().subscribe(config -> this.updateEnhancedPreparedEnabled((ClusterConfig)config));
    }
}

