/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.bucket;

import com.couchbase.client.scala.json.JsonArray;
import com.couchbase.client.scala.json.JsonArray$;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.manager.bucket.BucketSettings;
import com.couchbase.client.scala.manager.bucket.BucketType;
import com.couchbase.client.scala.manager.bucket.BucketType$;
import com.couchbase.client.scala.manager.bucket.CompressionMode;
import com.couchbase.client.scala.manager.bucket.CompressionMode$;
import com.couchbase.client.scala.manager.bucket.CompressionMode$Off$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple10;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;

public final class BucketSettings$
implements scala.Serializable {
    public static BucketSettings$ MODULE$;

    static {
        new BucketSettings$();
    }

    public BucketSettings parseFrom(byte[] raw) {
        JsonObject json = JsonObject$.MODULE$.fromJson(new String(raw, StandardCharsets.UTF_8));
        return this.parseFrom(json);
    }

    public BucketSettings parseFrom(JsonObject json) {
        boolean flushEnabled = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> json.bool("flush")).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        int rawRAM = json.obj("quota").num("rawRAM");
        int ramMB = rawRAM / 0x100000;
        int numReplicas = json.num("replicaNumber");
        JsonArray nodes = json.arr("nodes");
        BooleanRef isHealthy = BooleanRef.create((boolean)nodes.nonEmpty());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(nodes.values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)v -> {
            BucketSettings$.$anonfun$parseFrom$3(isHealthy, v);
            return BoxedUnit.UNIT;
        });
        int maxTTL = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> json.num("maxTTL")).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        CompressionMode compressionMode = (CompressionMode)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append('\"').append(json.str("compressionMode")).append('\"').toString()).map((Function1 & Serializable & scala.Serializable)v -> CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(v), CompressionMode$.MODULE$.rw())).getOrElse((Function0 & Serializable & scala.Serializable)() -> CompressionMode$Off$.MODULE$);
        return new BucketSettings(json.str("name"), flushEnabled, ramMB, numReplicas, BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> json.bool("replicaIndex")).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)), CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(new StringBuilder(11).append('\"').append(json.str("bucketType")).append('\"').toString()), BucketType$.MODULE$.rw()), CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(new StringBuilder(11).append('\"').append(json.str("evictionPolicy")).append('\"').toString()), EjectionMethod$.MODULE$.rw()), maxTTL, compressionMode, isHealthy.elem);
    }

    public Seq<BucketSettings> parseSeqFrom(byte[] raw) {
        JsonArray jsonArr = (JsonArray)JsonArray$.MODULE$.fromJson(new String(raw, StandardCharsets.UTF_8)).get();
        return (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(jsonArr.values()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> {
            JsonObject j = (JsonObject)v;
            return MODULE$.parseFrom(j);
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public BucketSettings apply(String name, boolean flushEnabled, int ramQuotaMB, int numReplicas, boolean replicaIndexes, BucketType bucketType, EjectionMethod ejectionMethod, int maxTTL, CompressionMode compressionMode, boolean healthy) {
        return new BucketSettings(name, flushEnabled, ramQuotaMB, numReplicas, replicaIndexes, bucketType, ejectionMethod, maxTTL, compressionMode, healthy);
    }

    public Option<Tuple10<String, Object, Object, Object, Object, BucketType, EjectionMethod, Object, CompressionMode, Object>> unapply(BucketSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple10((Object)x$0.name(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flushEnabled()), (Object)BoxesRunTime.boxToInteger((int)x$0.ramQuotaMB()), (Object)BoxesRunTime.boxToInteger((int)x$0.numReplicas()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.replicaIndexes()), (Object)x$0.bucketType(), (Object)x$0.ejectionMethod(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxTTL()), (Object)x$0.compressionMode(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.healthy$access$9())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$parseFrom$3(BooleanRef isHealthy$1, Object v) {
        block0: {
            JsonObject j = (JsonObject)v;
            String string = j.str("status");
            String string2 = "healthy";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            isHealthy$1.elem = false;
        }
    }

    private BucketSettings$() {
        MODULE$ = this;
    }
}

