/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.Bucket;
import com.couchbase.client.scala.Cluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.BucketManager;
import com.couchbase.client.scala.manager.query.QueryIndexManager;
import com.couchbase.client.scala.manager.search.SearchIndexManager;
import com.couchbase.client.scala.manager.user.UserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.util.AsyncUtils$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.util.UUID;
import reactor.core.scala.publisher.SMono;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\t5h\u0001B\u0017/\u0001]B\u0001\"\u0010\u0001\u0003\u0002\u0013\u0006IA\u0010\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0004_\u0001\u0011\u0005af\u0018\u0005\tK\u0002\u0011\r\u0011b\u0001/M\"1Q\u000e\u0001Q\u0001\n\u001dDqA\u001c\u0001C\u0002\u0013\u0005q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\ti\u0002A)\u0019!C\u0001k\"A\u0011\u0010\u0001EC\u0002\u0013\u0005!\u0010\u0003\u0006\u0002\u001e\u0001A)\u0019!C\u0001\u0003?A!\"a\f\u0001\u0011\u000b\u0007I\u0011AA\u0019\u0011)\t\t\u0005\u0001EC\u0002\u0013\u0005\u00111\t\u0005\u000b\u0003'\u0002\u0001R1A\u0005\u0002\u0005U\u0003B\u0002#\u0001\t\u0003\t)\u0007C\u0004\u0002(\u0001!\t!a\u001a\t\u000f\u0005e\u0002\u0001\"\u0001\u0002z!9\u0011\u0011\b\u0001\u0005\u0002\u0005}\u0005\"CAd\u0001E\u0005I\u0011AAe\u0011%\ti\u000eAI\u0001\n\u0003\ty\u000eC\u0005\u0002d\u0002\t\n\u0011\"\u0001\u0002f\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bbBAu\u0001\u0011\u0005!1\u0001\u0005\n\u0005#\u0001\u0011\u0013!C\u0001\u0005'A\u0011Ba\u0006\u0001#\u0003%\t!a8\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9!\u0011\u0004\u0001\u0005\u0002\t%\u0003\"\u0003B)\u0001E\u0005I\u0011AAp\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+B\u0011Ba\u0018\u0001#\u0003%\t!a8\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003d!I!Q\u000f\u0001\u0012\u0002\u0013\u0005!q\u000f\u0005\b\u0005C\u0002A\u0011\u0001B>\u0011\u001d\u0011I\t\u0001C\u0001\u0005\u0017C\u0011B!(\u0001#\u0003%\tAa(\t\u000f\t%\u0005\u0001\"\u0001\u0003$\"9!Q\u0016\u0001\u0005\u0002\t=\u0006b\u0002BW\u0001\u0011\u0005!QW\u0004\b\u0005\u0003t\u0003\u0012\u0001Bb\r\u0019ic\u0006#\u0001\u0003F\"1a\f\u000bC\u0001\u0005\u000fDqA!3)\t\u0003\u0011Y\rC\u0004\u0003J\"\"\tAa7\t\u000f\t%\u0007\u0006\"\u0001\u0003h\n91\t\\;ti\u0016\u0014(BA\u00181\u0003\u0015\u00198-\u00197b\u0015\t\t$'\u0001\u0004dY&,g\u000e\u001e\u0006\u0003gQ\n\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003U\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u001d\u0011\u0005eZT\"\u0001\u001e\u000b\u0003=J!\u0001\u0010\u001e\u0003\r\u0005s\u0017PU3g\u0003\u0011yVM\u001c<\u0011\u0007ez\u0014)\u0003\u0002Au\tAAHY=oC6,g\b\u0005\u0002C\u000b6\t1I\u0003\u0002E]\u0005\u0019QM\u001c<\n\u0005\u0019\u001b%AE\"mkN$XM]#om&\u0014xN\\7f]R\fQ\"Y;uQ\u0016tG/[2bi>\u0014\bCA%N\u001b\u0005Q%B\u0001#L\u0015\ta\u0005'\u0001\u0003d_J,\u0017B\u0001(K\u00055\tU\u000f\u001e5f]RL7-\u0019;pe\u0006I1/Z3e\u001d>$Wm\u001d\t\u0004#b[fB\u0001*W!\t\u0019&(D\u0001U\u0015\t)f'\u0001\u0004=e>|GOP\u0005\u0003/j\na\u0001\u0015:fI\u00164\u0017BA-[\u0005\r\u0019V\r\u001e\u0006\u0003/j\u0002\"A\u0011/\n\u0005u\u001b%\u0001C*fK\u0012tu\u000eZ3\u0002\rqJg.\u001b;?)\u0011\u0001'm\u00193\u0011\u0005\u0005\u0004Q\"\u0001\u0018\t\ru\"A\u00111\u0001?\u0011\u00159E\u00011\u0001I\u0011\u0015yE\u00011\u0001Q\u0003\t)7-F\u0001h!\tA7.D\u0001j\u0015\tQ'(\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001\\5\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u0005)\u0011m]=oGV\t\u0001\u000f\u0005\u0002bc&\u0011!O\f\u0002\r\u0003NLhnY\"mkN$XM]\u0001\u0007CNLhn\u0019\u0011\u0002\u0011I,\u0017m\u0019;jm\u0016,\u0012A\u001e\t\u0003C^L!\u0001\u001f\u0018\u0003\u001fI+\u0017m\u0019;jm\u0016\u001cE.^:uKJ\fQ!^:feN,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018\u0001B;tKJT1!!\u0001/\u0003\u001di\u0017M\\1hKJL1!!\u0002~\u0005-)6/\u001a:NC:\fw-\u001a:)\u0007)\tI\u0001\u0005\u0003\u0002\f\u0005]a\u0002BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E1*\u0001\u0006b]:|G/\u0019;j_:LA!!\u0006\u0002\u0010\u0005I1\u000b^1cS2LG/_\u0005\u0005\u00033\tYB\u0001\u0005W_2\fG/\u001b7f\u0015\u0011\t)\"a\u0004\u0002\u000f\t,8m[3ugV\u0011\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE@\u0002\r\t,8m[3u\u0013\u0011\tY#!\n\u0003\u001b\t+8m[3u\u001b\u0006t\u0017mZ3sQ\rY\u0011\u0011B\u0001\rcV,'/_%oI\u0016DXm]\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sy\u0018!B9vKJL\u0018\u0002BA\u001f\u0003o\u0011\u0011#U;fefLe\u000eZ3y\u001b\u0006t\u0017mZ3sQ\ra\u0011\u0011B\u0001\u000eg\u0016\f'o\u00195J]\u0012,\u00070Z:\u0016\u0005\u0005\u0015\u0003\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-s0\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0003\u001f\nIE\u0001\nTK\u0006\u00148\r[%oI\u0016DX*\u00198bO\u0016\u0014\bfA\u0007\u0002\n\u0005\u0001\u0012M\\1msRL7m]%oI\u0016DXm]\u000b\u0003\u0003/\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;z\u0018!C1oC2LH/[2t\u0013\u0011\t\t'a\u0017\u0003+\u0005s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\"\u001aa\"!\u0003\u0016\u0003\u0005#B!!\u001b\u0002pA\u0019\u0011-a\u001b\n\u0007\u00055dF\u0001\u0004Ck\u000e\\W\r\u001e\u0005\b\u0003c\u0002\u0002\u0019AA:\u0003)\u0011WoY6fi:\u000bW.\u001a\t\u0004#\u0006U\u0014bAA<5\n11\u000b\u001e:j]\u001e$b!a\u001f\u0002\u0012\u0006U\u0005CBA?\u0003\u0007\u000b9)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u0011\u001e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\u000byHA\u0002Uef\u0004B!!#\u0002\u000e6\u0011\u00111\u0012\u0006\u0004\u0003sq\u0013\u0002BAH\u0003\u0017\u00131\"U;fef\u0014Vm];mi\"9\u00111S\tA\u0002\u0005M\u0014!C:uCR,W.\u001a8u\u0011\u001d\t9*\u0005a\u0001\u00033\u000bqa\u001c9uS>t7\u000f\u0005\u0003\u0002\n\u0006m\u0015\u0002BAO\u0003\u0017\u0013A\"U;fef|\u0005\u000f^5p]N$\"\"a\u001f\u0002\"\u0006\r\u0016QVA_\u0011\u001d\t\u0019J\u0005a\u0001\u0003gB\u0011\"!*\u0013!\u0003\u0005\r!a*\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002\n\u0006%\u0016\u0002BAV\u0003\u0017\u0013q\"U;fef\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0003_\u0013\u0002\u0013!a\u0001\u0003c\u000bq\u0001^5nK>,H\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9,[\u0001\tIV\u0014\u0018\r^5p]&!\u00111XA[\u0005!!UO]1uS>t\u0007\"CA`%A\u0005\t\u0019AAa\u0003\u0015\tG\r[8d!\rI\u00141Y\u0005\u0004\u0003\u000bT$a\u0002\"p_2,\u0017M\\\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001a\u0016\u0005\u0003O\u000bim\u000b\u0002\u0002PB!\u0011\u0011[Am\u001b\t\t\u0019N\u0003\u0003\u0002V\u0006]\u0017!C;oG\",7m[3e\u0015\r\t\tBO\u0005\u0005\u00037\f\u0019NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"];fef$C-\u001a4bk2$HeM\u000b\u0003\u0003CTC!!-\u0002N\u0006y\u0011/^3ss\u0012\"WMZ1vYR$C'\u0006\u0002\u0002h*\"\u0011\u0011YAg\u00039\tg.\u00197zi&\u001c7/U;fef$b!!<\u0002z\u0006m\bCBA?\u0003\u0007\u000by\u000f\u0005\u0003\u0002r\u0006UXBAAz\u0015\r\tiFL\u0005\u0005\u0003o\f\u0019PA\bB]\u0006d\u0017\u0010^5dgJ+7/\u001e7u\u0011\u001d\t\u0019J\u0006a\u0001\u0003gBq!a&\u0017\u0001\u0004\ti\u0010\u0005\u0003\u0002r\u0006}\u0018\u0002\u0002B\u0001\u0003g\u0014\u0001#\u00118bYf$\u0018nY:PaRLwN\\:\u0015\u0011\u00055(Q\u0001B\u0004\u0005\u001fAq!a%\u0018\u0001\u0004\t\u0019\bC\u0005\u0002&^\u0001\n\u00111\u0001\u0003\nA!\u0011\u0011\u001fB\u0006\u0013\u0011\u0011i!a=\u0003'\u0005s\u0017\r\\=uS\u000e\u001c\b+\u0019:b[\u0016$XM]:\t\u0013\u0005=v\u0003%AA\u0002\u0005E\u0016\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0003\u0016\u0005\u0005\u0013\ti-\u0001\rb]\u0006d\u0017\u0010^5dgF+XM]=%I\u00164\u0017-\u001e7uIM\n1b]3be\u000eD\u0017+^3ssRA!Q\u0004B\u0017\u0005c\u0011y\u0004\u0005\u0004\u0002~\u0005\r%q\u0004\t\u0005\u0005C\u0011I#\u0004\u0002\u0003$)!!Q\u0005B\u0014\u0003\u0019\u0011Xm];mi*\u0019\u00111\n\u0018\n\t\t-\"1\u0005\u0002\r'\u0016\f'o\u00195SKN,H\u000e\u001e\u0005\b\u0005_Q\u0002\u0019AA:\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0002:i\u0001\rAa\r\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u0003(\u00059\u0011/^3sS\u0016\u001c\u0018\u0002\u0002B\u001f\u0005o\u00111bU3be\u000eD\u0017+^3ss\"9\u0011q\u0013\u000eA\u0002\t\u0005\u0003\u0003\u0002B\"\u0005\u000bj!Aa\n\n\t\t\u001d#q\u0005\u0002\u000e'\u0016\f'o\u00195PaRLwN\\:\u0015\u0011\tu!1\nB'\u0005\u001fBqAa\f\u001c\u0001\u0004\t\u0019\bC\u0004\u0002:m\u0001\rAa\r\t\u0013\u0005=6\u0004%AA\u0002\u0005E\u0016!F:fCJ\u001c\u0007.U;fef$C-\u001a4bk2$HeM\u0001\u000bI&\u001c8m\u001c8oK\u000e$H\u0003\u0002B,\u0005;\u00022!\u000fB-\u0013\r\u0011YF\u000f\u0002\u0005+:LG\u000fC\u0005\u00020v\u0001\n\u00111\u0001\u00022\u0006!B-[:d_:tWm\u0019;%I\u00164\u0017-\u001e7uIE\n1\u0002Z5bO:|7\u000f^5dgR!!Q\rB9!\u0019\ti(a!\u0003hA!!\u0011\u000eB7\u001b\t\u0011YGC\u0002\u0003b-KAAa\u001c\u0003l\t\tB)[1h]>\u001cH/[2t%\u0016\u001cX\u000f\u001c;\t\u0013\tMt\u0004%AA\u0002\u0005M\u0014\u0001\u0003:fa>\u0014H/\u00133\u0002+\u0011L\u0017m\u001a8pgRL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0010\u0016\u0005\u0003g\ni\r\u0006\u0003\u0003f\tu\u0004bBALC\u0001\u0007!q\u0010\t\u0005\u0005\u0003\u0013))\u0004\u0002\u0003\u0004*\u0019!\u0011\r\u0018\n\t\t\u001d%1\u0011\u0002\u0013\t&\fwM\\8ti&\u001c7o\u00149uS>t7/\u0001\u0003qS:<G\u0003\u0002BG\u0005+\u0003b!! \u0002\u0004\n=\u0005\u0003\u0002B5\u0005#KAAa%\u0003l\tQ\u0001+\u001b8h%\u0016\u001cX\u000f\u001c;\t\u0013\u0005=&\u0005%AA\u0002\t]\u0005#B\u001d\u0003\u001a\u0006E\u0016b\u0001BNu\t1q\n\u001d;j_:\fa\u0002]5oO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\"*\"!qSAg)\u0011\u0011iI!*\t\u000f\u0005]E\u00051\u0001\u0003(B!!\u0011\u0011BU\u0013\u0011\u0011YKa!\u0003\u0017AKgnZ(qi&|gn]\u0001\u000fo\u0006LG/\u00168uS2\u0014V-\u00193z)\u0011\u0011\tLa-\u0011\r\u0005u\u00141\u0011B,\u0011\u001d\ty+\na\u0001\u0003c#bA!-\u00038\ne\u0006bBAXM\u0001\u0007\u0011\u0011\u0017\u0005\b\u0003/3\u0003\u0019\u0001B^!\u0011\u0011\tI!0\n\t\t}&1\u0011\u0002\u0016/\u0006LG/\u00168uS2\u0014V-\u00193z\u001fB$\u0018n\u001c8t\u0003\u001d\u0019E.^:uKJ\u0004\"!\u0019\u0015\u0014\u0005!BDC\u0001Bb\u0003\u001d\u0019wN\u001c8fGR$\u0002B!4\u0003P\nM'q\u001b\t\u0006\u0003{\n\u0019\t\u0019\u0005\b\u0005#T\u0003\u0019AA:\u0003A\u0019wN\u001c8fGRLwN\\*ue&tw\rC\u0004\u0003V*\u0002\r!a\u001d\u0002\u0011U\u001cXM\u001d8b[\u0016DqA!7+\u0001\u0004\t\u0019(\u0001\u0005qCN\u001cxo\u001c:e)\u0019\u0011iM!8\u0003`\"9!\u0011[\u0016A\u0002\u0005M\u0004bBALW\u0001\u0007!\u0011\u001d\t\u0004C\n\r\u0018b\u0001Bs]\tq1\t\\;ti\u0016\u0014x\n\u001d;j_:\u001cHC\u0002Bg\u0005S\u0014Y\u000fC\u0003PY\u0001\u0007\u0001\u000bC\u0004\u0002\u00182\u0002\rA!9")
public class Cluster {
    private ReactiveCluster reactive;
    @Stability.Volatile
    private UserManager users;
    @Stability.Volatile
    private BucketManager buckets;
    @Stability.Volatile
    private QueryIndexManager queryIndexes;
    @Stability.Volatile
    private SearchIndexManager searchIndexes;
    @Stability.Volatile
    private AnalyticsIndexManager analyticsIndexes;
    private final Function0<ClusterEnvironment> _env;
    private final ExecutionContext ec;
    private final AsyncCluster async;
    private volatile byte bitmap$0;

    public static Try<Cluster> connect(Set<SeedNode> set, ClusterOptions clusterOptions) {
        return Cluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<Cluster> connect(String string, ClusterOptions clusterOptions) {
        return Cluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<Cluster> connect(String string, String string2, String string3) {
        return Cluster$.MODULE$.connect(string, string2, string3);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public AsyncCluster async() {
        return this.async;
    }

    private ReactiveCluster reactive$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactive = new ReactiveCluster(this.async());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactive;
    }

    public ReactiveCluster reactive() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reactive$lzycompute() : this.reactive;
    }

    private UserManager users$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.users = new UserManager(this.async().users(), this.reactive().users());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.users;
    }

    public UserManager users() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.users$lzycompute() : this.users;
    }

    private BucketManager buckets$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.buckets = new BucketManager(this.async().buckets());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.buckets;
    }

    public BucketManager buckets() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private QueryIndexManager queryIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.queryIndexes = new QueryIndexManager(this.async().queryIndexes(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.queryIndexes;
    }

    public QueryIndexManager queryIndexes() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private SearchIndexManager searchIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.searchIndexes = new SearchIndexManager(this.async().searchIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.searchIndexes;
    }

    public SearchIndexManager searchIndexes() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AnalyticsIndexManager analyticsIndexes$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.analyticsIndexes = new AnalyticsIndexManager(this.reactive().analyticsIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.analyticsIndexes;
    }

    public AnalyticsIndexManager analyticsIndexes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    public ClusterEnvironment env() {
        return (ClusterEnvironment)this._env.apply();
    }

    public Bucket bucket(String bucketName) {
        return new Bucket(this.async().bucket(bucketName));
    }

    public Try<QueryResult> query(String statement, QueryOptions options) {
        java.time.Duration duration;
        Option<Duration> option = options.timeout();
        if (option instanceof Some) {
            Some some = (Some)option;
            Duration v = (Duration)some.value();
            duration = DurationConversions$.MODULE$.scalaDurationToJava(v);
        } else {
            duration = ((ClusterEnvironment)this._env.apply()).timeoutConfig().queryTimeout();
        }
        java.time.Duration timeout = duration;
        return AsyncUtils$.MODULE$.block(this.async().query(statement, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return AsyncUtils$.MODULE$.block(this.async().query(statement, parameters, timeout, adhoc), AsyncUtils$.MODULE$.block$default$2());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this._env.apply()).timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Try<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().analyticsQuery(statement, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().analyticsQuery(statement, parameters, timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this._env.apply()).timeoutConfig().queryTimeout());
    }

    public Try<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().searchQuery(indexName, query, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().searchQuery(indexName, query, timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.async().env().timeoutConfig().searchTimeout());
    }

    public void disconnect(Duration timeout) {
        SMono<BoxedUnit> qual$1 = this.reactive().disconnect(timeout);
        Duration x$1 = qual$1.block$default$1();
        qual$1.block(x$1);
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this._env.apply()).timeoutConfig().disconnectTimeout());
    }

    public Try<DiagnosticsResult> diagnostics(String reportId) {
        return AsyncUtils$.MODULE$.block(this.async().diagnostics(reportId), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().diagnostics(options), AsyncUtils$.MODULE$.block$default$2());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Try<PingResult> ping(Option<Duration> timeout) {
        return AsyncUtils$.MODULE$.block(this.async().ping(timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<PingResult> ping(PingOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().ping(options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Try<BoxedUnit> waitUntilReady(Duration timeout) {
        return AsyncUtils$.MODULE$.block(this.async().waitUntilReady(timeout), AsyncUtils$.MODULE$.block$default$2());
    }

    public Try<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return AsyncUtils$.MODULE$.block(this.async().waitUntilReady(timeout, options), AsyncUtils$.MODULE$.block$default$2());
    }

    public Cluster(Function0<ClusterEnvironment> _env, Authenticator authenticator, Set<SeedNode> seedNodes) {
        this._env = _env;
        this.ec = ((ClusterEnvironment)_env.apply()).ec();
        this.async = new AsyncCluster(_env, authenticator, seedNodes);
    }
}

