/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.service.kv.Observe;
import com.couchbase.client.core.service.kv.ObserveContext;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.PersistTo$;
import com.couchbase.client.scala.durability.ReplicateTo$;
import com.couchbase.client.scala.kv.Get;
import com.couchbase.client.scala.kv.HasDurabilityTokens;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandlerWithTranscoder;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.time.Duration;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class AsyncCollection$ {
    public static AsyncCollection$ MODULE$;
    private final Get[] getFullDoc;

    static {
        new AsyncCollection$();
    }

    public Get[] getFullDoc() {
        return this.getFullDoc;
    }

    public <Resp extends Response, Res> Future<Res> com$couchbase$client$scala$AsyncCollection$$wrap(Try<KeyValueRequest<Resp>> in, String id, KeyValueRequestHandler<Resp, Res> handler, Core core, ExecutionContext ec) {
        Future future;
        Try<KeyValueRequest<Resp>> try_ = in;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            KeyValueRequest request = (KeyValueRequest)success.value();
            core.send((Request)request);
            Future out = FutureConverters$.MODULE$.toScala(request.response()).map((Function1 & Serializable & scala.Serializable)response -> handler.response(request, id, response), ec);
            out.onComplete((Function1 & Serializable & scala.Serializable)x$6 -> request.context().logicallyComplete(), ec);
            future = out;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public <Resp extends Response, Res> Future<Res> com$couchbase$client$scala$AsyncCollection$$wrapGet(Try<KeyValueRequest<Resp>> in, String id, KeyValueRequestHandlerWithTranscoder<Resp, Res> handler, Transcoder transcoder, Core core, ExecutionContext ec) {
        Future future;
        Try<KeyValueRequest<Resp>> try_ = in;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            KeyValueRequest request = (KeyValueRequest)success.value();
            core.send((Request)request);
            Future out = FutureConverters$.MODULE$.toScala(request.response()).map((Function1 & Serializable & scala.Serializable)response -> handler.response(request, id, response, transcoder), ec);
            out.onComplete((Function1 & Serializable & scala.Serializable)x$7 -> request.context().logicallyComplete(), ec);
            future = out;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    private <Resp extends Response, Res> Future<Res> wrap(Try<KeyValueRequest<Resp>> in, String id, KeyValueRequestHandlerWithTranscoder<Resp, Res> handler, Transcoder transcoder, Core core, ExecutionContext ec) {
        Future future;
        Try<KeyValueRequest<Resp>> try_ = in;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            KeyValueRequest request = (KeyValueRequest)success.value();
            core.send((Request)request);
            Future out = FutureConverters$.MODULE$.toScala(request.response()).map((Function1 & Serializable & scala.Serializable)response -> handler.response(request, id, response, transcoder), ec);
            out.onComplete((Function1 & Serializable & scala.Serializable)x$8 -> request.context().logicallyComplete(), ec);
            future = out;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public <Resp extends Response, Res extends HasDurabilityTokens> Future<Res> com$couchbase$client$scala$AsyncCollection$$wrapWithDurability(Try<KeyValueRequest<Resp>> in, String id, KeyValueRequestHandler<Resp, Res> handler, Durability durability, boolean remove, Duration timeout, Core core, String bucketName, CollectionIdentifier collectionidentifier, ExecutionContext ec) {
        Future future;
        Future initial = this.com$couchbase$client$scala$AsyncCollection$$wrap(in, id, handler, core, ec);
        Durability durability2 = durability;
        if (durability2 instanceof Durability.ClientVerified) {
            Durability.ClientVerified clientVerified = (Durability.ClientVerified)durability2;
            Enumeration.Value replicateTo = clientVerified.replicateTo();
            Enumeration.Value persistTo = clientVerified.persistTo();
            future = initial.flatMap((Function1 & Serializable & scala.Serializable)response -> {
                ObserveContext observeCtx = new ObserveContext(core.context(), PersistTo$.MODULE$.asCore(persistTo), ReplicateTo$.MODULE$.asCore(replicateTo), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(response.mutationToken())), response.cas(), collectionidentifier, id, remove, timeout, ((Request)in.get()).internalSpan().toRequestSpan());
                return FutureConversions$.MODULE$.javaMonoToScalaFuture(Observe.poll((ObserveContext)observeCtx)).map((Function1 & Serializable & scala.Serializable)x$9 -> response, ec);
            }, ec);
        } else {
            future = initial;
        }
        return future;
    }

    private AsyncCollection$() {
        MODULE$ = this;
        this.getFullDoc = (Get[])((Object[])new Get[]{LookupInSpec$.MODULE$.get("")});
    }
}

