/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.core.msg.kv.RemoveResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u00055a!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000by\u0004A\u0011A@\u0003\u001bI+Wn\u001c<f\u0011\u0006tG\r\\3s\u0015\t9\u0001\"\u0001\u0005iC:$G.\u001a:t\u0015\tI!\"\u0001\u0002lm*\u00111\u0002D\u0001\u0006g\u000e\fG.\u0019\u0006\u0003\u001b9\taa\u00197jK:$(BA\b\u0011\u0003%\u0019w.^2iE\u0006\u001cXMC\u0001\u0012\u0003\r\u0019w.\\\n\u0004\u0001MA\u0002C\u0001\u000b\u0017\u001b\u0005)\"\"A\u0006\n\u0005])\"AB!osJ+g\r\u0005\u0003\u001a5q)S\"\u0001\u0004\n\u0005m1!AF&fsZ\u000bG.^3SKF,Xm\u001d;IC:$G.\u001a:\u0011\u0005u\u0019S\"\u0001\u0010\u000b\u0005%y\"B\u0001\u0011\"\u0003\ri7o\u001a\u0006\u0003E1\tAaY8sK&\u0011AE\b\u0002\u000f%\u0016lwN^3SKN\u0004xN\\:f!\t1s%D\u0001\t\u0013\tA\u0003B\u0001\bNkR\fG/[8o%\u0016\u001cX\u000f\u001c;\u0002\u0005!\u00048\u0001\u0001\t\u0003Y5j\u0011AC\u0005\u0003])\u0011Q\u0002S1oI2,'\u000fU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u00022eA\u0011\u0011\u0004\u0001\u0005\u0006S\t\u0001\raK\u0001\be\u0016\fX/Z:u+\t)T\u000fF\u00047\u007f1\u000b\u0006L\u00196\u0011\u0007]RD(D\u00019\u0015\tIT#\u0001\u0003vi&d\u0017BA\u001e9\u0005\r!&/\u001f\t\u0003;uJ!A\u0010\u0010\u0003\u001bI+Wn\u001c<f%\u0016\fX/Z:u\u0011\u0015\u00015\u00011\u0001B\u0003\tIG\r\u0005\u0002C\u0013:\u00111i\u0012\t\u0003\tVi\u0011!\u0012\u0006\u0003\r*\na\u0001\u0010:p_Rt\u0014B\u0001%\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011!j\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005!+\u0002\"B'\u0004\u0001\u0004q\u0015aA2bgB\u0011AcT\u0005\u0003!V\u0011A\u0001T8oO\")!k\u0001a\u0001'\u0006QA-\u001e:bE&d\u0017\u000e^=\u0011\u0005Q3V\"A+\u000b\u0005IS\u0011BA,V\u0005)!UO]1cS2LG/\u001f\u0005\u00063\u000e\u0001\rAW\u0001\bi&lWm\\;u!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0003uS6,'\"A0\u0002\t)\fg/Y\u0005\u0003Cr\u0013\u0001\u0002R;sCRLwN\u001c\u0005\u0006G\u000e\u0001\r\u0001Z\u0001\u000ee\u0016$(/_*ue\u0006$XmZ=\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d\f\u0013!\u0002:fiJL\u0018BA5g\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\")1n\u0001a\u0001Y\u0006Q\u0001/\u0019:f]R\u001c\u0006/\u00198\u0011\u0007Qiw.\u0003\u0002o+\t1q\n\u001d;j_:\u0004\"\u0001]:\u000e\u0003ET!A]\u0011\u0002\u0007\rt7-\u0003\u0002uc\nY!+Z9vKN$8\u000b]1o\t\u001518A1\u0001x\u0005\u0005!\u0016C\u0001=|!\t!\u00120\u0003\u0002{+\t9aj\u001c;iS:<\u0007C\u0001\u000b}\u0013\tiXCA\u0002B]f\f\u0001B]3ta>t7/\u001a\u000b\bK\u0005\u0005\u0011\u0011BA\u0006\u0011\u0019\u0019D\u00011\u0001\u0002\u0004A!Q$!\u0002\u001d\u0013\r\t9A\b\u0002\u0010\u0017\u0016Lh+\u00197vKJ+\u0017/^3ti\")\u0001\t\u0002a\u0001\u0003\")a\u0010\u0002a\u00019\u0001")
public class RemoveHandler
implements KeyValueRequestHandler<RemoveResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<RemoveRequest> request(String id, long cas, Durability durability, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)cas), "cas").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))))));
        return validations.isFailure() ? validations : new Success((Object)new RemoveRequest(id, cas, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), this.hp.tracer().internalSpan("remove", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
    }

    @Override
    public MutationResult response(KeyValueRequest<RemoveResponse> request, String id, RemoveResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public RemoveHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

