/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.manager.query.IndexesNotReadyException;
import com.couchbase.client.scala.manager.query.QueryIndex;
import com.couchbase.client.scala.manager.query.QueryIndex$;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.RowTraversalUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import reactor.core.scala.publisher.PimpMyPublisher$;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Unit$;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001B\u001a5\u0001\u0005C\u0011b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u000f%\t\u00115\u0003!\u0011!Q\u0001\n%C\u0001B\u0014\u0001\u0003\u0006\u0004%\u0019a\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005!\")q\u000b\u0001C\u00011\"9a\f\u0001b\u0001\n\u0013y\u0006BB3\u0001A\u0003%\u0001\rC\u0004g\u0001\t\u0007I\u0011B4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003{\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013A\u0011\"!\u0013\u0001#\u0003%\t!a\u0013\t\u0013\u0005\u0005\u0004!%A\u0005\u0002\u0005\r\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\n\u0003G\u0003\u0011\u0013!C\u0001\u0003KC\u0011\"!+\u0001#\u0003%\t!a+\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0006\"CA[\u0001E\u0005I\u0011AA&\u0011%\t9\fAI\u0001\n\u0003\t\u0019\u0007C\u0004\u0002:\u0002!\t!a/\t\u0013\u00055\u0007!%A\u0005\u0002\u0005=\u0007\"CAj\u0001E\u0005I\u0011AAS\u0011%\t)\u000eAI\u0001\n\u0003\tY\u000bC\u0005\u0002X\u0002\t\n\u0011\"\u0001\u00022\"I\u0011\u0011\u001c\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u00037\u0004\u0011\u0013!C\u0001\u0003GBq!!8\u0001\t\u0003\ty\u000eC\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002&\"I\u0011q\u001e\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0003c\u0004\u0011\u0013!C\u0001\u0003GBq!a=\u0001\t\u0003\t)\u0010C\u0005\u0002\u0000\u0002\t\n\u0011\"\u0001\u0002&\"I!\u0011\u0001\u0001\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0005\u0007\u0001\u0011\u0013!C\u0001\u0003GBqA!\u0002\u0001\t\u0003\u00119\u0001C\u0005\u0003\u0018\u0001\t\n\u0011\"\u0001\u0002&\"I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\r\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wA\u0011Ba\u0011\u0001#\u0003%\t!a\u0013\t\u0013\t\u0015\u0003!%A\u0005\u0002\u0005\r\u0004b\u0002B$\u0001\u0011%!\u0011\n\u0005\b\u00053\u0002A\u0011\u0002B.\u0011%\u0011y\bAI\u0001\n\u0013\tY\u0005C\u0005\u0003\u0002\u0002\t\n\u0011\"\u0003\u0002d!A!1\u0011\u0001\u0005\u0002a\u0012)\tC\u0004\u0003\"\u0002!\tAa)\u0003-\u0005\u001b\u0018P\\2Rk\u0016\u0014\u00180\u00138eKbl\u0015M\\1hKJT!!\u000e\u001c\u0002\u000bE,XM]=\u000b\u0005]B\u0014aB7b]\u0006<WM\u001d\u0006\u0003si\nQa]2bY\u0006T!a\u000f\u001f\u0002\r\rd\u0017.\u001a8u\u0015\tid(A\u0005d_V\u001c\u0007NY1tK*\tq(A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0005B\u00111)R\u0007\u0002\t*\t\u0011(\u0003\u0002G\t\n1\u0011I\\=SK\u001a\fqa\u00197vgR,'/F\u0001J!\tQ5*D\u00019\u0013\ta\u0005H\u0001\u0007Bgft7m\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003\t)7-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F)\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u00051A(\u001b8jiz\"\"!W/\u0015\u0005ic\u0006CA.\u0001\u001b\u0005!\u0004\"\u0002(\u0006\u0001\b\u0001\u0006\"B$\u0006\u0001\u0004I\u0015\u0001B2pe\u0016,\u0012\u0001\u0019\t\u0003C\u000el\u0011A\u0019\u0006\u0003=jJ!\u0001\u001a2\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\u000f\t\u00164\u0017-\u001e7u)&lWm\\;u+\u0005A\u0007CA5m\u001b\u0005Q'BA6S\u0003!!WO]1uS>t\u0017BA7k\u0005!!UO]1uS>t\u0017a\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011+g-Y;miJ+GO]=TiJ\fG/Z4z+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;c\u0003\u0015\u0011X\r\u001e:z\u0013\t18OA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016\t\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u0003A\u0001&/[7befLe\u000eZ3y\u001d\u0006lW-F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0005Y\u0006twMC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAP\u0001\u0004TiJLgnZ\u0001\u0012!JLW.\u0019:z\u0013:$W\r\u001f(b[\u0016\u0004\u0013!D4fi\u0006cG.\u00138eKb,7\u000f\u0006\u0005\u0002\f\u0005=\u0012\u0011IA#!\u0015\t\u0016QBA\t\u0013\r\tyA\u0015\u0002\u0007\rV$XO]3\u0011\r\u0005M\u00111EA\u0015\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007A\u0003\u0019a$o\\8u}%\t\u0011(C\u0002\u0002\"\u0011\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"aA*fc*\u0019\u0011\u0011\u0005#\u0011\u0007m\u000bY#C\u0002\u0002.Q\u0012!\"U;fefLe\u000eZ3y\u0011\u001d\t\tD\u0004a\u0001\u0003g\t!BY;dW\u0016$h*Y7f!\u0011\t)$!\u0010\u000f\t\u0005]\u0012\u0011\b\t\u0004\u0003/!\u0015bAA\u001e\t\u00061\u0001K]3eK\u001aLA!a\u0001\u0002@)\u0019\u00111\b#\t\u0011\u0005\rc\u0002%AA\u0002!\fq\u0001^5nK>,H\u000f\u0003\u0005\u0002H9\u0001\n\u00111\u0001r\u00035\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u00069r-\u001a;BY2Le\u000eZ3yKN$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bR3\u0001[A(W\t\t\t\u0006\u0005\u0003\u0002T\u0005uSBAA+\u0015\u0011\t9&!\u0017\u0002\u0013Ut7\r[3dW\u0016$'bAA.\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aF4fi\u0006cG.\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t)GK\u0002r\u0003\u001f\n1b\u0019:fCR,\u0017J\u001c3fqR\u0011\u00121NA:\u0003k\nI(a \u0002\n\u0006e\u0015qTAQ!\u0015\t\u0016QBA7!\r\u0019\u0015qN\u0005\u0004\u0003c\"%\u0001B+oSRDq!!\r\u0012\u0001\u0004\t\u0019\u0004C\u0004\u0002xE\u0001\r!a\r\u0002\u0013%tG-\u001a=OC6,\u0007bBA>#\u0001\u0007\u0011QP\u0001\u0007M&,G\u000eZ:\u0011\r\u0005M\u00111EA\u001a\u0011%\t\t)\u0005I\u0001\u0002\u0004\t\u0019)\u0001\bjO:|'/Z%g\u000bbL7\u000f^:\u0011\u0007\r\u000b))C\u0002\u0002\b\u0012\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\fF\u0001\n\u00111\u0001\u0002\u000e\u0006Ya.^7SKBd\u0017nY1t!\u0015\u0019\u0015qRAJ\u0013\r\t\t\n\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\r\u000b)*C\u0002\u0002\u0018\u0012\u00131!\u00138u\u0011%\tY*\u0005I\u0001\u0002\u0004\ti*\u0001\u0005eK\u001a,'O]3e!\u0015\u0019\u0015qRAB\u0011!\t\u0019%\u0005I\u0001\u0002\u0004A\u0007\u0002CA$#A\u0005\t\u0019A9\u0002+\r\u0014X-\u0019;f\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0015\u0016\u0005\u0003\u0007\u000by%A\u000bde\u0016\fG/Z%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u00055&\u0006BAG\u0003\u001f\nQc\u0019:fCR,\u0017J\u001c3fq\u0012\"WMZ1vYR$c'\u0006\u0002\u00024*\"\u0011QTA(\u0003U\u0019'/Z1uK&sG-\u001a=%I\u00164\u0017-\u001e7uI]\nQc\u0019:fCR,\u0017J\u001c3fq\u0012\"WMZ1vYR$\u0003(\u0001\nde\u0016\fG/\u001a)sS6\f'/_%oI\u0016DH\u0003EA6\u0003{\u000by,a1\u0002F\u0006\u001d\u0017\u0011ZAf\u0011\u001d\t\td\u0006a\u0001\u0003gA\u0011\"a\u001e\u0018!\u0003\u0005\r!!1\u0011\u000b\r\u000by)a\r\t\u0013\u0005\u0005u\u0003%AA\u0002\u0005\r\u0005\"CAF/A\u0005\t\u0019AAG\u0011%\tYj\u0006I\u0001\u0002\u0004\ti\n\u0003\u0005\u0002D]\u0001\n\u00111\u0001i\u0011!\t9e\u0006I\u0001\u0002\u0004\t\u0018\u0001H2sK\u0006$X\r\u0015:j[\u0006\u0014\u00180\u00138eKb$C-\u001a4bk2$HEM\u000b\u0003\u0003#TC!!1\u0002P\u0005a2M]3bi\u0016\u0004&/[7befLe\u000eZ3yI\u0011,g-Y;mi\u0012\u001a\u0014\u0001H2sK\u0006$X\r\u0015:j[\u0006\u0014\u00180\u00138eKb$C-\u001a4bk2$H\u0005N\u0001\u001dGJ,\u0017\r^3Qe&l\u0017M]=J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0003q\u0019'/Z1uKB\u0013\u0018.\\1ss&sG-\u001a=%I\u00164\u0017-\u001e7uIY\nAd\u0019:fCR,\u0007K]5nCJL\u0018J\u001c3fq\u0012\"WMZ1vYR$s'A\u0005ee>\u0004\u0018J\u001c3fqRa\u00111NAq\u0003G\f)/!;\u0002l\"9\u0011\u0011\u0007\u0010A\u0002\u0005M\u0002bBA<=\u0001\u0007\u00111\u0007\u0005\n\u0003Ot\u0002\u0013!a\u0001\u0003\u0007\u000b\u0011#[4o_J,\u0017J\u001a(pi\u0016C\u0018n\u001d;t\u0011!\t\u0019E\bI\u0001\u0002\u0004A\u0007\u0002CA$=A\u0005\t\u0019A9\u0002'\u0011\u0014x\u000e]%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001a\u0002'\u0011\u0014x\u000e]%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001b\u0002'\u0011\u0014x\u000e]%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001b\u0002!\u0011\u0014x\u000e\u001d)sS6\f'/_%oI\u0016DHCCA6\u0003o\fI0a?\u0002~\"9\u0011\u0011\u0007\u0012A\u0002\u0005M\u0002\"CAtEA\u0005\t\u0019AAB\u0011!\t\u0019E\tI\u0001\u0002\u0004A\u0007\u0002CA$EA\u0005\t\u0019A9\u00025\u0011\u0014x\u000e\u001d)sS6\f'/_%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001a\u00025\u0011\u0014x\u000e\u001d)sS6\f'/_%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001a\u00025\u0011\u0014x\u000e\u001d)sS6\f'/_%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001b\u0002\u0019]\fGo\u00195J]\u0012,\u00070Z:\u0015\u0019\u0005-$\u0011\u0002B\u0006\u0005\u001f\u0011\tB!\u0006\t\u000f\u0005Eb\u00051\u0001\u00024!9!Q\u0002\u0014A\u0002\u0005u\u0014AC5oI\u0016Dh*Y7fg\"1\u00111\t\u0014A\u0002!D\u0011Ba\u0005'!\u0003\u0005\r!a!\u0002\u0019]\fGo\u00195Qe&l\u0017M]=\t\u0011\u0005\u001dc\u0005%AA\u0002E\fac^1uG\"Le\u000eZ3yKN$C-\u001a4bk2$H\u0005N\u0001\u0017o\u0006$8\r[%oI\u0016DXm\u001d\u0013eK\u001a\fW\u000f\u001c;%k\u00059Bo\\,bi\u000eDG+[7f_V$X\t_2faRLwN\u001c\u000b\u0007\u0005?\u0011iCa\u000e\u0011\t\t\u0005\"\u0011F\u0007\u0003\u0005GQ1a\u0015B\u0013\u0015\r\u00119C`\u0001\u0005kRLG.\u0003\u0003\u0003,\t\r\"\u0001\u0005+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o\u0011\u001d\u0011y#\u000ba\u0001\u0005c\t\u0011\u0001\u001e\t\u0005\u0003'\u0011\u0019$\u0003\u0003\u00036\u0005\u001d\"!\u0003+ie><\u0018M\u00197f\u0011\u0019\t\u0019%\u000ba\u0001Q\u0006!\"-^5mI\u0012+g-\u001a:sK\u0012Le\u000eZ3yKN$\u0002\"a\u001b\u0003>\t}\"\u0011\t\u0005\b\u0003cQ\u0003\u0019AA\u001a\u0011!\t\u0019E\u000bI\u0001\u0002\u0004A\u0007\u0002CA$UA\u0005\t\u0019A9\u0002=\t,\u0018\u000e\u001c3EK\u001a,'O]3e\u0013:$W\r_3tI\u0011,g-Y;mi\u0012\u0012\u0014A\b2vS2$G)\u001a4feJ,G-\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003\u0015\tXo\u001c;f)\u0011\u0011YE!\u0016\u0011\r\t5#\u0011KA\u001a\u001b\t\u0011yEC\u0002\u0003(\u0011KAAa\u0015\u0003P\t\u0019AK]=\t\u000f\t]S\u00061\u0001\u00024\u0005\t1/\u0001\u0003fq\u0016\u001cG\u0003EA6\u0005;\u0012\tG!\u001a\u0003x\te$1\u0010B?\u0011\u001d\u0011yF\fa\u0001\u0003\u0007\u000b\u0001B]3bI>tG.\u001f\u0005\b\u0005Gr\u0003\u0019AA\u001a\u0003%\u0019H/\u0019;f[\u0016tG\u000fC\u0004\u0003h9\u0002\rA!\u001b\u0002\u0017]LG\u000f[(qi&|gn\u001d\t\u0006\u0007\u0006=%1\u000e\t\u0005\u0005[\u0012\u0019(\u0004\u0002\u0003p)\u0019!\u0011\u000f\u001d\u0002\t)\u001cxN\\\u0005\u0005\u0005k\u0012yG\u0001\u0006Kg>twJ\u00196fGRDq!!!/\u0001\u0004\t\u0019\tC\u0004\u0002h:\u0002\r!a!\t\u0011\u0005\rc\u0006%AA\u0002!D\u0001\"a\u0012/!\u0003\u0005\r!]\u0001\u000fKb,7\r\n3fM\u0006,H\u000e\u001e\u00137\u00039)\u00070Z2%I\u00164\u0017-\u001e7uI]\nA\"\u001a=fG&sG/\u001a:oC2$\"Ba\"\u0003\u0014\nU%Q\u0014BP!\u0015\t\u0016Q\u0002BE!\u0011\u0011YIa$\u000e\u0005\t5%BA\u001b9\u0013\u0011\u0011\tJ!$\u0003\u0017E+XM]=SKN,H\u000e\u001e\u0005\b\u0005?\n\u0004\u0019AAB\u0011\u001d\u0011\u0019'\ra\u0001\u0005/\u00032a\u001fBM\u0013\r\u0011Y\n \u0002\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0005\u0007\u0003\u0007\n\u0004\u0019\u00015\t\r\u0005\u001d\u0013\u00071\u0001r\u0003\u00119(/\u00199\u0015\u0011\u0005-$Q\u0015BU\u0005WCqAa*3\u0001\u0004\u00119)\u0001\u0002j]\"9\u0011\u0011\u0011\u001aA\u0002\u0005\r\u0005bBAte\u0001\u0007\u00111\u0011\u0015\u0004\u0001\t=\u0006\u0003\u0002BY\u0005wsAAa-\u000386\u0011!Q\u0017\u0006\u0004\u00037\u0012\u0017\u0002\u0002B]\u0005k\u000b\u0011b\u0015;bE&d\u0017\u000e^=\n\t\tu&q\u0018\u0002\t->d\u0017\r^5mK*!!\u0011\u0018B[\u0001")
public class AsyncQueryIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;
    private final String PrimaryIndexName;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private String PrimaryIndexName() {
        return this.PrimaryIndexName;
    }

    public Future<Seq<QueryIndex>> getAllIndexes(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        String statement = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(137).append("SELECT idx.* FROM system:indexes AS idx WHERE keyspace_id = \"").append(bucketName).append("\"\n         | AND `using`=\"gsi\" ORDER BY is_primary\n         | DESC, name ASC").toString())).stripMargin();
        return this.execInternal(true, statement, timeout, retryStrategy).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.rowsAs(QueryIndex$.MODULE$.codec()), this.ec()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Seq z = (Seq)success.value();
                future = Future$.MODULE$.successful((Object)z);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                future = Future$.MODULE$.failed(err);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, this.ec());
    }

    public Duration getAllIndexes$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> createIndex(String bucketName, String indexName, Seq<String> fields, boolean ignoreIfExists, Option<Object> numReplicas, Option<Object> deferred, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement;
        JsonObject withOptions = JsonObject$.MODULE$.create();
        numReplicas.foreach((Function1 & Serializable & scala.Serializable)value -> withOptions.put("num_replica", BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value))));
        deferred.foreach((Function1 & Serializable & scala.Serializable)value -> withOptions.put("defer_build", BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value))));
        Try try_ = statement = this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> this.quote(indexName).flatMap((Function1 & Serializable & scala.Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(18).append("CREATE INDEX ").append((String)quotedIndexName).append(" ON ").append((String)quotedBucketName).append(" ").append(fields.mkString("(", ",", ")")).toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)new Some((Object)withOptions), ignoreIfExists, false, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean createIndex$default$4() {
        return false;
    }

    public Option<Object> createIndex$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> createIndex$default$6() {
        return None$.MODULE$;
    }

    public Duration createIndex$default$7() {
        return this.DefaultTimeout();
    }

    public RetryStrategy createIndex$default$8() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> createPrimaryIndex(String bucketName, Option<String> indexName, boolean ignoreIfExists, Option<Object> numReplicas, Option<Object> deferred, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement;
        Try try_;
        JsonObject withOptions = JsonObject$.MODULE$.create();
        numReplicas.foreach((Function1 & Serializable & scala.Serializable)value -> withOptions.put("num_replica", BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value))));
        deferred.foreach((Function1 & Serializable & scala.Serializable)value -> withOptions.put("defer_build", BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value))));
        Option<String> option = indexName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String in = (String)some.value();
            try_ = this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> this.quote(in).flatMap((Function1 & Serializable & scala.Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(25).append("CREATE PRIMARY INDEX ").append((String)quotedIndexName).append(" ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement)));
        } else {
            try_ = this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(24).append("CREATE PRIMARY INDEX ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement));
        }
        Try try_2 = statement = try_;
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)new Some((Object)withOptions), ignoreIfExists, false, timeout, retryStrategy);
        } else if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_2);
        }
        return future;
    }

    public Option<String> createPrimaryIndex$default$2() {
        return None$.MODULE$;
    }

    public boolean createPrimaryIndex$default$3() {
        return false;
    }

    public Option<Object> createPrimaryIndex$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> createPrimaryIndex$default$5() {
        return None$.MODULE$;
    }

    public Duration createPrimaryIndex$default$6() {
        return this.DefaultTimeout();
    }

    public RetryStrategy createPrimaryIndex$default$7() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String bucketName, String indexName, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement = this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> this.quote(indexName).flatMap((Function1 & Serializable & scala.Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(12).append("DROP INDEX ").append((String)quotedBucketName).append(".").append((String)quotedIndexName).toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement)));
        Try try_ = statement;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, ignoreIfNotExists, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean dropIndex$default$3() {
        return false;
    }

    public Duration dropIndex$default$4() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$5() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropPrimaryIndex(String bucketName, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement = this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(22).append("DROP PRIMARY INDEX ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement));
        Try try_ = statement;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, ignoreIfNotExists, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean dropPrimaryIndex$default$2() {
        return false;
    }

    public Duration dropPrimaryIndex$default$3() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropPrimaryIndex$default$4() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> watchIndexes(String bucketName, Seq<String> indexNames, Duration timeout, boolean watchPrimary, RetryStrategy retryStrategy) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(PimpMyPublisher$.MODULE$.monoToJMono(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> SMono$.MODULE$.fromFuture(this.getAllIndexes(bucketName, timeout, retryStrategy), this.ec()).doOnNext((Function1 & Serializable & scala.Serializable)allIndexes -> {
            AsyncQueryIndexManager.$anonfun$watchIndexes$2(this, indexNames, watchPrimary, allIndexes);
            return BoxedUnit.UNIT;
        }))).retryWhen((Function)Retry.onlyIf(ctx -> CbThrowables.hasCause((Throwable)ctx.exception(), IndexesNotReadyException.class)).exponentialBackoff(DurationConversions$.MODULE$.scalaDurationToJava((Duration)new package.DurationInt(package$.MODULE$.DurationInt(50)).milliseconds()), DurationConversions$.MODULE$.scalaDurationToJava((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds())).timeout(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).onErrorMap(err -> err instanceof RetryExhaustedException ? this.toWatchTimeoutException((Throwable)err, timeout) : err)).toFuture().map((Function1 & Serializable & scala.Serializable)x$5 -> {
            AsyncQueryIndexManager.$anonfun$watchIndexes$9(x$5);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public boolean watchIndexes$default$4() {
        return false;
    }

    public RetryStrategy watchIndexes$default$5() {
        return this.DefaultRetryStrategy();
    }

    private TimeoutException toWatchTimeoutException(Throwable t, Duration timeout) {
        StringBuilder msg = new StringBuilder(new java.lang.StringBuilder(44).append("A requested index is still not ready after ").append(timeout).append(".").toString());
        return new TimeoutException(msg.toString());
    }

    public Future<BoxedUnit> buildDeferredIndexes(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllIndexes(bucketName, timeout, retryStrategy).flatMap((Function1 & Serializable & scala.Serializable)allIndexes -> {
            Future future;
            Seq deferred = (Seq)((TraversableLike)allIndexes.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$buildDeferredIndexes$2(x$6)))).map((Function1 & Serializable & scala.Serializable)v -> this.quote(v.name()), Seq$.MODULE$.canBuildFrom());
            if (deferred.isEmpty()) {
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                Future<BoxedUnit> future2;
                Try statement = RowTraversalUtil$.MODULE$.traverse(deferred.iterator()).flatMap((Function1 & Serializable & scala.Serializable)quotedDefers -> this.quote(bucketName).flatMap((Function1 & Serializable & scala.Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(17).append("BUILD INDEX ON ").append((String)quotedBucketName).append("(").append(quotedDefers.mkString(",")).append(")").toString()).map((Function1 & Serializable & scala.Serializable)statement -> statement)));
                Try try_ = statement;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String st = (String)success.value();
                    future2 = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, false, timeout, retryStrategy);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    future2 = Future$.MODULE$.failed(err);
                } else {
                    throw new MatchError((Object)try_);
                }
                future = future2;
            }
            return future;
        }, this.ec());
    }

    public Duration buildDeferredIndexes$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy buildDeferredIndexes$default$3() {
        return this.DefaultRetryStrategy();
    }

    private Try<String> quote(String s) {
        return s.contains("`") ? new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(35).append("Value [").append(RedactableArgument.redactMeta((Object)s)).append("] may not contain backticks.").toString())) : new Success((Object)new java.lang.StringBuilder(2).append("`").append(s).append("`").toString());
    }

    private Future<BoxedUnit> exec(boolean readonly, String statement, Option<JsonObject> withOptions, boolean ignoreIfExists, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<QueryResult> future;
        if (withOptions.isEmpty() || ((JsonObject)withOptions.get()).isEmpty()) {
            future = this.execInternal(readonly, statement, timeout, retryStrategy);
        } else {
            String revisedStatement = new java.lang.StringBuilder(6).append(statement).append(" WITH ").append(JacksonTransformers.MAPPER.writeValueAsString(withOptions.get())).toString();
            future = this.execInternal(readonly, revisedStatement, timeout, retryStrategy);
        }
        Future<QueryResult> out = future;
        return this.wrap(out, ignoreIfExists, ignoreIfNotExists);
    }

    private Duration exec$default$6() {
        return this.DefaultTimeout();
    }

    private RetryStrategy exec$default$7() {
        return this.DefaultRetryStrategy();
    }

    public Future<QueryResult> execInternal(boolean readonly, CharSequence statement, Duration timeout, RetryStrategy retryStrategy) {
        QueryOptions queryOpts = QueryOptions$.MODULE$.apply().readonly(readonly).timeout(timeout).retryStrategy(retryStrategy);
        return this.cluster().query(((Object)statement).toString(), queryOpts);
    }

    public Future<BoxedUnit> wrap(Future<QueryResult> in, boolean ignoreIfExists, boolean ignoreIfNotExists) {
        Future out = in.transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable err;
            boolean bl = false;
            Failure failure = null;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                return success;
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable err2 = failure.exception();
                if (err2 instanceof IndexNotFoundException) {
                    IndexNotFoundException indexNotFoundException = (IndexNotFoundException)err2;
                    return ignoreIfNotExists ? new Success((Object)Unit$.MODULE$) : new Failure((Throwable)indexNotFoundException);
                }
            }
            if (bl && (err = failure.exception()) instanceof IndexExistsException) {
                IndexExistsException indexExistsException = (IndexExistsException)err;
                return ignoreIfExists ? new Success((Object)Unit$.MODULE$) : new Failure((Throwable)indexExistsException);
            }
            if (!bl) throw new MatchError((Object)try_);
            Throwable err3 = failure.exception();
            return new Failure(err3);
        }, this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$7 -> {
            AsyncQueryIndexManager.$anonfun$wrap$2(x$7);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$3(Seq indexNames$1, boolean watchPrimary$1, QueryIndex v) {
        return indexNames$1.contains((Object)v.name()) || watchPrimary$1 && v.isPrimary();
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$6(QueryIndex x$4) {
        String string = x$4.state();
        String string2 = "online";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$watchIndexes$2(AsyncQueryIndexManager $this, Seq indexNames$1, boolean watchPrimary$1, Seq allIndexes) {
        Seq matchingIndexes = (Seq)allIndexes.filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$3(indexNames$1, watchPrimary$1, v)));
        boolean primaryIndexPresent = matchingIndexes.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isPrimary()));
        if (watchPrimary$1 && !primaryIndexPresent) {
            throw new IndexNotFoundException($this.PrimaryIndexName());
        }
        Set matchingIndexNames = ((TraversableOnce)matchingIndexes.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Seq$.MODULE$.canBuildFrom())).toSet();
        Set missingIndexNames = (Set)indexNames$1.toSet().diff((GenSet)matchingIndexNames);
        if (missingIndexNames.nonEmpty()) {
            throw new IndexNotFoundException(missingIndexNames.mkString(","));
        }
        Seq offlineIndexes = (Seq)matchingIndexes.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$6(x$4)));
        if (offlineIndexes.nonEmpty()) {
            throw new IndexesNotReadyException();
        }
    }

    public static final /* synthetic */ void $anonfun$watchIndexes$9(Seq x$5) {
    }

    public static final /* synthetic */ boolean $anonfun$buildDeferredIndexes$2(QueryIndex x$6) {
        String string = x$6.state();
        String string2 = "deferred";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$wrap$2(Object x$7) {
    }

    public AsyncQueryIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
        this.PrimaryIndexName = "#primary";
    }
}

