/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.DocumentFlags$;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.kv.Count;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.Exists;
import com.couchbase.client.scala.kv.Get;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.ProjectionsApplier$;
import com.couchbase.client.scala.util.FunctionalUtil$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0005\u000b\u000191\u0002\u0002\u0003\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\t\u000b\t\u0002A\u0011A\u0012\t\u000f\u001d\u0002!\u0019!C\u0005Q!1\u0011\u0007\u0001Q\u0001\n%BQA\r\u0001\u0005\u0002MBq!!\u0005\u0001\t\u0003\t\u0019\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\t)r)\u001a;Tk\n$unY;nK:$\b*\u00198eY\u0016\u0014(BA\u0006\r\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0007\u000f\u0003\tYgO\u0003\u0002\u0010!\u0005)1oY1mC*\u0011\u0011CE\u0001\u0007G2LWM\u001c;\u000b\u0005M!\u0012!C2pk\u000eD'-Y:f\u0015\u0005)\u0012aA2p[N\u0011\u0001a\u0006\t\u00031ii\u0011!\u0007\u0006\u0002\u001f%\u00111$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0005!\u00048\u0001\u0001\t\u0003?\u0001j\u0011AD\u0005\u0003C9\u0011Q\u0002S1oI2,'\u000fU1sC6\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002%MA\u0011Q\u0005A\u0007\u0002\u0015!)AD\u0001a\u0001=\u00059Q\t\u001f9US6,W#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001e\f\u0001\"\u0012=q)&lW\rI\u0001\be\u0016\fX/Z:u+\t!t\u0010F\u00046\tB{F\r\u001c;\u0011\u0007YJ4(D\u00018\u0015\tA\u0014$\u0001\u0003vi&d\u0017B\u0001\u001e8\u0005\r!&/\u001f\t\u0003y\tk\u0011!\u0010\u0006\u0003\u001byR!a\u0010!\u0002\u00075\u001cxM\u0003\u0002B!\u0005!1m\u001c:f\u0013\t\u0019UH\u0001\tTk\n$wnY$fiJ+\u0017/^3ti\")Q)\u0002a\u0001\r\u0006\u0011\u0011\u000e\u001a\t\u0003\u000f:s!\u0001\u0013'\u0011\u0005%KR\"\u0001&\u000b\u0005-k\u0012A\u0002\u001fs_>$h(\u0003\u0002N3\u00051\u0001K]3eK\u001aL!\u0001M(\u000b\u00055K\u0002\"B)\u0006\u0001\u0004\u0011\u0016\u0001B:qK\u000e\u00042a\u0015-\\\u001d\t!fK\u0004\u0002J+&\tq\"\u0003\u0002X3\u00059\u0001/Y2lC\u001e,\u0017BA-[\u0005\r\u0019V-\u001d\u0006\u0003/f\u0001\"\u0001X/\u000e\u00031I!A\u0018\u0007\u0003\u00191{wn[;q\u0013:\u001c\u0006/Z2\t\u000b\u0001,\u0001\u0019A1\u0002\u001d]LG\u000f[#ya&\u0014\u0018\r^5p]B\u0011\u0001DY\u0005\u0003Gf\u0011qAQ8pY\u0016\fg\u000eC\u0003f\u000b\u0001\u0007a-A\u0004uS6,w.\u001e;\u0011\u0005\u001dTW\"\u00015\u000b\u0005%l\u0013\u0001\u0002;j[\u0016L!a\u001b5\u0003\u0011\u0011+(/\u0019;j_:DQ!\\\u0003A\u00029\fQB]3uef\u001cFO]1uK\u001eL\bCA8s\u001b\u0005\u0001(BA9A\u0003\u0015\u0011X\r\u001e:z\u0013\t\u0019\bOA\u0007SKR\u0014\u0018p\u0015;sCR,w-\u001f\u0005\u0006k\u0016\u0001\rA^\u0001\u000ba\u0006\u0014XM\u001c;Ta\u0006t\u0007c\u0001\rxs&\u0011\u00010\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ilX\"A>\u000b\u0005q\u0004\u0015aA2oG&\u0011ap\u001f\u0002\f%\u0016\fX/Z:u'B\fg\u000eB\u0004\u0002\u0002\u0015\u0011\r!a\u0001\u0003\u0003Q\u000bB!!\u0002\u0002\fA\u0019\u0001$a\u0002\n\u0007\u0005%\u0011DA\u0004O_RD\u0017N\\4\u0011\u0007a\ti!C\u0002\u0002\u0010e\u00111!\u00118z\u00039\u0011X-];fgR\u0004&o\u001c6fGR,B!!\u0006\u0002&QYQ'a\u0006\u0002\u001a\u0005}\u0011\u0011EA\u0012\u0011\u0015)e\u00011\u0001G\u0011\u001d\tYB\u0002a\u0001\u0003;\tq\u0001\u001d:pU\u0016\u001cG\u000fE\u0002T1\u001aCQ!\u001a\u0004A\u0002\u0019DQ!\u001c\u0004A\u00029DQ!\u001e\u0004A\u0002Y$q!!\u0001\u0007\u0005\u0004\t\u0019!\u0001\u0005sKN\u0004xN\\:f)1\tY#!\r\u0002@\u0005\u0005\u00131IA#!\ra\u0016QF\u0005\u0004\u0003_a!A\u0004'p_.,\b/\u00138SKN,H\u000e\u001e\u0005\u0007e\u001d\u0001\r!a\r\u0011\u000bq\n)$!\u000f\n\u0007\u0005]RHA\bLKf4\u0016\r\\;f%\u0016\fX/Z:u!\ra\u00141H\u0005\u0004\u0003{i$!E*vE\u0012|7mR3u%\u0016\u001c\bo\u001c8tK\")Qi\u0002a\u0001\r\"9\u0011qE\u0004A\u0002\u0005e\u0002\"\u00021\b\u0001\u0004\t\u0007bBA$\u000f\u0001\u0007\u0011\u0011J\u0001\u000biJ\fgn]2pI\u0016\u0014\b\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=c\"A\u0003d_\u0012,7-\u0003\u0003\u0002T\u00055#A\u0003+sC:\u001c8m\u001c3fe\u0006y!/Z:q_:\u001cX\r\u0015:pU\u0016\u001cG\u000f\u0006\u0006\u0002Z\u0005\u0005\u00141MA3\u0003O\u0002BAN\u001d\u0002\\A\u0019A,!\u0018\n\u0007\u0005}CBA\u0005HKR\u0014Vm];mi\"1!\u0007\u0003a\u0001\u0003gAQ!\u0012\u0005A\u0002\u0019Cq!a\n\t\u0001\u0004\tI\u0004C\u0004\u0002H!\u0001\r!!\u0013")
public class GetSubDocumentHandler {
    private final HandlerParams hp;
    private final String ExpTime;

    private String ExpTime() {
        return this.ExpTime;
    }

    public <T> Try<SubdocGetRequest> request(String id, Seq<LookupInSpec> spec, boolean withExpiration, java.time.Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Object object;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(spec, "spec").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null)))));
        if (validations.isFailure()) {
            object = validations;
        } else {
            ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>();
            Object object2 = withExpiration ? BoxesRunTime.boxToBoolean((boolean)commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET, this.ExpTime(), true, spec.size()))) : BoxedUnit.UNIT;
            ((IterableLike)((SeqLike)((TraversableLike)spec.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    LookupInSpec x = (LookupInSpec)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (x instanceof Get) {
                        Get get = (Get)x;
                        String string = get.path();
                        String string2 = "";
                        SubdocCommandType cmd = !(string != null ? !string.equals(string2) : string2 != null) ? SubdocCommandType.GET_DOC : SubdocCommandType.GET;
                        return new SubdocGetRequest.Command(cmd, get.path(), get._xattr(), idx);
                    }
                }
                if (tuple2 != null) {
                    LookupInSpec x = (LookupInSpec)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (x instanceof Exists) {
                        Exists exists = (Exists)x;
                        return new SubdocGetRequest.Command(SubdocCommandType.EXISTS, exists.path(), exists._xattr(), idx);
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                LookupInSpec x = (LookupInSpec)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                if (!(x instanceof Count)) throw new MatchError((Object)tuple2);
                Count count = (Count)x;
                return new SubdocGetRequest.Command(SubdocCommandType.COUNT, count.path(), count._xattr(), idx);
            }, Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GetSubDocumentHandler.$anonfun$request$7(x$1)), (Ordering)Ordering.Boolean$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)commands.add(x$1)));
            object = commands.isEmpty() ? new Failure((Throwable)new IllegalArgumentException("No SubDocument commands provided")) : new Success((Object)new SubdocGetRequest(timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, id, 0, commands, this.hp.tracer().internalSpan("subdoc_get", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
        }
        return object;
    }

    public <T> Try<SubdocGetRequest> requestProject(String id, Seq<String> project, java.time.Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try<SubdocGetRequest> try_;
        Try<SubdocGetRequest> validations = Validate$.MODULE$.notNullOrEmpty(project, "project").map((Function1 & Serializable & scala.Serializable)_ -> null);
        if (validations.isFailure()) {
            try_ = validations;
        } else if (project.size() > 16) {
            try_ = new Failure((Throwable)new IllegalArgumentException(new StringBuilder(45).append("A maximum of ").append(16).append(" projection fields are supported").toString()));
        } else {
            Seq spec = (Seq)project.map((Function1 & Serializable & scala.Serializable)v -> LookupInSpec$.MODULE$.get((String)v), Seq$.MODULE$.canBuildFrom());
            try_ = this.request(id, (Seq<LookupInSpec>)spec, false, timeout, retryStrategy, parentSpan);
        }
        return try_;
    }

    public LookupInResult response(KeyValueRequest<SubdocGetResponse> request, String id, SubdocGetResponse response, boolean withExpiration, Transcoder transcoder) {
        LookupInResult lookupInResult;
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            WrappedArray values = Predef$.MODULE$.wrapRefArray((Object[])response.values());
            if (withExpiration) {
                ObjectRef exptime = ObjectRef.create((Object)None$.MODULE$);
                Seq removingExpTime = (Seq)values.filter((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)GetSubDocumentHandler.$anonfun$response$1(this, exptime, value)));
                lookupInResult = new LookupInResult(id, (Seq<SubDocumentField>)removingExpTime, DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Duration>)((Option)exptime.elem), transcoder);
            } else {
                lookupInResult = new LookupInResult(id, (Seq<SubDocumentField>)values, DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Duration>)None$.MODULE$, transcoder);
            }
        } else {
            if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (ResponseStatus)response.status());
                throw new DocumentNotFoundException((ErrorContext)ctx);
            }
            if (ResponseStatus.SUBDOC_FAILURE.equals(responseStatus)) {
                Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.error()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CouchbaseException err = (CouchbaseException)some.value();
                    throw err;
                }
                throw new CouchbaseException("Unknown SubDocument failure occurred", (ErrorContext)ReducedKeyValueErrorContext.create((String)id));
            }
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        LookupInResult lookupInResult2 = lookupInResult;
        return lookupInResult2;
    }

    public Try<GetResult> responseProject(KeyValueRequest<SubdocGetResponse> request, String id, SubdocGetResponse response, Transcoder transcoder) {
        Failure failure;
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            WrappedArray values = Predef$.MODULE$.wrapRefArray((Object[])response.values());
            JsonObject out = JsonObject$.MODULE$.create();
            Seq x = (Seq)values.map((Function1 & Serializable & scala.Serializable)value -> ProjectionsApplier$.MODULE$.parse(out, value.path(), value.value()), Seq$.MODULE$.canBuildFrom());
            Try y = FunctionalUtil$.MODULE$.traverse(x.toList());
            failure = y.map((Function1 & Serializable & scala.Serializable)x$2 -> new GetResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Right().apply((Object)out), DocumentFlags$.MODULE$.Json(), response.cas(), (Option<Duration>)None$.MODULE$, transcoder));
        } else if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (ResponseStatus)response.status());
            failure = new Failure((Throwable)new DocumentNotFoundException((ErrorContext)ctx));
        } else if (ResponseStatus.SUBDOC_FAILURE.equals(responseStatus)) {
            Failure failure2;
            Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.error()));
            if (option instanceof Some) {
                Some some = (Some)option;
                CouchbaseException err = (CouchbaseException)some.value();
                failure2 = new Failure((Throwable)err);
            } else {
                failure2 = new Failure((Throwable)new CouchbaseException("Unknown SubDocument failure occurred", (ErrorContext)ReducedKeyValueErrorContext.create((String)id)));
            }
            failure = failure2;
        } else {
            failure = new Failure((Throwable)DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response));
        }
        return failure;
    }

    public static final /* synthetic */ boolean $anonfun$request$7(SubdocGetRequest.Command x$1) {
        return !x$1.xattr();
    }

    public static final /* synthetic */ boolean $anonfun$response$1(GetSubDocumentHandler $this, ObjectRef exptime$1, SubDocumentField value) {
        boolean bl;
        String string = value.path();
        String string2 = $this.ExpTime();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String str = new String(value.value(), CharsetUtil.UTF_8);
            exptime$1.elem = new Some((Object)Duration$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString(str)).toLong(), TimeUnit.SECONDS));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public GetSubDocumentHandler(HandlerParams hp) {
        this.hp = hp;
        this.ExpTime = "$document.exptime";
    }
}

